/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecResult;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.ClientExecHandleBuilder;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;

public class DefaultExecAction
implements ExecAction {
    private final ClientExecHandleBuilder execHandleBuilder;
    private boolean ignoreExitValue;

    public DefaultExecAction(ClientExecHandleBuilder execHandleBuilder) {
        this.execHandleBuilder = execHandleBuilder;
    }

    @Override
    public ExecResult execute() {
        ExecHandle execHandle = this.execHandleBuilder.build();
        ExecResult execResult = execHandle.start().waitForFinish();
        if (!this.isIgnoreExitValue()) {
            execResult.assertNormalExitValue();
        }
        return execResult;
    }

    public String getExecutable() {
        return this.execHandleBuilder.getExecutable();
    }

    public void setExecutable(String executable) {
        this.execHandleBuilder.setExecutable(executable);
    }

    public void setExecutable(Object executable) {
        this.execHandleBuilder.setExecutable(executable);
    }

    public ProcessForkOptions executable(Object executable) {
        this.execHandleBuilder.setExecutable(executable);
        return this;
    }

    public File getWorkingDir() {
        return this.execHandleBuilder.getWorkingDir();
    }

    public void setWorkingDir(File dir) {
        this.execHandleBuilder.setWorkingDir(dir);
    }

    public void setWorkingDir(Object dir) {
        this.execHandleBuilder.setWorkingDir(dir);
    }

    public ExecAction commandLine(Object ... arguments) {
        this.execHandleBuilder.commandLine(arguments);
        return this;
    }

    public ExecAction commandLine(Iterable<?> args) {
        this.execHandleBuilder.commandLine(args);
        return this;
    }

    public void setCommandLine(List<String> args) {
        this.execHandleBuilder.commandLine(args);
    }

    public void setCommandLine(Object ... args) {
        this.execHandleBuilder.commandLine(args);
    }

    public void setCommandLine(Iterable<?> args) {
        this.execHandleBuilder.commandLine(args);
    }

    public ExecAction args(Object ... args) {
        this.execHandleBuilder.args(args);
        return this;
    }

    public ExecAction args(Iterable<?> args) {
        this.execHandleBuilder.args(args);
        return this;
    }

    public ExecAction setArgs(List<String> arguments) {
        this.execHandleBuilder.setArgs(arguments);
        return this;
    }

    public ExecAction setArgs(Iterable<?> arguments) {
        this.execHandleBuilder.setArgs(arguments);
        return this;
    }

    public List<String> getArgs() {
        return this.execHandleBuilder.getArgs();
    }

    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.execHandleBuilder.getArgumentProviders();
    }

    public ExecAction setIgnoreExitValue(boolean ignoreExitValue) {
        this.ignoreExitValue = ignoreExitValue;
        return this;
    }

    public boolean isIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    public ExecAction setStandardInput(InputStream inputStream) {
        this.execHandleBuilder.setStandardInput(inputStream);
        return this;
    }

    public ExecAction workingDir(Object dir) {
        this.execHandleBuilder.setWorkingDir(dir);
        return this;
    }

    public Map<String, Object> getEnvironment() {
        return this.execHandleBuilder.getEnvironment();
    }

    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.execHandleBuilder.setEnvironment(environmentVariables);
    }

    public ExecAction environment(Map<String, ?> environmentVariables) {
        this.execHandleBuilder.environment(environmentVariables);
        return this;
    }

    public ExecAction environment(String name, Object value) {
        this.execHandleBuilder.environment(name, value);
        return this;
    }

    public OutputStream getStandardOutput() {
        return this.execHandleBuilder.getStandardOutput();
    }

    public BaseExecSpec setErrorOutput(OutputStream outputStream) {
        this.execHandleBuilder.setErrorOutput(outputStream);
        return this;
    }

    public OutputStream getErrorOutput() {
        return this.execHandleBuilder.getErrorOutput();
    }

    public List<String> getCommandLine() {
        return this.execHandleBuilder.getCommandLine();
    }

    public InputStream getStandardInput() {
        return this.execHandleBuilder.getStandardInput();
    }

    public ExecAction setStandardOutput(OutputStream outputStream) {
        this.execHandleBuilder.setStandardOutput(outputStream);
        return this;
    }

    @Override
    public ExecAction listener(ExecHandleListener listener) {
        this.execHandleBuilder.listener(listener);
        return this;
    }

    public ExecAction copyTo(ProcessForkOptions options) {
        throw new UnsupportedOperationException("Copy to ProcessForkOptions is not supported for ExecAction");
    }
}

