/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.rubygrapefruit.platform.SystemInfo;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdk;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkInstall;
import org.gradle.util.internal.VersionNumber;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class WindowsKitSdkInstall
extends WindowsKitInstall
implements WindowsSdkInstall {
    private final File binDir;
    private final SystemInfo systemInfo;

    public WindowsKitSdkInstall(File baseDir, VersionNumber version, File binDir, String name, SystemInfo systemInfo) {
        super(baseDir, version, name);
        this.binDir = binDir;
        this.systemInfo = systemInfo;
    }

    @Override
    public WindowsSdk forPlatform(NativePlatformInternal platform) {
        String host;
        switch (this.systemInfo.getArchitecture()) {
            case i386: {
                host = "x86";
                break;
            }
            case amd64: {
                host = "x64";
                break;
            }
            case aarch64: {
                host = "arm64";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported host for %s", this.toString()));
            }
        }
        if (platform.getArchitecture().isAmd64()) {
            return new WindowsKitBackedSdk("x64", host);
        }
        if (platform.getArchitecture().isArm64()) {
            return new WindowsKitBackedSdk("arm64", host);
        }
        if (platform.getArchitecture().isArm32()) {
            return new WindowsKitBackedSdk("arm", host);
        }
        if (platform.getArchitecture().isI386()) {
            return new WindowsKitBackedSdk("x86", host);
        }
        throw new UnsupportedOperationException(String.format("Unsupported %s for %s.", platform.getArchitecture().getDisplayName(), this.toString()));
    }

    private class WindowsKitBackedSdk
    implements WindowsSdk {
        private final String platformDirName;
        private final String hostDirName;

        WindowsKitBackedSdk(String platformDirName, String hostDirName) {
            this.platformDirName = platformDirName;
            this.hostDirName = hostDirName;
        }

        @Override
        public VersionNumber getImplementationVersion() {
            return WindowsKitSdkInstall.this.getVersion();
        }

        @Override
        public VersionNumber getSdkVersion() {
            return this.getImplementationVersion();
        }

        @Override
        public List<File> getIncludeDirs() {
            return Arrays.asList(new File(WindowsKitSdkInstall.this.getBaseDir(), "Include/" + this.getImplementationVersion().toString() + "/um"), new File(WindowsKitSdkInstall.this.getBaseDir(), "Include/" + this.getImplementationVersion().toString() + "/shared"));
        }

        @Override
        public List<File> getLibDirs() {
            return Collections.singletonList(new File(WindowsKitSdkInstall.this.getBaseDir(), "Lib/" + this.getImplementationVersion().toString() + "/um/" + this.platformDirName));
        }

        @Override
        public File getResourceCompiler() {
            return new File(this.getHostBinDir(), "rc.exe");
        }

        @Override
        public Map<String, String> getPreprocessorMacros() {
            return Collections.emptyMap();
        }

        @Override
        public List<File> getPath() {
            return Collections.singletonList(this.getBinDir());
        }

        private File getBinDir() {
            return new File(WindowsKitSdkInstall.this.binDir, this.platformDirName);
        }

        private File getHostBinDir() {
            return new File(WindowsKitSdkInstall.this.binDir, this.hostDirName);
        }
    }
}

