/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.SpelExpressionTransformer;
import org.springframework.util.Assert;

public class AggregationSpELExpression
implements AggregationExpression {
    private static final SpelExpressionTransformer TRANSFORMER = new SpelExpressionTransformer();
    private final String rawExpression;
    private final Object[] parameters;

    private AggregationSpELExpression(String rawExpression, Object[] parameters) {
        this.rawExpression = rawExpression;
        this.parameters = parameters;
    }

    public static AggregationSpELExpression expressionOf(String expressionString, Object ... parameters) {
        Assert.notNull((Object)expressionString, (String)"ExpressionString must not be null");
        return new AggregationSpELExpression(expressionString, parameters);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return (Document)TRANSFORMER.transform(this.rawExpression, context, this.parameters);
    }
}

