/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.List;
import org.bson.Document;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.FieldLookupPolicy;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;

class AggregationUtil {
    final QueryMapper queryMapper;
    final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    final Lazy<AggregationOperationContext> untypedMappingContext;

    AggregationUtil(QueryMapper queryMapper, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this.queryMapper = queryMapper;
        this.mappingContext = mappingContext;
        this.untypedMappingContext = Lazy.of(() -> new TypeBasedAggregationOperationContext(Object.class, mappingContext, queryMapper, FieldLookupPolicy.relaxed()));
    }

    AggregationOperationContext createAggregationContext(Aggregation aggregation, @Nullable Class<?> inputType) {
        FieldLookupPolicy lookupPolicy;
        AggregationOptions.DomainTypeMapping domainTypeMapping = aggregation.getOptions().getDomainTypeMapping();
        if (domainTypeMapping == AggregationOptions.DomainTypeMapping.NONE) {
            return Aggregation.DEFAULT_CONTEXT;
        }
        FieldLookupPolicy fieldLookupPolicy = lookupPolicy = domainTypeMapping == AggregationOptions.DomainTypeMapping.STRICT && !aggregation.getPipeline().containsUnionWith() ? FieldLookupPolicy.strict() : FieldLookupPolicy.relaxed();
        if (aggregation instanceof TypedAggregation) {
            TypedAggregation ta = (TypedAggregation)aggregation;
            return new TypeBasedAggregationOperationContext(ta.getInputType(), this.mappingContext, this.queryMapper, lookupPolicy);
        }
        if (inputType == null) {
            return (AggregationOperationContext)this.untypedMappingContext.get();
        }
        return new TypeBasedAggregationOperationContext(inputType, this.mappingContext, this.queryMapper, lookupPolicy);
    }

    List<Document> createPipeline(Aggregation aggregation, AggregationOperationContext context) {
        return aggregation.toPipeline(context);
    }

    Document createCommand(String collection, Aggregation aggregation, AggregationOperationContext context) {
        return aggregation.toDocument(collection, context);
    }
}

