/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.tokenizer;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;
import org.gjt.xpp.impl.tokenizer.TokenizerBufferOverflowException;
import org.gjt.xpp.impl.tokenizer.TokenizerException;

public class Tokenizer {
    public static final byte END_DOCUMENT = 2;
    public static final byte CONTENT = 10;
    public static final byte CHARACTERS = 20;
    public static final byte CDSECT = 30;
    public static final byte COMMENT = 40;
    public static final byte DOCTYPE = 50;
    public static final byte PI = 60;
    public static final byte ENTITY_REF = 70;
    public static final byte CHAR_REF = 75;
    public static final byte ETAG_NAME = 110;
    public static final byte EMPTY_ELEMENT = 111;
    public static final byte STAG_END = 112;
    public static final byte STAG_NAME = 120;
    public static final byte ATTR_NAME = 122;
    public static final byte ATTR_CHARACTERS = 124;
    public static final byte ATTR_CONTENT = 127;
    public boolean paramNotifyCharacters;
    public boolean paramNotifyComment;
    public boolean paramNotifyCDSect;
    public boolean paramNotifyDoctype;
    public boolean paramNotifyPI;
    public boolean paramNotifyCharRef;
    public boolean paramNotifyEntityRef;
    public boolean paramNotifyAttValue;
    public char[] buf = new char[12288];
    public int pos;
    public int posStart;
    public int posEnd;
    public int posNsColon;
    public int nsColonCount;
    public boolean seenContent;
    public boolean parsedContent;
    public char[] pc = new char[12288];
    public int pcStart;
    public int pcEnd;
    protected static final int LOOKUP_MAX = 1024;
    protected static final char LOOKUP_MAX_CHAR = '\u0400';
    protected static boolean[] lookupNameStartChar;
    protected static boolean[] lookupNameChar;
    private static final boolean TRACING = false;
    private static final boolean TRACE_SIZING = false;
    private boolean paramPC = true;
    private boolean paramNoMixContent = false;
    private boolean mixInElement = false;
    private boolean backtracking = false;
    private static final int BUF_SIZE = 12288;
    private int readChunkSize = 4096;
    private int loadFactor = 99;
    private int posSafe = this.loadFactor * 12288 / 100;
    private int softLimit = -1;
    private int hardLimit = -1;
    private int shrinkOffset = 0;
    private boolean shrinkable = true;
    private boolean reading = true;
    private Reader reader;
    private int bufStart;
    private int bufEnd;
    private int bufSize = 12288;
    private int posCol;
    private int posRow;
    private char prevCh;
    private char prevPrevCh;
    private char attrMarker;
    private char charRefValue;
    private boolean charRefHex;
    private boolean seenStartTag;
    private byte previousState;
    private byte state;
    private static final boolean NORMALIZE_LINE_BREAKS = true;
    private static final byte STATE_INIT = 1;
    private static final byte STATE_FINISH_CONTENT = 5;
    private static final byte STATE_FINISH = 6;
    private static final byte STATE_FINISHED = 7;
    private static final byte STATE_CONTENT_INIT = 10;
    private static final byte STATE_CONTENT_CONTINUED = 11;
    private static final byte STATE_CONTENT = 12;
    private static final byte STATE_SEEN_LT = 13;
    private static final byte STATE_SEEN_LT_BANG = 14;
    private static final byte STATE_CDSECT = 30;
    private static final byte STATE_CDSECT_BRACKET = 31;
    private static final byte STATE_CDSECT_BRACKET_BRACKET = 32;
    private static final byte STATE_COMMENT = 40;
    private static final byte STATE_COMMENT_DASH = 41;
    private static final byte STATE_COMMENT_DASH_DASH = 42;
    private static final byte STATE_DOCTYPE = 50;
    private static final byte STATE_DOCTYPE_BRACKET = 51;
    private static final byte STATE_DOCTYPE_BRACKET_BRACKET = 52;
    private static final byte STATE_PI = 60;
    private static final byte STATE_PI_END = 61;
    private static final byte STATE_SEEN_AMP = 70;
    private static final byte STATE_ENTITY_REF = 71;
    private static final byte STATE_CHAR_REF = 75;
    private static final byte STATE_CHAR_REF_DIGITS = 76;
    private static final byte STATE_SCAN_ETAG_NAME = 110;
    private static final byte STATE_SCAN_STAG_NAME = 120;
    private static final byte STATE_SCAN_STAG_GT = 121;
    private static final byte STATE_SCAN_ATTR_NAME = 122;
    private static final byte STATE_SCAN_ATTR_EQ = 123;
    private static final byte STATE_SCAN_ATTR_VALUE = 124;
    private static final byte STATE_SCAN_ATTR_VALUE_CONTINUE = 125;
    private static final byte STATE_SCAN_ATTR_VALUE_END = 126;
    private static final byte STATE_ATTR_VALUE_CONTENT = 127;

    public void reset() {
        if (!this.reading) {
            if (this.softLimit != -1) {
                this.resize(this.softLimit);
            } else {
                this.resize(12288);
            }
        }
        this.resetState();
    }

    private void resetState() {
        this.reading = true;
        this.reader = null;
        this.bufSize = this.buf.length;
        this.bufEnd = 0;
        this.bufStart = 0;
        this.pos = 0;
        this.posStart = 0;
        this.posEnd = 0;
        this.posNsColon = -1;
        this.state = 1;
        this.prevCh = '\u0000';
        this.posRow = 1;
        this.posCol = 1;
        this.pcStart = 0;
        this.pcEnd = 0;
        if (this.pc.length > 24576) {
            this.pc = new char[12288];
        }
        this.previousState = (byte)-1;
        this.backtracking = false;
        this.seenContent = false;
        this.shrinkOffset = 0;
    }

    public void setInput(Reader r) {
        this.reset();
        this.reading = true;
        this.reader = r;
        this.bufEnd = 0;
        this.bufStart = 0;
    }

    public void setInput(char[] data) {
        this.setInput(data, 0, data.length);
    }

    public void setInput(char[] data, int off, int len) {
        this.resetState();
        this.reading = false;
        this.buf = data;
        this.bufStart = this.pos = off;
        this.bufSize = this.bufEnd = off + len;
    }

    public void setNotifyAll(boolean enable) {
        this.paramNotifyCharacters = enable;
        this.paramNotifyComment = enable;
        this.paramNotifyCDSect = enable;
        this.paramNotifyDoctype = enable;
        this.paramNotifyPI = enable;
        this.paramNotifyEntityRef = enable;
        this.paramNotifyCharRef = enable;
        this.paramNotifyAttValue = enable;
    }

    public void setParseContent(boolean enable) {
        this.paramPC = enable;
    }

    public boolean isAllowedMixedContent() {
        return !this.paramNoMixContent;
    }

    public void setAllowedMixedContent(boolean enable) {
        this.paramNoMixContent = !enable;
    }

    public int getSoftLimit() {
        return this.softLimit;
    }

    public void setSoftLimit(int value) throws TokenizerException {
        if (!this.reading) {
            throw new TokenizerException("hard limit can not be set for char array input");
        }
        if (value != -1 && this.hardLimit != -1 && 2 * value > this.hardLimit) {
            throw new TokenizerException("soft limit can no tbe bigger than half of hard limitcurrent hard limit " + this.hardLimit);
        }
        this.softLimit = value;
        this.posSafe = this.softLimit != -1 ? this.softLimit : (this.hardLimit != -1 ? this.hardLimit / 2 : this.loadFactor * this.bufSize / 100);
    }

    public int getHardLimit() {
        return this.hardLimit;
    }

    public void setHardLimit(int value) throws TokenizerException {
        if (!this.reading) {
            throw new TokenizerException("hard limit can not be set for char array input");
        }
        if (this.state != 1 && value < this.hardLimit) {
            throw new TokenizerException("hard limit on buffer size can not be shrunk during parsing");
        }
        if (this.softLimit == -1 && value != -1) {
            throw new TokenizerException("soft limit must be set to non -1 before setting hard limit" + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        if (value != -1 && 2 * this.softLimit >= value) {
            throw new TokenizerException("hard limit must be at least twice the size of soft limitcurrent soft limit " + this.softLimit + " and hard limit " + value + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        this.hardLimit = value;
        if (this.shrinkable && this.softLimit != -1 && this.softLimit < this.bufSize) {
            this.resize(this.softLimit);
        }
    }

    public int getBufferShrinkOffset() {
        return this.shrinkOffset;
    }

    public void setBufferShrinkable(boolean shrinkable) throws TokenizerException {
        this.shrinkable = shrinkable;
    }

    public boolean isBufferShrinkable() {
        return this.shrinkable;
    }

    private static int findFragment(int bufStart, char[] b, int start, int end) {
        char c;
        if (start < bufStart) {
            start = bufStart;
            if (start > end) {
                start = end;
            }
            return start;
        }
        if (end - start > 55) {
            start = end - 10;
        }
        int i = start + 1;
        while (--i > bufStart && end - i <= 55 && ((c = b[i]) != '<' || start - i <= 10)) {
        }
        return i;
    }

    public String getPosDesc() {
        int start;
        String fragment = null;
        if (this.posStart <= this.posEnd && (start = Tokenizer.findFragment(this.bufStart, this.buf, this.posStart, this.posEnd)) < this.posEnd) {
            fragment = new String(this.buf, start, this.posEnd - start);
            if (start > this.bufStart) {
                fragment = "..." + fragment;
            }
        }
        return " at line " + this.posRow + " and column " + (this.posCol - 1) + (fragment != null ? " seen " + Tokenizer.printable(fragment) + "..." : "");
    }

    public int getLineNumber() {
        return this.posRow;
    }

    public int getColumnNumber() {
        return this.posCol - 1;
    }

    private static boolean compareCharArr(char[] a, char[] b, int bStart, int bEnd) {
        if (bEnd - bStart != a.length) {
            return false;
        }
        int i = bStart;
        int j = 0;
        while (i < bEnd) {
            if (a[j] != b[i]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static String printableChar(char ch) {
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\t') {
            return "\\t";
        }
        if (ch < ' ') {
            return "\\u" + Character.digit(ch, 16) + "";
        }
        return "" + ch;
    }

    private static String printable(char ch) {
        return "'" + Tokenizer.printableChar(ch) + "'";
    }

    private static String printable(String s) {
        int iN = s.indexOf(10);
        int iR = s.indexOf(13);
        int iT = s.indexOf(9);
        if (iN != -1 || iR != -1 || iT != -1) {
            StringBuffer buf = new StringBuffer("\"");
            for (int i = 0; i < s.length(); ++i) {
                buf.append(Tokenizer.printableChar(s.charAt(i)));
            }
            buf.append("\"");
            s = buf.toString();
        }
        return s;
    }

    private static final void setName(char ch) {
        Tokenizer.lookupNameChar[ch] = true;
    }

    private static final void setNameStart(char ch) {
        Tokenizer.lookupNameStartChar[ch] = true;
        Tokenizer.setName(ch);
    }

    protected boolean isNameStartChar(char ch) {
        return ch < '\u0400' && lookupNameStartChar[ch] || ch >= '\u0400' && ch <= '\u2027' || ch >= '\u202a' && ch <= '\u218f' || ch >= '\u2800' && ch <= '\uffef';
    }

    protected boolean isNameChar(char ch) {
        return ch < '\u0400' && lookupNameChar[ch] || ch >= '\u0400' && ch <= '\u2027' || ch >= '\u202a' && ch <= '\u218f' || ch >= '\u2800' && ch <= '\uffef';
    }

    protected boolean isS(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t';
    }

    private char readName(char ch) throws IOException, TokenizerException {
        this.posNsColon = -1;
        this.nsColonCount = 0;
        if (!this.isNameStartChar(ch)) {
            throw new TokenizerException("expected name start not " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        do {
            if ((ch = this.more()) != ':') continue;
            this.posNsColon = this.pos - 1;
            ++this.nsColonCount;
        } while (this.isNameChar(ch));
        return ch;
    }

    private char skipS(char ch) throws IOException, TokenizerException {
        while (ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r') {
            ch = this.more();
        }
        return ch;
    }

    private char readS(char ch) throws IOException, TokenizerException {
        if (!this.isS(ch)) {
            throw new TokenizerException("expected white space not " + ch + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        while (ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r') {
            ch = this.more();
        }
        return ch;
    }

    private char more() throws IOException, TokenizerException {
        char ch;
        if (this.backtracking) {
            this.backtracking = false;
            ++this.pos;
            ++this.posCol;
            return this.prevCh;
        }
        if (!this.reading) {
            if (this.pos >= this.bufEnd) {
                throw new EOFException("no more data available");
            }
        } else {
            if (this.hardLimit != -1 && this.pos >= this.hardLimit - 1) {
                throw new TokenizerBufferOverflowException("reached hard limit on buffer size" + this.getPosDesc(), this.posRow, this.posCol - 1);
            }
            if (this.pos > this.bufEnd - 1) {
                int chunkie;
                if (this.hardLimit != -1 && this.bufSize > this.hardLimit) {
                    throw new TokenizerBufferOverflowException("buffer size should never exceed hard limit" + this.getPosDesc(), this.posRow, this.posCol - 1);
                }
                int spaceLeft = this.bufSize - this.bufEnd;
                if (spaceLeft <= this.readChunkSize) {
                    int newSize = 2 * this.bufSize;
                    if (this.hardLimit == -1) {
                        if (newSize < this.softLimit) {
                            newSize = 2 * this.softLimit;
                        }
                        if (newSize < 4 * this.readChunkSize) {
                            newSize = 12 * this.readChunkSize;
                        }
                    } else if (newSize > this.hardLimit) {
                        if (this.bufEnd >= this.hardLimit) {
                            throw new TokenizerBufferOverflowException("buffer can not grow beyond hard limit" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        newSize = this.hardLimit;
                    }
                    if (newSize - this.bufSize > 0) {
                        this.resize(newSize);
                    }
                }
                if (this.bufSize - this.bufEnd < (chunkie = this.readChunkSize)) {
                    chunkie = this.bufSize - this.bufEnd;
                }
                if (this.reader == null) {
                    throw new TokenizerException("to start parsing setInput() must be called!");
                }
                int bufRead = this.reader.read(this.buf, this.bufEnd, chunkie);
                if (bufRead == -1) {
                    throw new EOFException("no more data available to read");
                }
                if (bufRead == 0) {
                    throw new TokenizerBufferOverflowException("can't read more data in buffer (read() returns 0 chars)" + this.getPosDesc());
                }
                this.bufEnd += bufRead;
            }
        }
        if ((ch = this.buf[this.pos++]) == '\n' || ch == '\r') {
            if (this.prevCh != '\r' || ch != '\n') {
                this.posCol = 2;
                ++this.posRow;
            }
        } else {
            ++this.posCol;
        }
        this.prevPrevCh = this.prevCh;
        this.prevCh = ch;
        return this.prevCh;
    }

    private void resize(int newSize) {
        char[] newBuf = new char[newSize];
        int end = this.bufEnd;
        if (end > newSize) {
            end = newSize;
            if (this.state != 1) {
                throw new PullParserRuntimeException("internal buffer may not be shrank during parsing" + this.getPosDesc());
            }
        }
        System.arraycopy(this.buf, 0, newBuf, 0, end);
        this.buf = newBuf;
        this.bufSize = newSize;
        if (this.softLimit == -1) {
            this.posSafe = this.loadFactor * this.bufSize / 100;
        }
    }

    private void ensurePC() {
        if (this.paramPC && this.pcEnd >= this.pc.length) {
            int newSize = 2 * this.pcEnd + 1;
            char[] newpc = new char[newSize];
            System.arraycopy(this.pc, 0, newpc, 0, this.pc.length);
            this.pc = newpc;
        }
    }

    private char less() {
        --this.pos;
        --this.posCol;
        this.backtracking = true;
        return this.prevPrevCh;
    }

    private void shrink(int posCut) {
        System.arraycopy(this.buf, posCut, this.buf, 0, this.bufEnd - posCut);
        this.shrinkOffset += posCut;
        this.bufEnd -= posCut;
        this.pos -= posCut;
        this.posStart -= posCut;
        this.posEnd -= posCut;
        this.posNsColon -= posCut;
    }

    private void joinPC() {
        if (this.pcStart == this.pcEnd) {
            this.appendPC();
        }
    }

    private void appendPC() {
        if (this.posEnd > this.posStart) {
            int pcLen = this.pc.length - this.pcEnd;
            int len = this.posEnd - this.posStart;
            if (pcLen < len) {
                int newSize = len;
                char[] newpc = new char[newSize];
                System.arraycopy(this.pc, 0, newpc, 0, this.pc.length);
                this.pc = newpc;
            }
            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
            this.pcEnd += len;
        }
    }

    public byte next() throws TokenizerException, IOException {
        block143: {
            if (this.state == 7) {
                throw new TokenizerException("attempt to read beyond end of input");
            }
            if (this.state != 5 && this.state != 6) {
                try {
                    this.parsedContent = false;
                    block34: while (true) {
                        char ch;
                        if ((ch = this.more()) == '\r') {
                            this.joinPC();
                        } else if (this.prevPrevCh == '\r' && ch == '\n') continue;
                        switch (this.state) {
                            case 1: {
                                if (ch == '\ufffe') {
                                    throw new TokenizerException("first character in input was UNICODE noncharacter (0xFFFE)- input requires byte swapping");
                                }
                                if (ch == '\ufeff') {
                                    this.state = (byte)10;
                                    break;
                                }
                            }
                            case 10: {
                                this.pcStart = 0;
                                this.pcEnd = 0;
                            }
                            case 11: {
                                this.posEnd = this.posStart = this.pos - 1;
                                this.state = (byte)12;
                            }
                            case 12: {
                                while (true) {
                                    if (ch == '<') {
                                        this.state = (byte)13;
                                        if (this.paramNotifyCharacters && this.posStart != this.posEnd) {
                                            return 20;
                                        }
                                    } else if (ch == '&') {
                                        if (this.paramPC) {
                                            this.joinPC();
                                        }
                                        if (!this.seenContent) {
                                            this.seenContent = true;
                                            if (this.paramNoMixContent && !this.mixInElement) {
                                                throw new TokenizerException("mixed content disallowed outside element" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                            }
                                        }
                                        this.state = (byte)70;
                                        this.previousState = (byte)11;
                                        this.posStart = this.pos - 1;
                                    } else {
                                        if (!this.seenContent && !this.isS(ch)) {
                                            this.seenContent = true;
                                            if (this.paramNoMixContent && !this.mixInElement) {
                                                throw new TokenizerException("mixed content disallowed outside element, character " + Tokenizer.printable(ch) + " (" + ch + ")" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                            }
                                        }
                                        this.posEnd = this.pos;
                                        if (this.paramPC && (this.pcStart != this.pcEnd || ch == '\r')) {
                                            if (ch == '\r') {
                                                if (this.pcEnd >= this.pc.length) {
                                                    this.ensurePC();
                                                }
                                                this.pc[this.pcEnd++] = 10;
                                            } else {
                                                if (this.pcEnd >= this.pc.length) {
                                                    this.ensurePC();
                                                }
                                                this.pc[this.pcEnd++] = ch;
                                            }
                                        }
                                    }
                                    if (this.state != 12) continue block34;
                                    ch = this.more();
                                    if (ch == '\r') {
                                        this.joinPC();
                                        continue;
                                    }
                                    if (this.prevPrevCh == '\r' && ch == '\n') break;
                                }
                                continue block34;
                            }
                            case 13: {
                                if (ch == '!') {
                                    this.state = (byte)14;
                                } else if (ch == '?') {
                                    this.state = (byte)60;
                                } else {
                                    boolean prevMixSeenContent = this.seenContent;
                                    boolean prevMixInElement = this.mixInElement;
                                    if (ch == '/') {
                                        this.state = (byte)110;
                                        this.mixInElement = false;
                                    } else {
                                        this.state = (byte)120;
                                        if (this.paramNoMixContent && this.seenContent) {
                                            throw new TokenizerException("mixed content disallowed inside element and before start tag" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                        }
                                        this.mixInElement = true;
                                    }
                                    if (this.paramPC && (this.pcStart != this.pcEnd || this.posEnd != this.posStart || this.state == 110 && this.seenStartTag) && (!this.paramNoMixContent || prevMixSeenContent || this.paramNoMixContent && this.state == 110 && this.seenStartTag)) {
                                        boolean bl = this.parsedContent = this.pcEnd != this.pcStart;
                                        if (!this.parsedContent && this.posEnd == this.posStart) continue block34;
                                        return 10;
                                    }
                                }
                                if (this.paramPC && this.state != 120 && this.state != 110) {
                                    this.joinPC();
                                }
                                this.posStart = this.pos;
                                break;
                            }
                            case 14: {
                                if (ch == '-') {
                                    ch = this.more();
                                    if (ch != '-') {
                                        throw new TokenizerException("expected - for start of comment <!-- not " + ch + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    this.state = (byte)40;
                                    this.posStart = this.pos;
                                    break;
                                }
                                if (ch == '[') {
                                    ch = this.more();
                                    if (ch != 'C') {
                                        throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    ch = this.more();
                                    if (ch != 'D') {
                                        throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    ch = this.more();
                                    if (ch != 'A') {
                                        throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    ch = this.more();
                                    if (ch != 'T') {
                                        throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    ch = this.more();
                                    if (ch != 'A') {
                                        throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    ch = this.more();
                                    if (ch != '[') {
                                        throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    this.posStart = this.pos;
                                    if (!this.seenContent) {
                                        this.seenContent = true;
                                        if (this.paramNoMixContent && !this.mixInElement) {
                                            throw new TokenizerException("mixed content disallowed outside element" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                        }
                                    }
                                    this.state = (byte)30;
                                    break;
                                }
                                if (ch == 'D') {
                                    ch = this.more();
                                    if (ch != 'O') {
                                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    ch = this.more();
                                    if (ch != 'C') {
                                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    ch = this.more();
                                    if (ch != 'T') {
                                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    ch = this.more();
                                    if (ch != 'Y') {
                                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    ch = this.more();
                                    if (ch != 'P') {
                                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    ch = this.more();
                                    if (ch != 'E') {
                                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                    this.posStart = this.pos;
                                    this.state = (byte)50;
                                    break;
                                }
                                throw new TokenizerException("unknown markup after <! " + Tokenizer.printableChar(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                            case 70: {
                                this.posStart = this.pos - 2;
                                if (ch == '#') {
                                    this.state = (byte)75;
                                    break;
                                }
                                this.state = (byte)71;
                            }
                            case 71: {
                                if (ch != ';') continue block34;
                                this.state = this.previousState;
                                this.posEnd = this.pos;
                                if (this.paramPC) {
                                    int j = this.pos - 1;
                                    int i = this.posStart + 1;
                                    int len = j - i;
                                    if (len == 2 && this.buf[i] == 'l' && this.buf[i + 1] == 't') {
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC();
                                        }
                                        this.pc[this.pcEnd++] = 60;
                                    } else if (len == 3 && this.buf[i] == 'a' && this.buf[i + 1] == 'm' && this.buf[i + 2] == 'p') {
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC();
                                        }
                                        this.pc[this.pcEnd++] = 38;
                                    } else if (len == 2 && this.buf[i] == 'g' && this.buf[i + 1] == 't') {
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC();
                                        }
                                        this.pc[this.pcEnd++] = 62;
                                    } else if (len == 4 && this.buf[i] == 'a' && this.buf[i + 1] == 'p' && this.buf[i + 2] == 'o' && this.buf[i + 3] == 's') {
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC();
                                        }
                                        this.pc[this.pcEnd++] = 39;
                                    } else if (len == 4 && this.buf[i] == 'q' && this.buf[i + 1] == 'u' && this.buf[i + 2] == 'o' && this.buf[i + 3] == 't') {
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC();
                                        }
                                        this.pc[this.pcEnd++] = 34;
                                    } else {
                                        String s = new String(this.buf, i, j - i);
                                        throw new TokenizerException("undefined entity " + s + this.getPosDesc(), this.posRow, this.posCol - 1);
                                    }
                                }
                                if (!this.paramNotifyEntityRef) continue block34;
                                return 70;
                            }
                            case 75: {
                                this.charRefValue = '\u0000';
                                this.state = (byte)76;
                                if (ch == 'x') {
                                    this.charRefHex = true;
                                    break;
                                }
                                this.charRefHex = false;
                            }
                            case 76: {
                                if (ch == ';') {
                                    if (this.paramPC) {
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC();
                                        }
                                        this.pc[this.pcEnd++] = this.charRefValue;
                                    }
                                    this.state = this.previousState;
                                    this.posEnd = this.pos;
                                    if (!this.paramNotifyCharRef) continue block34;
                                    return 75;
                                }
                                if (ch >= '0' && ch <= '9') {
                                    if (this.charRefHex) {
                                        this.charRefValue = (char)(this.charRefValue * 16 + (ch - 48));
                                        break;
                                    }
                                    this.charRefValue = (char)(this.charRefValue * 10 + (ch - 48));
                                    break;
                                }
                                if (this.charRefHex && ch >= 'A' && ch <= 'F') {
                                    this.charRefValue = (char)(this.charRefValue * 16 + (ch - 65 + 10));
                                    break;
                                }
                                if (this.charRefHex && ch >= 'a' && ch <= 'f') {
                                    this.charRefValue = (char)(this.charRefValue * 16 + (ch - 97 + 10));
                                    break;
                                }
                                throw new TokenizerException("character reference may not contain " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                            case 110: {
                                this.seenStartTag = false;
                                this.seenContent = false;
                                this.posStart = this.pos - 1;
                                ch = this.readName(ch);
                                this.posEnd = this.pos - 1;
                                ch = this.skipS(ch);
                                if (ch != '>') {
                                    throw new TokenizerException("expected > for end tag not " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                                }
                                this.state = (byte)10;
                                return 110;
                            }
                            case 120: {
                                if (this.shrinkable && this.reading && this.pos > 2 && this.pos > this.posSafe) {
                                    this.shrink(this.pos - 2);
                                }
                                this.seenStartTag = true;
                                this.seenContent = false;
                                ch = this.less();
                                this.posStart = this.pos - 1;
                                ch = this.readName(ch);
                                this.posEnd = this.pos - 1;
                                ch = this.less();
                                this.state = (byte)122;
                                this.pcStart = 0;
                                this.pcEnd = 0;
                                return 120;
                            }
                            case 121: {
                                if (ch == '>') {
                                    this.state = (byte)10;
                                    this.posStart = this.pos - 1;
                                    this.posEnd = this.pos;
                                    return 112;
                                }
                                throw new TokenizerException("expected > for end of start tag not " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                            case 122: {
                                this.pcStart = this.pcEnd;
                                boolean seenSBeforeAttrName = this.isS(ch);
                                ch = this.skipS(ch);
                                if (ch == '/') {
                                    this.state = (byte)121;
                                    this.posStart = this.pos - 1;
                                    this.posEnd = this.pos;
                                    this.mixInElement = false;
                                    this.seenStartTag = false;
                                    return 111;
                                }
                                if (ch == '>') {
                                    this.state = (byte)10;
                                    this.posStart = this.pos - 1;
                                    this.posEnd = this.pos;
                                    return 112;
                                }
                                if (!seenSBeforeAttrName) {
                                    throw new TokenizerException("white space expected before attribute name and not " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                                }
                                this.posStart = this.pos - 1;
                                ch = this.readName(ch);
                                this.posEnd = this.pos - 1;
                                ch = this.less();
                                this.state = (byte)123;
                                return 122;
                            }
                            case 123: {
                                ch = this.skipS(ch);
                                if (ch != '=') {
                                    throw new TokenizerException("expected = after attribute name not " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                                }
                                this.state = (byte)124;
                                break;
                            }
                            case 124: {
                                ch = this.skipS(ch);
                                if (ch != '\'' && ch != '\"') {
                                    throw new TokenizerException("attribute value must start with double quote or apostrophe not " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                                }
                                this.attrMarker = ch;
                                this.state = (byte)125;
                                this.posEnd = this.posStart = this.pos;
                                this.pcEnd = this.pcStart;
                                break;
                            }
                            case 125: {
                                this.state = (byte)126;
                            }
                            case 126: {
                                if (ch == this.attrMarker) {
                                    this.state = this.paramPC ? (byte)127 : (byte)122;
                                    if (!this.paramNotifyAttValue) continue block34;
                                    return 124;
                                }
                                if (ch == '&') {
                                    if (this.paramPC) {
                                        this.joinPC();
                                    }
                                    this.state = (byte)70;
                                    this.previousState = (byte)125;
                                    if (!this.paramNotifyAttValue) continue block34;
                                    return 124;
                                }
                                if (ch == '<') {
                                    throw new TokenizerException("attribute value can not contain " + ch + this.getPosDesc(), this.posRow, this.posCol - 1);
                                }
                                if (this.paramPC && (this.pcStart != this.pcEnd || ch == '\t' || ch == '\n' || ch == '\r')) {
                                    this.joinPC();
                                    if (ch == '\t' || ch == '\n' || ch == '\r') {
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC();
                                        }
                                        this.pc[this.pcEnd++] = 32;
                                        break;
                                    }
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC();
                                    }
                                    this.pc[this.pcEnd++] = ch;
                                    break;
                                }
                                this.posEnd = this.pos;
                                break;
                            }
                            case 127: {
                                ch = this.less();
                                this.parsedContent = this.pcEnd != this.pcStart;
                                this.state = (byte)122;
                                return 127;
                            }
                            case 30: {
                                if (ch != ']') continue block34;
                                this.state = (byte)31;
                                break;
                            }
                            case 31: {
                                if (ch == ']') {
                                    this.state = (byte)32;
                                    break;
                                }
                                this.state = (byte)30;
                                break;
                            }
                            case 32: {
                                if (ch == '>') {
                                    this.state = (byte)11;
                                    this.posEnd = this.pos - 3;
                                    if (this.paramPC) {
                                        this.appendPC();
                                    }
                                    if (!this.paramNotifyCDSect) continue block34;
                                    return 30;
                                }
                                if (ch == ']') {
                                    this.state = (byte)32;
                                    break;
                                }
                                this.state = (byte)30;
                                break;
                            }
                            case 40: {
                                if (ch != '-') continue block34;
                                this.state = (byte)41;
                                break;
                            }
                            case 41: {
                                if (ch == '-') {
                                    this.state = (byte)42;
                                    break;
                                }
                                this.state = (byte)40;
                                break;
                            }
                            case 42: {
                                if (ch == '>') {
                                    this.state = (byte)11;
                                    this.posEnd = this.pos - 3;
                                    if (!this.paramNotifyComment) continue block34;
                                    return 40;
                                }
                                if (ch == '-') {
                                    throw new TokenizerException("expected > after -- in coment and not " + ch + this.getPosDesc(), this.posRow, this.posCol - 1);
                                }
                                this.state = (byte)40;
                                break;
                            }
                            case 50: {
                                if (ch == '[') {
                                    this.state = (byte)51;
                                    break;
                                }
                                if (ch != '>') continue block34;
                                this.state = (byte)11;
                                this.posEnd = this.pos - 1;
                                if (!this.paramNotifyDoctype) continue block34;
                                return 50;
                            }
                            case 51: {
                                if (ch != ']') continue block34;
                                this.state = (byte)52;
                                break;
                            }
                            case 52: {
                                ch = this.skipS(ch);
                                if (ch == '>') {
                                    this.state = (byte)11;
                                    this.posEnd = this.pos - 1;
                                    if (!this.paramNotifyDoctype) continue block34;
                                    return 50;
                                }
                                throw new TokenizerException("expected > for DOCTYPE end not " + ch + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                            case 60: {
                                if (ch != '?') continue block34;
                                this.state = (byte)61;
                                break;
                            }
                            case 61: {
                                if (ch != '>') continue block34;
                                this.state = (byte)11;
                                this.posEnd = this.pos - 2;
                                if (!this.paramNotifyPI) continue block34;
                                return 60;
                            }
                            default: {
                                throw new TokenizerException("invalid internal state " + this.state + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                        }
                    }
                }
                catch (EOFException ex) {
                    if (this.state != 12 && this.state != 10 && this.state != 11) {
                        throw new TokenizerException("unexpected end of stream (state=" + this.state + ")" + this.getPosDesc());
                    }
                    this.state = (byte)5;
                    if (!this.paramNotifyCharacters || this.posEnd <= this.posStart) break block143;
                    return 20;
                }
            }
        }
        if (this.state == 5) {
            if (this.state == 10 || this.state == 11) {
                if (this.state == 10) {
                    this.pcStart = 0;
                    this.pcEnd = 0;
                }
                this.posEnd = this.posStart = this.pos - 1;
            }
            this.state = (byte)6;
            if (this.paramPC && (this.pcStart != this.pcEnd || this.posEnd != this.posStart)) {
                boolean bl = this.parsedContent = this.pcEnd != this.pcStart;
                if (!this.paramNoMixContent || !this.seenContent) {
                    return 10;
                }
                if (this.parsedContent) {
                    throw new TokenizerException("no element content allowed before end of stream" + this.getPosDesc());
                }
            }
        }
        if (this.state == 6) {
            this.state = (byte)7;
            return 2;
        }
        throw new TokenizerException("unexpected internal tokenizer state " + this.state + this.getPosDesc(), this.posRow, this.posCol - 1);
    }

    static {
        char ch;
        lookupNameStartChar = new boolean[1024];
        lookupNameChar = new boolean[1024];
        Tokenizer.setNameStart(':');
        for (ch = 'A'; ch <= 'Z'; ch = (char)((char)(ch + 1))) {
            Tokenizer.setNameStart(ch);
        }
        Tokenizer.setNameStart('_');
        for (ch = 'a'; ch <= 'z'; ch = (char)((char)(ch + 1))) {
            Tokenizer.setNameStart(ch);
        }
        for (ch = '\u00c0'; ch <= '\u02ff'; ch = (char)((char)(ch + 1))) {
            Tokenizer.setNameStart(ch);
        }
        for (ch = '\u0370'; ch <= '\u037d'; ch = (char)((char)(ch + 1))) {
            Tokenizer.setNameStart(ch);
        }
        for (ch = '\u037f'; ch < '\u0400'; ch = (char)((char)(ch + '\u0001'))) {
            Tokenizer.setNameStart(ch);
        }
        Tokenizer.setName('-');
        Tokenizer.setName('.');
        for (ch = '0'; ch <= '9'; ch = (char)((char)(ch + 1))) {
            Tokenizer.setName(ch);
        }
        Tokenizer.setName('\u00b7');
        for (ch = '\u0300'; ch <= '\u036f'; ch = (char)(ch + '\u0001')) {
            Tokenizer.setName(ch);
        }
    }
}

