/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.event;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ApplicationListenerMethodAdapter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalApplicationListener;
import org.springframework.transaction.event.TransactionalApplicationListenerSynchronization;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.util.Assert;

public class TransactionalApplicationListenerMethodAdapter
extends ApplicationListenerMethodAdapter
implements TransactionalApplicationListener<ApplicationEvent> {
    private final TransactionPhase transactionPhase;
    private final boolean fallbackExecution;
    private final List<TransactionalApplicationListener.SynchronizationCallback> callbacks = new CopyOnWriteArrayList<TransactionalApplicationListener.SynchronizationCallback>();

    public TransactionalApplicationListenerMethodAdapter(String beanName, Class<?> targetClass, Method method) {
        super(beanName, targetClass, method);
        TransactionalEventListener eventAnn = (TransactionalEventListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.getTargetMethod(), TransactionalEventListener.class);
        if (eventAnn == null) {
            throw new IllegalStateException("No TransactionalEventListener annotation found on method: " + String.valueOf(method));
        }
        this.transactionPhase = eventAnn.phase();
        this.fallbackExecution = eventAnn.fallbackExecution();
    }

    @Override
    public TransactionPhase getTransactionPhase() {
        return this.transactionPhase;
    }

    @Override
    public void addCallback(TransactionalApplicationListener.SynchronizationCallback callback) {
        Assert.notNull((Object)callback, (String)"SynchronizationCallback must not be null");
        this.callbacks.add(callback);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (TransactionalApplicationListenerSynchronization.register(event, this, this.callbacks)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registered transaction synchronization for " + String.valueOf(event)));
            }
        } else if (this.fallbackExecution) {
            if (this.getTransactionPhase() == TransactionPhase.AFTER_ROLLBACK && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Processing " + String.valueOf(event) + " as a fallback execution on AFTER_ROLLBACK phase"));
            }
            this.processEvent(event);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No transaction is active - skipping " + String.valueOf(event)));
        }
    }
}

