/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.port;

import com.ubnt.data.Site;
import com.ubnt.model.api.alert.AlertListDto;
import com.ubnt.model.api.alert.PortAlertListParameterDto;
import com.ubnt.model.api.port.DeviceMacTablesDto;
import com.ubnt.model.api.port.DeviceMacTablesParameterDto;
import com.ubnt.net.security.role.B;
import com.ubnt.net.security.role.String;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.service.alert.O0OOo;
import com.ubnt.service.alert.ifnew;
import com.ubnt.service.alert.ooOo;
import com.ubnt.service.port.insight.A;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="Ports Insight")
public class PortsInsightController {
    private final O0OOo \u00d200000;
    private final ifnew o00000;
    private final A String;
    private final B \u00d300000;

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/ports/mac-tables"})
    @Operation(summary="Retrieve MAC tables of specific devices and ports", description="Since 9.4.4")
    public List<DeviceMacTablesDto> retrieveMacTables(@PathVariable(value="siteName") Site site, @RequestBody @Valid List<DeviceMacTablesParameterDto> list) {
        Map<java.lang.String, List<Integer>> map = list.stream().collect(Collectors.toMap(DeviceMacTablesParameterDto::getMac, DeviceMacTablesParameterDto::getPortIndexes));
        return this.String.\u00d400000(site.getId(), map);
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/ports/system-logs"})
    @Operation(summary="Retrieve system-logs of specific device port", description="Since 10.0.65")
    public AlertListDto listAllSystemLogsOfPort(@PathVariable(value="siteName") Site site, @RequestBody @Valid PortAlertListParameterDto portAlertListParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.super(site, httpServletRequest, httpServletResponse);
        ooOo ooOo2 = this.o00000.oO0000(site.getId(), portAlertListParameterDto, string);
        return AlertListDto.builder().totalElementCount(ooOo2.\u00d300000()).totalPageCount(ooOo2.\u00d400000()).pageNumber(ooOo2.super()).data(this.\u00d200000.\u00d600000(ooOo2.\u00d200000(), false)).build();
    }

    private String super(Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d300000.\u00d300000(httpServletRequest, httpServletResponse, site.getId());
    }

    @ConstructorProperties(value={"alertDocumentMapper", "alertSearchService", "portsInsightService", "roleManager"})
    @Generated
    public PortsInsightController(O0OOo o0OOo2, ifnew ifnew2, A a2, B b2) {
        this.\u00d200000 = o0OOo2;
        this.o00000 = ifnew2;
        this.String = a2;
        this.\u00d300000 = b2;
    }
}

