/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.logging;

import com.mongodb.connection.ClusterId;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.logging.LogMessage;
import com.mongodb.internal.logging.LoggingInterceptor;
import com.mongodb.lang.Nullable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class StructuredLogger {
    private static final ConcurrentHashMap<String, LoggingInterceptor> INTERCEPTORS = new ConcurrentHashMap();
    private final Logger logger;

    public static void addInterceptor(String clusterDescription, LoggingInterceptor interceptor) {
        INTERCEPTORS.put(clusterDescription, interceptor);
    }

    public static void removeInterceptor(String clusterDescription) {
        INTERCEPTORS.remove(clusterDescription);
    }

    @Nullable
    private static LoggingInterceptor getInterceptor(@Nullable String clusterDescription) {
        if (clusterDescription == null) {
            return null;
        }
        return INTERCEPTORS.get(clusterDescription);
    }

    public StructuredLogger(String suffix) {
        this(Loggers.getLogger(suffix));
    }

    public StructuredLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isRequired(LogMessage.Level level, ClusterId clusterId) {
        if (StructuredLogger.getInterceptor(clusterId.getDescription()) != null) {
            return true;
        }
        switch (level) {
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
        }
        throw new UnsupportedOperationException();
    }

    public void log(LogMessage logMessage) {
        LoggingInterceptor interceptor = StructuredLogger.getInterceptor(logMessage.getClusterId().getDescription());
        if (interceptor != null) {
            interceptor.intercept(logMessage);
        }
        switch (logMessage.getLevel()) {
            case DEBUG: {
                StructuredLogger.logUnstructured(logMessage, this.logger::isDebugEnabled, this.logger::debug, this.logger::debug);
                break;
            }
            case INFO: {
                StructuredLogger.logUnstructured(logMessage, this.logger::isInfoEnabled, this.logger::info, this.logger::info);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void logUnstructured(LogMessage logMessage, Supplier<Boolean> loggingEnabled, Consumer<String> doLog, BiConsumer<String, Throwable> doLogWithException) {
        if (loggingEnabled.get().booleanValue()) {
            LogMessage.UnstructuredLogMessage unstructuredLogMessage = logMessage.toUnstructuredLogMessage();
            String message = unstructuredLogMessage.interpolate();
            Throwable exception = logMessage.getException();
            if (exception == null) {
                doLog.accept(message);
            } else {
                doLogWithException.accept(message, exception);
            }
        }
    }
}

