/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.jackson2.JacksonMcpJsonMapper;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.transport.HttpServletStreamableServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStreamableServerTransportProvider;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.traccar.api.security.PermissionsService;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.geocoder.Geocoder;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;
import reactor.core.publisher.Mono;

@Singleton
public class McpServerHolder
implements AutoCloseable {
    public static final String PATH = "/api/mcp";
    private final Storage storage;
    private final Provider<PermissionsService> permissionsService;
    private final Geocoder geocoder;
    private final boolean geocodeOnRequest;
    private final HttpServletStreamableServerTransportProvider transport;
    private final McpAsyncServer server;

    @Inject
    public McpServerHolder(ObjectMapper objectMapper, Storage storage, Provider<PermissionsService> permissionsService, Config config, @Nullable Geocoder geocoder) {
        this.storage = storage;
        this.permissionsService = permissionsService;
        this.geocoder = geocoder;
        this.geocodeOnRequest = config.getBoolean(Keys.GEOCODER_ON_REQUEST);
        this.transport = HttpServletStreamableServerTransportProvider.builder().mcpEndpoint(PATH).jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(objectMapper)).contextExtractor(this::extractTransportContext).build();
        McpSchema.ServerCapabilities capabilities = McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).resources(Boolean.valueOf(false), Boolean.valueOf(true)).prompts(Boolean.valueOf(true)).build();
        this.server = McpServer.async((McpStreamableServerTransportProvider)this.transport).serverInfo("traccar-mcp", "1.0.0").capabilities(capabilities).tools(new McpServerFeatures.AsyncToolSpecification[]{this.createVersionTool(), this.createDevicePositionTool()}).build();
    }

    private McpTransportContext extractTransportContext(HttpServletRequest request) {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        Object userId = request.getAttribute("userId");
        if (userId != null) {
            contextData.put("userId", userId);
        }
        if (contextData.isEmpty()) {
            return McpTransportContext.EMPTY;
        }
        return McpTransportContext.create(contextData);
    }

    private McpServerFeatures.AsyncToolSpecification createVersionTool() {
        McpSchema.JsonSchema inputSchema = new McpSchema.JsonSchema("object", Collections.emptyMap(), null, null, null, null);
        McpSchema.Tool toolSchema = McpSchema.Tool.builder().name("traccar-version").title("Returns server version name").inputSchema(inputSchema).build();
        return McpServerFeatures.AsyncToolSpecification.builder().tool(toolSchema).callHandler((context, request) -> {
            String version = this.getClass().getPackage().getImplementationVersion();
            McpSchema.CallToolResult result = new McpSchema.CallToolResult(version != null ? version : "Unknown", Boolean.valueOf(false));
            return Mono.just((Object)result);
        }).build();
    }

    private McpServerFeatures.AsyncToolSpecification createDevicePositionTool() {
        McpSchema.JsonSchema deviceIdSchema = new McpSchema.JsonSchema("number", Collections.emptyMap(), null, null, null, null);
        McpSchema.JsonSchema inputSchema = new McpSchema.JsonSchema("object", Map.of("deviceId", deviceIdSchema), Collections.singletonList("deviceId"), null, null, null);
        McpSchema.Tool toolSchema = McpSchema.Tool.builder().name("device-position").title("Returns latest device position with address and other parameters").inputSchema(inputSchema).build();
        return McpServerFeatures.AsyncToolSpecification.builder().tool(toolSchema).callHandler(this::getDevicePosition).build();
    }

    private McpSchema.CallToolResult errorResult(String message) {
        return McpSchema.CallToolResult.builder().addTextContent(message).isError(Boolean.valueOf(true)).build();
    }

    private Mono<McpSchema.CallToolResult> getDevicePosition(McpAsyncServerExchange context, McpSchema.CallToolRequest request) {
        Long userId = (Long)context.transportContext().get("userId");
        if (userId == null) {
            return Mono.just((Object)this.errorResult("User context is missing"));
        }
        Object deviceIdValue = request.arguments().get("deviceId");
        if (!(deviceIdValue instanceof Number)) {
            return Mono.just((Object)this.errorResult("deviceId argument is required"));
        }
        Number deviceIdNumber = (Number)deviceIdValue;
        long deviceId = deviceIdNumber.longValue();
        try {
            ((PermissionsService)this.permissionsService.get()).checkPermission(Device.class, userId, deviceId);
            Position position = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.LatestPositions(deviceId)));
            if (position == null) {
                return Mono.just((Object)this.errorResult("No position available for device"));
            }
            String address = position.getAddress();
            if (address == null && this.geocoder != null && this.geocodeOnRequest) {
                position.setAddress(this.geocoder.getAddress(position.getLatitude(), position.getLongitude(), null));
            }
            return Mono.just((Object)McpSchema.CallToolResult.builder().structuredContent((Object)position).isError(Boolean.valueOf(false)).build());
        }
        catch (SecurityException | StorageException e) {
            return Mono.just((Object)this.errorResult(e.getMessage()));
        }
    }

    public HttpServlet getServlet() {
        return this.transport;
    }

    @Override
    public void close() throws Exception {
        this.server.close();
    }
}

