/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.DataConverter;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class SmartcarProtocolDecoder
extends BaseHttpProtocolDecoder {
    public SmartcarProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        JsonObject root = Json.createReader((Reader)new StringReader(request.content().toString(StandardCharsets.UTF_8))).readObject();
        String eventType = root.getString("eventType");
        JsonObject data = root.getJsonObject("data");
        if ("VERIFY".equals(eventType)) {
            String challenge = data.getString("challenge");
            String managementToken = this.getConfig().getString(Keys.SMARTCAR_MANAGEMENT_TOKEN);
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(managementToken.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            String signedChallenge = DataConverter.printHex(mac.doFinal(challenge.getBytes(StandardCharsets.UTF_8)));
            this.sendResponse(channel, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)Json.createObjectBuilder().add("challenge", signedChallenge).build().toString(), (Charset)StandardCharsets.UTF_8));
            return null;
        }
        if (!"VEHICLE_STATE".equals(eventType)) {
            this.sendResponse(channel, HttpResponseStatus.OK);
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, root.getString("vehicleId"));
        if (deviceSession == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new Date(root.getJsonObject("meta").getJsonNumber("deliveredAt").longValue()));
        JsonArray signals = data.getJsonArray("signals");
        block16: for (JsonValue signalValue : signals) {
            JsonObject signal = signalValue.asJsonObject();
            JsonObject body = signal.getJsonObject("body");
            String code = signal.getString("code");
            JsonValue value = (JsonValue)body.get((Object)"value");
            String unit = body.getString("unit", null);
            switch (code) {
                case "location-preciselocation": {
                    position.setValid(true);
                    position.setLatitude(body.getJsonNumber("latitude").doubleValue());
                    position.setLongitude(body.getJsonNumber("longitude").doubleValue());
                    JsonObject meta = signal.getJsonObject("meta");
                    position.setFixTime(new Date(meta.getJsonNumber("oemUpdatedAt").longValue()));
                    position.setDeviceTime(new Date(meta.getJsonNumber("fetchedAt").longValue()));
                    break;
                }
                case "tractionbattery-stateofcharge": {
                    if (!(value instanceof JsonNumber)) continue block16;
                    JsonNumber number = (JsonNumber)value;
                    position.set("batteryLevel", number.doubleValue());
                    break;
                }
                case "charge-ischarging": {
                    if (value != JsonValue.TRUE && value != JsonValue.FALSE) continue block16;
                    position.set("charge", value == JsonValue.TRUE);
                    break;
                }
                case "charge-voltage": {
                    if (!(value instanceof JsonNumber)) continue block16;
                    JsonNumber number = (JsonNumber)value;
                    position.set("power", number.doubleValue());
                    break;
                }
                case "odometer": {
                    if (!(value instanceof JsonNumber)) continue block16;
                    JsonNumber number = (JsonNumber)value;
                    position.set("odometer", "miles".equalsIgnoreCase(unit) ? number.doubleValue() * 1609.344 : number.doubleValue() * 1000.0);
                    break;
                }
                case "speed": {
                    if (!(value instanceof JsonNumber)) continue block16;
                    JsonNumber number = (JsonNumber)value;
                    position.setSpeed("miles_per_hour".equalsIgnoreCase(unit) ? UnitsConverter.knotsFromMph(number.doubleValue()) : UnitsConverter.knotsFromKph(number.doubleValue()));
                    break;
                }
                default: {
                    JsonNumber number;
                    if (value instanceof JsonNumber) {
                        number = (JsonNumber)value;
                        position.set(code, number.doubleValue());
                        break;
                    }
                    if (value != JsonValue.TRUE && value != JsonValue.FALSE) continue block16;
                    position.set(code, value == JsonValue.TRUE);
                }
            }
        }
        if (!position.getValid()) {
            this.getLastLocation(position, position.getDeviceTime());
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return position;
    }
}

