/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import jakarta.inject.Inject;
import org.traccar.handler.BasePositionHandler;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class EngineHoursHandler
extends BasePositionHandler {
    private final CacheManager cacheManager;

    @Inject
    public EngineHoursHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void onPosition(Position position, BasePositionHandler.Callback callback) {
        Position last;
        if (!position.hasAttribute("hours") && (last = this.cacheManager.getPosition(position.getDeviceId())) != null) {
            long hours = last.getLong("hours");
            if (last.getBoolean("ignition") && position.getBoolean("ignition")) {
                hours += position.getDeviceTime().getTime() - last.getDeviceTime().getTime();
            }
            if (hours != 0L) {
                position.set("hours", hours);
            }
        }
        callback.processed(false);
    }
}

