/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.hybrid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.search.Combiner;
import redis.clients.jedis.search.SearchProtocol;
import redis.clients.jedis.search.hybrid.FTHybridPostProcessingParams;
import redis.clients.jedis.search.hybrid.FTHybridSearchParams;
import redis.clients.jedis.search.hybrid.FTHybridVectorParams;
import redis.clients.jedis.util.JedisAsserts;

@Experimental
public class FTHybridParams
implements IParams {
    private final List<FTHybridSearchParams> searchArgs = new ArrayList<FTHybridSearchParams>();
    private final List<FTHybridVectorParams> vectorArgs = new ArrayList<FTHybridVectorParams>();
    private Combiner combiner;
    private FTHybridPostProcessingParams postProcessingArgs;
    private final Map<String, Object> params = new HashMap<String, Object>();
    private Long timeout;

    private FTHybridParams() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void addParams(CommandArguments args) {
        for (FTHybridSearchParams fTHybridSearchParams : this.searchArgs) {
            fTHybridSearchParams.addParams(args);
        }
        for (FTHybridVectorParams fTHybridVectorParams : this.vectorArgs) {
            fTHybridVectorParams.addParams(args);
        }
        if (this.combiner != null) {
            args.add(SearchProtocol.SearchKeyword.COMBINE);
            this.combiner.addParams(args);
        }
        if (this.postProcessingArgs != null) {
            this.postProcessingArgs.addParams(args);
        }
        if (!this.params.isEmpty()) {
            args.add(SearchProtocol.SearchKeyword.PARAMS);
            args.add(this.params.size() * 2);
            for (Map.Entry entry : this.params.entrySet()) {
                args.add((String)entry.getKey());
                args.add(entry.getValue());
            }
        }
        if (this.timeout != null) {
            args.add(SearchProtocol.SearchKeyword.TIMEOUT);
            args.add(this.timeout);
        }
    }

    public static class Builder {
        private final FTHybridParams instance = new FTHybridParams();

        public FTHybridParams build() {
            JedisAsserts.isTrue(!this.instance.searchArgs.isEmpty(), "At least one SEARCH clause must be configured");
            JedisAsserts.isTrue(!this.instance.vectorArgs.isEmpty(), "At least one VSIM clause must be configured");
            return this.instance;
        }

        public Builder search(FTHybridSearchParams searchArgs) {
            JedisAsserts.notNull(searchArgs, "Search args must not be null");
            this.instance.searchArgs.add(searchArgs);
            return this;
        }

        public Builder vectorSearch(FTHybridVectorParams vectorArgs) {
            JedisAsserts.notNull(vectorArgs, "Vector args must not be null");
            this.instance.vectorArgs.add(vectorArgs);
            return this;
        }

        public Builder combine(Combiner combiner) {
            JedisAsserts.notNull(combiner, "Combiner must not be null");
            this.instance.combiner = combiner;
            return this;
        }

        public Builder postProcessing(FTHybridPostProcessingParams postProcessingArgs) {
            JedisAsserts.notNull(postProcessingArgs, "PostProcessingParams must not be null");
            this.instance.postProcessingArgs = postProcessingArgs;
            return this;
        }

        public Builder param(String name, Object value) {
            JedisAsserts.notNull(name, "Parameter name must not be null");
            JedisAsserts.notNull(value, "Parameter value must not be null");
            this.instance.params.put(name, value);
            return this;
        }

        public Builder timeout(long timeout) {
            this.instance.timeout = timeout;
            return this;
        }
    }
}

