/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.search.Combiner;
import redis.clients.jedis.search.SearchProtocol;

@Experimental
public final class Combiners {
    private Combiners() {
    }

    public static RRF rrf() {
        return new RRF();
    }

    public static Linear linear() {
        return new Linear();
    }

    public static class Linear
    extends Combiner {
        private Double alpha;
        private Double beta;
        private Integer window;

        Linear() {
            super("LINEAR");
        }

        public Linear alpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public Linear beta(double beta) {
            this.beta = beta;
            return this;
        }

        public Linear window(int window) {
            this.window = window;
            return this;
        }

        @Override
        protected List<Object> getOwnArgs() {
            if (this.alpha == null && this.beta == null && this.window == null) {
                return Collections.emptyList();
            }
            ArrayList<Object> args = new ArrayList<Object>();
            if (this.alpha != null) {
                args.add(SearchProtocol.SearchKeyword.ALPHA);
                args.add(this.alpha);
            }
            if (this.beta != null) {
                args.add(SearchProtocol.SearchKeyword.BETA);
                args.add(this.beta);
            }
            if (this.window != null) {
                args.add(SearchProtocol.SearchKeyword.WINDOW);
                args.add(this.window);
            }
            return args;
        }
    }

    public static class RRF
    extends Combiner {
        private Integer window;
        private Double constant;

        RRF() {
            super("RRF");
        }

        public RRF window(int window) {
            this.window = window;
            return this;
        }

        public RRF constant(double constant) {
            this.constant = constant;
            return this;
        }

        @Override
        protected List<Object> getOwnArgs() {
            if (this.window == null && this.constant == null) {
                return Collections.emptyList();
            }
            ArrayList<Object> args = new ArrayList<Object>();
            if (this.window != null) {
                args.add(SearchProtocol.SearchKeyword.WINDOW);
                args.add(this.window);
            }
            if (this.constant != null) {
                args.add(SearchProtocol.SearchKeyword.CONSTANT);
                args.add(this.constant);
            }
            return args;
        }
    }
}

