/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure.core;

import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import org.apache.commons.lang3.StringUtils;

public class StoredProcedure
extends StoredDatabaseLogic<StoredProcedure> {
    public StoredProcedure() {
    }

    public StoredProcedure(String catalogName, String schemaName, String procedureName) {
        this.setSchema(new Schema(catalogName, schemaName));
        this.setName(procedureName);
    }

    public String getArguments() {
        return (String)((Object)this.getAttribute("arg", String.class));
    }

    public StoredProcedure setArguments(String arg) {
        this.setAttribute("arg", arg);
        return this;
    }

    public String getProcedureName() {
        return (String)((Object)this.getAttribute("procedureName", String.class));
    }

    public StoredProcedure setProcedureName(String procedureName) {
        this.setAttribute("procedureName", procedureName);
        return this;
    }

    public static String getProcedureName(DatabaseObject dbObject) {
        if (dbObject instanceof StoredProcedure) {
            StoredProcedure procedure = (StoredProcedure)dbObject;
            return StringUtils.isNotEmpty((CharSequence)procedure.getProcedureName()) ? procedure.getProcedureName() : procedure.getName();
        }
        throw new IllegalArgumentException("Expected Procedure, got: " + (dbObject == null ? "null" : dbObject.getClass().getName()));
    }
}

