/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.changelog.ChangeLogChild;
import liquibase.changelog.ChangeSet;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.diff.output.changelog.core.ChangelogPrintService;
import liquibase.exception.DatabaseException;
import liquibase.resource.OpenOptions;
import liquibase.resource.Resource;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.util.StreamUtil;

public class StandardChangelogPrintService
implements ChangelogPrintService {
    protected DiffToChangeLog diffToChangeLog;

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public ChangelogPrintService setDiffChangelog(DiffToChangeLog diffToChangeLog) {
        this.diffToChangeLog = diffToChangeLog;
        return this;
    }

    @Override
    public void printNew(ChangeLogSerializer changeLogSerializer, Resource file) throws ParserConfigurationException, IOException, DatabaseException {
        List<ChangeSet> changeSets = this.diffToChangeLog.generateChangeSets();
        ArrayList<ChangeLogChild> changeLogChildren = new ArrayList<ChangeLogChild>(changeSets);
        this.printChangeSets(changeLogSerializer, file, changeLogChildren, new OpenOptions());
    }

    @Override
    public void printToExisting(ChangeLogSerializer changeLogSerializer, Resource file, boolean overwriteOutputFile) throws ParserConfigurationException, IOException, DatabaseException {
        StringBuilder fileContents = new StringBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.print(file, new PrintStream((OutputStream)out, true, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()), changeLogSerializer);
        String xml = out.toString(GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue());
        if (overwriteOutputFile) {
            Scope.getCurrentScope().getLog(this.getClass()).info(String.valueOf(file.getUri()) + " exists, overwriting");
            fileContents.append(xml);
        } else {
            Scope.getCurrentScope().getLog(this.getClass()).info(String.valueOf(file.getUri()) + " exists, appending");
            fileContents = new StringBuilder(StreamUtil.readStreamAsString(file.openInputStream()));
            String innerXml = xml.replaceFirst("(?ms).*<databaseChangeLog[^>]*>", "");
            innerXml = innerXml.replaceFirst("</databaseChangeLog>", "");
            innerXml = innerXml.trim();
            if (innerXml.isEmpty()) {
                Scope.getCurrentScope().getLog(this.getClass()).info("No changes found, nothing to do");
                return;
            }
            int endTagIndex = fileContents.indexOf("</databaseChangeLog>");
            if (endTagIndex == -1) {
                fileContents.append(xml);
            } else {
                String lineSeparator = GlobalConfiguration.OUTPUT_LINE_SEPARATOR.getCurrentValue();
                String toInsert = "    " + innerXml + lineSeparator;
                fileContents.insert(endTagIndex, toInsert);
            }
        }
        try (OutputStream outputStream = file.openOutputStream(new OpenOptions());){
            outputStream.write(fileContents.toString().getBytes());
        }
    }

    @Override
    public void printChangeSets(ChangeLogSerializer changeLogSerializer, Resource file, List<ChangeLogChild> changelogChildren, OpenOptions openOptions) throws IOException {
        Scope.getCurrentScope().getLog(this.getClass()).info("changeSets count: " + changelogChildren.size());
        if (changelogChildren.isEmpty()) {
            Scope.getCurrentScope().getLog(this.getClass()).info("No changesets to add to the changelog output.");
        } else {
            Scope.getCurrentScope().getLog(this.getClass()).info(String.valueOf(file) + " does not exist, creating and adding " + changelogChildren.size() + " changesets.");
            try (OutputStream stream = file.openOutputStream(openOptions);
                 PrintStream out = new PrintStream(stream, true, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue());){
                changeLogSerializer.write(changelogChildren, out);
            }
        }
    }

    @Override
    public void print(Resource ignored, PrintStream out, ChangeLogSerializer changeLogSerializer) throws ParserConfigurationException, IOException, DatabaseException {
        this.diffToChangeLog.print(new PrintStream((OutputStream)out, true, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()), changeLogSerializer);
    }
}

