/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class PositrexProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_PING = 46;

    public PositrexProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Date readTime(ByteBuf buf) {
        long time = buf.readUnsignedInt();
        DateBuilder dateBuilder = new DateBuilder();
        dateBuilder.setSecond((int)(time % 60L));
        dateBuilder.setMinute((int)((time /= 60L) % 60L));
        dateBuilder.setHour((int)((time /= 60L) % 24L));
        dateBuilder.setDay((int)((time /= 24L) % 32L));
        dateBuilder.setMonth((int)((time /= 32L) % 13L));
        dateBuilder.setYear((int)(2000L + time / 13L));
        return dateBuilder.getDate();
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        short first = buf.getUnsignedByte(buf.readerIndex());
        long deviceId = BitUtil.check(first, 7) ? (BitUtil.check(first, 6) ? 73000000L + BitUtil.to(buf.readUnsignedInt(), 30) : (!BitUtil.check(first, 5) && !BitUtil.check(first, 4) ? (long)(7590000 + BitUtil.to(buf.readUnsignedMedium(), 20)) : (long)(70000000 + BitUtil.to(buf.readUnsignedMedium(), 20)))) : (long)(7560000 + buf.readUnsignedShort());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(deviceId));
        if (deviceSession == null) {
            return null;
        }
        short service = buf.readUnsignedByte();
        if (service == 46) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(this.readTime(buf));
            int latitude = buf.readMedium();
            int longitude = buf.readMedium();
            position.setValid(BitUtil.check(latitude, 23));
            position.setLatitude((double)BitUtil.to(latitude, 23) * 2.5E-5);
            position.setLongitude((double)longitude * 2.5E-5);
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
            position.setCourse(buf.readUnsignedByte() * 2);
            position.set("io", buf.readUnsignedByte());
            position.set("odometer", buf.readUnsignedInt());
            buf.readUnsignedInt();
            buf.readUnsignedInt();
            buf.readUnsignedInt();
            if (buf.isReadable()) {
                position.set("power", (double)buf.readUnsignedShort() * 0.01);
                position.set("battery", (double)buf.readUnsignedShort() * 0.01);
            }
            return position;
        }
        return null;
    }
}

