/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.util.List;
import java.util.Objects;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public final class TestSuiteInfo {
    @NonNull
    private String name;
    private String moduleName;
    private String modulePath;
    private String file;
    private Range range;
    @NonNull
    private String state;
    private List<TestCaseInfo> tests;

    public TestSuiteInfo() {
        this("", "");
    }

    public TestSuiteInfo(@NonNull String name, @NonNull String state) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name");
        this.state = (String)Preconditions.checkNotNull((Object)state, (String)"state");
    }

    public TestSuiteInfo(@NonNull String name, String moduleName, String modulePath, String file, Range range, @NonNull String state, List<TestCaseInfo> tests) {
        this(name, state);
        this.moduleName = moduleName;
        this.modulePath = modulePath;
        this.file = file;
        this.range = range;
        this.tests = tests;
    }

    @Pure
    @NonNull
    public String getName() {
        return this.name;
    }

    public TestSuiteInfo setSuiteName(@NonNull String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name");
        return this;
    }

    @Pure
    public String getModuleName() {
        return this.moduleName;
    }

    public TestSuiteInfo setModuleName(String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    @Pure
    public String getModulePath() {
        return this.modulePath;
    }

    public TestSuiteInfo setModulePath(String modulePath) {
        this.modulePath = modulePath;
        return this;
    }

    @Pure
    public String getFile() {
        return this.file;
    }

    public TestSuiteInfo setFile(String file) {
        this.file = file;
        return this;
    }

    @Pure
    public Range getRange() {
        return this.range;
    }

    public TestSuiteInfo setRange(Range range) {
        this.range = range;
        return this;
    }

    @Pure
    @NonNull
    public String getState() {
        return this.state;
    }

    public TestSuiteInfo setState(@NonNull String state) {
        this.state = (String)Preconditions.checkNotNull((Object)state, (String)"state");
        return this;
    }

    @Pure
    public List<TestCaseInfo> getTests() {
        return this.tests;
    }

    public TestSuiteInfo setTests(List<TestCaseInfo> tests) {
        this.tests = tests;
        return this;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("name", (Object)this.name);
        b.add("moduleName", (Object)this.moduleName);
        b.add("modulePath", (Object)this.modulePath);
        b.add("file", (Object)this.file);
        b.add("range", (Object)this.range);
        b.add("state", (Object)this.state);
        b.add("tests", this.tests);
        return b.toString();
    }

    @Pure
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.name);
        hash = 67 * hash + Objects.hashCode(this.moduleName);
        hash = 67 * hash + Objects.hashCode(this.modulePath);
        hash = 67 * hash + Objects.hashCode(this.file);
        hash = 67 * hash + Objects.hashCode(this.range);
        hash = 67 * hash + Objects.hashCode(this.state);
        hash = 67 * hash + Objects.hashCode(this.tests);
        return hash;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestSuiteInfo other = (TestSuiteInfo)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.moduleName, other.moduleName)) {
            return false;
        }
        if (!Objects.equals(this.modulePath, other.modulePath)) {
            return false;
        }
        if (!Objects.equals(this.file, other.file)) {
            return false;
        }
        if (!Objects.equals(this.range, other.range)) {
            return false;
        }
        if (!Objects.equals(this.state, other.state)) {
            return false;
        }
        return Objects.equals(this.tests, other.tests);
    }

    public static final class State {
        public static final String Loaded = "loaded";
        public static final String Started = "started";
        public static final String Passed = "passed";
        public static final String Failed = "failed";
        public static final String Skipped = "skipped";
        public static final String Errored = "errored";

        private State() {
        }
    }

    public static final class TestCaseInfo {
        @NonNull
        private String id;
        @NonNull
        private String name;
        private String file;
        private Range range;
        @NonNull
        private String state;
        private List<String> stackTrace;

        public TestCaseInfo() {
            this("", "", "");
        }

        public TestCaseInfo(@NonNull String id, @NonNull String name, @NonNull String state) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (String)"id");
            this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name");
            this.state = (String)Preconditions.checkNotNull((Object)state, (String)"state");
        }

        public TestCaseInfo(@NonNull String id, @NonNull String name, String file, Range range, @NonNull String state, List<String> stackTrace) {
            this(id, name, state);
            this.file = file;
            this.range = range;
            this.stackTrace = stackTrace;
        }

        @Pure
        @NonNull
        public String getId() {
            return this.id;
        }

        public TestCaseInfo setId(@NonNull String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (String)"id");
            return this;
        }

        @Pure
        @NonNull
        public String getName() {
            return this.name;
        }

        public TestCaseInfo setName(@NonNull String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name");
            return this;
        }

        @Pure
        public String getFile() {
            return this.file;
        }

        public TestCaseInfo setFile(String file) {
            this.file = file;
            return this;
        }

        @Pure
        public Range getRange() {
            return this.range;
        }

        public TestCaseInfo setRange(Range range) {
            this.range = range;
            return this;
        }

        @Pure
        @NonNull
        public String getState() {
            return this.state;
        }

        public TestCaseInfo setState(@NonNull String state) {
            this.state = (String)Preconditions.checkNotNull((Object)state, (String)"state");
            return this;
        }

        @Pure
        public List<String> getStackTrace() {
            return this.stackTrace;
        }

        public TestCaseInfo setStackTrace(List<String> stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("id", (Object)this.id);
            b.add("name", (Object)this.name);
            b.add("file", (Object)this.file);
            b.add("range", (Object)this.range);
            b.add("state", (Object)this.state);
            b.add("stackTrace", this.stackTrace);
            return b.toString();
        }

        @Pure
        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.id);
            hash = 97 * hash + Objects.hashCode(this.name);
            hash = 97 * hash + Objects.hashCode(this.file);
            hash = 97 * hash + Objects.hashCode(this.range);
            hash = 97 * hash + Objects.hashCode(this.state);
            hash = 97 * hash + Objects.hashCode(this.stackTrace);
            return hash;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestCaseInfo other = (TestCaseInfo)obj;
            if (!Objects.equals(this.id, other.id)) {
                return false;
            }
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            if (!Objects.equals(this.file, other.file)) {
                return false;
            }
            if (!Objects.equals(this.range, other.range)) {
                return false;
            }
            if (!Objects.equals(this.state, other.state)) {
                return false;
            }
            return Objects.equals(this.stackTrace, other.stackTrace);
        }
    }
}

