/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.project;

import java.io.IOException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seembedded.project.Utilities;
import org.netbeans.modules.java.j2seproject.api.J2SECustomPropertySaver;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class RemotePlatformProjectSaver
implements J2SECustomPropertySaver {
    public void save(final @NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Runnable action = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean hasExtension = Utilities.hasRemoteExtension(project);
                    Utilities.UpdateConfigResult res = Utilities.updateRemotePlatformConfigurations(project);
                    if (!hasExtension && res.hasRemotePlatform()) {
                        try {
                            Utilities.addRemoteExtension(project);
                            ProjectManager.getDefault().saveProject(project);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        };
        RemotePlatformProjectSaver.runDeferred(action);
    }

    private static void runDeferred(final @NonNull Runnable r) {
        ProjectManager.mutex().postReadRequest(new Runnable(){

            @Override
            public void run() {
                ProjectManager.mutex().postWriteRequest(r);
            }
        });
    }
}

