/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools.util;

public enum Comparison {
    LESS_THAN("<"),
    LESS_THAN_OR_EQUAL("<="),
    EQUAL("="),
    GREATER_THAN_OR_EQUAL(">="),
    GREATER_THAN(">"),
    RANGE_INCLUDING("..."),
    RANGE_EXCLUDING_TO("..<"),
    RANGE_EXCLUDING_FROM(">.."),
    RANGE_EXCLUDING(">.<");

    private final String operator;

    private Comparison(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public static Comparison fromText(String text) {
        switch (text) {
            case "<": {
                return LESS_THAN;
            }
            case "<=": {
                return LESS_THAN_OR_EQUAL;
            }
            case "=": {
                return EQUAL;
            }
            case ">=": {
                return GREATER_THAN_OR_EQUAL;
            }
            case ">": {
                return GREATER_THAN;
            }
            case "...": {
                return RANGE_INCLUDING;
            }
            case "..<": {
                return RANGE_EXCLUDING_TO;
            }
            case ">..": {
                return RANGE_EXCLUDING_FROM;
            }
            case ">.<": {
                return RANGE_EXCLUDING;
            }
        }
        return EQUAL;
    }
}

