/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.spi.SaasViewProvider;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SaasExplorerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private JPanel innerPanel;
    private JLabel selectWsdlLbl;
    private DialogDescriptor descriptor;
    private ExplorerManager manager = new ExplorerManager();
    private BeanTreeView treeView;
    private WsdlSaas wsdl;

    public SaasExplorerPanel() {
        this.initComponents();
        this.initUserComponents();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        SaasViewProvider saasView = (SaasViewProvider)Lookup.getDefault().lookup(SaasViewProvider.class);
        if (saasView != null) {
            Node saasRootNode = saasView.getSaasView();
            this.manager.setRootContext(saasRootNode);
        }
        this.descriptor.setValid(false);
    }

    @Override
    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Node[] nodes;
        if (evt.getSource() == this.manager && "selectedNodes".equals(evt.getPropertyName()) && (nodes = this.manager.getSelectedNodes()) != null && nodes.length > 0) {
            Node node = nodes[0];
            this.wsdl = (WsdlSaas)node.getLookup().lookup(WsdlSaas.class);
            if (this.wsdl != null) {
                this.descriptor.setValid(true);
            } else {
                this.descriptor.setValid(false);
            }
        }
    }

    WsdlSaas getWsdlSaas() {
        return this.wsdl;
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.add((Component)this.treeView, "Center");
        this.selectWsdlLbl.setLabelFor(this.treeView.getViewport().getView());
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SaasExplorerPanel.class, (String)"ACSN_SaasTreeView"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SaasExplorerPanel.class, (String)"ACSD_SaasTreeView"));
    }

    private void initComponents() {
        this.selectWsdlLbl = new JLabel();
        this.innerPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.selectWsdlLbl, (String)NbBundle.getMessage(SaasExplorerPanel.class, (String)"LBL_SelectWSDL"));
        this.innerPanel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout innerPanelLayout = new GroupLayout(this.innerPanel);
        this.innerPanel.setLayout(innerPanelLayout);
        innerPanelLayout.setHorizontalGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 376, Short.MAX_VALUE));
        innerPanelLayout.setVerticalGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 254, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.innerPanel, -1, -1, Short.MAX_VALUE).addComponent(this.selectWsdlLbl)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.selectWsdlLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.innerPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }
}

