/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.wizards;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.core.api.support.classpath.ContainerClassPathModifier;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlParameter;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.ServiceCreator;
import org.netbeans.modules.websvc.api.support.java.GenerationUtils;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JaxWsServiceCreator
implements ServiceCreator {
    private static final String SOAP_BINDING_TYPE = "javax.xml.ws.soap.SOAPBinding";
    private static final String BINDING_TYPE_ANNOTATION = "javax.xml.ws.BindingType";
    private static final String SOAP12_HTTP_BINDING = "SOAP12HTTP_BINDING";
    private Project project;
    private WizardDescriptor wiz;
    private boolean addJaxWsLib;
    private int serviceType;
    private static final Logger LOG = Logger.getLogger(JaxWsServiceCreator.class.getCanonicalName());

    public JaxWsServiceCreator(Project project, WizardDescriptor wiz, boolean addJaxWsLib) {
        this.project = project;
        this.wiz = wiz;
        this.addJaxWsLib = addJaxWsLib;
    }

    public void createService() throws IOException {
        this.serviceType = (Integer)this.wiz.getProperty("webServiceType");
        final ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_WebServiceGeneration"));
        handle.start(100);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    JaxWsServiceCreator.this.generateWebService(handle);
                }
                catch (IOException e) {
                    handle.finish();
                    String message = e.getLocalizedMessage();
                    if (message != null) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                }
            }
        };
        RequestProcessor.getDefault().post(r);
    }

    public void createServiceFromWsdl() throws IOException {
        final ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_WebServiceGeneration"));
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    handle.start(100);
                    JaxWsServiceCreator.this.generateWsFromWsdl15(handle);
                }
                catch (IOException e) {
                    handle.finish();
                    String message = e.getLocalizedMessage();
                    if (message != null) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                }
            }
        };
        RequestProcessor.getDefault().post(r);
    }

    private void generateWebService(ProgressHandle handle) throws IOException {
        FileObject pkg = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        if (this.serviceType == 0) {
            handle.progress(NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_GEN_WS"), 50);
            if (this.addJaxWsLib) {
                MavenModelUtils.addMetroLibrary(this.project);
            }
            this.generateJaxWSImplFromTemplate(pkg, WSUtils.isEJB(this.project), false, false);
            handle.finish();
        } else if (this.serviceType == 1) {
            String wsName = Templates.getTargetName((WizardDescriptor)this.wiz);
            handle.progress(NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_GEN_SEI_AND_IMPL"), 50);
            Node[] nodes = (Node[])this.wiz.getProperty("delegateToSessionBean");
            this.generateWebServiceFromEJB(wsName, pkg, nodes);
            handle.finish();
        }
    }

    private void generateWsFromWsdl15(ProgressHandle handle) throws IOException {
        handle.progress(NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_GEN_WS"), 50);
        JAXWSLightSupport jaxWsSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.project.getProjectDirectory());
        String wsdlUrl = (String)this.wiz.getProperty("wsdl_url");
        String filePath = (String)this.wiz.getProperty("wsdlFilePath");
        if (wsdlUrl == null) {
            wsdlUrl = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(filePath))).toURL().toExternalForm();
        }
        FileObject localWsdlFolder = jaxWsSupport.getWsdlFolder(true);
        boolean hasSrcFolder = false;
        File srcFile = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "src");
        hasSrcFolder = srcFile.exists() ? true : srcFile.mkdirs();
        if (localWsdlFolder != null) {
            NotifyDescriptor.Message desc;
            String mes;
            FileObject wsdlFo = null;
            try {
                wsdlFo = WSUtils.retrieveResource(localWsdlFolder, hasSrcFolder ? new URI("src/jax-ws-catalog.xml") : new URI("jax-ws-catalog.xml"), new URI(wsdlUrl));
            }
            catch (URISyntaxException ex) {
                mes = NbBundle.getMessage(JaxWsServiceCreator.class, (String)"ERR_IncorrectURI", (Object)wsdlUrl);
                desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            catch (UnknownHostException ex) {
                mes = NbBundle.getMessage(JaxWsServiceCreator.class, (String)"ERR_UnknownHost", (Object)ex.getMessage());
                desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            catch (IOException ex) {
                mes = NbBundle.getMessage(JaxWsServiceCreator.class, (String)"ERR_WsdlRetrieverFailure", (Object)wsdlUrl);
                desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            if (wsdlFo != null) {
                WsdlService wsdlService = (WsdlService)this.wiz.getProperty("wsdlService");
                WsdlPort wsdlPort = (WsdlPort)this.wiz.getProperty("wsdlPort");
                if (wsdlService == null || wsdlPort == null) {
                    WsdlModeler wsdlModeler = (WsdlModeler)this.wiz.getProperty("wsdlModeler");
                    if (wsdlModeler != null && wsdlModeler.getCreationException() != null) {
                        handle.finish();
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_CannotGenerateArtifacts", (Object)wsdlModeler.getCreationException().getLocalizedMessage()), 0));
                    } else {
                        handle.finish();
                    }
                } else {
                    boolean isJaxWsLibrary = MavenModelUtils.hasJaxWsAPI(this.project);
                    final String relativePath = FileUtil.getRelativePath((FileObject)localWsdlFolder, (FileObject)wsdlFo);
                    final String serviceName = wsdlFo.getName();
                    Preferences prefs = ProjectUtils.getPreferences((Project)this.project, MavenWebService.class, (boolean)true);
                    if (prefs != null) {
                        prefs.put("_S_" + WSUtils.getUniqueId(wsdlFo.getName(), jaxWsSupport.getServices()), wsdlUrl);
                    }
                    if (!isJaxWsLibrary) {
                        try {
                            MavenModelUtils.addMetroLibrary(this.project);
                            MavenModelUtils.addJavadoc(this.project);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(JaxWsServiceCreator.class.getName()).log(Level.INFO, "Cannot add Metro libbrary to pom file", ex);
                        }
                    }
                    ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                        public void performOperation(POMModel model) {
                            Plugin plugin = WSUtils.isEJB(JaxWsServiceCreator.this.project) ? MavenModelUtils.addJaxWSPlugin(model, "2.0") : MavenModelUtils.addJaxWSPlugin(model);
                            MavenModelUtils.addWsimportExecution(plugin, serviceName, relativePath, null);
                            if (WSUtils.isWeb(JaxWsServiceCreator.this.project)) {
                                MavenModelUtils.addWarPlugin(model, false);
                            } else {
                                MavenModelUtils.addWsdlResources(model);
                            }
                        }
                    };
                    Utilities.performPOMModelOperations((FileObject)this.project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(operation));
                    FileObject pkg = Templates.getTargetFolder((WizardDescriptor)this.wiz);
                    boolean useProvider = (Boolean)this.wiz.getProperty("useProvider");
                    boolean isStateless = (Boolean)this.wiz.getProperty("endpointAsStatelessBean");
                    FileObject targetFile = this.generateJaxWSImplFromTemplate(pkg, isStateless, true, useProvider);
                    RunConfig cfg = RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (Project)this.project, (String)"JAX-WS:wsimport", Collections.singletonList("compile"));
                    ExecutorTask task = RunUtils.executeMaven((RunConfig)cfg);
                    try {
                        task.waitFinished(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        SaveCookie save;
                        String wsdlLocationPrefix = WSUtils.isWeb(this.project) ? "WEB-INF/wsdl/" : "META-INF/wsdl/";
                        this.generateJaxWsImplClass(targetFile, wsdlService, wsdlPort, wsdlLocationPrefix + relativePath, useProvider);
                        DataObject targetDo = DataObject.find((FileObject)targetFile);
                        if (targetDo != null && (save = (SaveCookie)targetDo.getCookie(SaveCookie.class)) != null) {
                            save.save();
                        }
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(4096, (Throwable)ex);
                    }
                }
            }
        }
        handle.finish();
    }

    private FileObject generateJaxWSImplFromTemplate(FileObject pkg, boolean isEjbTemplate, boolean fromWsdl, boolean useProvider) throws IOException {
        FileObject templateParent;
        DataFolder df = DataFolder.findFolder((FileObject)pkg);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        if (useProvider) {
            templateParent = template.getParent();
            template = isEjbTemplate ? templateParent.getFileObject("EjbWebServiceProvider", "java") : templateParent.getFileObject("WebServiceProvider", "java");
        } else if (!fromWsdl && ((Boolean)this.wiz.getProperty("endpointAsStatelessBean")).booleanValue()) {
            templateParent = template.getParent();
            template = templateParent.getFileObject("EjbWebService", "java");
        }
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)this.wiz));
        FileObject createdFile = dobj.getPrimaryFile();
        dobj = DataObject.find((FileObject)createdFile);
        JaxWsServiceCreator.openFileInEditor(dobj);
        return createdFile;
    }

    private ClassPath getClassPathForFile(Project project, FileObject file) {
        SourceGroup[] srcGroups;
        for (SourceGroup srcGroup : srcGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject srcRoot = srcGroup.getRootFolder();
            if (!FileUtil.isParentOf((FileObject)srcRoot, (FileObject)file)) continue;
            return ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/source");
        }
        return null;
    }

    public static void openFileInEditor(DataObject dobj) {
        final OpenCookie openCookie = (OpenCookie)dobj.getCookie(OpenCookie.class);
        if (openCookie != null) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    openCookie.open();
                }
            }, 1000);
        }
    }

    private void generateJaxWsImplClass(FileObject targetFile, final WsdlService service, final WsdlPort port, final String wsdlLocation, final boolean useProvider) throws IOException {
        final JavaSource targetSource = JavaSource.forFileObject((FileObject)targetFile);
        final boolean[] isIncomplete = new boolean[1];
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (javaClass != null) {
                    TreeMaker make = workingCopy.getTreeMaker();
                    GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                    ArrayList<AssignmentTree> attrs = new ArrayList<AssignmentTree>();
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"serviceName"), (ExpressionTree)make.Literal((Object)service.getName())));
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"portName"), (ExpressionTree)make.Literal((Object)port.getName())));
                    if (!useProvider) {
                        attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"endpointInterface"), (ExpressionTree)make.Literal((Object)port.getJavaName())));
                    }
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"targetNamespace"), (ExpressionTree)make.Literal((Object)port.getNamespaceURI())));
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"wsdlLocation"), (ExpressionTree)make.Literal((Object)wsdlLocation)));
                    AnnotationTree WSAnnotation = make.Annotation((Tree)(useProvider ? make.QualIdent("javax.xml.ws.WebServiceProvider") : make.QualIdent("javax.jws.WebService")), attrs);
                    ClassTree modifiedClass = genUtils.addAnnotation(javaClass, WSAnnotation);
                    if ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(port.getSOAPVersion())) {
                        TypeElement bindingElement = workingCopy.getElements().getTypeElement(JaxWsServiceCreator.BINDING_TYPE_ANNOTATION);
                        if (bindingElement == null) {
                            isIncomplete[0] = true;
                        } else {
                            TypeElement soapBindingElement = workingCopy.getElements().getTypeElement(JaxWsServiceCreator.SOAP_BINDING_TYPE);
                            MemberSelectTree exp = make.MemberSelect(make.QualIdent((Element)soapBindingElement), (CharSequence)JaxWsServiceCreator.SOAP12_HTTP_BINDING);
                            AnnotationTree bindingAnnotation = make.Annotation((Tree)make.QualIdent((Element)bindingElement), Collections.singletonList(exp));
                            modifiedClass = genUtils.addAnnotation(modifiedClass, bindingAnnotation);
                        }
                    }
                    if (!useProvider) {
                        if (WSUtils.isEJB(JaxWsServiceCreator.this.project)) {
                            TypeElement statelessAn = workingCopy.getElements().getTypeElement("javax.ejb.Stateless");
                            if (statelessAn != null) {
                                AnnotationTree StatelessAnnotation = make.Annotation((Tree)make.QualIdent((Element)statelessAn), Collections.emptyList());
                                modifiedClass = genUtils.addAnnotation(modifiedClass, StatelessAnnotation);
                            } else {
                                isIncomplete[0] = true;
                            }
                        }
                        List operations = port.getOperations();
                        for (WsdlOperation operation : operations) {
                            String returnType = operation.getReturnTypeName();
                            List parameters = operation.getParameters();
                            ArrayList<VariableTree> params = new ArrayList<VariableTree>();
                            for (WsdlParameter parameter : parameters) {
                                params.add(make.Variable(make.Modifiers(Collections.emptySet(), Collections.emptyList()), (CharSequence)parameter.getName(), (Tree)make.Identifier((CharSequence)parameter.getTypeName()), null));
                            }
                            Iterator exceptions = operation.getExceptions();
                            ArrayList<ExpressionTree> exc = new ArrayList<ExpressionTree>();
                            while (exceptions.hasNext()) {
                                String exception = (String)exceptions.next();
                                TypeElement excEl = workingCopy.getElements().getTypeElement(exception);
                                if (excEl != null) {
                                    exc.add(make.QualIdent((Element)excEl));
                                    continue;
                                }
                                isIncomplete[0] = true;
                                exc.add(make.Identifier((CharSequence)exception));
                            }
                            ModifiersTree methodModifiers = make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.emptyList());
                            MethodTree method = make.Method(methodModifiers, (CharSequence)operation.getJavaName(), (Tree)make.Identifier((CharSequence)returnType), Collections.emptyList(), params, exc, "{ //TODO implement this method\nthrow new UnsupportedOperationException(\"Not implemented yet.\") }", null);
                            modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                        }
                    }
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }

            public void cancel() {
            }
        };
        ModificationResult modificationTask = targetSource.runModificationTask((Task)task);
        if (isIncomplete[0] && org.netbeans.api.java.source.SourceUtils.isScanInProgress()) {
            final String title = NbBundle.getMessage(JaxWsServiceCreator.class, (String)"LBL_GenWsClass");
            final Runnable runnable = new Runnable(){
                final /* synthetic */ CancellableTask val$task;
                {
                    this.val$task = cancellableTask;
                }

                @Override
                public void run() {
                    try {
                        targetSource.runModificationTask((Task)this.val$task).commit();
                    }
                    catch (IOException e) {
                        Logger.getLogger(JaxWsServiceCreator.class.getCanonicalName()).log(Level.WARNING, null, e);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
                    }
                });
            }
        } else {
            modificationTask.commit();
        }
    }

    private void generateWebServiceFromEJB(String wsName, FileObject pkg, Node[] nodes) throws IOException {
        EjbReference ejbRef;
        if (nodes != null && nodes.length == 1 && (ejbRef = (EjbReference)nodes[0].getLookup().lookup(EjbReference.class)) != null) {
            DataFolder df = DataFolder.findFolder((FileObject)pkg);
            FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
            FileObject templateParent = template.getParent();
            template = (Boolean)this.wiz.getProperty("endpointAsStatelessBean") != false ? templateParent.getFileObject("EjbWebServiceNoOp", "java") : templateParent.getFileObject("WebServiceNoOp", "java");
            DataObject dTemplate = DataObject.find((FileObject)template);
            DataObject dobj = dTemplate.createFromTemplate(df, wsName);
            FileObject createdFile = dobj.getPrimaryFile();
            dobj = DataObject.find((FileObject)createdFile);
            ClassPath classPath = this.getClassPathForFile(this.project, createdFile);
            if (classPath != null) {
                ContainerClassPathModifier modifier;
                if (classPath.findResource("javax/ejb/EJB.class") == null && (modifier = (ContainerClassPathModifier)this.project.getLookup().lookup(ContainerClassPathModifier.class)) != null) {
                    modifier.extendClasspath(createdFile, new String[]{"ejb"});
                }
                this.generateDelegateMethods(createdFile, ejbRef);
                JaxWsServiceCreator.openFileInEditor(dobj);
            }
        }
    }

    private void generateDelegateMethods(FileObject targetFo, final EjbReference ref) throws IOException {
        final boolean[] onClassPath = new boolean[1];
        final String[] interfaceClass = new String[1];
        final JavaSource targetSource = JavaSource.forFileObject((FileObject)targetFo);
        CancellableTask<WorkingCopy> modificationTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker make = workingCopy.getTreeMaker();
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                if (typeElement != null) {
                    VariableTree ejbRefInjection = null;
                    interfaceClass[0] = ref.getLocal();
                    if (interfaceClass[0] == null) {
                        interfaceClass[0] = ref.getRemote();
                    }
                    if (interfaceClass[0] == null) {
                        interfaceClass[0] = ref.getEjbClass();
                    }
                    if ((ejbRefInjection = JaxWsServiceCreator.this.generateEjbInjection(workingCopy, make, interfaceClass[0], onClassPath)) != null) {
                        String comment1 = "Add business logic below. (Right-click in editor and choose";
                        String comment2 = "\"Web Service > Add Operation\"";
                        make.addComment((Tree)ejbRefInjection, Comment.create((Comment.Style)Comment.Style.LINE, (int)0, (int)0, (int)4, (String)comment1), false);
                        make.addComment((Tree)ejbRefInjection, Comment.create((Comment.Style)Comment.Style.LINE, (int)0, (int)0, (int)4, (String)comment2), false);
                        ClassTree javaClass = workingCopy.getTrees().getTree(typeElement);
                        ClassTree modifiedClass = make.insertClassMember(javaClass, 0, (Tree)ejbRefInjection);
                        if (onClassPath[0]) {
                            TypeElement beanInterface = workingCopy.getElements().getTypeElement(interfaceClass[0]);
                            modifiedClass = JaxWsServiceCreator.this.generateMethods(workingCopy, make, typeElement, modifiedClass, beanInterface);
                        }
                        workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                    }
                }
            }

            public void cancel() {
            }
        };
        final Runnable runnable = new Runnable(){
            final /* synthetic */ CancellableTask val$modificationTask;
            final /* synthetic */ boolean[] val$onClassPath;
            final /* synthetic */ String[] val$interfaceClass;
            final /* synthetic */ FileObject val$targetFo;
            {
                this.val$modificationTask = cancellableTask;
                this.val$onClassPath = blArray;
                this.val$interfaceClass = stringArray;
                this.val$targetFo = fileObject;
            }

            @Override
            public void run() {
                try {
                    targetSource.runModificationTask((Task)this.val$modificationTask).commit();
                    if (!this.val$onClassPath[0]) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_EJB_NOT_ON_CLASSPATH", (Object)this.val$interfaceClass[0], (Object)this.val$targetFo.getName()), 2));
                    }
                }
                catch (IOException e) {
                    Logger.getLogger(JaxWsServiceCreator.class.getCanonicalName()).log(Level.WARNING, null, e);
                }
            }
        };
        final String title = NbBundle.getMessage(JaxWsServiceCreator.class, (String)"LBL_GenDelegateMethods");
        if (SwingUtilities.isEventDispatchThread()) {
            ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
                }
            });
        }
    }

    private VariableTree generateEjbInjection(WorkingCopy workingCopy, TreeMaker make, String beanInterface, boolean[] onClassPath) {
        TypeElement ejbAnElement = workingCopy.getElements().getTypeElement("javax.ejb.EJB");
        TypeElement interfaceElement = workingCopy.getElements().getTypeElement(beanInterface);
        AnnotationTree ejbAnnotation = make.Annotation((Tree)make.QualIdent((Element)ejbAnElement), Collections.emptyList());
        ModifiersTree methodModifiers = make.Modifiers(Collections.singleton(Modifier.PRIVATE), Collections.singletonList(ejbAnnotation));
        onClassPath[0] = interfaceElement != null;
        return make.Variable(methodModifiers, (CharSequence)"ejbRef", onClassPath[0] ? make.Type(interfaceElement.asType()) : make.Identifier((CharSequence)beanInterface), null);
    }

    private ClassTree generateMethods(WorkingCopy workingCopy, TreeMaker make, TypeElement classElement, ClassTree modifiedClass, TypeElement beanInterface) throws IOException {
        GeneratorUtilities utils = GeneratorUtilities.get((WorkingCopy)workingCopy);
        List<? extends Element> interfaceElements = beanInterface.getEnclosedElements();
        TypeElement webMethodEl = workingCopy.getElements().getTypeElement("javax.jws.WebMethod");
        assert (webMethodEl != null);
        if (webMethodEl == null) {
            return modifiedClass;
        }
        HashSet<String> operationNames = new HashSet<String>();
        for (Element element : interfaceElements) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement methodEl = (ExecutableElement)element;
            MethodTree method = utils.createAbstractMethodImplementation(classElement, methodEl);
            Name methodName = methodEl.getSimpleName();
            boolean isVoid = workingCopy.getTypes().getNoType(TypeKind.VOID) == methodEl.getReturnType();
            String operationName = this.findUniqueOperationName(operationNames, methodName.toString());
            operationNames.add(operationName);
            AssignmentTree opName = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"operationName"), (ExpressionTree)make.Literal((Object)operationName));
            AnnotationTree webMethodAn = make.Annotation((Tree)make.QualIdent((Element)webMethodEl), Collections.singletonList(opName));
            ModifiersTree modifiersTree = make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(webMethodAn));
            if (!methodName.contentEquals(operationName)) {
                TypeElement requestWrapperEl = workingCopy.getElements().getTypeElement("javax.xml.ws.RequestWrapper");
                TypeElement responseWrapperEl = workingCopy.getElements().getTypeElement("javax.xml.ws.ResponseWrapper");
                AssignmentTree className = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"className"), (ExpressionTree)make.Literal((Object)operationName));
                AnnotationTree requestWrapperAn = make.Annotation((Tree)make.QualIdent((Element)requestWrapperEl), Collections.singletonList(className));
                modifiersTree = make.addModifiersAnnotation(modifiersTree, requestWrapperAn);
                if (!isVoid) {
                    className = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"className"), (ExpressionTree)make.Literal((Object)(operationName + "Response")));
                    AnnotationTree annotationTree = make.Annotation((Tree)make.QualIdent((Element)responseWrapperEl), Collections.singletonList(className));
                    modifiersTree = make.addModifiersAnnotation(modifiersTree, annotationTree);
                }
            }
            if (isVoid && method.getThrows().isEmpty()) {
                TypeElement onewayEl = workingCopy.getElements().getTypeElement("javax.jws.Oneway");
                AnnotationTree onewayAn = make.Annotation((Tree)make.QualIdent((Element)onewayEl), Collections.emptyList());
                modifiersTree = make.addModifiersAnnotation(modifiersTree, onewayAn);
            }
            List<? extends VariableTree> params = method.getParameters();
            ArrayList<VariableTree> newParams = new ArrayList<VariableTree>();
            if (params.size() > 0) {
                TypeElement paramEl = workingCopy.getElements().getTypeElement("javax.jws.WebParam");
                for (VariableTree variableTree : params) {
                    String paramName = variableTree.getName().toString();
                    AssignmentTree nameAttr = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"name"), (ExpressionTree)make.Literal((Object)paramName));
                    AnnotationTree paramAn = make.Annotation((Tree)make.QualIdent((Element)paramEl), Collections.singletonList(nameAttr));
                    ModifiersTree paramModifierTree = make.addModifiersAnnotation(variableTree.getModifiers(), paramAn);
                    newParams.add(make.Variable(paramModifierTree, (CharSequence)variableTree.getName(), variableTree.getType(), null));
                }
            }
            ArrayList<IdentifierTree> arguments = new ArrayList<IdentifierTree>();
            for (VariableElement variableElement : methodEl.getParameters()) {
                arguments.add(make.Identifier((CharSequence)variableElement.getSimpleName()));
            }
            MethodInvocationTree inv = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"ejbRef"), (CharSequence)methodName), arguments);
            StatementTree statementTree = isVoid ? make.ExpressionStatement((ExpressionTree)inv) : make.Return((ExpressionTree)inv);
            BlockTree body = make.Block(Collections.singletonList(statementTree), false);
            MethodTree delegatingMethod = make.Method(modifiersTree, (CharSequence)method.getName(), method.getReturnType(), method.getTypeParameters(), newParams, method.getThrows(), body, null);
            modifiedClass = make.addClassMember(modifiedClass, (Tree)delegatingMethod);
        }
        return modifiedClass;
    }

    private String findUniqueOperationName(Set<String> existingNames, String operationName) {
        if (!existingNames.contains(operationName)) {
            return operationName;
        }
        int i = 1;
        String newName = operationName + "_1";
        while (existingNames.contains(newName)) {
            newName = operationName + "_" + String.valueOf(++i);
        }
        return newName;
    }
}

