/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.netbeans.modules.java.j2seplatform.JDKDetectorUtils;

public class LinuxJavaPlatformDetector
implements Runnable {
    static final Path LINUX_JAVA_DIR = Paths.get("/usr/lib/jvm", new String[0]);
    static final String JAVA_DIR_MATCHER = "^java-(\\d+)-openjdk(-.+)?";

    @Override
    public void run() {
        if (Files.isDirectory(LINUX_JAVA_DIR, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(LINUX_JAVA_DIR);){
                Pattern pattern = Pattern.compile(JAVA_DIR_MATCHER);
                List<Path> jdks = files.filter(p -> Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS)).filter(p -> pattern.matcher(p.getFileName().toString()).matches()).collect(Collectors.toList());
                JDKDetectorUtils.registerJDKs(jdks, path -> LinuxJavaPlatformDetector.getDisplayName(path, pattern));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String getDisplayName(Path path, Pattern pattern) {
        String folder = path.getFileName().toString();
        Matcher m = pattern.matcher(folder);
        return (String)(m.matches() ? "JDK " + m.group(1) : folder) + " (System)";
    }
}

