/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.api.ui.OpenableInBrowser;
import org.netbeans.modules.hudson.impl.Bundle;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.impl.HudsonJobBuildImpl;
import org.netbeans.modules.hudson.spi.BuilderConnector;
import org.netbeans.modules.hudson.util.HudsonPropertiesSupport;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class HudsonJobImpl
implements HudsonJob,
OpenableInBrowser {
    private HudsonPropertiesSupport properties = new HudsonPropertiesSupport();
    private Collection<HudsonView> views = new ArrayList<HudsonView>();
    private HudsonInstanceImpl instance;
    private Collection<? extends HudsonJobBuild> builds;
    final List<HudsonMavenModule> mavenModules = new LinkedList<HudsonMavenModule>();

    HudsonJobImpl(HudsonInstanceImpl instance) {
        this.instance = instance;
    }

    public void putProperty(String name, Object o) {
        if (o == null) {
            throw new NullPointerException("putProperty: " + name);
        }
        this.properties.putProperty(name, o);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return this.properties.getProperty("job_display_name", String.class, this.getName());
    }

    @Override
    @NonNull
    public String getName() {
        String n = this.properties.getProperty("job_name", String.class);
        assert (n != null);
        return n;
    }

    @Override
    @NonNull
    public String getUrl() {
        String url = this.properties.getProperty("job_url", String.class);
        assert (url != null && url.endsWith("/")) : url;
        return url;
    }

    @Override
    @NonNull
    public HudsonJob.Color getColor() {
        return this.properties.getProperty("job_color", HudsonJob.Color.class, HudsonJob.Color.grey);
    }

    @Override
    public boolean isInQueue() {
        return this.properties.getProperty("job_in_queue", Boolean.class, false);
    }

    @Override
    public boolean isBuildable() {
        return this.properties.getProperty("job_buildable", Boolean.class, false);
    }

    @Override
    public int getLastBuild() {
        return this.properties.getProperty("job_last_build", Integer.class, -1);
    }

    @Override
    public int getLastStableBuild() {
        return this.properties.getProperty("job_last_stable_build", Integer.class, -1);
    }

    @Override
    public int getLastSuccessfulBuild() {
        return this.properties.getProperty("job_last_successful_build", Integer.class, -1);
    }

    @Override
    public int getLastFailedBuild() {
        return this.properties.getProperty("job_last_failed_build", Integer.class, -1);
    }

    @Override
    public int getLastCompletedBuild() {
        return this.properties.getProperty("job_last_completed_build", Integer.class, -1);
    }

    @Override
    public Collection<HudsonView> getViews() {
        return this.views;
    }

    void addView(HudsonView view) {
        this.views.add(view);
    }

    @Override
    public void start() {
        ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.MSG_Starting(this.getName()));
        handle.start();
        try {
            this.instance.getBuilderConnector().startJob(this);
        }
        finally {
            handle.finish();
        }
        this.instance.synchronize(false);
    }

    @Override
    public FileSystem getRemoteWorkspace() {
        return this.instance.getRemoteWorkspace(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof HudsonJobImpl)) {
            return false;
        }
        HudsonJobImpl j = (HudsonJobImpl)o;
        if (!Utilities.compareObjects((Object)this.getDisplayName(), (Object)j.getDisplayName())) {
            return false;
        }
        if (!Utilities.compareObjects((Object)this.getName(), (Object)j.getName())) {
            return false;
        }
        if (!Utilities.compareObjects((Object)this.getUrl(), (Object)j.getUrl())) {
            return false;
        }
        if (!Utilities.compareObjects((Object)((Object)this.getColor()), (Object)((Object)j.getColor()))) {
            return false;
        }
        if (this.isInQueue() != j.isInQueue()) {
            return false;
        }
        if (this.isBuildable() != j.isBuildable()) {
            return false;
        }
        if (!Utilities.compareObjects(this.views, j.views)) {
            return false;
        }
        if (this.getLastCompletedBuild() != j.getLastCompletedBuild()) {
            return false;
        }
        return this.mavenModules.equals(j.mavenModules);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public int compareTo(HudsonJob o) {
        if (this.isSalient() != o.isSalient()) {
            return this.isSalient() ? -1 : 1;
        }
        return this.getDisplayName().compareTo(o.getDisplayName());
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public synchronized Collection<? extends HudsonJobBuild> getBuilds() {
        if (this.builds == null) {
            this.builds = this.createBuilds(this.instance.getBuilderConnector().getJobBuildsData(this));
        }
        return this.builds;
    }

    private Collection<? extends HudsonJobBuild> createBuilds(Collection<BuilderConnector.BuildData> data) {
        if (data == null) {
            return Collections.emptySet();
        }
        ArrayList<HudsonJobBuildImpl> buildList = new ArrayList<HudsonJobBuildImpl>();
        for (BuilderConnector.BuildData bd : data) {
            buildList.add(new HudsonJobBuildImpl(this.getInstance().getBuilderConnector(), this, bd.getNumber(), bd.isBuilding(), bd.getResult()));
        }
        return buildList;
    }

    @Override
    public HudsonInstanceImpl getInstance() {
        return this.instance;
    }

    @Override
    public boolean isSalient() {
        return this.instance.isSalient(this);
    }

    @Override
    public void setSalient(boolean b) {
        this.instance.setSalient(this, b);
    }

    void addModule(@NonNull String name, @NonNull String displayName, @NonNull HudsonJob.Color color, @NonNull String url) {
        this.mavenModules.add(new HudsonMavenModule(name, displayName, color, url));
    }

    static class HudsonMavenModule {
        @NonNull
        final String name;
        @NonNull
        final String displayName;
        @NonNull
        final HudsonJob.Color color;
        @NonNull
        final String url;

        HudsonMavenModule(@NonNull String name, @NonNull String displayName, @NonNull HudsonJob.Color color, @NonNull String url) {
            this.name = name;
            this.displayName = displayName;
            this.color = color;
            this.url = url;
        }

        public boolean equals(Object other) {
            if (!(other instanceof HudsonMavenModule)) {
                return false;
            }
            HudsonMavenModule o = (HudsonMavenModule)other;
            return this.name.equals(o.name) && this.displayName.equals(o.displayName) && this.color == o.color && this.url.equals(o.url);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.url;
        }
    }
}

