/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonFolder;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.api.ui.OpenableInBrowser;
import org.netbeans.modules.hudson.impl.Bundle;
import org.netbeans.modules.hudson.impl.HudsonConnector;
import org.netbeans.modules.hudson.impl.HudsonFolderImpl;
import org.netbeans.modules.hudson.impl.HudsonInstanceProperties;
import org.netbeans.modules.hudson.impl.HudsonJobImpl;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.impl.HudsonViewImpl;
import org.netbeans.modules.hudson.spi.BuilderConnector;
import org.netbeans.modules.hudson.spi.RemoteFileSystem;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class HudsonInstanceImpl
implements HudsonInstance,
OpenableInBrowser {
    private static final Logger LOG = Logger.getLogger(HudsonInstanceImpl.class.getName());
    private HudsonInstanceProperties properties;
    private BuilderConnector builderConnector;
    private HudsonInstance.Persistence persistence;
    private HudsonVersion version;
    private boolean connected;
    private boolean forbidden;
    private boolean terminated;
    private final RequestProcessor RP;
    private final RequestProcessor.Task synchronization;
    private Collection<HudsonJob> jobs = new ArrayList<HudsonJob>();
    private Collection<HudsonFolder> folders = new ArrayList<HudsonFolder>();
    private Collection<HudsonView> views = new ArrayList<HudsonView>();
    private HudsonView primaryView;
    private final Collection<HudsonChangeListener> listeners = new ArrayList<HudsonChangeListener>();
    private final Map<String, Reference<RemoteFileSystem>> workspaces = new HashMap<String, Reference<RemoteFileSystem>>();
    private final Map<String, Reference<RemoteFileSystem>> artifacts = new HashMap<String, Reference<RemoteFileSystem>>();

    private HudsonInstanceImpl(HudsonInstanceProperties properties, boolean interactive, BuilderConnector builderConnector, HudsonInstance.Persistence persistence) {
        this.builderConnector = builderConnector;
        this.properties = properties;
        this.persistence = persistence != null ? persistence : HudsonInstance.Persistence.persistent();
        this.RP = new RequestProcessor(this.getUrl(), 1, true);
        final AtomicBoolean firstSynch = new AtomicBoolean(interactive);
        this.synchronization = this.RP.create(new Runnable(){
            private boolean firstRun = true;

            @Override
            public void run() {
                String s = (String)HudsonInstanceImpl.this.getProperties().get("sync_time");
                int pause = Integer.parseInt(s) * 60 * 1000;
                if (pause > 0 || firstSynch.compareAndSet(true, false)) {
                    HudsonInstanceImpl.this.doSynchronize(false, this.firstRun);
                    this.firstRun = false;
                }
                if (pause > 0) {
                    HudsonInstanceImpl.this.synchronization.schedule(pause);
                }
            }
        });
        this.synchronization.schedule(0);
        this.properties.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("sync_time")) {
                    HudsonInstanceImpl.this.synchronization.schedule(0);
                }
            }
        });
    }

    @Override
    public boolean isPersisted() {
        return this.properties.isPersisted();
    }

    public void makePersistent() {
        if (this.isPersisted()) {
            return;
        }
        this.properties.put("persisted", "true");
        this.fireContentChanges();
    }

    @Override
    public Preferences prefs() {
        return this.properties.getPreferences();
    }

    public static HudsonInstanceImpl createHudsonInstance(String name, String url, BuilderConnector client, int sync) {
        HudsonInstanceProperties hudsonInstanceProperties = new HudsonInstanceProperties(name, url, Integer.toBinaryString(sync));
        HudsonInstanceImpl instance = new HudsonInstanceImpl(hudsonInstanceProperties, true, client, null);
        if (null == HudsonManagerImpl.getDefault().addInstance(instance)) {
            return null;
        }
        return instance;
    }

    public static HudsonInstanceImpl createHudsonInstance(String name, String url, String sync) {
        return HudsonInstanceImpl.createHudsonInstance(new HudsonInstanceProperties(name, url, sync), true, null);
    }

    public static HudsonInstanceImpl createHudsonInstance(HudsonInstanceProperties properties, boolean interactive) {
        return HudsonInstanceImpl.createHudsonInstance(properties, interactive, HudsonInstance.Persistence.persistent());
    }

    public static HudsonInstanceImpl createHudsonInstance(HudsonInstanceProperties properties, boolean interactive, HudsonInstance.Persistence persistence) {
        HudsonConnector connector = new HudsonConnector((String)properties.get("url"));
        HudsonInstanceImpl instance = new HudsonInstanceImpl(properties, interactive, connector, persistence);
        assert (instance.getName() != null);
        assert (instance.getUrl() != null);
        assert (instance.getProperties().get("sync_time") != null);
        if (null == HudsonManagerImpl.getDefault().addInstance(instance)) {
            return null;
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        HudsonInstanceImpl hudsonInstanceImpl = this;
        synchronized (hudsonInstanceImpl) {
            this.RP.stop();
            this.terminated = true;
            this.connected = false;
            this.forbidden = false;
            this.version = null;
            this.jobs.clear();
            this.folders.clear();
            this.views.clear();
            this.primaryView = null;
        }
        this.fireStateChanges();
        this.fireContentChanges();
    }

    public BuilderConnector getBuilderConnector() {
        return this.builderConnector;
    }

    public synchronized void changeBuilderConnector(BuilderConnector connector) {
        assert (!(connector instanceof HudsonConnector));
        this.builderConnector = connector;
        this.jobs.clear();
        this.folders.clear();
        this.views.clear();
        this.synchronize(false);
    }

    @Override
    public HudsonVersion getVersion() {
        return this.version;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isForbidden() {
        return this.forbidden;
    }

    public HudsonInstanceProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getName() {
        return (String)this.getProperties().get("name");
    }

    @Override
    public String getUrl() {
        String url = (String)this.getProperties().get("url");
        assert (url.endsWith("/")) : url;
        return url;
    }

    @Override
    public synchronized Collection<HudsonJob> getJobs() {
        return new ArrayList<HudsonJob>(this.jobs);
    }

    @Override
    public synchronized Collection<HudsonFolder> getFolders() {
        return new ArrayList<HudsonFolder>(this.folders);
    }

    boolean isSalient(HudsonJobImpl job) {
        HudsonInstanceProperties props = this.getProperties();
        if (HudsonInstanceProperties.split((String)props.get("suppressed_jobs")).contains(job.getName())) {
            return false;
        }
        List<String> preferred = HudsonInstanceProperties.split((String)props.get("pref_jobs"));
        if (!preferred.isEmpty()) {
            return preferred.contains(job.getName());
        }
        return true;
    }

    void setSalient(HudsonJobImpl job, boolean salient) {
        HudsonInstanceProperties props = this.getProperties();
        ArrayList<String> preferred = new ArrayList<String>(HudsonInstanceProperties.split((String)props.get("pref_jobs")));
        if (salient && !preferred.isEmpty() && !preferred.contains(job.getName())) {
            ArrayList<String> list = new ArrayList<String>(preferred);
            list.add(job.getName());
            props.put("pref_jobs", HudsonInstanceProperties.join(list));
        }
        ArrayList<String> suppressed = new ArrayList<String>(HudsonInstanceProperties.split((String)props.get("suppressed_jobs")));
        if (salient) {
            suppressed.remove(job.getName());
        } else if (!suppressed.contains(job.getName())) {
            suppressed.add(job.getName());
        }
        props.put("suppressed_jobs", HudsonInstanceProperties.join(suppressed));
        this.fireContentChanges();
    }

    @Override
    public synchronized Collection<HudsonView> getViews() {
        return new ArrayList<HudsonView>(this.views);
    }

    @Override
    public synchronized HudsonView getPrimaryView() {
        if (this.primaryView == null) {
            this.primaryView = new HudsonViewImpl(this, "All", this.getUrl());
        }
        return this.primaryView;
    }

    synchronized void setViews(Collection<HudsonView> views, HudsonView primaryView) {
        this.views = views;
        this.primaryView = primaryView;
    }

    @Override
    public void synchronize(final boolean authentication) {
        if (this.terminated) {
            return;
        }
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                HudsonInstanceImpl.this.doSynchronize(authentication, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSynchronize(boolean authentication, boolean showProgress) {
        final AtomicReference<Thread> synchThread = new AtomicReference<Thread>();
        final AtomicReference<ProgressHandle> handle = new AtomicReference<ProgressHandle>();
        ProgressHandle handleObject = ProgressHandle.createHandle((String)Bundle.MSG_Synchronizing(this.getName()), (Cancellable)new Cancellable(){

            public boolean cancel() {
                Thread t = (Thread)synchThread.get();
                if (t != null) {
                    LOG.log(Level.FINE, "Cancelling synchronization of {0}", HudsonInstanceImpl.this.getUrl());
                    if (!HudsonInstanceImpl.this.isPersisted()) {
                        HudsonInstanceImpl.this.properties.put("sync_time", "0");
                    }
                    t.interrupt();
                    ((ProgressHandle)handle.get()).finish();
                    return true;
                }
                return false;
            }
        });
        handleObject.setInitialDelay(showProgress ? 100 : 30000);
        handle.set(handleObject);
        ((ProgressHandle)handle.get()).start();
        if (authentication) {
            ConnectionBuilder.clearRejectedAuthentication();
        }
        synchThread.set(Thread.currentThread());
        try {
            Collection<HudsonView> oldViews = this.getViews();
            BuilderConnector.InstanceData instanceData = this.getBuilderConnector().getInstanceData(authentication);
            this.configureViews(instanceData.getViewsData());
            Collection<HudsonJob> retrieved = this.createJobs(instanceData.getJobsData());
            Collection<HudsonFolder> retrievedFolders = this.createFolders(instanceData.getFoldersData());
            if (this.terminated) {
                return;
            }
            this.connected = this.getBuilderConnector().isConnected();
            this.version = this.getBuilderConnector().getHudsonVersion(authentication);
            this.forbidden = this.getBuilderConnector().isForbidden();
            this.fireStateChanges();
            Object object = this.workspaces;
            synchronized (object) {
                Iterator<Map.Entry<String, Reference<RemoteFileSystem>>> it = this.workspaces.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Reference<RemoteFileSystem>> entry = it.next();
                    RemoteFileSystem fs = entry.getValue().get();
                    if (fs != null) {
                        fs.refreshAll();
                        continue;
                    }
                    it.remove();
                }
            }
            object = this;
            synchronized (object) {
                block16: {
                    if (!this.jobs.equals(retrieved) || !this.folders.equals(retrievedFolders) || !oldViews.equals(this.views)) break block16;
                    return;
                }
                this.jobs = retrieved;
                this.folders = retrievedFolders;
            }
            this.fireContentChanges();
        }
        finally {
            ((ProgressHandle)handle.get()).finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHudsonChangeListener(HudsonChangeListener l) {
        if (l != null) {
            Collection<HudsonChangeListener> collection = this.listeners;
            synchronized (collection) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHudsonChangeListener(HudsonChangeListener l) {
        Collection<HudsonChangeListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanges() {
        ArrayList<HudsonChangeListener> tempList;
        Collection<HudsonChangeListener> collection = this.listeners;
        synchronized (collection) {
            tempList = new ArrayList<HudsonChangeListener>(this.listeners);
        }
        for (HudsonChangeListener l : tempList) {
            l.stateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContentChanges() {
        ArrayList<HudsonChangeListener> tempList;
        Collection<HudsonChangeListener> collection = this.listeners;
        synchronized (collection) {
            tempList = new ArrayList<HudsonChangeListener>(this.listeners);
        }
        for (HudsonChangeListener l : tempList) {
            l.contentChanged();
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof HudsonInstance && this.getUrl().equals(((HudsonInstance)obj).getUrl());
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public int compareTo(HudsonInstance o) {
        return this.getName().compareTo(o.getName());
    }

    FileSystem getRemoteWorkspace(final HudsonJob job) {
        return HudsonInstanceImpl.getFileSystemFromCache(this.workspaces, job.getName(), new Callable<RemoteFileSystem>(){

            @Override
            public RemoteFileSystem call() throws Exception {
                return HudsonInstanceImpl.this.builderConnector.getWorkspace(job);
            }
        });
    }

    FileSystem getArtifacts(final HudsonJobBuild build) {
        return HudsonInstanceImpl.getFileSystemFromCache(this.artifacts, build.getJob().getName() + "/" + build.getNumber(), new Callable<RemoteFileSystem>(){

            @Override
            public RemoteFileSystem call() throws Exception {
                return HudsonInstanceImpl.this.builderConnector.getArtifacts(build);
            }
        });
    }

    FileSystem getArtifacts(final HudsonMavenModuleBuild module) {
        return HudsonInstanceImpl.getFileSystemFromCache(this.artifacts, module.getBuild().getJob().getName() + "/" + module.getBuild().getNumber() + "/" + module.getName(), new Callable<RemoteFileSystem>(){

            @Override
            public RemoteFileSystem call() throws Exception {
                return HudsonInstanceImpl.this.builderConnector.getArtifacts(module);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem getFileSystemFromCache(Map<String, Reference<RemoteFileSystem>> cache, String key, Callable<RemoteFileSystem> create) {
        Map<String, Reference<RemoteFileSystem>> map = cache;
        synchronized (map) {
            RemoteFileSystem fs;
            RemoteFileSystem remoteFileSystem = fs = cache.containsKey(key) ? cache.get(key).get() : null;
            if (fs == null) {
                try {
                    fs = create.call();
                    if (fs == null) {
                        return null;
                    }
                    cache.put(key, new WeakReference<RemoteFileSystem>(fs));
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return FileUtil.createMemoryFileSystem();
                }
            }
            return fs;
        }
    }

    public Collection<HudsonJob> createJobs(Collection<BuilderConnector.JobData> data) {
        ArrayList<HudsonJob> jobList = new ArrayList<HudsonJob>();
        for (BuilderConnector.JobData jd : data) {
            HudsonJobImpl job = new HudsonJobImpl(this);
            if (jd.isSecured()) {
                job.putProperty("job_color", (Object)HudsonJob.Color.secured);
            }
            job.putProperty("job_name", jd.getJobName());
            job.putProperty("job_url", jd.getJobUrl());
            if (jd.getColor() != null) {
                job.putProperty("job_color", (Object)jd.getColor());
            }
            job.putProperty("job_display_name", jd.getDisplayName() == null ? jd.getJobName() : jd.getDisplayName());
            job.putProperty("job_buildable", jd.isBuildable());
            job.putProperty("job_in_queue", jd.isInQueue());
            job.putProperty("job_last_build", jd.getLastBuild());
            job.putProperty("job_last_failed_build", jd.getLastFailedBuild());
            job.putProperty("job_last_stable_build", jd.getLastStableBuild());
            job.putProperty("job_last_successful_build", jd.getLastSuccessfulBuild());
            job.putProperty("job_last_completed_build", jd.getLastCompletedBuild());
            for (BuilderConnector.ModuleData md : jd.getModules()) {
                job.addModule(md.getName(), md.getDisplayName(), md.getColor(), md.getUrl());
            }
            for (HudsonView v : this.getViews()) {
                if (!jd.isSecured() && !jd.getViews().contains(v.getName())) continue;
                job.addView(v);
            }
            jobList.add(job);
        }
        return jobList;
    }

    public Collection<HudsonFolder> createFolders(Collection<BuilderConnector.FolderData> foldersData) {
        ArrayList<HudsonFolder> result = new ArrayList<HudsonFolder>();
        for (BuilderConnector.FolderData datum : foldersData) {
            result.add(new HudsonFolderImpl(this, datum.getName(), datum.getUrl()));
        }
        return result;
    }

    private void configureViews(Collection<BuilderConnector.ViewData> viewsData) {
        ArrayList<HudsonView> viewList = new ArrayList<HudsonView>();
        HudsonViewImpl foundPrimaryView = null;
        for (BuilderConnector.ViewData viewData : viewsData) {
            HudsonViewImpl view = new HudsonViewImpl(this, viewData.getName(), viewData.getUrl());
            viewList.add(view);
            if (!viewData.isPrimary()) continue;
            foundPrimaryView = view;
        }
        this.setViews(viewList, foundPrimaryView);
    }

    @Override
    public HudsonInstance.Persistence getPersistence() {
        return this.persistence;
    }

    @Override
    public List<String> getPreferredJobs() {
        String preferred = (String)this.properties.get("pref_jobs");
        if (preferred == null) {
            return null;
        }
        return HudsonInstanceProperties.split(preferred);
    }

    @Override
    public void setPreferredJobs(List<String> preferredJobs) {
        if (preferredJobs == null) {
            this.properties.put("pref_jobs", null);
        } else {
            this.properties.put("pref_jobs", HudsonInstanceProperties.join(preferredJobs));
        }
    }

    @Override
    public int getSyncInterval() {
        return Integer.parseInt((String)this.getProperties().get("sync_time"));
    }

    @Override
    public void setSyncInterval(int syncInterval) {
        this.getProperties().put("sync_time", Integer.toString(syncInterval));
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getProperties().addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getProperties().removePropertyChangeListener(listener);
    }
}

