/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.JTableHeader;
import org.netbeans.modules.form.FormCodeAwareEditor;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.editors2.TableColumnModelEditor;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JTableHeaderEditor
extends PropertyEditorSupport
implements NamedPropertyEditor,
FormCodeAwareEditor,
XMLPropertyEditor {
    private FormProperty property;
    private boolean initialized;
    private static final String XML_TABLE_HEADER = "TableHeader";
    private static final String ATTR_RESIZING = "resizingAllowed";
    private static final String ATTR_REORDERING = "reorderingAllowed";
    private JPanel customizer;
    private JCheckBox reorderingCheckBox;
    private JCheckBox resizingCheckBox;

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"TableHeaderEditor");
    }

    @Override
    public void setContext(FormModel formModel, FormProperty property) {
        this.property = property;
    }

    @Override
    public void updateFormVersionLevel() {
        this.property.getPropertyContext().getFormModel().raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (!this.initialized) {
            this.initialized = true;
            this.initComponents();
        }
        this.updateUI();
        return this.customizer;
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle rectangle) {
        String msg = NbBundle.getMessage(TableColumnModelEditor.class, (String)"TableHeaderEditor_TableHeader");
        FontMetrics fm = g.getFontMetrics();
        g.drawString(msg, rectangle.x, rectangle.y + (rectangle.height - fm.getHeight()) / 2 + fm.getAscent());
    }

    private void initComponents() {
        this.customizer = new JPanel();
        this.resizingCheckBox = new JCheckBox();
        this.reorderingCheckBox = new JCheckBox();
        FormListener formListener = new FormListener();
        this.resizingCheckBox.setText(NbBundle.getMessage(JTableHeaderEditor.class, (String)"TableHeaderEditor_Resizing"));
        this.resizingCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.resizingCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.resizingCheckBox.addActionListener(formListener);
        this.reorderingCheckBox.setText(NbBundle.getMessage(JTableHeaderEditor.class, (String)"TableHeaderEditor_Reordering"));
        this.reorderingCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reorderingCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.reorderingCheckBox.addActionListener(formListener);
        GroupLayout customizerLayout = new GroupLayout(this.customizer);
        this.customizer.setLayout(customizerLayout);
        customizerLayout.setHorizontalGroup(customizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customizerLayout.createSequentialGroup().addContainerGap().addGroup(customizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resizingCheckBox).addComponent(this.reorderingCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        customizerLayout.setVerticalGroup(customizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customizerLayout.createSequentialGroup().addContainerGap().addComponent(this.resizingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reorderingCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void headerChanged(ActionEvent evt) {
        this.updateFromUI();
        this.firePropertyChange();
    }

    private void updateFromUI() {
        this.setValue(new FormTableHeader(this.property, this.resizingCheckBox.isSelected(), this.reorderingCheckBox.isSelected()));
    }

    private void updateUI() {
        Object value = this.getValue();
        boolean resizing = true;
        boolean reordering = true;
        if (value instanceof FormTableHeader) {
            FormTableHeader header = (FormTableHeader)value;
            resizing = header.isResizingAllowed();
            reordering = header.isReorderingAllowed();
        } else if (value instanceof JTableHeader) {
            JTableHeader header = (JTableHeader)value;
            resizing = header.getResizingAllowed();
            reordering = header.getReorderingAllowed();
        }
        this.resizingCheckBox.setSelected(resizing);
        this.reorderingCheckBox.setSelected(reordering);
    }

    @Override
    public String getSourceCode() {
        RADProperty property = (RADProperty)this.property;
        RADComponent comp = property.getRADComponent();
        CodeVariable var = comp.getCodeExpression().getVariable();
        String varName = var == null ? null : var.getName();
        String readMethod = property.getPropertyDescriptor().getReadMethod().getName();
        String getter = readMethod + "()";
        if (varName != null) {
            getter = varName + "." + getter;
        }
        boolean resizing = true;
        boolean reordering = true;
        Object value = this.getValue();
        if (value instanceof FormTableHeader) {
            FormTableHeader header = (FormTableHeader)value;
            resizing = header.isResizingAllowed();
            reordering = header.isReorderingAllowed();
        }
        Object code = "";
        if (!resizing) {
            code = (String)code + getter + ".setResizingAllowed(false);\n";
        }
        if (!reordering) {
            code = (String)code + getter + ".setReorderingAllowed(false);\n";
        }
        return resizing && reordering ? null : code;
    }

    public void readFromXML(Node element) throws IOException {
        NamedNodeMap attributes = element.getAttributes();
        Node node = attributes.getNamedItem(ATTR_RESIZING);
        boolean resizing = true;
        if (node != null) {
            resizing = Boolean.valueOf(node.getNodeValue());
        }
        node = attributes.getNamedItem(ATTR_REORDERING);
        boolean reordering = true;
        if (node != null) {
            reordering = Boolean.valueOf(node.getNodeValue());
        }
        this.setValue(new FormTableHeader(this.property, resizing, reordering));
    }

    public Node storeToXML(Document doc) {
        Object value = this.getValue();
        Element el = null;
        if (value instanceof FormTableHeader) {
            FormTableHeader header = (FormTableHeader)value;
            el = doc.createElement(XML_TABLE_HEADER);
            el.setAttribute(ATTR_RESIZING, Boolean.toString(header.isResizingAllowed()));
            el.setAttribute(ATTR_REORDERING, Boolean.toString(header.isReorderingAllowed()));
        }
        return el;
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == JTableHeaderEditor.this.resizingCheckBox) {
                JTableHeaderEditor.this.headerChanged(evt);
            } else if (evt.getSource() == JTableHeaderEditor.this.reorderingCheckBox) {
                JTableHeaderEditor.this.headerChanged(evt);
            }
        }
    }

    public static class FormTableHeader
    extends FormDesignValueAdapter {
        private FormProperty property;
        private boolean resizingAllowed;
        private boolean reorderingAllowed;

        public FormTableHeader(FormProperty property, boolean resizingAllowed, boolean reorderingAllowed) {
            this.property = property;
            this.resizingAllowed = resizingAllowed;
            this.reorderingAllowed = reorderingAllowed;
        }

        public boolean isResizingAllowed() {
            return this.resizingAllowed;
        }

        public boolean isReorderingAllowed() {
            return this.reorderingAllowed;
        }

        @Override
        public Object getDesignValue() {
            Object value = null;
            try {
                value = this.property.getTargetValue();
                if (value instanceof JTableHeader) {
                    JTableHeader header = (JTableHeader)value;
                    header.setResizingAllowed(this.resizingAllowed);
                    header.setReorderingAllowed(this.reorderingAllowed);
                }
            }
            catch (IllegalAccessException iaex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, iaex.getMessage(), iaex);
            }
            catch (InvocationTargetException itex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, itex.getMessage(), itex);
            }
            return value;
        }

        @Override
        public Object getDesignValue(Object target) {
            JTableHeader header = null;
            if (target instanceof JTable) {
                header = ((JTable)target).getTableHeader();
                header.setResizingAllowed(this.resizingAllowed);
                header.setReorderingAllowed(this.reorderingAllowed);
            }
            return header;
        }

        @Override
        public Object copy(FormProperty targetFormProperty) {
            return new FormTableHeader(targetFormProperty, this.resizingAllowed, this.reorderingAllowed);
        }
    }
}

