/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.form.editors.StringArrayCustomizable;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class StringArrayCustomEditor
extends JPanel {
    private static String EMPTY_STRING = "";
    private static String SPACER = " ";
    private static String LINE_SEP = "\n";
    static final long serialVersionUID = -4347656479280614636L;
    private StringArrayCustomizable editor;
    private JLabel label;
    private JScrollPane scrollPane;
    private JTextArea textArea;

    public StringArrayCustomEditor(StringArrayCustomizable sac, String labelContent) {
        this(sac);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)labelContent);
    }

    public StringArrayCustomEditor(StringArrayCustomizable sac) {
        this.initComponents();
        this.editor = sac;
        String[] sourceArr = this.editor.getStringArray();
        StringBuilder textBuffer = new StringBuilder();
        if (sourceArr != null) {
            for (int i = 0; i < sourceArr.length; ++i) {
                boolean lastRow;
                String actValue = sourceArr[i];
                boolean bl = lastRow = i == sourceArr.length - 1;
                if (actValue != null && actValue.trim().length() == 0) {
                    actValue = EMPTY_STRING;
                }
                textBuffer.append(actValue);
                if (lastRow) continue;
                textBuffer.append(LINE_SEP);
            }
        }
        this.textArea.setText(textBuffer.toString());
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                StringArrayCustomEditor.this.updateValue();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                StringArrayCustomEditor.this.updateValue();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                StringArrayCustomEditor.this.updateValue();
            }
        });
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.label = new JLabel();
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        this.scrollPane.setViewportView(this.textArea);
        this.textArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(StringArrayCustomEditor.class, (String)"StringArrayCustomEditor.textArea.AccessibleContext.accessibleName"));
        this.textArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StringArrayCustomEditor.class, (String)"StringArrayCustomEditor.textArea.AccessibleContext.accessibleDescription"));
        this.label.setLabelFor(this.textArea);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(StringArrayCustomEditor.class, (String)"StringArrayCustomEditor.label.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.label, GroupLayout.Alignment.LEADING, -1, 386, Short.MAX_VALUE).addComponent(this.scrollPane, GroupLayout.Alignment.LEADING, -1, 386, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.label, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scrollPane, -1, 171, Short.MAX_VALUE).addContainerGap()));
        this.label.getAccessibleContext().setAccessibleName(NbBundle.getMessage(StringArrayCustomEditor.class, (String)"StringArrayCustomEditor.label.AccessibleContext.accessibleName"));
        this.label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StringArrayCustomEditor.class, (String)"StringArrayCustomEditor.label.AccessibleContext.accessibleDescription"));
    }

    public void updateValue() {
        String lastToken = EMPTY_STRING;
        ArrayList<String> list = new ArrayList<String>();
        Object text = this.textArea.getText();
        if (((String)text).endsWith(LINE_SEP)) {
            text = (String)text + SPACER;
        }
        StringTokenizer st = new StringTokenizer((String)text, LINE_SEP, true);
        while (st.hasMoreTokens()) {
            String actToken = st.nextToken();
            if (!actToken.equals(LINE_SEP)) {
                list.add(actToken);
            } else if (lastToken.equals(LINE_SEP)) {
                list.add(SPACER);
            }
            lastToken = actToken;
        }
        this.editor.setStringArray(list.toArray(new String[0]));
    }
}

