/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;
import org.netbeans.modules.form.CustomCodeData;
import org.netbeans.modules.form.FormServices;
import org.netbeans.modules.form.FormUtils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class CustomCodeView
extends JPanel {
    private CustomCodeData codeData;
    private int lastLocalModifiers = -1;
    private int lastFieldModifiers = -1;
    private boolean changed;
    private Listener controller;
    private DocumentL docListener;
    private boolean ignoreComboAction;
    private Map<CustomCodeData.CodeCategory, EditBlockInfo[]> editBlockInfos;
    private Map<CustomCodeData.CodeCategory, GuardBlockInfo[]> guardBlockInfos;
    private static final String UNDO_MANAGER_PROP = "undo-manager";
    private JComboBox accessCombo;
    private JComboBox componentCombo;
    private JEditorPane declareCodeEditor;
    private JCheckBox finalCheckBox;
    private JEditorPane initCodeEditor;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton renameButton;
    private JCheckBox staticCheckBox;
    private JCheckBox transientCheckBox;
    private JComboBox variableCombo;
    private JCheckBox volatileCheckBox;
    private JPanel initGutter;
    private JPanel declareGutter;
    private static final boolean[] variableValues = new boolean[]{false, true};
    private static final String[] variableStrings = new String[]{NbBundle.getMessage(CustomCodeView.class, (String)"CTL_VariableCombo_Field"), NbBundle.getMessage(CustomCodeView.class, (String)"CTL_VariableCombo_Local")};
    private static final int[] accessValues = new int[]{2, 0, 4, 1};
    private static final String[] accessStrings = new String[]{"private", NbBundle.getMessage(CustomCodeView.class, (String)"CTL_AccessCombo_package_private"), "protected", "public"};

    CustomCodeView(Listener controller) {
        this.controller = controller;
        this.initComponents();
        this.variableCombo.setModel(new DefaultComboBoxModel<String>(variableStrings));
        this.accessCombo.setModel(new DefaultComboBoxModel<String>(accessStrings));
        HashMap<Component, Position> positions = new HashMap<Component, Position>();
        this.initGutter = new JPanel();
        this.initGutter.setLayout(new GutterLayout(this.initCodeEditor, positions));
        this.declareGutter = new JPanel();
        this.declareGutter.setLayout(new GutterLayout(this.declareCodeEditor, positions));
        this.jScrollPane1.setRowHeaderView(this.initGutter);
        this.jScrollPane2.setRowHeaderView(this.declareGutter);
    }

    private JEditorPane createCodeEditorPane() {
        FormServices services = (FormServices)Lookup.getDefault().lookup(FormServices.class);
        return services.createCodeEditorPane();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initCodeEditor.requestFocusInWindow();
    }

    boolean isChanged() {
        return this.changed;
    }

    void setComponentNames(String[] compNames) {
        this.componentCombo.setModel(new DefaultComboBoxModel<String>(compNames));
    }

    void setCodeData(String componentName, CustomCodeData codeData, FileObject srcFile, int[] positions) {
        if (this.codeData != null) {
            this.initCodeEditor.getDocument().removeDocumentListener(this.docListener);
            this.declareCodeEditor.getDocument().removeDocumentListener(this.docListener);
            this.initGutter.removeAll();
            this.declareGutter.removeAll();
            this.revalidate();
            this.repaint();
        }
        if (this.editBlockInfos != null) {
            this.editBlockInfos.clear();
            this.guardBlockInfos.clear();
        } else {
            this.editBlockInfos = new HashMap<CustomCodeData.CodeCategory, EditBlockInfo[]>();
            this.guardBlockInfos = new HashMap<CustomCodeData.CodeCategory, GuardBlockInfo[]>();
        }
        FormUtils.setupEditorPane(this.initCodeEditor, srcFile, positions[0]);
        FormUtils.setupEditorPane(this.declareCodeEditor, srcFile, positions[1]);
        this.codeData = codeData;
        this.selectInComboBox(this.componentCombo, componentName);
        this.buildCodeView(CustomCodeData.CodeCategory.CREATE_AND_INIT);
        this.buildCodeView(CustomCodeData.CodeCategory.DECLARATION);
        Object um = this.initCodeEditor.getDocument().getProperty(UNDO_MANAGER_PROP);
        if (um instanceof UndoManager) {
            ((UndoManager)um).discardAllEdits();
        }
        if ((um = this.declareCodeEditor.getDocument().getProperty(UNDO_MANAGER_PROP)) instanceof UndoManager) {
            ((UndoManager)um).discardAllEdits();
        }
        CustomCodeData.VariableDeclaration decl = codeData.getDeclarationData();
        boolean local = decl.local;
        for (int i = 0; i < variableValues.length; ++i) {
            if (variableValues[i] != local) continue;
            this.selectInComboBox(this.variableCombo, variableStrings[i]);
            break;
        }
        int modifiers = decl.modifiers;
        int access = modifiers & 7;
        for (int i = 0; i < accessValues.length; ++i) {
            if (accessValues[i] != access) continue;
            this.selectInComboBox(this.accessCombo, accessStrings[i]);
            break;
        }
        this.staticCheckBox.setSelected((modifiers & 8) == 8);
        this.finalCheckBox.setSelected((modifiers & 0x10) == 16);
        this.transientCheckBox.setSelected((modifiers & 0x80) == 128);
        this.volatileCheckBox.setSelected((modifiers & 0x40) == 64);
        this.accessCombo.setEnabled(!local);
        this.staticCheckBox.setEnabled(!local);
        this.transientCheckBox.setEnabled(!local);
        this.volatileCheckBox.setEnabled(!local);
        if (local) {
            this.lastLocalModifiers = modifiers;
        } else {
            this.lastFieldModifiers = modifiers;
        }
        this.changed = false;
        if (this.docListener == null) {
            this.docListener = new DocumentL();
        }
        this.initCodeEditor.getDocument().addDocumentListener(this.docListener);
        this.declareCodeEditor.getDocument().addDocumentListener(this.docListener);
        this.initCodeEditor.setCaretPosition(0);
        this.declareCodeEditor.setCaretPosition(0);
    }

    private void buildCodeView(CustomCodeData.CodeCategory category) {
        this.editBlockInfos.put(category, new EditBlockInfo[this.codeData.getEditableBlockCount(category)]);
        int gCount = this.codeData.getGuardedBlockCount(category);
        this.guardBlockInfos.put(category, new GuardBlockInfo[gCount]);
        try {
            for (int i = 0; i < gCount; ++i) {
                this.addEditableCode(category, i);
                this.addGuardedCode(category, i);
            }
            if (gCount > 0) {
                this.addEditableCode(category, gCount);
            }
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        this.getEditor(category).setEnabled(gCount > 0);
    }

    private void addEditableCode(CustomCodeData.CodeCategory category, int blockIndex) throws BadLocationException {
        Document doc = this.getDocument(category);
        CustomCodeData.EditableBlock eBlock = this.codeData.getEditableBlock(category, blockIndex);
        boolean lastBlock = blockIndex + 1 == this.codeData.getEditableBlockCount(category);
        LinkedList<EditableLine> lineList = new LinkedList<EditableLine>();
        int startIndex = doc.getLength();
        boolean needLineEnd = false;
        CustomCodeData.CodeEntry[] entries = eBlock.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            CustomCodeData.CodeEntry e = entries[i];
            String code = e.getCode();
            if (code == null) continue;
            int lineStart = 0;
            int codeLength = code.length();
            for (int j = 0; j < codeLength; ++j) {
                char c = code.charAt(j);
                if (c != '\n' && j + 1 != codeLength) continue;
                if (needLineEnd) {
                    doc.insertString(doc.getLength(), "\n", null);
                }
                boolean lastLine = lastBlock && i + 1 == entries.length && j + 1 == codeLength;
                needLineEnd = c != '\n' && !lastLine;
                int lineEnd = c == '\n' && lastLine ? j : j + 1;
                int index = doc.getLength();
                doc.insertString(index, code.substring(lineStart, lineEnd), null);
                Position pos = NbDocument.createPosition((Document)doc, (int)index, (Position.Bias)Position.Bias.Backward);
                lineList.add(new EditableLine(pos, eBlock, i, lineList));
                lineStart = j + 1;
            }
        }
        if (lineList.size() > 0) {
            if (needLineEnd) {
                doc.insertString(doc.getLength(), "\n", null);
            }
        } else {
            int index = doc.getLength();
            if (!lastBlock) {
                doc.insertString(index, "\n", null);
            }
            Position pos = NbDocument.createPosition((Document)doc, (int)index, (Position.Bias)Position.Bias.Backward);
            lineList.add(new EditableLine(pos, eBlock, eBlock.getPreferredEntryIndex(), lineList));
        }
        this.updateGutterComponents(lineList, doc, startIndex, doc.getLength());
        EditBlockInfo eInfo = new EditBlockInfo();
        eInfo.position = ((EditableLine)lineList.get(0)).getPosition();
        eInfo.lines = lineList;
        this.getEditInfos((CustomCodeData.CodeCategory)category)[blockIndex] = eInfo;
    }

    private void addGuardedCode(CustomCodeData.CodeCategory category, int blockIndex) throws BadLocationException {
        Position pos;
        StyledDocument doc = (StyledDocument)this.getDocument(category);
        CustomCodeData.GuardedBlock gBlock = this.codeData.getGuardedBlock(category, blockIndex);
        GuardBlockInfo gInfo = new GuardBlockInfo();
        int index = doc.getLength();
        if (gBlock.isCustomized()) {
            code = gBlock.getCustomCode();
            doc.insertString(index, code, null);
            if (!code.endsWith("\n")) {
                doc.insertString(doc.getLength(), "\n", null);
            }
            int header = gBlock.getHeaderLength();
            int footer = gBlock.getFooterLength();
            NbDocument.markGuarded((StyledDocument)doc, (int)index, (int)header);
            NbDocument.markGuarded((StyledDocument)doc, (int)(doc.getLength() - footer), (int)footer);
            gInfo.customized = true;
        } else {
            code = gBlock.getDefaultCode();
            doc.insertString(index, code, null);
            if (!code.endsWith("\n")) {
                doc.insertString(doc.getLength(), "\n", null);
            }
            NbDocument.markGuarded((StyledDocument)doc, (int)index, (int)(doc.getLength() - index));
        }
        gInfo.position = pos = NbDocument.createPosition((Document)doc, (int)index, (Position.Bias)Position.Bias.Forward);
        this.getGuardInfos((CustomCodeData.CodeCategory)category)[blockIndex] = gInfo;
        if (gBlock.isCustomizable()) {
            String[] items = new String[]{NbBundle.getMessage(CustomCodeView.class, (String)"CTL_GuardCombo_Default"), gBlock.getCustomEntry().getDisplayName()};
            JComboBox<String> combo = new JComboBox<String>(items);
            if (gBlock.isCustomized()) {
                this.selectInComboBox(combo, items[1]);
                combo.setToolTipText(gBlock.getCustomEntry().getToolTipText());
            } else {
                this.selectInComboBox(combo, items[0]);
                combo.setToolTipText(NbBundle.getMessage(CustomCodeView.class, (String)"CTL_GuardCombo_Default_Hint"));
            }
            combo.getAccessibleContext().setAccessibleName(gBlock.getCustomEntry().getName());
            combo.addActionListener(new GuardSwitchL(category, blockIndex));
            this.getGutter(doc).add(combo, pos);
        }
    }

    CustomCodeData retreiveCodeData() {
        int modifiers;
        this.retreiveCodeData(CustomCodeData.CodeCategory.CREATE_AND_INIT);
        this.retreiveCodeData(CustomCodeData.CodeCategory.DECLARATION);
        CustomCodeData.VariableDeclaration decl = this.codeData.getDeclarationData();
        boolean local = variableValues[this.variableCombo.getSelectedIndex()];
        if (local != decl.local) {
            int n = modifiers = local ? this.lastLocalModifiers : this.lastFieldModifiers;
            modifiers = this.finalCheckBox.isSelected() ? (modifiers |= 0x10) : (modifiers &= 0xFFFFFFEF);
        } else {
            modifiers = accessValues[this.accessCombo.getSelectedIndex()];
            if (this.staticCheckBox.isSelected()) {
                modifiers |= 8;
            }
            if (this.finalCheckBox.isSelected()) {
                modifiers |= 0x10;
            }
            if (this.transientCheckBox.isSelected()) {
                modifiers |= 0x80;
            }
            if (this.volatileCheckBox.isSelected()) {
                modifiers |= 0x40;
            }
            if (local) {
                modifiers &= 0xFFFFFF37;
            }
        }
        decl.local = local;
        decl.modifiers = modifiers;
        return this.codeData;
    }

    private void retreiveCodeData(CustomCodeData.CodeCategory category) {
        int gCount = this.codeData.getGuardedBlockCount(category);
        for (int i = 0; i < gCount; ++i) {
            this.retreiveEditableBlock(category, i);
            this.retreiveGuardedBlock(category, i);
        }
        if (gCount > 0) {
            this.retreiveEditableBlock(category, gCount);
        }
    }

    private void retreiveEditableBlock(CustomCodeData.CodeCategory category, int index) {
        CustomCodeData.CodeEntry[] entries;
        for (CustomCodeData.CodeEntry e : entries = this.codeData.getEditableBlock(category, index).getEntries()) {
            e.setCode(null);
        }
        int[] blockBounds = this.getEditBlockBounds(category, index);
        Document doc = this.getDocument(category);
        try {
            String allCode = doc.getText(blockBounds[0], blockBounds[1] - blockBounds[0]);
            if (allCode.trim().equals("")) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            int selIndex = -1;
            EditableLine nextLine = null;
            Iterator<EditableLine> it = this.getEditInfos((CustomCodeData.CodeCategory)category)[index].lines.iterator();
            while (it.hasNext() || nextLine != null) {
                int endPos;
                EditableLine l = nextLine != null ? nextLine : it.next();
                int startPos = l.getPosition().getOffset();
                if (it.hasNext()) {
                    nextLine = it.next();
                    endPos = nextLine.getPosition().getOffset();
                } else {
                    nextLine = null;
                    endPos = blockBounds[1];
                }
                buf.append(doc.getText(startPos, endPos - startPos));
                if (nextLine != null && nextLine.getSelectedIndex() == l.getSelectedIndex()) continue;
                String code = buf.toString().trim();
                if (!code.equals("")) {
                    entries[l.getSelectedIndex()].setCode(code);
                }
                buf.delete(0, buf.length());
            }
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    private void retreiveGuardedBlock(CustomCodeData.CodeCategory category, int index) {
        CustomCodeData.GuardedBlock gBlock = this.codeData.getGuardedBlock(category, index);
        if (!gBlock.isCustomizable()) {
            return;
        }
        if (this.getGuardInfos((CustomCodeData.CodeCategory)category)[index].customized) {
            Document doc = this.getDocument(category);
            int[] blockBounds = this.getGuardBlockBounds(category, index);
            try {
                int startPos = blockBounds[0] + gBlock.getHeaderLength();
                String code = doc.getText(startPos, blockBounds[1] - gBlock.getFooterLength() - startPos);
                gBlock.setCustomizedCode(code);
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        } else {
            gBlock.setCustomizedCode(null);
        }
    }

    private void selectInComboBox(JComboBox combo, Object item) {
        this.ignoreComboAction = true;
        combo.setSelectedItem(item);
        this.ignoreComboAction = false;
    }

    private JTextComponent getEditor(CustomCodeData.CodeCategory category) {
        switch (category) {
            case CREATE_AND_INIT: {
                return this.initCodeEditor;
            }
            case DECLARATION: {
                return this.declareCodeEditor;
            }
        }
        return null;
    }

    private Document getDocument(CustomCodeData.CodeCategory category) {
        return this.getEditor(category).getDocument();
    }

    private EditBlockInfo[] getEditInfos(CustomCodeData.CodeCategory category) {
        return this.editBlockInfos.get((Object)category);
    }

    private GuardBlockInfo[] getGuardInfos(CustomCodeData.CodeCategory category) {
        return this.guardBlockInfos.get((Object)category);
    }

    private JPanel getGutter(Document doc) {
        if (doc == this.initCodeEditor.getDocument()) {
            return this.initGutter;
        }
        if (doc == this.declareCodeEditor.getDocument()) {
            return this.declareGutter;
        }
        return null;
    }

    private CustomCodeData.CodeCategory getCategoryForDocument(Document doc) {
        if (doc == this.initCodeEditor.getDocument()) {
            return CustomCodeData.CodeCategory.CREATE_AND_INIT;
        }
        if (doc == this.declareCodeEditor.getDocument()) {
            return CustomCodeData.CodeCategory.DECLARATION;
        }
        return null;
    }

    private boolean updateGutterComponents(List<EditableLine> lines, Document doc, int startIndex, int endIndex) {
        String text;
        try {
            text = doc.getText(startIndex, endIndex - startIndex);
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return false;
        }
        boolean visibility = !text.trim().equals("");
        int prevSelectedIndex = 0;
        boolean changed = false;
        JPanel gutter = this.getGutter(doc);
        for (EditableLine l : lines) {
            if (l.getSelectedIndex() < prevSelectedIndex) {
                l.setSelectedIndex(prevSelectedIndex);
            } else {
                prevSelectedIndex = l.getSelectedIndex();
            }
            Component comp = l.getGutterComponent();
            if (comp.getParent() == null) {
                gutter.add(comp, l.getPosition());
            }
            if (visibility == l.isVisible()) continue;
            comp.setVisible(visibility);
            changed = true;
        }
        return changed;
    }

    private void updateLines(Document doc, int startPos, int endPos, List<EditableLine> lines, CustomCodeData.EditableBlock eBlock) {
        String text;
        try {
            text = doc.getText(startPos, endPos - startPos);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        ListIterator<EditableLine> lineIt = lines.listIterator();
        EditableLine line = null;
        int selIndex = -1;
        boolean onNewLine = true;
        for (int offset = startPos; offset < endPos; ++offset) {
            boolean lineIsHere = false;
            if (line == null && lineIt.hasNext()) {
                line = lineIt.next();
            }
            EditableLine first = null;
            while (line != null && line.getPosition().getOffset() == offset) {
                lineIsHere = true;
                if (onNewLine && first == null) {
                    first = line;
                    selIndex = line.getSelectedIndex();
                } else {
                    lineIt.remove();
                    Component comp = line.getGutterComponent();
                    comp.getParent().remove(comp);
                    if (first != null) {
                        selIndex = line.getSelectedIndex();
                        first.setSelectedIndex(selIndex);
                    }
                }
                line = lineIt.hasNext() ? lineIt.next() : null;
            }
            if (onNewLine && !lineIsHere) {
                if (selIndex < 0) {
                    selIndex = eBlock.getPreferredEntryIndex();
                }
                try {
                    Position pos = NbDocument.createPosition((Document)doc, (int)offset, (Position.Bias)Position.Bias.Backward);
                    if (line != null) {
                        lineIt.previous();
                    }
                    lineIt.add(new EditableLine(pos, eBlock, selIndex, lines));
                    if (line != null) {
                        lineIt.next();
                    }
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            onNewLine = text.charAt(offset - startPos) == '\n';
        }
    }

    private int[] getEditBlockBounds(CustomCodeData.CodeCategory category, int index) {
        int startIndex = this.getEditInfos((CustomCodeData.CodeCategory)category)[index].position.getOffset();
        GuardBlockInfo[] gInfos = this.getGuardInfos(category);
        int endIndex = index < gInfos.length ? gInfos[index].position.getOffset() : this.getDocument(category).getLength();
        return new int[]{startIndex, endIndex};
    }

    private int getEditBlockIndex(CustomCodeData.CodeCategory category, int offset) {
        return this.getBlockIndex(category, offset, true);
    }

    private int getBlockIndex(CustomCodeData.CodeCategory category, int offset, boolean editable) {
        EditBlockInfo[] editInfos = this.getEditInfos(category);
        GuardBlockInfo[] guardInfos = this.getGuardInfos(category);
        for (int i = 0; i < guardInfos.length; ++i) {
            int editPos = editInfos[i].position.getOffset();
            if (editPos > offset) {
                return editable ? -1 : i - 1;
            }
            if (editPos != offset && guardInfos[i].position.getOffset() < offset) continue;
            return editable ? i : -1;
        }
        return editable ? editInfos.length - 1 : -1;
    }

    private int[] getGuardBlockBounds(CustomCodeData.CodeCategory category, int index) {
        int startIndex = this.getGuardInfos((CustomCodeData.CodeCategory)category)[index].position.getOffset();
        int endIndex = this.getEditInfos((CustomCodeData.CodeCategory)category)[index + 1].position.getOffset();
        return new int[]{startIndex, endIndex};
    }

    private static int getLineCount(Document doc) {
        String text;
        int length = doc.getLength();
        int count = 0;
        try {
            text = doc.getText(0, length);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return -1;
        }
        for (int i = 0; i < length; ++i) {
            if (text.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    private static int findLineNumber(Document doc, int offset) {
        String text;
        int length = doc.getLength();
        int count = 0;
        try {
            text = doc.getText(0, length);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return -1;
        }
        for (int i = 0; i < length; ++i) {
            if (i == offset) {
                return count;
            }
            if (text.charAt(i) != '\n') continue;
            ++count;
        }
        return offset == length ? count : -1;
    }

    private void initComponents() {
        JLabel initCodeLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.initCodeEditor = this.createCodeEditorPane();
        JLabel declarationCodeLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.declareCodeEditor = this.createCodeEditorPane();
        JLabel selectComponentLabel = new JLabel();
        this.componentCombo = new JComboBox();
        this.renameButton = new JButton();
        JLabel variableScopeLabel = new JLabel();
        this.variableCombo = new JComboBox();
        JLabel variableAccessLabel = new JLabel();
        this.accessCombo = new JComboBox();
        this.staticCheckBox = new JCheckBox();
        this.finalCheckBox = new JCheckBox();
        this.transientCheckBox = new JCheckBox();
        this.volatileCheckBox = new JCheckBox();
        FormListener formListener = new FormListener();
        initCodeLabel.setFont(initCodeLabel.getFont().deriveFont(initCodeLabel.getFont().getStyle() | 1));
        initCodeLabel.setLabelFor(this.initCodeEditor);
        Mnemonics.setLocalizedText((JLabel)initCodeLabel, (String)NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.initCodeLabel.text"));
        this.jScrollPane1.setViewportView(this.initCodeEditor);
        declarationCodeLabel.setFont(declarationCodeLabel.getFont().deriveFont(declarationCodeLabel.getFont().getStyle() | 1));
        declarationCodeLabel.setLabelFor(this.declareCodeEditor);
        Mnemonics.setLocalizedText((JLabel)declarationCodeLabel, (String)NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.declarationCodeLabel.text"));
        this.jScrollPane2.setViewportView(this.declareCodeEditor);
        selectComponentLabel.setLabelFor(this.componentCombo);
        Mnemonics.setLocalizedText((JLabel)selectComponentLabel, (String)NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.selectComponentLabel.text"));
        this.componentCombo.setToolTipText(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.componentCombo.toolTipText"));
        this.componentCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.renameButton, (String)NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.renameButton.text"));
        this.renameButton.setToolTipText(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.renameButton.toolTipText"));
        this.renameButton.addActionListener(formListener);
        variableScopeLabel.setLabelFor(this.variableCombo);
        Mnemonics.setLocalizedText((JLabel)variableScopeLabel, (String)NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.variableScopeLabel.text"));
        this.variableCombo.addActionListener(formListener);
        variableAccessLabel.setLabelFor(this.accessCombo);
        Mnemonics.setLocalizedText((JLabel)variableAccessLabel, (String)NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.variableAccessLabel.text"));
        this.accessCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.staticCheckBox, (String)"&static");
        this.staticCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.staticCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.staticCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.finalCheckBox, (String)"&final");
        this.finalCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.finalCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.finalCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.transientCheckBox, (String)"&transient");
        this.transientCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.transientCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.transientCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.volatileCheckBox, (String)"v&olatile");
        this.volatileCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.volatileCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.volatileCheckBox.addActionListener(formListener);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 680, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(variableScopeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.variableCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(variableAccessLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.finalCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.staticCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.transientCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volatileCheckBox)).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 680, Short.MAX_VALUE).addComponent(declarationCodeLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(selectComponentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.componentCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.renameButton)).addComponent(initCodeLabel, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.linkSize(0, this.accessCombo, this.variableCombo);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(selectComponentLabel).addComponent(this.componentCombo, -2, -1, -2).addComponent(this.renameButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(initCodeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 348, Short.MAX_VALUE).addGap(11, 11, 11).addComponent(declarationCodeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(variableScopeLabel).addComponent(this.variableCombo, -2, -1, -2).addComponent(variableAccessLabel).addComponent(this.accessCombo, -2, -1, -2).addComponent(this.staticCheckBox).addComponent(this.finalCheckBox).addComponent(this.transientCheckBox).addComponent(this.volatileCheckBox)).addContainerGap()));
        this.staticCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.staticCheckBox.accessibleDescription"));
        this.finalCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.finalCheckBox.accessibleDescription"));
        this.transientCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.transientCheckBox.accessibleDescription"));
        this.volatileCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.volatileCheckBox.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.accessibleDescription"));
    }

    private void declControlActionPerformed(ActionEvent evt) {
        if (this.ignoreComboAction) {
            return;
        }
        if (evt.getSource() == this.finalCheckBox) {
            if (this.finalCheckBox.isSelected()) {
                this.volatileCheckBox.setSelected(false);
            }
        } else if (evt.getSource() == this.volatileCheckBox && this.volatileCheckBox.isSelected()) {
            this.finalCheckBox.setSelected(false);
        }
        this.changed = true;
        this.controller.declarationChanged();
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        this.controller.renameInvoked();
    }

    private void componentComboActionPerformed(ActionEvent evt) {
        if (this.ignoreComboAction) {
            return;
        }
        this.controller.componentExchanged((String)this.componentCombo.getSelectedItem());
    }

    static interface Listener {
        public void componentExchanged(String var1);

        public void renameInvoked();

        public void declarationChanged();
    }

    private static class GutterLayout
    implements LayoutManager2 {
        private JTextComponent editor;
        private Map<Component, Position> positions;
        private int lineHeight = -1;
        private static final int LEFT_GAP = 2;
        private static final int RIGHT_GAP = 4;

        GutterLayout(JTextComponent editor, Map<Component, Position> positionMap) {
            this.editor = editor;
            this.positions = positionMap;
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.positions.put(comp, (Position)constraints);
        }

        @Override
        public void layoutContainer(Container parent) {
            StyledDocument doc = (StyledDocument)this.editor.getDocument();
            for (Component comp : parent.getComponents()) {
                Position pos = this.positions.get(comp);
                int line = CustomCodeView.findLineNumber(doc, pos.getOffset());
                Dimension prefSize = comp.getPreferredSize();
                int dy = this.lineHeight() - prefSize.height;
                dy = dy > 0 ? dy / 2 + 1 : 0;
                comp.setBounds(2, line * this.lineHeight() + dy, parent.getWidth() - 2 - 4, Math.min(prefSize.height, this.lineHeight()));
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.positions.remove(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int prefWidth = 0;
            for (Component comp : this.positions.keySet()) {
                Dimension prefSize = comp.getPreferredSize();
                if (prefSize.width <= prefWidth) continue;
                prefWidth = prefSize.width;
            }
            return new Dimension(prefWidth + 2 + 4, this.editor.getPreferredSize().height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension maximumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        private int lineHeight() {
            if (this.lineHeight < 0) {
                Element root = this.editor.getDocument().getDefaultRootElement();
                if (root.getElementCount() > 0) {
                    Element elem = root.getElement(0);
                    try {
                        int y1 = this.editor.modelToView((int)elem.getStartOffset()).y;
                        int y2 = this.editor.modelToView((int)elem.getEndOffset()).y;
                        this.lineHeight = y2 - y1;
                    }
                    catch (BadLocationException blex) {
                        Logger.getLogger(CustomCodeView.class.getName()).log(Level.INFO, blex.getMessage(), blex);
                    }
                }
                if (this.lineHeight <= 0) {
                    this.lineHeight = this.editor.getFontMetrics(this.editor.getFont()).getHeight();
                }
            }
            return this.lineHeight;
        }
    }

    private class DocumentL
    implements DocumentListener {
        private boolean active = true;
        private Map<Document, Integer> lastDocLineCounts = new HashMap<Document, Integer>();

        private DocumentL() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (this.active) {
                this.contentChange(e);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (this.active) {
                this.contentChange(e);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        void setActive(boolean active) {
            this.active = active;
            if (active) {
                this.lastDocLineCounts.clear();
            }
        }

        private void contentChange(DocumentEvent e) {
            CustomCodeView.this.changed = true;
            Document doc = e.getDocument();
            CustomCodeData.CodeCategory category = CustomCodeView.this.getCategoryForDocument(doc);
            int eBlockIndex = CustomCodeView.this.getEditBlockIndex(category, e.getOffset());
            if (eBlockIndex < 0) {
                return;
            }
            List<EditableLine> lines = CustomCodeView.this.getEditInfos((CustomCodeData.CodeCategory)category)[eBlockIndex].lines;
            int[] blockBounds = CustomCodeView.this.getEditBlockBounds(category, eBlockIndex);
            boolean repaint = false;
            Integer lastLineCount = this.lastDocLineCounts.get(doc);
            int lineCount = CustomCodeView.getLineCount(doc);
            if (lastLineCount == null || lastLineCount != lineCount) {
                this.lastDocLineCounts.put(doc, lineCount);
                CustomCodeView.this.updateLines(doc, blockBounds[0], blockBounds[1], lines, CustomCodeView.this.codeData.getEditableBlock(category, eBlockIndex));
                repaint = true;
                doc.removeDocumentListener(this);
                doc.addDocumentListener(this);
            }
            if (repaint |= CustomCodeView.this.updateGutterComponents(lines, doc, blockBounds[0], blockBounds[1])) {
                JPanel gutter = CustomCodeView.this.getGutter(doc);
                gutter.revalidate();
                gutter.repaint();
            }
        }
    }

    private static class EditBlockInfo {
        Position position;
        List<EditableLine> lines;

        private EditBlockInfo() {
        }
    }

    private static class GuardBlockInfo {
        Position position;
        String customizedCode;
        boolean customized;

        private GuardBlockInfo() {
        }
    }

    private class EditableLine {
        private Position position;
        private JComboBox targetCombo;
        private List<EditableLine> linesInBlock;
        private CustomCodeData.CodeEntry[] codeEntries;

        EditableLine(Position pos, CustomCodeData.EditableBlock eBlock, int selIndex, List<EditableLine> lines) {
            this.position = pos;
            this.linesInBlock = lines;
            this.codeEntries = eBlock.getEntries();
            this.targetCombo = new JComboBox<CustomCodeData.CodeEntry>(this.codeEntries);
            this.setSelectedIndex(selIndex);
            this.targetCombo.getAccessibleContext().setAccessibleName(this.codeEntries[selIndex].getName());
            this.targetCombo.setToolTipText(this.codeEntries[selIndex].getToolTipText());
            this.targetCombo.addActionListener(new EditSwitchL());
        }

        Position getPosition() {
            return this.position;
        }

        Component getGutterComponent() {
            return this.targetCombo;
        }

        boolean isVisible() {
            return this.targetCombo.getParent() != null && this.targetCombo.isVisible();
        }

        int getSelectedIndex() {
            return this.targetCombo.getSelectedIndex();
        }

        void setSelectedIndex(int index) {
            CustomCodeView.this.selectInComboBox(this.targetCombo, this.targetCombo.getItemAt(index));
        }

        class EditSwitchL
        implements ActionListener {
            EditSwitchL() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomCodeView.this.ignoreComboAction) {
                    return;
                }
                CustomCodeView.this.changed = true;
                int selectedIndex = EditableLine.this.targetCombo.getSelectedIndex();
                boolean preceding = true;
                for (EditableLine l : EditableLine.this.linesInBlock) {
                    if (l != EditableLine.this) {
                        if ((!preceding || l.getSelectedIndex() <= selectedIndex) && (preceding || l.getSelectedIndex() >= selectedIndex)) continue;
                        l.setSelectedIndex(selectedIndex);
                        continue;
                    }
                    preceding = false;
                }
                EditableLine.this.targetCombo.setToolTipText(EditableLine.this.codeEntries[selectedIndex].getToolTipText());
            }
        }
    }

    private class GuardSwitchL
    implements ActionListener {
        CustomCodeData.CodeCategory category;
        int blockIndex;

        GuardSwitchL(CustomCodeData.CodeCategory cat, int index) {
            this.category = cat;
            this.blockIndex = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CustomCodeView.this.ignoreComboAction) {
                return;
            }
            CustomCodeData.GuardedBlock gBlock = CustomCodeView.this.codeData.getGuardedBlock(this.category, this.blockIndex);
            GuardBlockInfo gInfo = CustomCodeView.this.getGuardInfos(this.category)[this.blockIndex];
            int[] blockBounds = CustomCodeView.this.getGuardBlockBounds(this.category, this.blockIndex);
            int startOffset = blockBounds[0];
            int endOffset = blockBounds[1];
            int gHead = gBlock.getHeaderLength();
            int gFoot = gBlock.getFooterLength();
            JTextComponent editor = CustomCodeView.this.getEditor(this.category);
            StyledDocument doc = (StyledDocument)editor.getDocument();
            CustomCodeView.this.changed = true;
            JComboBox combo = (JComboBox)e.getSource();
            try {
                CustomCodeView.this.docListener.setActive(false);
                if (combo.getSelectedIndex() == 1) {
                    NbDocument.unmarkGuarded((StyledDocument)doc, (int)startOffset, (int)(endOffset - startOffset));
                    doc.remove(startOffset, endOffset - startOffset - 1);
                    Object customCode = gBlock.getCustomCode();
                    int customLength = ((String)customCode).length();
                    if (gInfo.customizedCode != null) {
                        customCode = ((String)customCode).substring(0, gHead) + gInfo.customizedCode + ((String)customCode).substring(customLength - gFoot);
                        customLength = ((String)customCode).length();
                    }
                    if (((String)customCode).endsWith("\n")) {
                        customCode = ((String)customCode).substring(0, customLength - 1);
                    }
                    doc.insertString(startOffset, (String)customCode, null);
                    gInfo.customized = true;
                    NbDocument.markGuarded((StyledDocument)doc, (int)startOffset, (int)gHead);
                    NbDocument.markGuarded((StyledDocument)doc, (int)(startOffset + customLength - gFoot), (int)gFoot);
                    editor.setSelectionStart(startOffset + gHead);
                    editor.setSelectionEnd(startOffset + customLength - gFoot);
                    editor.requestFocus();
                    combo.setToolTipText(gBlock.getCustomEntry().getToolTipText());
                } else {
                    gInfo.customizedCode = doc.getText(startOffset + gHead, endOffset - gFoot - gHead - startOffset);
                    NbDocument.unmarkGuarded((StyledDocument)doc, (int)(endOffset - gFoot), (int)gFoot);
                    NbDocument.unmarkGuarded((StyledDocument)doc, (int)startOffset, (int)gHead);
                    doc.remove(startOffset, endOffset - startOffset - 1);
                    String defaultCode = gBlock.getDefaultCode();
                    if (defaultCode.endsWith("\n")) {
                        defaultCode = defaultCode.substring(0, defaultCode.length() - 1);
                    }
                    doc.insertString(startOffset, defaultCode, null);
                    gInfo.customized = false;
                    NbDocument.markGuarded((StyledDocument)doc, (int)startOffset, (int)(defaultCode.length() + 1));
                    if (editor.getSelectionStart() >= startOffset && editor.getSelectionEnd() <= endOffset) {
                        editor.setCaretPosition(startOffset);
                    }
                    combo.setToolTipText(NbBundle.getMessage(CustomCodeData.class, (String)"CTL_GuardCombo_Default_Hint"));
                }
                gInfo.position = NbDocument.createPosition((Document)doc, (int)startOffset, (Position.Bias)Position.Bias.Forward);
                CustomCodeView.this.docListener.setActive(true);
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == CustomCodeView.this.componentCombo) {
                CustomCodeView.this.componentComboActionPerformed(evt);
            } else if (evt.getSource() == CustomCodeView.this.renameButton) {
                CustomCodeView.this.renameButtonActionPerformed(evt);
            } else if (evt.getSource() == CustomCodeView.this.variableCombo) {
                CustomCodeView.this.declControlActionPerformed(evt);
            } else if (evt.getSource() == CustomCodeView.this.accessCombo) {
                CustomCodeView.this.declControlActionPerformed(evt);
            } else if (evt.getSource() == CustomCodeView.this.staticCheckBox) {
                CustomCodeView.this.declControlActionPerformed(evt);
            } else if (evt.getSource() == CustomCodeView.this.finalCheckBox) {
                CustomCodeView.this.declControlActionPerformed(evt);
            } else if (evt.getSource() == CustomCodeView.this.transientCheckBox) {
                CustomCodeView.this.declControlActionPerformed(evt);
            } else if (evt.getSource() == CustomCodeView.this.volatileCheckBox) {
                CustomCodeView.this.declControlActionPerformed(evt);
            }
        }
    }
}

