/*
 * Decompiled with CFR 0.152.
 */
package nbjavac;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Map;

public class FileSystemsWrapper {
    private static final Method newFS13;

    public static FileSystem newFileSystem(Path path, Map<String, ?> env, ClassLoader loader) throws IOException {
        if (newFS13 != null) {
            try {
                return (FileSystem)newFS13.invoke(null, path, env, loader);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException();
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new RuntimeException(ex);
            }
        }
        return FileSystems.newFileSystem(path, loader);
    }

    public static FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        return FileSystemsWrapper.newFileSystem(path, env, null);
    }

    static {
        Method m = null;
        try {
            m = FileSystems.class.getDeclaredMethod("newFileSystem", Path.class, Map.class, ClassLoader.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        newFS13 = m;
    }
}

