/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.EventListener;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.debugger.jpda.BreakpointStratifier;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class LineBreakpoint
extends JPDABreakpoint {
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_URL = "url";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_SOURCE_NAME = "sourceName";
    public static final String PROP_SOURCE_PATH = "sourcePath";
    public static final String PROP_STRATUM = "stratum";
    public static final String PROP_PREFERRED_CLASS_NAME = "classNamePreferred";
    public static final String PROP_INSTANCE_FILTERS = "instanceFilters";
    public static final String PROP_THREAD_FILTERS = "threadFilters";
    private static final Logger LOG = Logger.getLogger(LineBreakpoint.class.getName());
    private String url = "";
    private int lineNumber;
    private String condition = "";
    private String sourceName = null;
    private String sourcePath = null;
    private String stratum = "Java";
    private String className = null;
    private Map<JPDADebugger, ObjectVariable[]> instanceFilters;
    private Map<JPDADebugger, JPDAThread[]> threadFilters;

    private LineBreakpoint(String url) {
        this.url = url;
    }

    public static LineBreakpoint create(String url, int lineNumber) {
        LineBreakpointImpl b = new LineBreakpointImpl(url);
        b.setLineNumber(lineNumber);
        if (url != null && !url.isEmpty()) {
            Collection stratifiers = Lookup.getDefault().lookupAll(BreakpointStratifier.class);
            for (BreakpointStratifier stratifier : stratifiers) {
                stratifier.stratify(b);
            }
        }
        return b;
    }

    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String url) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (url == null) {
                url = "";
            }
            if (url.equals(this.url)) {
                return;
            }
            old = this.url;
            this.url = url;
        }
        this.firePropertyChange(PROP_URL, old, url);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineNumber(int ln) {
        int old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (ln == this.lineNumber) {
                return;
            }
            old = this.lineNumber;
            this.lineNumber = ln;
        }
        this.firePropertyChange(PROP_LINE_NUMBER, old, ln);
    }

    public ObjectVariable[] getInstanceFilters(JPDADebugger session) {
        if (this.instanceFilters != null) {
            return this.instanceFilters.get(session);
        }
        return null;
    }

    public void setInstanceFilters(JPDADebugger session, ObjectVariable[] instances) {
        Object[] objectArray;
        if (this.instanceFilters == null) {
            this.instanceFilters = new WeakHashMap<JPDADebugger, ObjectVariable[]>();
        }
        if (instances != null) {
            this.instanceFilters.put(session, instances);
        } else {
            this.instanceFilters.remove(session);
        }
        if (instances != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = session;
            objectArray = objectArray2;
            objectArray2[1] = instances;
        } else {
            objectArray = null;
        }
        this.firePropertyChange(PROP_INSTANCE_FILTERS, null, objectArray);
    }

    public JPDAThread[] getThreadFilters(JPDADebugger session) {
        if (this.threadFilters != null) {
            return this.threadFilters.get(session);
        }
        return null;
    }

    public void setThreadFilters(JPDADebugger session, JPDAThread[] threads) {
        Object[] objectArray;
        if (this.threadFilters == null) {
            this.threadFilters = new WeakHashMap<JPDADebugger, JPDAThread[]>();
        }
        if (threads != null) {
            this.threadFilters.put(session, threads);
        } else {
            this.threadFilters.remove(session);
        }
        if (threads != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = session;
            objectArray = objectArray2;
            objectArray2[1] = threads;
        } else {
            objectArray = null;
        }
        this.firePropertyChange(PROP_THREAD_FILTERS, null, objectArray);
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String c) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (c == null) {
                c = "";
            }
            if ((c = c.trim()).equals(this.condition)) {
                return;
            }
            old = this.condition;
            this.condition = c;
        }
        this.firePropertyChange(PROP_CONDITION, old, c);
    }

    public String getStratum() {
        return this.stratum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStratum(String s) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (s == null) {
                s = "";
            }
            if ((s = s.trim()).equals(this.stratum)) {
                return;
            }
            old = this.stratum;
            this.stratum = s;
        }
        this.firePropertyChange(PROP_CONDITION, old, s);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceName(String sn) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (sn != null) {
                if ((sn = sn.trim()).equals(this.sourceName)) {
                    return;
                }
            } else if (this.sourceName == null) {
                return;
            }
            old = this.sourceName;
            this.sourceName = sn;
        }
        this.firePropertyChange(PROP_SOURCE_NAME, old, sn);
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourcePath(String sp) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (sp != null) {
                if ((sp = sp.trim()).equals(this.sourcePath)) {
                    return;
                }
            } else if (this.sourcePath == null) {
                return;
            }
            old = this.sourcePath;
            this.sourcePath = sp;
        }
        this.firePropertyChange(PROP_SOURCE_PATH, old, sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferredClassName(String className) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (className == null ? this.className == null : className.equals(this.className)) {
                return;
            }
            old = className;
            this.className = className;
        }
        this.firePropertyChange(PROP_PREFERRED_CLASS_NAME, old, className);
    }

    public String getPreferredClassName() {
        return this.className;
    }

    public String toString() {
        String fileName = null;
        try {
            FileObject fo = URLMapper.findFileObject((URL)new URL(this.url));
            if (fo != null) {
                fileName = fo.getNameExt();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (fileName == null) {
            fileName = this.url;
        }
        return "LineBreakpoint " + fileName + " : " + this.lineNumber;
    }

    private static class LineBreakpointImpl
    extends LineBreakpoint
    implements Comparable,
    FileChangeListener,
    ChangeListener,
    PropertyChangeListener {
        public static final String PROP_PREFERRED_CLASS_TYPE = "classTypePreferred";
        private FileObject fo;
        private ChangeListener registryListener;
        private FileChangeListener fileListener;
        private JPDAClassType classType;
        private boolean wasRegisteredWhenFileDeleted;

        public LineBreakpointImpl(String url) {
            super(url);
            if (url.length() > 0) {
                try {
                    this.fo = URLMapper.findFileObject((URL)new URL(url));
                    if (this.fo != null) {
                        this.fileListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)this.fo);
                        this.fo.addFileChangeListener(this.fileListener);
                    }
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.WARNING, "URL = '" + url + "'", ex);
                }
                catch (IllegalArgumentException ex) {
                    LOG.log(Level.WARNING, "URL = '" + url + "'", ex);
                }
            }
        }

        @Override
        public void setURL(String url) {
            if (this.fo != null) {
                this.fo.removeFileChangeListener(this.fileListener);
            }
            super.setURL(url);
            if (url.length() > 0) {
                try {
                    this.fo = URLMapper.findFileObject((URL)new URL(url));
                    if (this.fo != null) {
                        this.fileListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)this.fo);
                        this.fo.addFileChangeListener(this.fileListener);
                    }
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.WARNING, "URL = '" + url + "'", ex);
                }
                catch (IllegalArgumentException ex) {
                    LOG.log(Level.WARNING, "URL = '" + url + "'", ex);
                }
            }
            this.firePropertyChange("groupProperties", null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPreferredClassType(JPDAClassType classType) {
            JPDAClassType old;
            LineBreakpointImpl lineBreakpointImpl = this;
            synchronized (lineBreakpointImpl) {
                if (classType == null ? this.classType == null : classType.equals(this.classType)) {
                    return;
                }
                old = classType;
                this.classType = classType;
            }
            this.firePropertyChange(PROP_PREFERRED_CLASS_TYPE, old, classType);
        }

        public JPDAClassType getPreferredClassType() {
            return this.classType;
        }

        public Breakpoint.GroupProperties getGroupProperties() {
            return new LineGroupProperties();
        }

        public int compareTo(Object o) {
            if (o instanceof LineBreakpointImpl) {
                LineBreakpointImpl lbthis = this;
                LineBreakpoint lb = (LineBreakpoint)((Object)o);
                int uc = lbthis.url.compareTo(lb.url);
                if (uc != 0) {
                    return uc;
                }
                return lbthis.lineNumber - lb.lineNumber;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            Breakpoint[] breakpoints;
            for (Breakpoint b : breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints()) {
                if (b != this) continue;
                this.wasRegisteredWhenFileDeleted = true;
                DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this);
                break;
            }
            this.fo = null;
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.setURL(((FileObject)fe.getSource()).toURL().toString());
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        @Override
        public void stateChanged(ChangeEvent chev) {
            Object source = chev.getSource();
            if (!(source instanceof Breakpoint.VALIDITY)) {
                throw new UnsupportedOperationException(chev.toString());
            }
            this.setValidity((Breakpoint.VALIDITY)source, chev.toString());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (DebuggerEngine.class.getName().equals(evt.getPropertyName())) {
                this.enginePropertyChange(evt);
            }
        }

        private final class LineGroupProperties
        extends Breakpoint.GroupProperties {
            private LineGroupProperties() {
            }

            public String getType() {
                return NbBundle.getMessage(LineBreakpoint.class, (String)"LineBrkp_Type");
            }

            public String getLanguage() {
                return "Java";
            }

            public FileObject[] getFiles() {
                return new FileObject[]{LineBreakpointImpl.this.fo};
            }

            public Project[] getProjects() {
                FileObject f = LineBreakpointImpl.this.fo;
                while (!(f == null || (f = f.getParent()) != null && ProjectManager.getDefault().isProject(f))) {
                }
                if (f != null) {
                    try {
                        return new Project[]{ProjectManager.getDefault().findProject(f)};
                    }
                    catch (IOException iOException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return null;
            }

            public DebuggerEngine[] getEngines() {
                return LineBreakpointImpl.this.getEngines();
            }

            public boolean isHidden() {
                return LineBreakpointImpl.this.isHidden();
            }
        }
    }
}

