/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.ui;

import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.inspect.webkit.actions.GoToRuleSourceAction;
import org.netbeans.modules.web.inspect.webkit.ui.Bundle;
import org.netbeans.modules.web.inspect.webkit.ui.RuleInfo;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class MatchedRuleNode
extends AbstractNode {
    public static final String PROPERTY_NODE = "node";
    private Node.PropertySet[] propertySets;
    Node node;
    private Action preferredAction;

    MatchedRuleNode(Node node, Rule rule, Resource ruleOrigin, RuleInfo ruleInfo) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{rule, ruleOrigin, ruleInfo}));
        String stylesheet;
        this.node = node;
        String sourceURL = ruleInfo.getMetaSourceFile();
        if (sourceURL != null && ruleInfo.getMetaSourceLine() != -1) {
            if (sourceURL.startsWith("file://") && !sourceURL.startsWith("file:///")) {
                sourceURL = "file:/" + sourceURL.substring(5);
            }
        } else {
            sourceURL = rule.getSourceURL();
        }
        if ((stylesheet = Utilities.relativeResourceName(sourceURL, ruleOrigin.getProject())) != null) {
            if (stylesheet.isEmpty()) {
                stylesheet = Bundle.CSSStylesSelectionPanel_generatedStylesheet();
            }
            String description = NbBundle.getMessage(MatchedRuleNode.class, (String)"MatchedRuleNode.description", (Object)stylesheet);
            this.setShortDescription(description);
        }
    }

    public String getHtmlDisplayName() {
        return this.node.getHtmlDisplayName();
    }

    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    public synchronized Node.PropertySet[] getPropertySets() {
        if (this.propertySets == null) {
            this.propertySets = this.createPropertySets();
        }
        return this.propertySets;
    }

    private Node.PropertySet[] createPropertySets() {
        String displayName = NbBundle.getMessage(MatchedRuleNode.class, (String)"MatchedRuleNode.properties");
        Node.PropertySet set = new Node.PropertySet("properties", displayName, null){
            private final Node.Property<?> nodeProperty;
            {
                this.nodeProperty = new PropertySupport.ReadOnly<String>(MatchedRuleNode.PROPERTY_NODE, String.class, null, null){

                    public String getValue() throws IllegalAccessException, InvocationTargetException {
                        return MatchedRuleNode.this.node.getHtmlDisplayName();
                    }
                };
            }

            public Node.Property<?>[] getProperties() {
                return new Node.Property[]{this.nodeProperty};
            }
        };
        return new Node.PropertySet[]{set};
    }

    public Action[] getActions(boolean context) {
        return new Action[]{this.getPreferredAction()};
    }

    public synchronized Action getPreferredAction() {
        if (this.preferredAction == null) {
            this.preferredAction = new GoToRuleSourceAction((Node)this);
        }
        return this.preferredAction;
    }
}

