/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.mac;

import com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.keyring.impl.KeyringSupport;
import org.netbeans.modules.keyring.mac.SecurityLibrary;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openide.util.Utilities;

public class MacProvider
implements KeyringProvider {
    private static final Logger LOG = Logger.getLogger(MacProvider.class.getName());
    private final byte[] appName = KeyringSupport.getAppNameMac().getBytes(StandardCharsets.UTF_8);

    public boolean enabled() {
        if (Boolean.getBoolean("netbeans.keyring.no.native")) {
            LOG.fine("native keyring integration disabled");
            return false;
        }
        return Utilities.isMac();
    }

    public char[] read(String key) {
        byte[] serviceName = key.getBytes(StandardCharsets.UTF_8);
        byte[] accountName = this.appName;
        int[] dataLength = new int[1];
        Pointer[] data = new Pointer[1];
        MacProvider.error("find", SecurityLibrary.LIBRARY.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, accountName.length, accountName, dataLength, data, null));
        if (data[0] == null) {
            return null;
        }
        byte[] value = data[0].getByteArray(0L, dataLength[0]);
        return new String(value, StandardCharsets.UTF_8).toCharArray();
    }

    public void save(String key, char[] password, String description) {
        byte[] serviceName = key.getBytes(StandardCharsets.UTF_8);
        byte[] accountName = this.appName;
        byte[] data = new String(password).getBytes(StandardCharsets.UTF_8);
        Pointer[] itemRef = new Pointer[1];
        MacProvider.error("find (for save)", SecurityLibrary.LIBRARY.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, accountName.length, accountName, null, null, itemRef));
        if (itemRef[0] != null) {
            MacProvider.error("save (update)", SecurityLibrary.LIBRARY.SecKeychainItemModifyContent(itemRef[0], null, data.length, data));
            SecurityLibrary.LIBRARY.CFRelease(itemRef[0]);
        } else {
            MacProvider.error("save (new)", SecurityLibrary.LIBRARY.SecKeychainAddGenericPassword(null, serviceName.length, serviceName, accountName.length, accountName, data.length, data, null));
        }
    }

    public void delete(String key) {
        byte[] serviceName = key.getBytes(StandardCharsets.UTF_8);
        byte[] accountName = this.appName;
        Pointer[] itemRef = new Pointer[1];
        MacProvider.error("find (for delete)", SecurityLibrary.LIBRARY.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, accountName.length, accountName, null, null, itemRef));
        if (itemRef[0] != null) {
            MacProvider.error("delete", SecurityLibrary.LIBRARY.SecKeychainItemDelete(itemRef[0]));
            SecurityLibrary.LIBRARY.CFRelease(itemRef[0]);
        }
    }

    private static void error(String msg, int code) {
        if (code != 0 && code != -25300) {
            Object str;
            Pointer translated = SecurityLibrary.LIBRARY.SecCopyErrorMessageString(code, null);
            if (translated == null) {
                str = String.valueOf(code);
            } else {
                char[] buf = new char[(int)SecurityLibrary.LIBRARY.CFStringGetLength(translated)];
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = SecurityLibrary.LIBRARY.CFStringGetCharacterAtIndex(translated, i);
                }
                SecurityLibrary.LIBRARY.CFRelease(translated);
                str = new String(buf) + " (" + code + ")";
            }
            LOG.log(Level.WARNING, "{0}: {1}", new Object[]{msg, str});
        }
    }
}

