/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seprofiles;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.java.j2seprofiles.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Union2;

class ProfilesCustomizer
extends JPanel
implements ActionListener {
    private final Analyzer.CustomizerContext<Void, ProfilesCustomizer> context;
    private JLabel jLabel1;
    private JComboBox profiles;

    ProfilesCustomizer(@NonNull Analyzer.CustomizerContext<Void, ProfilesCustomizer> context) {
        assert (context != null);
        this.context = context;
        this.initComponents();
        this.profiles.setRenderer(new ProfileKeyRenderer());
        this.initProfiles();
        this.profiles.addActionListener(this);
    }

    @Override
    public void actionPerformed(@NonNull ActionEvent event) {
        Object selection = this.profiles.getSelectedItem();
        ProfileKey key = selection instanceof ProfileKey ? (ProfileKey)selection : ProfileKey.forProject();
        SourceLevelQuery.Profile profile = key.getProfile();
        if (profile != null) {
            this.context.getSettings().put("profile-to-check", profile.getName());
        } else {
            this.context.getSettings().put("profile-to-check", "<tombstone>");
        }
    }

    private void initProfiles() {
        this.profiles.removeAllItems();
        this.profiles.addItem(ProfileKey.forProject());
        for (SourceLevelQuery.Profile profile : SourceLevelQuery.Profile.values()) {
            if (profile == SourceLevelQuery.Profile.DEFAULT) continue;
            this.profiles.addItem(ProfileKey.forProfile(profile));
        }
        String profileName = this.context.getSettings().get("profile-to-check", null);
        SourceLevelQuery.Profile profile = profileName == null ? null : SourceLevelQuery.Profile.forName((String)profileName);
        this.profiles.setSelectedItem(profile == null ? ProfileKey.forProject() : ProfileKey.forProfile(profile));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.profiles = new JComboBox();
        this.jLabel1.setLabelFor(this.profiles);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProfilesCustomizer.class, (String)"TXT_ProfilesCustomizer_profiles"));
        this.profiles.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.profiles, 0, 251, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.profiles, -2, -1, -2)).addContainerGap(34, Short.MAX_VALUE)));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProfilesCustomizer.class, (String)"AD_ProfilesCustomizer_profiles"));
    }

    private static final class ProfileKeyRenderer
    extends DefaultListCellRenderer {
        private ProfileKeyRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ProfileKey) {
                value = ((ProfileKey)value).getDisplayName();
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static final class ProfileKey {
        private final Union2<SourceLevelQuery.Profile, String> profile;

        private ProfileKey(@NonNull Union2<SourceLevelQuery.Profile, String> profile) {
            assert (profile != null);
            this.profile = profile;
        }

        public String toString() {
            return String.format("ProfileKey[%s]", this.profile.hasFirst() ? this.profile.first() : this.profile.second());
        }

        public int hashCode() {
            return this.profile.hashCode();
        }

        public boolean equals(@NonNull Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProfileKey)) {
                return false;
            }
            return this.profile.equals(((ProfileKey)other).profile);
        }

        @NonNull
        String getDisplayName() {
            return this.profile.hasFirst() ? ((SourceLevelQuery.Profile)this.profile.first()).getDisplayName() : (String)this.profile.second();
        }

        @CheckForNull
        SourceLevelQuery.Profile getProfile() {
            return this.profile.hasFirst() ? (SourceLevelQuery.Profile)this.profile.first() : null;
        }

        @NonNull
        static ProfileKey forProfile(@NonNull SourceLevelQuery.Profile profile) {
            assert (profile != null);
            return new ProfileKey((Union2<SourceLevelQuery.Profile, String>)Union2.createFirst((Object)profile));
        }

        @NonNull
        static ProfileKey forProject() {
            return new ProfileKey((Union2<SourceLevelQuery.Profile, String>)Union2.createSecond((Object)Bundle.MSG_ProfileFromProject()));
        }
    }
}

