/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateSettings;
import org.netbeans.modules.autoupdate.ui.actions.Installer;
import org.netbeans.modules.autoupdate.ui.actions.PluginManagerAction;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.wizards.LazyInstallUnitWizardIterator;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.WindowManager;

public class AutoupdateCheckScheduler {
    private static RequestProcessor.Task regularlyCheck = null;
    private static final RequestProcessor REGULARLY_CHECK_TIMER = new RequestProcessor("auto-checker-reqularly-timer", 1, true);
    private static final Logger err = Logger.getLogger(AutoupdateCheckScheduler.class.getName());
    private static Notification updatesNotification = null;
    private static Runnable doCheckAvailableUpdates = new Runnable(){

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                Installer.RP.post(doCheckAvailableUpdates);
                return;
            }
            boolean hasUpdates = false;
            if (Utilities.shouldCheckAvailableUpdates()) {
                HashSet<UpdateElement> updates = new HashSet<UpdateElement>();
                AutoupdateCheckScheduler.checkUpdateElements(OperationWizardModel.OperationType.UPDATE, null, false, updates);
                hasUpdates = updates != null && !updates.isEmpty();
                LazyInstallUnitWizardIterator.LazyUnit.storeUpdateElements(OperationWizardModel.OperationType.UPDATE, updates);
                Utilities.storeAcceptedLicenseIDs();
            }
            if (!hasUpdates && Utilities.shouldCheckAvailableNewPlugins()) {
                LazyInstallUnitWizardIterator.LazyUnit.storeUpdateElements(OperationWizardModel.OperationType.INSTALL, AutoupdateCheckScheduler.checkUpdateElements(OperationWizardModel.OperationType.INSTALL, null, false, null));
            }
            Installer.RP.post(doCheckLazyUpdates, 500);
        }
    };
    private static Runnable doCheck = new Runnable(){

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                Installer.RP.post(doCheck);
                return;
            }
            if (AutoupdateCheckScheduler.timeToCheck()) {
                AutoupdateCheckScheduler.scheduleRefreshProviders();
                if (AutoupdateCheckScheduler.getWaitPeriod() > 0 && regularlyCheck != null && regularlyCheck.getDelay() <= 0) {
                    regularlyCheck = REGULARLY_CHECK_TIMER.post(doCheck, AutoupdateCheckScheduler.getWaitPeriod(), 1);
                }
            }
        }
    };
    private static Runnable doCheckLazyUpdates = new Runnable(){

        @Override
        public void run() {
            boolean hasUpdates;
            if (SwingUtilities.isEventDispatchThread()) {
                Installer.RP.post(doCheckLazyUpdates);
                return;
            }
            Collection<LazyInstallUnitWizardIterator.LazyUnit> updates = LazyInstallUnitWizardIterator.LazyUnit.loadLazyUnits(OperationWizardModel.OperationType.UPDATE);
            boolean bl = hasUpdates = updates != null && !updates.isEmpty();
            if (Utilities.shouldCheckAvailableUpdates()) {
                AutoupdateCheckScheduler.notifyAvailable(updates, OperationWizardModel.OperationType.UPDATE);
            }
            if (!hasUpdates && Utilities.shouldCheckAvailableNewPlugins()) {
                Collection<LazyInstallUnitWizardIterator.LazyUnit> newUnits = LazyInstallUnitWizardIterator.LazyUnit.loadLazyUnits(OperationWizardModel.OperationType.INSTALL);
                AutoupdateCheckScheduler.notifyAvailable(newUnits, OperationWizardModel.OperationType.INSTALL);
            }
            for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
                Utilities.showProviderNotification(p);
            }
        }
    };

    private AutoupdateCheckScheduler() {
    }

    public static void signOn() {
        NotificationDisplayer.getDefault();
        AutoupdateSettings.generateIdentity();
        if (AutoupdateCheckScheduler.timeToCheck()) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    Installer.RP.post(doCheck, 5000);
                }
            });
        } else {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    Installer.RP.post(doCheckLazyUpdates, 11000);
                }
            });
        }
    }

    private static void scheduleRefreshProviders() {
        AutoupdateCheckScheduler.refreshUpdateCenters(null);
        int delay = 500;
        final long startTime = System.currentTimeMillis();
        RequestProcessor.Task t = Installer.RP.post(doCheckAvailableUpdates, 500);
        t.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                task.removeTaskListener((TaskListener)this);
                long time = (System.currentTimeMillis() - startTime - 500L) / 1000L;
                if (time > 0L) {
                    Utilities.putTimeOfInitialization(time);
                }
            }
        });
    }

    private static Runnable getRefresher(final UpdateUnitProvider p, final Collection<String> problems, final ProgressHandle progress) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    err.log(Level.FINE, "Start refresh " + p.getName() + "[" + p.getDisplayName() + "]");
                    p.refresh(progress, true);
                    PluginManagerUI pluginManagerUI = PluginManagerAction.getPluginManagerUI();
                    if (pluginManagerUI != null && pluginManagerUI.initTask.isFinished()) {
                        pluginManagerUI.updateUnitsChanged();
                    }
                    Utilities.showProviderNotification(p);
                }
                catch (IOException ioe) {
                    if (!(ioe instanceof UnknownHostException) && !(ioe.getCause() instanceof UnknownHostException)) {
                        err.log(Level.INFO, null, ioe);
                    }
                    if (problems != null) {
                        problems.add(ioe.getLocalizedMessage());
                    }
                }
                finally {
                    err.log(Level.FINEST, "Refresh of " + p.getName() + "[" + p.getDisplayName() + "] is finish.");
                }
            }
        };
    }

    public static void runCheckAvailableUpdates(int delay) {
        Installer.RP.post(doCheckAvailableUpdates, delay);
    }

    public static Collection<UpdateElement> checkUpdateElements(OperationWizardModel.OperationType type, Collection<String> problems, boolean forceReload, Collection<UpdateElement> visibleUpdateElement) {
        List<UnitCategory> cats;
        err.log(Level.FINEST, "Check UpdateElements for " + type);
        if (forceReload) {
            ProgressHandle dummyHandler = ProgressHandle.createHandle((String)"dummy-check-for-updates");
            ProgressHandleFactory.createProgressComponent((ProgressHandle)dummyHandler);
            dummyHandler.start();
            Collection<String> updateProblems = AutoupdateCheckScheduler.refreshUpdateCenters(dummyHandler);
            if (problems != null && updateProblems != null) {
                problems.addAll(updateProblems);
            }
        }
        List units = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        boolean handleUpdates = OperationWizardModel.OperationType.UPDATE == type;
        List<UnitCategory> list = cats = handleUpdates ? Utilities.makeUpdateCategories(units, false) : Utilities.makeAvailableCategories(units, false);
        if (cats == null || cats.isEmpty()) {
            err.log(Level.FINE, "findUpdateElements(" + type + ") doesn't find any elements.");
            return null;
        }
        Set<Object> updates = new HashSet<UpdateElement>();
        boolean somePendingElements = false;
        boolean someBrokenDependencies = false;
        OperationContainer container = handleUpdates ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
        ArrayList<UpdateElement> elements = new ArrayList<UpdateElement>();
        for (UnitCategory cat : cats) {
            for (Unit u : cat.getUnits()) {
                if (u instanceof Unit.Available) {
                    elements.add(((Unit.Available)u).getRelevantElement());
                    continue;
                }
                if (u instanceof Unit.CompoundUpdate) {
                    for (UpdateUnit updateUnit : ((Unit.CompoundUpdate)u).getUpdateUnits()) {
                        elements.add((UpdateElement)updateUnit.getAvailableUpdates().get(0));
                    }
                    if (((Unit.CompoundUpdate)u).getRealUpdate() == null) continue;
                    elements.add(((Unit.CompoundUpdate)u).getRealUpdate());
                    continue;
                }
                if (!(u instanceof Unit.Update)) continue;
                elements.add(((Unit.Update)u).getRelevantElement());
            }
        }
        for (UpdateElement element : elements) {
            if (somePendingElements || !container.canBeAdded(element.getUpdateUnit(), element)) continue;
            OperationContainer.OperationInfo operationInfo = container.add(element);
            if (operationInfo == null) {
                updates.add(element);
                continue;
            }
            HashSet reqs = new HashSet(operationInfo.getRequiredElements());
            Set brokenDeps = operationInfo.getBrokenDependencies();
            if (!brokenDeps.isEmpty()) {
                err.log(Level.WARNING, "Plugin " + operationInfo + " cannot be installed because some dependencies cannot be satisfied: " + brokenDeps);
                someBrokenDependencies = true;
                break;
            }
            for (UpdateElement tmpEl : reqs) {
                if (!tmpEl.getUpdateUnit().isPending()) continue;
                err.log(Level.WARNING, "Plugin " + operationInfo.getUpdateElement() + " depends on " + tmpEl + " in pending state.");
                somePendingElements = true;
                updates = Collections.emptySet();
                break;
            }
            if (somePendingElements) continue;
            container.add(reqs);
            updates.add(element);
        }
        if (!somePendingElements && !container.listInvalid().isEmpty()) {
            err.log(Level.WARNING, "Plugins " + updates + " cannot be installed, Install Container contains invalid elements " + container.listInvalid());
        }
        if (!somePendingElements && someBrokenDependencies) {
            updates = new HashSet();
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                UpdateUnit unit;
                UpdateElement element;
                OperationContainer oc = handleUpdates ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
                if (!oc.canBeAdded(unit = (element = (UpdateElement)iterator.next()).getUpdateUnit(), element)) continue;
                OperationContainer.OperationInfo operationInfo = oc.add(element);
                if (operationInfo == null) {
                    updates.add(element);
                    continue;
                }
                boolean bl = false;
                HashSet reqs = new HashSet(operationInfo.getRequiredElements());
                for (UpdateElement tmpEl : reqs) {
                    if (!tmpEl.getUpdateUnit().isPending()) continue;
                    err.log(Level.WARNING, "Plugin " + element + " depends on " + tmpEl + " in pending state.");
                    bl = true;
                }
                if (bl) continue;
                oc.add(reqs);
                HashSet brokenDeps = new HashSet();
                for (OperationContainer.OperationInfo info : oc.listAll()) {
                    brokenDeps.addAll(info.getBrokenDependencies());
                }
                if (brokenDeps.isEmpty() && oc.listInvalid().isEmpty()) {
                    updates.add(element);
                    continue;
                }
                oc.removeAll();
                if (!brokenDeps.isEmpty()) {
                    err.log(Level.WARNING, "Plugin " + element + " cannot be installed because some dependencies cannot be satisfied: " + brokenDeps);
                    continue;
                }
                err.log(Level.WARNING, "Plugin " + element + " cannot be installed, Install Container contains invalid elements " + oc.listInvalid());
            }
        }
        if (visibleUpdateElement == null) {
            err.log(Level.FINE, "findUpdateElements(" + type + ") returns " + updates.size() + " elements.");
            return updates;
        }
        for (UnitCategory cat : cats) {
            for (Unit u : cat.getUnits()) {
                assert (u instanceof Unit.Update) : u + " has to be instanceof Unit.Update";
                if (!(u instanceof Unit.Update)) continue;
                visibleUpdateElement.add(((Unit.Update)u).getRelevantElement());
            }
        }
        err.log(Level.FINE, "findUpdateElements(" + type + ") returns " + visibleUpdateElement.size() + " visible elements (" + updates.size() + " in all)");
        return updates;
    }

    private static Collection<String> refreshUpdateCenters(ProgressHandle progress) {
        long startTime = System.currentTimeMillis();
        HashSet<String> problems = new HashSet<String>();
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run refreshProviders in EQ!";
        HashSet<RequestProcessor.Task> refreshTasks = new HashSet<RequestProcessor.Task>();
        List providers = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true);
        RequestProcessor rp = new RequestProcessor("autoupdate-refresh-providers", providers.size(), false);
        for (UpdateUnitProvider p : providers) {
            RequestProcessor.Task t = rp.post(AutoupdateCheckScheduler.getRefresher(p, problems, progress));
            refreshTasks.add(t);
        }
        err.log(Level.FINEST, "Waiting for all refreshTasks...");
        for (RequestProcessor.Task t : refreshTasks) {
            t.waitFinished();
        }
        err.log(Level.FINEST, "Waiting for all refreshTasks is done.");
        long time = (System.currentTimeMillis() - startTime) / 1000L;
        if (time > 0L) {
            Utilities.putTimeOfRefreshUpdateCenters(time);
        }
        return problems;
    }

    private static boolean timeToCheck() {
        if (AutoupdateCheckScheduler.getReqularlyTimerTask() != null && AutoupdateCheckScheduler.getReqularlyTimerTask().getDelay() <= 0 && AutoupdateCheckScheduler.getWaitPeriod() > 0) {
            return true;
        }
        if (AutoupdateSettings.getLastCheck() == null) {
            return true;
        }
        switch (AutoupdateSettings.getPeriod()) {
            case 0: {
                return true;
            }
            case 5: {
                return false;
            }
            case 6: {
                return AutoupdateSettings.getLastCheck().getTime() + (long)AutoupdateSettings.getCheckInterval() < new Date().getTime();
            }
        }
        Date lastCheck = AutoupdateSettings.getLastCheck();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(lastCheck);
        calendar.set(10, 0);
        calendar.set(9, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (AutoupdateSettings.getPeriod()) {
            case 1: {
                calendar.add(5, 1);
                break;
            }
            case 2: {
                calendar.add(3, 1);
                break;
            }
            case 3: {
                calendar.add(3, 2);
                break;
            }
            case 4: {
                calendar.add(2, 1);
            }
        }
        return calendar.getTime().before(new Date());
    }

    private static RequestProcessor.Task getReqularlyTimerTask() {
        if (regularlyCheck == null && AutoupdateCheckScheduler.getWaitPeriod() > 0) {
            int waitPeriod;
            int restTime = waitPeriod = AutoupdateCheckScheduler.getWaitPeriod();
            if (AutoupdateSettings.getLastCheck() != null) {
                restTime = waitPeriod - (int)(System.currentTimeMillis() - AutoupdateSettings.getLastCheck().getTime());
            }
            if (restTime <= 0) {
                restTime = waitPeriod;
            }
            regularlyCheck = REGULARLY_CHECK_TIMER.post(doCheck, restTime, 1);
        }
        return regularlyCheck;
    }

    private static int getWaitPeriod() {
        switch (AutoupdateSettings.getPeriod()) {
            case 5: {
                return 0;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 86400000;
            }
            case 2: {
                return 604800000;
            }
            case 3: {
                return 1209600000;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
            case 6: {
                return AutoupdateSettings.getCheckInterval();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyAvailable(final Collection<LazyInstallUnitWizardIterator.LazyUnit> units, final OperationWizardModel.OperationType type) {
        if (units == null || units.isEmpty()) {
            if (updatesNotification != null) {
                updatesNotification.clear();
                updatesNotification = null;
            }
            return;
        }
        ActionListener onMouseClickAction = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent ae) {
                boolean wizardFinished = false;
                RequestProcessor.Task t = PluginManagerUI.getRunningTask();
                if (t != null && !t.isFinished()) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_InstallInProgress"), 2));
                    return;
                }
                try {
                    wizardFinished = new InstallUnitWizard().invokeLazyWizard(units, type, false);
                }
                finally {
                    if (wizardFinished) {
                        PluginManagerUI pluginManagerUI = PluginManagerAction.getPluginManagerUI();
                        if (pluginManagerUI != null) {
                            pluginManagerUI.updateUnitsChanged();
                        }
                        Installer.RP.post(doCheckAvailableUpdates);
                    }
                }
            }
        };
        int updateCount = units.size();
        String title = updateCount == 1 ? NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_UpdateFound_ToolTip", (Object)updateCount) : NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_UpdatesFound_ToolTip", (Object)updateCount);
        Class<AutoupdateCheckScheduler> clazz = AutoupdateCheckScheduler.class;
        synchronized (AutoupdateCheckScheduler.class) {
            if (updatesNotification != null) {
                updatesNotification.clear();
                updatesNotification = null;
            }
            updatesNotification = NotificationDisplayer.getDefault().notify(title, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/newUpdates.png", (boolean)false), NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_UpdateFound_Hint"), onMouseClickAction, NotificationDisplayer.Priority.HIGH);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static void notifyAvailableUpdates(Collection<UpdateElement> updates) {
        assert (updates != null && !updates.isEmpty()) : "Some updates found.";
        LazyInstallUnitWizardIterator.LazyUnit.storeUpdateElements(OperationWizardModel.OperationType.UPDATE, updates);
        AutoupdateCheckScheduler.notifyAvailable(LazyInstallUnitWizardIterator.LazyUnit.loadLazyUnits(OperationWizardModel.OperationType.UPDATE), OperationWizardModel.OperationType.UPDATE);
    }
}

