/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.BorderLayout;
import java.awt.Image;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.vmd.VMDConnectionWidget;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.vmd.VMDPinWidget;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.editor.JSFConfigEditorContext;
import org.netbeans.modules.web.jsf.navigation.Bundle;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.PageFlowElement;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneData;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.netbeans.modules.web.jsf.navigation.graph.SceneSerializer;
import org.netbeans.modules.web.jsf.navigation.graph.layout.LayoutUtility;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class PageFlowView
extends TopComponent
implements Lookup.Provider {
    private static final RequestProcessor RP = new RequestProcessor(PageFlowView.class.getSimpleName(), 3);
    private volatile PageFlowController pfc;
    private JSFConfigEditorContext context;
    private PageFlowScene scene;
    private PageFlowSceneData sceneData;
    private static final Logger LOG = Logger.getLogger("org.netbeans.web.jsf.navigation");
    private static final String ACN_PAGEVIEW_TC = NbBundle.getMessage(PageFlowView.class, (String)"ACN_PageView_TC");
    private static final String ACDS_PAGEVIEW_TC = NbBundle.getMessage(PageFlowView.class, (String)"ACDS_PageView_TC");
    private Future initTask;
    private WeakReference<Lookup> lookupWRef = new WeakReference<Object>(null);
    public int sceneAssgn = 0;
    private static RequestProcessor requestProcessor = new RequestProcessor();
    private static final String PATH_TOOLBAR_FOLDER = "PageFlowEditor/Toolbars";
    private static final String PATH_PALETTE_FOLDER = "PageFlowEditor/Palette";
    LayoutUtility.LayoutType lastUsedLayout = LayoutUtility.LayoutType.GRID_GRAPH;
    private WeakReference<PageFlowElement> multiviewRef;

    PageFlowView(PageFlowElement multiview, JSFConfigEditorContext context) {
        this.setMultiview(multiview);
        this.context = context;
        this.initializeScene();
        this.processScene();
    }

    public void requestMultiViewActive() {
        this.getMultiview().getMultiViewCallback().requestActive();
        this.requestFocus();
    }

    public synchronized PageFlowController getPageFlowController() {
        return this.pfc;
    }

    public Lookup getLookup() {
        Lookup lookup = (Lookup)this.lookupWRef.get();
        DataObject jsfConfigDataObject = null;
        if (lookup == null) {
            Lookup superLookup = super.getLookup();
            try {
                jsfConfigDataObject = DataObject.find((FileObject)this.context.getFacesConfigFile());
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            lookup = jsfConfigDataObject != null ? new ProxyLookup(new Lookup[]{superLookup, Lookups.fixed((Object[])new Object[]{this.getScene(), jsfConfigDataObject})}) : new ProxyLookup(new Lookup[]{superLookup, Lookups.fixed((Object[])new Object[]{this.getScene()})});
            this.lookupWRef = new WeakReference<Lookup>(lookup);
        }
        return lookup;
    }

    public synchronized void unregstierListeners() {
        if (this.pfc != null) {
            this.pfc.unregisterListeners();
        }
    }

    public synchronized void registerListeners() {
        if (this.pfc != null) {
            this.pfc.registerListeners();
        }
    }

    private synchronized PageFlowScene initializeScene() {
        if (this.getScene() == null) {
            this.setLayout(new BorderLayout());
            this.setScene(new PageFlowScene(this));
            this.getScene().setAccessibleContext(this.getAccessibleContext());
            JScrollPane pane = new JScrollPane(this.getScene().createView());
            pane.setVisible(true);
            this.add(pane, "Center");
            this.setDefaultActivatedNode();
        }
        return this.getScene();
    }

    public synchronized void destroyScene() {
        this.clearGraph();
        this.getScene().destoryPageFlowScene();
        this.setScene(null);
        this.sceneData = null;
        this.context = null;
        this.pfc.destroy();
        this.pfc = null;
    }

    public void setDefaultActivatedNode() {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    PageFlowView.this.setDefaultActivatedNode();
                }
            });
            return;
        }
        if (this.context == null) {
            return;
        }
        FileObject facesConfigFO = this.context.getFacesConfigFile();
        if (!facesConfigFO.isValid()) {
            this.setActivatedNode(null, null);
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)facesConfigFO);
            FileObject srcFolder = PageFlowView.findSourceFolder(dataObject);
            DataObject srcDataObject = null;
            try {
                srcDataObject = DataObject.find((FileObject)srcFolder);
            }
            catch (DataObjectNotFoundException ex) {
                LOG.fine("WARNING: Unable to find the following DataObject: " + srcFolder);
            }
            this.setActivatedNode(dataObject, srcDataObject);
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
            LOG.fine("WARNING: Unable to find the following DataObject: " + facesConfigFO);
            this.setActivatedNode(null, null);
        }
    }

    public PageFlowScene getScene() {
        return this.scene;
    }

    public void setScene(PageFlowScene scene) {
        ++this.sceneAssgn;
        this.scene = scene;
    }

    private synchronized void processScene() {
        final ProgressHandle progressHandle = ProgressHandle.createHandle((String)Bundle.PageFlowView_lbl_graph_initialization());
        progressHandle.start();
        this.initTask = RP.submit(new Runnable(){

            @Override
            public void run() {
                PageFlowView.this.pfc = new PageFlowController(PageFlowView.this.context, PageFlowView.this);
                PageFlowView.this.sceneData = new PageFlowSceneData(PageFlowToolbarUtilities.getInstance(PageFlowView.this));
                PageFlowView.this.deserializeNodeLocation(PageFlowView.getStorageFile(PageFlowView.this.context.getFacesConfigFile()));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PageFlowView.this.pfc.setupGraphNoSaveData();
                        LOG.fine("Initializing Page Flow SetupGraph");
                        PageFlowView.this.setFocusable(true);
                        LOG.finest("Create Executor Thread");
                        PageFlowView.this.getAccessibleContext().setAccessibleDescription(ACDS_PAGEVIEW_TC);
                        PageFlowView.this.getAccessibleContext().setAccessibleName(ACN_PAGEVIEW_TC);
                        PageFlowView.this.pfc.registerListeners();
                        assert (PageFlowView.this.pfc.isListenerRegistered());
                        progressHandle.finish();
                    }
                });
            }
        });
    }

    private void setActivatedNode(final DataObject dataObject, final DataObject srcFolder) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PageFlowView.this.setActivatedNode(dataObject, srcFolder);
                }
            });
            return;
        }
        if (dataObject == null) {
            this.setActivatedNodes(new Node[0]);
            return;
        }
        DefaultDataNode node = new DefaultDataNode(dataObject, srcFolder != null ? srcFolder.getNodeDelegate() : null);
        this.setActivatedNodes(new Node[]{node});
    }

    private static FileObject findSourceFolder(DataObject dataObject) {
        assert (!SwingUtilities.isEventDispatchThread());
        Project p = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
        if (p != null) {
            Sources sources = ProjectUtils.getSources((Project)p);
            SourceGroup[] groups = sources.getSourceGroups("generic");
            FileObject srcFolder = groups != null && groups.length > 0 ? groups[0].getRootFolder() : dataObject.getFolder().getPrimaryFile();
            return srcFolder;
        }
        return null;
    }

    public void warnUserMalFormedFacesConfig() {
        this.getScene().createMalFormedWidget();
    }

    public void removeUserMalFormedFacesConfig() {
        this.getScene().removeMalFormedWidget();
    }

    public void clearGraph() {
        long time = System.currentTimeMillis();
        HashSet pages = new HashSet(this.getScene().getNodes());
        for (Page page : pages) {
            this.getScene().removeNodeWithEdges(page);
            PageFlowView.destroyPage(page);
        }
        this.getScene().validate();
        LOG.log(Level.FINE, "clearGraph() took: " + (System.currentTimeMillis() - time) + " ms");
    }

    private static void destroyPage(final Page page) {
        requestProcessor.post(new Runnable(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                page.destroy2();
                LOG.log(Level.FINE, "Destroy page took: " + (System.currentTimeMillis() - time) + " ms");
            }
        });
    }

    public void validateGraph() {
        this.getScene().validate();
    }

    public void saveLocations() {
        this.sceneData.saveCurrentSceneData(this.getScene());
    }

    public void saveLocation(String oldDisplayName, String newDisplayName) {
        this.sceneData.savePageWithNewName(oldDisplayName, newDisplayName);
    }

    protected VMDNodeWidget createNode(Page pageNode, String type, List<Image> glyphs) {
        String pageName = pageNode.getDisplayName();
        VMDNodeWidget widget = (VMDNodeWidget)this.getScene().addNode(pageNode);
        widget.setNodeProperties(pageNode.getIcon(1), pageName, type, glyphs);
        PageFlowSceneData.PageData data = this.sceneData.getPageData(pageName);
        if (data != null) {
            widget.setPreferredLocation(data.getPoint());
            widget.setMinimized(data.isMinimized());
        }
        this.getScene().addPin(pageNode, new Pin(pageNode));
        this.selectPageFlowSceneElement(pageNode);
        return widget;
    }

    private void selectPageFlowSceneElement(PageFlowSceneElement element) {
        HashSet<PageFlowSceneElement> selectedSet = new HashSet<PageFlowSceneElement>(1);
        selectedSet.add(element);
        this.getScene().setSelectedObjects(selectedSet);
    }

    private void setupPinsInNode(Page pageNode) {
        Collection<Pin> pinNodes = pageNode.getPinNodes();
        for (Pin pinNode : pinNodes) {
            this.createPin(pageNode, pinNode);
        }
    }

    protected final VMDPinWidget createPin(Page pageNode, Pin pinNode) {
        VMDPinWidget widget = null;
        if (pageNode != null && this.getScene().isNode(pageNode)) {
            widget = (VMDPinWidget)this.getScene().addPin(pageNode, pinNode);
        }
        return widget;
    }

    protected void createEdge(NavigationCaseEdge navCaseEdge, Page fromPageNode, Page toPageNode) {
        assert (fromPageNode.getDisplayName() != null);
        assert (toPageNode.getDisplayName() != null);
        VMDConnectionWidget connectionWidget = (VMDConnectionWidget)this.getScene().addEdge(navCaseEdge);
        this.setEdgeSourcePin(navCaseEdge, fromPageNode);
        this.setEdgeTargePin(navCaseEdge, toPageNode);
        this.selectPageFlowSceneElement(navCaseEdge);
    }

    public void renameEdgeWidget(NavigationCaseEdge edge, String newName, String oldName) {
        this.getScene().renameEdgeWidget(edge, newName, oldName);
    }

    public Pin getEdgeSourcePin(NavigationCaseEdge navCase) {
        return (Pin)this.getScene().getEdgeSource(navCase);
    }

    public void setEdgeSourcePin(NavigationCaseEdge navCaseNode, Page fromPageNode) {
        Pin sourcePin = this.getScene().getDefaultPin(fromPageNode);
        Collection pinNodes = this.getScene().getPins();
        for (Pin pin : pinNodes) {
            if (pin.getFromOutcome() == null || fromPageNode != pin.getPage() || !pin.getFromOutcome().equals(navCaseNode.getFromOuctome())) continue;
            sourcePin = pin;
            Collection oldNavCaseNodes = this.getScene().findPinEdges(sourcePin, true, false);
            for (NavigationCaseEdge oldNavCaseNode : oldNavCaseNodes) {
                this.getScene().setEdgeSource(oldNavCaseNode, this.getScene().getDefaultPin(fromPageNode));
            }
        }
        this.getScene().setEdgeSource(navCaseNode, sourcePin);
    }

    private void setEdgeTargePin(NavigationCaseEdge navCaseNode, Page toPageNode) {
        Pin targetPin = this.getScene().getDefaultPin(toPageNode);
        this.getScene().setEdgeTarget(navCaseNode, targetPin);
    }

    public JComponent getToolbarRepresentation() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.setBorder(new EmptyBorder(0, 0, 0, 0));
        toolbar.addSeparator();
        PageFlowToolbarUtilities utilities = PageFlowToolbarUtilities.getInstance(this);
        final JComboBox scopeComboBox = utilities.createScopeComboBox();
        if (this.sceneData == null) {
            scopeComboBox.setEnabled(false);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    if (PageFlowView.this.initTask != null) {
                        try {
                            PageFlowView.this.initTask.get();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    scopeComboBox.setEnabled(true);
                                }
                            });
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (ExecutionException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
        }
        toolbar.add(scopeComboBox);
        toolbar.addSeparator();
        toolbar.add(utilities.createLayoutButton());
        return toolbar;
    }

    public PaletteController getPaletteController() {
        try {
            return PaletteFactory.createPalette((String)PATH_PALETTE_FOLDER, (PaletteActions)new PaletteActions(){

                public Action[] getCustomCategoryActions(Lookup lookup) {
                    return new Action[0];
                }

                public Action[] getCustomItemActions(Lookup lookup) {
                    return new Action[0];
                }

                public Action[] getCustomPaletteActions() {
                    return new Action[0];
                }

                public Action[] getImportActions() {
                    return new Action[0];
                }

                public Action getPreferredAction(Lookup lookup) {
                    return null;
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void requestFocus() {
        super.requestFocus();
        this.getScene().getView().requestFocus();
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.getScene() == null || this.getScene().getView() == null) {
            this.initializeScene();
        }
        return this.getScene().getView().requestFocusInWindow();
    }

    public void removeEdge(NavigationCaseEdge node) {
        if (this.getScene().getEdges().contains(node)) {
            this.getScene().removeEdge(node);
        }
    }

    public void removeNodeWithEdges(Page node) {
        if (this.getScene().getNodes().contains(node)) {
            this.getScene().removeNodeWithEdges(node);
        }
    }

    public synchronized void resetNodeWidget(Page pageNode, boolean contentItemsChanged) {
        if (pageNode == null) {
            throw new RuntimeException("PageFlowEditor: Cannot set node to null");
        }
        VMDNodeWidget nodeWidget = (VMDNodeWidget)this.getScene().findWidget(pageNode);
        pageNode.updateNode_HACK();
        if (nodeWidget != null) {
            nodeWidget.setNodeProperties(pageNode.getIcon(1), pageNode.getDisplayName(), null, null);
            if (contentItemsChanged) {
                this.redrawPinsAndEdges(pageNode);
            }
        } else {
            this.validateGraph();
            System.err.println("PageFlowCreationStack: " + this.pfc.PageFlowCreationStack);
            System.err.println("PageFlowDestroyStack: " + this.pfc.PageFlowDestroyStack);
            this.pfc.PageFlowCreationStack.clear();
            this.pfc.PageFlowDestroyStack.clear();
            System.err.println("PageNode: " + pageNode);
            System.err.println("Here are the scene nodes: " + this.getScene().getNodes());
        }
    }

    private final void redrawPinsAndEdges(Page pageNode) {
        ArrayList redrawCaseNodes = new ArrayList();
        ArrayList pinNodes = new ArrayList(this.getScene().getPins());
        for (Pin pin : pinNodes) {
            if (pin.getPage() != pageNode) continue;
            assert (pin.getPage().getDisplayName().equals(pageNode.getDisplayName()));
            Collection caseNodes = this.getScene().findPinEdges(pin, true, false);
            redrawCaseNodes.addAll(caseNodes);
            if (pin.isDefault()) continue;
            this.getScene().removePin(pin);
        }
        if (pageNode.isDataNode()) {
            this.setupPinsInNode(pageNode);
        }
        for (NavigationCaseEdge caseNode : redrawCaseNodes) {
            this.setEdgeSourcePin(caseNode, pageNode);
        }
    }

    public Collection<NavigationCaseEdge> getNodeEdges(Page node) {
        Collection navCases = this.getScene().getEdges();
        HashSet<NavigationCaseEdge> myNavCases = new HashSet<NavigationCaseEdge>();
        String fromViewId = node.getDisplayName();
        for (NavigationCaseEdge navCaseNode : navCases) {
            String strToViewId = navCaseNode.getToViewId();
            String strFromViewId = navCaseNode.getFromViewId();
            if ((strToViewId == null || !strToViewId.equals(fromViewId)) && (strFromViewId == null || !strFromViewId.equals(fromViewId))) continue;
            myNavCases.add(navCaseNode);
        }
        return myNavCases;
    }

    public static synchronized FileObject getStorageFile(FileObject configFile) {
        String filename;
        FileObject storageFile;
        Project p = FileOwnerQuery.getOwner((FileObject)configFile);
        if (p == null) {
            LOG.warning("File does not exist inside a project. Can't solve getStorageFile().");
            return null;
        }
        FileObject projectDirectory = p.getProjectDirectory();
        FileObject nbprojectFolder = projectDirectory.getFileObject("nbproject", null);
        if (nbprojectFolder == null) {
            if (projectDirectory.getFileObject("pom", "xml") != null) {
                nbprojectFolder = projectDirectory;
            } else {
                LOG.log(Level.WARNING, "Unable to create access the follow folder: {0}", nbprojectFolder);
                return null;
            }
        }
        if ((storageFile = nbprojectFolder.getFileObject(filename = configFile.getName() + ".NavData")) == null) {
            try {
                storageFile = nbprojectFolder.createData(filename);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return storageFile;
    }

    public static final FileObject getWebFolder(FileObject configFile) {
        WebModule webModule = WebModule.getWebModule((FileObject)configFile);
        if (webModule == null) {
            LOG.warning("This configuration file is not part of a webModule: " + configFile);
            System.err.println("This configuration file is not part of a webModule: " + configFile);
            return null;
        }
        FileObject webFolder = webModule.getDocumentBase();
        return webFolder;
    }

    public void serializeNodeLocations(FileObject navDataFile) {
        if (navDataFile != null) {
            this.saveLocations();
            SceneSerializer.serialize(this.sceneData, navDataFile);
        }
    }

    public void deserializeNodeLocation(FileObject navDataFile) {
        if (navDataFile != null && navDataFile.isValid() && navDataFile.getSize() > 0L) {
            SceneSerializer.deserialize(this.sceneData, navDataFile);
        }
    }

    protected String preferredID() {
        return "PageFlowEditor";
    }

    public int getPersistenceType() {
        return 2;
    }

    public void layoutNodes() {
        LayoutUtility.LayoutType useLayout = null;
        switch (this.lastUsedLayout) {
            case GRID_GRAPH: {
                useLayout = LayoutUtility.LayoutType.FREE_PLACES_NODES;
                break;
            }
            case FREE_PLACES_NODES: {
                useLayout = LayoutUtility.LayoutType.GRID_GRAPH;
            }
        }
        LayoutUtility.performLayout(this.getScene(), useLayout);
        this.lastUsedLayout = useLayout;
    }

    public PageFlowElement getMultiview() {
        PageFlowElement multiview = null;
        if (this.multiviewRef != null) {
            multiview = (PageFlowElement)this.multiviewRef.get();
        }
        return multiview;
    }

    public void setMultiview(PageFlowElement multiview) {
        this.multiviewRef = new WeakReference<PageFlowElement>(multiview);
    }

    private class DefaultDataNode
    extends FilterNode {
        Node srcFolderNode;

        public DefaultDataNode(DataObject dataObject) {
            this(dataObject.getNodeDelegate());
            try {
                this.srcFolderNode = DataObject.find((FileObject)PageFlowView.findSourceFolder(dataObject)).getNodeDelegate();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public DefaultDataNode(DataObject dataObject, Node srcFolderNode) {
            this(dataObject.getNodeDelegate());
            this.srcFolderNode = srcFolderNode;
        }

        public DefaultDataNode(Node node) {
            super(node);
            this.srcFolderNode = null;
        }

        public <T extends Node.Cookie> T getCookie(Class<T> type) {
            if (type.equals(DataFolder.class)) {
                assert (this.srcFolderNode != null);
                return (T)this.srcFolderNode.getCookie(type);
            }
            return (T)super.getCookie(type);
        }
    }

    static class PFVTestAccessor {
        PFVTestAccessor() {
        }

        static PageFlowScene getPageFlowScene(PageFlowView view) throws InterruptedException {
            if (view.getScene() == null) {
                Thread.sleep(3000L);
            }
            return view.getScene();
        }
    }

    public final class VMDNodeWidgetListener
    implements StateModel.Listener {
        public void stateChanged() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

