/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.support;

import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.SwingUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class OpenInEditorAction
implements Runnable {
    private static final RequestProcessor RP = new RequestProcessor("Open in Editor");
    private final URL url;
    private final int lineNumber;
    private LineCookie lc;

    public static void post(URL url, int lineNumber) {
        RP.post((Runnable)new OpenInEditorAction(url, lineNumber));
    }

    public static void post(String filePath, int lineNumber) {
        try {
            RP.post((Runnable)new OpenInEditorAction(Utilities.toURI((File)new File(filePath)).toURL(), lineNumber));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private OpenInEditorAction(URL url, int lineNumber) {
        this.url = url;
        this.lineNumber = lineNumber;
    }

    @Override
    public void run() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doEDT();
        } else {
            this.doWork();
        }
    }

    private void doEDT() {
        if (this.lc != null) {
            Line l = this.lc.getLineSet().getOriginal(this.lineNumber - 1);
            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
        }
    }

    private void doWork() {
        if (this.url == null) {
            return;
        }
        try {
            FileObject fo = URLMapper.findFileObject((URL)this.url);
            DataObject dobj = DataObject.find((FileObject)fo);
            EditorCookie ed = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
            if (ed != null && fo == dobj.getPrimaryFile()) {
                if (this.lineNumber == -1) {
                    ed.open();
                } else {
                    this.lc = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
                    SwingUtilities.invokeLater(this);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

