// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/securitycenter/v1beta1/securitycenter_service.proto

package securitycenterpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	SecurityCenter_CreateSource_FullMethodName               = "/google.cloud.securitycenter.v1beta1.SecurityCenter/CreateSource"
	SecurityCenter_CreateFinding_FullMethodName              = "/google.cloud.securitycenter.v1beta1.SecurityCenter/CreateFinding"
	SecurityCenter_GetIamPolicy_FullMethodName               = "/google.cloud.securitycenter.v1beta1.SecurityCenter/GetIamPolicy"
	SecurityCenter_GetOrganizationSettings_FullMethodName    = "/google.cloud.securitycenter.v1beta1.SecurityCenter/GetOrganizationSettings"
	SecurityCenter_GetSource_FullMethodName                  = "/google.cloud.securitycenter.v1beta1.SecurityCenter/GetSource"
	SecurityCenter_GroupAssets_FullMethodName                = "/google.cloud.securitycenter.v1beta1.SecurityCenter/GroupAssets"
	SecurityCenter_GroupFindings_FullMethodName              = "/google.cloud.securitycenter.v1beta1.SecurityCenter/GroupFindings"
	SecurityCenter_ListAssets_FullMethodName                 = "/google.cloud.securitycenter.v1beta1.SecurityCenter/ListAssets"
	SecurityCenter_ListFindings_FullMethodName               = "/google.cloud.securitycenter.v1beta1.SecurityCenter/ListFindings"
	SecurityCenter_ListSources_FullMethodName                = "/google.cloud.securitycenter.v1beta1.SecurityCenter/ListSources"
	SecurityCenter_RunAssetDiscovery_FullMethodName          = "/google.cloud.securitycenter.v1beta1.SecurityCenter/RunAssetDiscovery"
	SecurityCenter_SetFindingState_FullMethodName            = "/google.cloud.securitycenter.v1beta1.SecurityCenter/SetFindingState"
	SecurityCenter_SetIamPolicy_FullMethodName               = "/google.cloud.securitycenter.v1beta1.SecurityCenter/SetIamPolicy"
	SecurityCenter_TestIamPermissions_FullMethodName         = "/google.cloud.securitycenter.v1beta1.SecurityCenter/TestIamPermissions"
	SecurityCenter_UpdateFinding_FullMethodName              = "/google.cloud.securitycenter.v1beta1.SecurityCenter/UpdateFinding"
	SecurityCenter_UpdateOrganizationSettings_FullMethodName = "/google.cloud.securitycenter.v1beta1.SecurityCenter/UpdateOrganizationSettings"
	SecurityCenter_UpdateSource_FullMethodName               = "/google.cloud.securitycenter.v1beta1.SecurityCenter/UpdateSource"
	SecurityCenter_UpdateSecurityMarks_FullMethodName        = "/google.cloud.securitycenter.v1beta1.SecurityCenter/UpdateSecurityMarks"
)

// SecurityCenterClient is the client API for SecurityCenter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SecurityCenterClient interface {
	// Creates a source.
	CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Creates a finding. The corresponding source must exist for finding creation
	// to succeed.
	CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets the settings for an organization.
	GetOrganizationSettings(ctx context.Context, in *GetOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error)
	// Gets a source.
	GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Filters an organization's assets and  groups them by their specified
	// properties.
	GroupAssets(ctx context.Context, in *GroupAssetsRequest, opts ...grpc.CallOption) (*GroupAssetsResponse, error)
	// Filters an organization or source's findings and  groups them by their
	// specified properties.
	//
	// To group across all sources provide a `-` as the source id.
	// Example: /v1beta1/organizations/{organization_id}/sources/-/findings
	GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error)
	// Lists an organization's assets.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources provide a `-` as the source id.
	// Example: /v1beta1/organizations/{organization_id}/sources/-/findings
	ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error)
	// Runs asset discovery. The discovery is tracked with a long-running
	// operation.
	//
	// This API can only be called with limited frequency for an organization. If
	// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
	// error.
	RunAssetDiscovery(ctx context.Context, in *RunAssetDiscoveryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the state of a finding.
	SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Creates or updates a finding. The corresponding source must exist for a
	// finding creation to succeed.
	UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Updates an organization's settings.
	UpdateOrganizationSettings(ctx context.Context, in *UpdateOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error)
	// Updates a source.
	UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Updates security marks.
	UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error)
}

type securityCenterClient struct {
	cc grpc.ClientConnInterface
}

func NewSecurityCenterClient(cc grpc.ClientConnInterface) SecurityCenterClient {
	return &securityCenterClient{cc}
}

func (c *securityCenterClient) CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, SecurityCenter_CreateSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, SecurityCenter_CreateFinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, SecurityCenter_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetOrganizationSettings(ctx context.Context, in *GetOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error) {
	out := new(OrganizationSettings)
	err := c.cc.Invoke(ctx, SecurityCenter_GetOrganizationSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, SecurityCenter_GetSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GroupAssets(ctx context.Context, in *GroupAssetsRequest, opts ...grpc.CallOption) (*GroupAssetsResponse, error) {
	out := new(GroupAssetsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_GroupAssets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error) {
	out := new(GroupFindingsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_GroupFindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListAssets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error) {
	out := new(ListFindingsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListFindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error) {
	out := new(ListSourcesResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_ListSources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) RunAssetDiscovery(ctx context.Context, in *RunAssetDiscoveryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, SecurityCenter_RunAssetDiscovery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, SecurityCenter_SetFindingState_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, SecurityCenter_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, SecurityCenter_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateFinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateOrganizationSettings(ctx context.Context, in *UpdateOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error) {
	out := new(OrganizationSettings)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateOrganizationSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error) {
	out := new(SecurityMarks)
	err := c.cc.Invoke(ctx, SecurityCenter_UpdateSecurityMarks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityCenterServer is the server API for SecurityCenter service.
// All implementations should embed UnimplementedSecurityCenterServer
// for forward compatibility
type SecurityCenterServer interface {
	// Creates a source.
	CreateSource(context.Context, *CreateSourceRequest) (*Source, error)
	// Creates a finding. The corresponding source must exist for finding creation
	// to succeed.
	CreateFinding(context.Context, *CreateFindingRequest) (*Finding, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Gets the settings for an organization.
	GetOrganizationSettings(context.Context, *GetOrganizationSettingsRequest) (*OrganizationSettings, error)
	// Gets a source.
	GetSource(context.Context, *GetSourceRequest) (*Source, error)
	// Filters an organization's assets and  groups them by their specified
	// properties.
	GroupAssets(context.Context, *GroupAssetsRequest) (*GroupAssetsResponse, error)
	// Filters an organization or source's findings and  groups them by their
	// specified properties.
	//
	// To group across all sources provide a `-` as the source id.
	// Example: /v1beta1/organizations/{organization_id}/sources/-/findings
	GroupFindings(context.Context, *GroupFindingsRequest) (*GroupFindingsResponse, error)
	// Lists an organization's assets.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources provide a `-` as the source id.
	// Example: /v1beta1/organizations/{organization_id}/sources/-/findings
	ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error)
	// Runs asset discovery. The discovery is tracked with a long-running
	// operation.
	//
	// This API can only be called with limited frequency for an organization. If
	// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
	// error.
	RunAssetDiscovery(context.Context, *RunAssetDiscoveryRequest) (*longrunningpb.Operation, error)
	// Updates the state of a finding.
	SetFindingState(context.Context, *SetFindingStateRequest) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Creates or updates a finding. The corresponding source must exist for a
	// finding creation to succeed.
	UpdateFinding(context.Context, *UpdateFindingRequest) (*Finding, error)
	// Updates an organization's settings.
	UpdateOrganizationSettings(context.Context, *UpdateOrganizationSettingsRequest) (*OrganizationSettings, error)
	// Updates a source.
	UpdateSource(context.Context, *UpdateSourceRequest) (*Source, error)
	// Updates security marks.
	UpdateSecurityMarks(context.Context, *UpdateSecurityMarksRequest) (*SecurityMarks, error)
}

// UnimplementedSecurityCenterServer should be embedded to have forward compatible implementations.
type UnimplementedSecurityCenterServer struct {
}

func (UnimplementedSecurityCenterServer) CreateSource(context.Context, *CreateSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSource not implemented")
}
func (UnimplementedSecurityCenterServer) CreateFinding(context.Context, *CreateFindingRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFinding not implemented")
}
func (UnimplementedSecurityCenterServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedSecurityCenterServer) GetOrganizationSettings(context.Context, *GetOrganizationSettingsRequest) (*OrganizationSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrganizationSettings not implemented")
}
func (UnimplementedSecurityCenterServer) GetSource(context.Context, *GetSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSource not implemented")
}
func (UnimplementedSecurityCenterServer) GroupAssets(context.Context, *GroupAssetsRequest) (*GroupAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupAssets not implemented")
}
func (UnimplementedSecurityCenterServer) GroupFindings(context.Context, *GroupFindingsRequest) (*GroupFindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupFindings not implemented")
}
func (UnimplementedSecurityCenterServer) ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (UnimplementedSecurityCenterServer) ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFindings not implemented")
}
func (UnimplementedSecurityCenterServer) ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSources not implemented")
}
func (UnimplementedSecurityCenterServer) RunAssetDiscovery(context.Context, *RunAssetDiscoveryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunAssetDiscovery not implemented")
}
func (UnimplementedSecurityCenterServer) SetFindingState(context.Context, *SetFindingStateRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetFindingState not implemented")
}
func (UnimplementedSecurityCenterServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedSecurityCenterServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateFinding(context.Context, *UpdateFindingRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFinding not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateOrganizationSettings(context.Context, *UpdateOrganizationSettingsRequest) (*OrganizationSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOrganizationSettings not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateSource(context.Context, *UpdateSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSource not implemented")
}
func (UnimplementedSecurityCenterServer) UpdateSecurityMarks(context.Context, *UpdateSecurityMarksRequest) (*SecurityMarks, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSecurityMarks not implemented")
}

// UnsafeSecurityCenterServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SecurityCenterServer will
// result in compilation errors.
type UnsafeSecurityCenterServer interface {
	mustEmbedUnimplementedSecurityCenterServer()
}

func RegisterSecurityCenterServer(s grpc.ServiceRegistrar, srv SecurityCenterServer) {
	s.RegisterService(&SecurityCenter_ServiceDesc, srv)
}

func _SecurityCenter_CreateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_CreateSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateSource(ctx, req.(*CreateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_CreateFinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateFinding(ctx, req.(*CreateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetOrganizationSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetOrganizationSettings(ctx, req.(*GetOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GetSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetSource(ctx, req.(*GetSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GroupAssets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupAssets(ctx, req.(*GroupAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_GroupFindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupFindings(ctx, req.(*GroupFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListAssets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListFindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListFindings(ctx, req.(*ListFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_ListSources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListSources(ctx, req.(*ListSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_RunAssetDiscovery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunAssetDiscoveryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).RunAssetDiscovery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_RunAssetDiscovery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).RunAssetDiscovery(ctx, req.(*RunAssetDiscoveryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetFindingState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetFindingStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetFindingState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_SetFindingState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetFindingState(ctx, req.(*SetFindingStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateFinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, req.(*UpdateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateOrganizationSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateOrganizationSettings(ctx, req.(*UpdateOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSource(ctx, req.(*UpdateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSecurityMarks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecurityMarksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecurityCenter_UpdateSecurityMarks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, req.(*UpdateSecurityMarksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SecurityCenter_ServiceDesc is the grpc.ServiceDesc for SecurityCenter service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SecurityCenter_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.securitycenter.v1beta1.SecurityCenter",
	HandlerType: (*SecurityCenterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSource",
			Handler:    _SecurityCenter_CreateSource_Handler,
		},
		{
			MethodName: "CreateFinding",
			Handler:    _SecurityCenter_CreateFinding_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _SecurityCenter_GetIamPolicy_Handler,
		},
		{
			MethodName: "GetOrganizationSettings",
			Handler:    _SecurityCenter_GetOrganizationSettings_Handler,
		},
		{
			MethodName: "GetSource",
			Handler:    _SecurityCenter_GetSource_Handler,
		},
		{
			MethodName: "GroupAssets",
			Handler:    _SecurityCenter_GroupAssets_Handler,
		},
		{
			MethodName: "GroupFindings",
			Handler:    _SecurityCenter_GroupFindings_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _SecurityCenter_ListAssets_Handler,
		},
		{
			MethodName: "ListFindings",
			Handler:    _SecurityCenter_ListFindings_Handler,
		},
		{
			MethodName: "ListSources",
			Handler:    _SecurityCenter_ListSources_Handler,
		},
		{
			MethodName: "RunAssetDiscovery",
			Handler:    _SecurityCenter_RunAssetDiscovery_Handler,
		},
		{
			MethodName: "SetFindingState",
			Handler:    _SecurityCenter_SetFindingState_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _SecurityCenter_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _SecurityCenter_TestIamPermissions_Handler,
		},
		{
			MethodName: "UpdateFinding",
			Handler:    _SecurityCenter_UpdateFinding_Handler,
		},
		{
			MethodName: "UpdateOrganizationSettings",
			Handler:    _SecurityCenter_UpdateOrganizationSettings_Handler,
		},
		{
			MethodName: "UpdateSource",
			Handler:    _SecurityCenter_UpdateSource_Handler,
		},
		{
			MethodName: "UpdateSecurityMarks",
			Handler:    _SecurityCenter_UpdateSecurityMarks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/securitycenter/v1beta1/securitycenter_service.proto",
}
