// Code generated by smithy-go-codegen DO NOT EDIT.

package eks

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/eks/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a managed capability resource for an Amazon EKS cluster.
//
// Capabilities provide fully managed capabilities to build and scale with
// Kubernetes. When you create a capability, Amazon EKSprovisions and manages the
// infrastructure required to run the capability outside of your cluster. This
// approach reduces operational overhead and preserves cluster resources.
//
// You can only create one Capability of each type on a given Amazon EKS cluster.
// Valid types are Argo CD for declarative GitOps deployment, Amazon Web Services
// Controllers for Kubernetes (ACK) for resource management, and Kube Resource
// Orchestrator (KRO) for Kubernetes custom resource orchestration.
//
// For more information, see [EKS Capabilities] in the Amazon EKS User Guide.
//
// [EKS Capabilities]: https://docs.aws.amazon.com/eks/latest/userguide/capabilities.html
func (c *Client) CreateCapability(ctx context.Context, params *CreateCapabilityInput, optFns ...func(*Options)) (*CreateCapabilityOutput, error) {
	if params == nil {
		params = &CreateCapabilityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateCapability", params, optFns, c.addOperationCreateCapabilityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateCapabilityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateCapabilityInput struct {

	// A unique name for the capability. The name must be unique within your cluster
	// and can contain alphanumeric characters, hyphens, and underscores.
	//
	// This member is required.
	CapabilityName *string

	// The name of the Amazon EKS cluster where you want to create the capability.
	//
	// This member is required.
	ClusterName *string

	// Specifies how Kubernetes resources managed by the capability should be handled
	// when the capability is deleted. Currently, the only supported value is RETAIN
	// which retains all Kubernetes resources managed by the capability when the
	// capability is deleted.
	//
	// Because resources are retained, all Kubernetes resources created by the
	// capability should be deleted from the cluster before deleting the capability
	// itself. After the capability is deleted, these resources become difficult to
	// manage because the controller is no longer available.
	//
	// This member is required.
	DeletePropagationPolicy types.CapabilityDeletePropagationPolicy

	// The Amazon Resource Name (ARN) of the IAM role that the capability uses to
	// interact with Amazon Web Services services. This role must have a trust policy
	// that allows the EKS service principal to assume it, and it must have the
	// necessary permissions for the capability type you're creating.
	//
	// For ACK capabilities, the role needs permissions to manage the resources you
	// want to control through Kubernetes. For Argo CD capabilities, the role needs
	// permissions to access Git repositories and Secrets Manager. For KRO
	// capabilities, the role needs permissions based on the resources you'll be
	// orchestrating.
	//
	// This member is required.
	RoleArn *string

	// The type of capability to create. Valid values are:
	//
	//   - ACK – Amazon Web Services Controllers for Kubernetes (ACK), which lets you
	//   manage resources directly from Kubernetes.
	//
	//   - ARGOCD – Argo CD for GitOps-based continuous delivery.
	//
	//   - KRO – Kube Resource Orchestrator (KRO) for composing and managing custom
	//   Kubernetes resources.
	//
	// This member is required.
	Type types.CapabilityType

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. This token is valid for 24 hours after creation. If you retry a
	// request with the same client request token and the same parameters after the
	// original request has completed successfully, the result of the original request
	// is returned.
	ClientRequestToken *string

	// The configuration settings for the capability. The structure of this object
	// varies depending on the capability type. For Argo CD capabilities, you can
	// configure IAM Identity CenterIAM; Identity Center integration, RBAC role
	// mappings, and network access settings.
	Configuration *types.CapabilityConfigurationRequest

	// The metadata that you apply to a resource to help you categorize and organize
	// them. Each tag consists of a key and an optional value. You define them.
	//
	// The following basic restrictions apply to tags:
	//
	//   - Maximum number of tags per resource – 50
	//
	//   - For each resource, each tag key must be unique, and each tag key can have
	//   only one value.
	//
	//   - Maximum key length – 128 Unicode characters in UTF-8
	//
	//   - Maximum value length – 256 Unicode characters in UTF-8
	//
	//   - If your tagging schema is used across multiple services and resources,
	//   remember that other services may have restrictions on allowed characters.
	//   Generally allowed characters are: letters, numbers, and spaces representable in
	//   UTF-8, and the following characters: + - = . _ : / @.
	//
	//   - Tag keys and values are case-sensitive.
	//
	//   - Do not use aws: , AWS: , or any upper or lowercase combination of such as a
	//   prefix for either keys or values as it is reserved for Amazon Web Services use.
	//   You cannot edit or delete tag keys or values with this prefix. Tags with this
	//   prefix do not count against your tags per resource limit.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateCapabilityOutput struct {

	// An object containing information about the newly created capability, including
	// its name, ARN, status, and configuration.
	Capability *types.Capability

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateCapabilityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateCapability{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateCapability{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateCapability"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateCapabilityMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateCapabilityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateCapability(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateCapability struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateCapability) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateCapability) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateCapabilityInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateCapabilityInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateCapabilityMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateCapability{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateCapability(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateCapability",
	}
}
