// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1/feature_view.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Service agent type used during data sync.
type FeatureView_ServiceAgentType int32

const (
	// By default, the project-level Vertex AI Service Agent is enabled.
	FeatureView_SERVICE_AGENT_TYPE_UNSPECIFIED FeatureView_ServiceAgentType = 0
	// Indicates the project-level Vertex AI Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// will be used during sync jobs.
	FeatureView_SERVICE_AGENT_TYPE_PROJECT FeatureView_ServiceAgentType = 1
	// Enable a FeatureView service account to be created by Vertex AI and
	// output in the field `service_account_email`. This service account will
	// be used to read from the source BigQuery table during sync.
	FeatureView_SERVICE_AGENT_TYPE_FEATURE_VIEW FeatureView_ServiceAgentType = 2
)

// Enum value maps for FeatureView_ServiceAgentType.
var (
	FeatureView_ServiceAgentType_name = map[int32]string{
		0: "SERVICE_AGENT_TYPE_UNSPECIFIED",
		1: "SERVICE_AGENT_TYPE_PROJECT",
		2: "SERVICE_AGENT_TYPE_FEATURE_VIEW",
	}
	FeatureView_ServiceAgentType_value = map[string]int32{
		"SERVICE_AGENT_TYPE_UNSPECIFIED":  0,
		"SERVICE_AGENT_TYPE_PROJECT":      1,
		"SERVICE_AGENT_TYPE_FEATURE_VIEW": 2,
	}
)

func (x FeatureView_ServiceAgentType) Enum() *FeatureView_ServiceAgentType {
	p := new(FeatureView_ServiceAgentType)
	*p = x
	return p
}

func (x FeatureView_ServiceAgentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FeatureView_ServiceAgentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_feature_view_proto_enumTypes[0].Descriptor()
}

func (FeatureView_ServiceAgentType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_feature_view_proto_enumTypes[0]
}

func (x FeatureView_ServiceAgentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FeatureView_ServiceAgentType.Descriptor instead.
func (FeatureView_ServiceAgentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0, 0}
}

// The distance measure used in nearest neighbor search.
type FeatureView_IndexConfig_DistanceMeasureType int32

const (
	// Should not be set.
	FeatureView_IndexConfig_DISTANCE_MEASURE_TYPE_UNSPECIFIED FeatureView_IndexConfig_DistanceMeasureType = 0
	// Euclidean (L_2) Distance.
	FeatureView_IndexConfig_SQUARED_L2_DISTANCE FeatureView_IndexConfig_DistanceMeasureType = 1
	// Cosine Distance. Defined as 1 - cosine similarity.
	//
	// We strongly suggest using DOT_PRODUCT_DISTANCE + UNIT_L2_NORM instead
	// of COSINE distance. Our algorithms have been more optimized for
	// DOT_PRODUCT distance which, when combined with UNIT_L2_NORM, is
	// mathematically equivalent to COSINE distance and results in the same
	// ranking.
	FeatureView_IndexConfig_COSINE_DISTANCE FeatureView_IndexConfig_DistanceMeasureType = 2
	// Dot Product Distance. Defined as a negative of the dot product.
	FeatureView_IndexConfig_DOT_PRODUCT_DISTANCE FeatureView_IndexConfig_DistanceMeasureType = 3
)

// Enum value maps for FeatureView_IndexConfig_DistanceMeasureType.
var (
	FeatureView_IndexConfig_DistanceMeasureType_name = map[int32]string{
		0: "DISTANCE_MEASURE_TYPE_UNSPECIFIED",
		1: "SQUARED_L2_DISTANCE",
		2: "COSINE_DISTANCE",
		3: "DOT_PRODUCT_DISTANCE",
	}
	FeatureView_IndexConfig_DistanceMeasureType_value = map[string]int32{
		"DISTANCE_MEASURE_TYPE_UNSPECIFIED": 0,
		"SQUARED_L2_DISTANCE":               1,
		"COSINE_DISTANCE":                   2,
		"DOT_PRODUCT_DISTANCE":              3,
	}
)

func (x FeatureView_IndexConfig_DistanceMeasureType) Enum() *FeatureView_IndexConfig_DistanceMeasureType {
	p := new(FeatureView_IndexConfig_DistanceMeasureType)
	*p = x
	return p
}

func (x FeatureView_IndexConfig_DistanceMeasureType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FeatureView_IndexConfig_DistanceMeasureType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_feature_view_proto_enumTypes[1].Descriptor()
}

func (FeatureView_IndexConfig_DistanceMeasureType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_feature_view_proto_enumTypes[1]
}

func (x FeatureView_IndexConfig_DistanceMeasureType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FeatureView_IndexConfig_DistanceMeasureType.Descriptor instead.
func (FeatureView_IndexConfig_DistanceMeasureType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0, 2, 0}
}

// FeatureView is representation of values that the FeatureOnlineStore will
// serve based on its syncConfig.
type FeatureView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//
	//	*FeatureView_BigQuerySource_
	//	*FeatureView_FeatureRegistrySource_
	//	*FeatureView_VertexRagSource_
	Source isFeatureView_Source `protobuf_oneof:"source"`
	// Identifier. Name of the FeatureView. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Timestamp when this FeatureView was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this FeatureView was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Used to perform consistent read-modify-write updates. If not set,
	// a blind "overwrite" update happens.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. The labels with user-defined metadata to organize your
	// FeatureViews.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	// No more than 64 user labels can be associated with one
	// FeatureOnlineStore(System labels are excluded)." System reserved label keys
	// are prefixed with "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Configures when data is to be synced/updated for this FeatureView. At the
	// end of the sync the latest featureValues for each entityId of this
	// FeatureView are made ready for online serving.
	SyncConfig *FeatureView_SyncConfig `protobuf:"bytes,7,opt,name=sync_config,json=syncConfig,proto3" json:"sync_config,omitempty"`
	// Optional. Configuration for index preparation for vector search. It
	// contains the required configurations to create an index from source data,
	// so that approximate nearest neighbor (a.k.a ANN) algorithms search can be
	// performed during online serving.
	IndexConfig *FeatureView_IndexConfig `protobuf:"bytes,15,opt,name=index_config,json=indexConfig,proto3" json:"index_config,omitempty"`
	// Optional. Configuration for FeatureView created under Optimized
	// FeatureOnlineStore.
	OptimizedConfig *FeatureView_OptimizedConfig `protobuf:"bytes,16,opt,name=optimized_config,json=optimizedConfig,proto3" json:"optimized_config,omitempty"`
	// Optional. Service agent type used during data sync. By default, the Vertex
	// AI Service Agent is used. When using an IAM Policy to isolate this
	// FeatureView within a project, a separate service account should be
	// provisioned by setting this field to `SERVICE_AGENT_TYPE_FEATURE_VIEW`.
	// This will generate a separate service account to access the BigQuery source
	// table.
	ServiceAgentType FeatureView_ServiceAgentType `protobuf:"varint,14,opt,name=service_agent_type,json=serviceAgentType,proto3,enum=google.cloud.aiplatform.v1.FeatureView_ServiceAgentType" json:"service_agent_type,omitempty"`
	// Output only. A Service Account unique to this FeatureView. The role
	// bigquery.dataViewer should be granted to this service account to allow
	// Vertex AI Feature Store to sync data to the online store.
	ServiceAccountEmail string `protobuf:"bytes,13,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,19,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,20,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
	// Metadata containing information about the Cloud Bigtable.
	BigtableMetadata *FeatureView_BigtableMetadata `protobuf:"bytes,21,opt,name=bigtable_metadata,json=bigtableMetadata,proto3" json:"bigtable_metadata,omitempty"`
}

func (x *FeatureView) Reset() {
	*x = FeatureView{}
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureView) ProtoMessage() {}

func (x *FeatureView) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureView.ProtoReflect.Descriptor instead.
func (*FeatureView) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0}
}

func (m *FeatureView) GetSource() isFeatureView_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *FeatureView) GetBigQuerySource() *FeatureView_BigQuerySource {
	if x, ok := x.GetSource().(*FeatureView_BigQuerySource_); ok {
		return x.BigQuerySource
	}
	return nil
}

func (x *FeatureView) GetFeatureRegistrySource() *FeatureView_FeatureRegistrySource {
	if x, ok := x.GetSource().(*FeatureView_FeatureRegistrySource_); ok {
		return x.FeatureRegistrySource
	}
	return nil
}

func (x *FeatureView) GetVertexRagSource() *FeatureView_VertexRagSource {
	if x, ok := x.GetSource().(*FeatureView_VertexRagSource_); ok {
		return x.VertexRagSource
	}
	return nil
}

func (x *FeatureView) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FeatureView) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *FeatureView) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *FeatureView) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *FeatureView) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *FeatureView) GetSyncConfig() *FeatureView_SyncConfig {
	if x != nil {
		return x.SyncConfig
	}
	return nil
}

func (x *FeatureView) GetIndexConfig() *FeatureView_IndexConfig {
	if x != nil {
		return x.IndexConfig
	}
	return nil
}

func (x *FeatureView) GetOptimizedConfig() *FeatureView_OptimizedConfig {
	if x != nil {
		return x.OptimizedConfig
	}
	return nil
}

func (x *FeatureView) GetServiceAgentType() FeatureView_ServiceAgentType {
	if x != nil {
		return x.ServiceAgentType
	}
	return FeatureView_SERVICE_AGENT_TYPE_UNSPECIFIED
}

func (x *FeatureView) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *FeatureView) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *FeatureView) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

func (x *FeatureView) GetBigtableMetadata() *FeatureView_BigtableMetadata {
	if x != nil {
		return x.BigtableMetadata
	}
	return nil
}

type isFeatureView_Source interface {
	isFeatureView_Source()
}

type FeatureView_BigQuerySource_ struct {
	// Optional. Configures how data is supposed to be extracted from a BigQuery
	// source to be loaded onto the FeatureOnlineStore.
	BigQuerySource *FeatureView_BigQuerySource `protobuf:"bytes,6,opt,name=big_query_source,json=bigQuerySource,proto3,oneof"`
}

type FeatureView_FeatureRegistrySource_ struct {
	// Optional. Configures the features from a Feature Registry source that
	// need to be loaded onto the FeatureOnlineStore.
	FeatureRegistrySource *FeatureView_FeatureRegistrySource `protobuf:"bytes,9,opt,name=feature_registry_source,json=featureRegistrySource,proto3,oneof"`
}

type FeatureView_VertexRagSource_ struct {
	// Optional. The Vertex RAG Source that the FeatureView is linked to.
	VertexRagSource *FeatureView_VertexRagSource `protobuf:"bytes,18,opt,name=vertex_rag_source,json=vertexRagSource,proto3,oneof"`
}

func (*FeatureView_BigQuerySource_) isFeatureView_Source() {}

func (*FeatureView_FeatureRegistrySource_) isFeatureView_Source() {}

func (*FeatureView_VertexRagSource_) isFeatureView_Source() {}

type FeatureView_BigQuerySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery view URI that will be materialized on each sync
	// trigger based on FeatureView.SyncConfig.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Required. Columns to construct entity_id / row keys.
	EntityIdColumns []string `protobuf:"bytes,2,rep,name=entity_id_columns,json=entityIdColumns,proto3" json:"entity_id_columns,omitempty"`
}

func (x *FeatureView_BigQuerySource) Reset() {
	*x = FeatureView_BigQuerySource{}
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureView_BigQuerySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureView_BigQuerySource) ProtoMessage() {}

func (x *FeatureView_BigQuerySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureView_BigQuerySource.ProtoReflect.Descriptor instead.
func (*FeatureView_BigQuerySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0, 0}
}

func (x *FeatureView_BigQuerySource) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *FeatureView_BigQuerySource) GetEntityIdColumns() []string {
	if x != nil {
		return x.EntityIdColumns
	}
	return nil
}

// Configuration for Sync. Only one option is set.
type FeatureView_SyncConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
	// runs. To explicitly set a timezone to the cron tab, apply a prefix in
	// the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
	// The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
	// database. For example, "CRON_TZ=America/New_York 1 * * * *", or
	// "TZ=America/New_York 1 * * * *".
	Cron string `protobuf:"bytes,1,opt,name=cron,proto3" json:"cron,omitempty"`
	// Optional. If true, syncs the FeatureView in a continuous manner to Online
	// Store.
	Continuous bool `protobuf:"varint,2,opt,name=continuous,proto3" json:"continuous,omitempty"`
}

func (x *FeatureView_SyncConfig) Reset() {
	*x = FeatureView_SyncConfig{}
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureView_SyncConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureView_SyncConfig) ProtoMessage() {}

func (x *FeatureView_SyncConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureView_SyncConfig.ProtoReflect.Descriptor instead.
func (*FeatureView_SyncConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0, 1}
}

func (x *FeatureView_SyncConfig) GetCron() string {
	if x != nil {
		return x.Cron
	}
	return ""
}

func (x *FeatureView_SyncConfig) GetContinuous() bool {
	if x != nil {
		return x.Continuous
	}
	return false
}

// Configuration for vector indexing.
type FeatureView_IndexConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration with regard to the algorithms used for efficient
	// search.
	//
	// Types that are assignable to AlgorithmConfig:
	//
	//	*FeatureView_IndexConfig_TreeAhConfig
	//	*FeatureView_IndexConfig_BruteForceConfig_
	AlgorithmConfig isFeatureView_IndexConfig_AlgorithmConfig `protobuf_oneof:"algorithm_config"`
	// Optional. Column of embedding. This column contains the source data to
	// create index for vector search. embedding_column must be set when using
	// vector search.
	EmbeddingColumn string `protobuf:"bytes,1,opt,name=embedding_column,json=embeddingColumn,proto3" json:"embedding_column,omitempty"`
	// Optional. Columns of features that're used to filter vector search
	// results.
	FilterColumns []string `protobuf:"bytes,2,rep,name=filter_columns,json=filterColumns,proto3" json:"filter_columns,omitempty"`
	// Optional. Column of crowding. This column contains crowding attribute
	// which is a constraint on a neighbor list produced by
	// [FeatureOnlineStoreService.SearchNearestEntities][google.cloud.aiplatform.v1.FeatureOnlineStoreService.SearchNearestEntities]
	// to diversify search results. If
	// [NearestNeighborQuery.per_crowding_attribute_neighbor_count][google.cloud.aiplatform.v1.NearestNeighborQuery.per_crowding_attribute_neighbor_count]
	// is set to K in
	// [SearchNearestEntitiesRequest][google.cloud.aiplatform.v1.SearchNearestEntitiesRequest],
	// it's guaranteed that no more than K entities of the same crowding
	// attribute are returned in the response.
	CrowdingColumn string `protobuf:"bytes,3,opt,name=crowding_column,json=crowdingColumn,proto3" json:"crowding_column,omitempty"`
	// Optional. The number of dimensions of the input embedding.
	EmbeddingDimension *int32 `protobuf:"varint,4,opt,name=embedding_dimension,json=embeddingDimension,proto3,oneof" json:"embedding_dimension,omitempty"`
	// Optional. The distance measure used in nearest neighbor search.
	DistanceMeasureType FeatureView_IndexConfig_DistanceMeasureType `protobuf:"varint,5,opt,name=distance_measure_type,json=distanceMeasureType,proto3,enum=google.cloud.aiplatform.v1.FeatureView_IndexConfig_DistanceMeasureType" json:"distance_measure_type,omitempty"`
}

func (x *FeatureView_IndexConfig) Reset() {
	*x = FeatureView_IndexConfig{}
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureView_IndexConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureView_IndexConfig) ProtoMessage() {}

func (x *FeatureView_IndexConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureView_IndexConfig.ProtoReflect.Descriptor instead.
func (*FeatureView_IndexConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0, 2}
}

func (m *FeatureView_IndexConfig) GetAlgorithmConfig() isFeatureView_IndexConfig_AlgorithmConfig {
	if m != nil {
		return m.AlgorithmConfig
	}
	return nil
}

func (x *FeatureView_IndexConfig) GetTreeAhConfig() *FeatureView_IndexConfig_TreeAHConfig {
	if x, ok := x.GetAlgorithmConfig().(*FeatureView_IndexConfig_TreeAhConfig); ok {
		return x.TreeAhConfig
	}
	return nil
}

func (x *FeatureView_IndexConfig) GetBruteForceConfig() *FeatureView_IndexConfig_BruteForceConfig {
	if x, ok := x.GetAlgorithmConfig().(*FeatureView_IndexConfig_BruteForceConfig_); ok {
		return x.BruteForceConfig
	}
	return nil
}

func (x *FeatureView_IndexConfig) GetEmbeddingColumn() string {
	if x != nil {
		return x.EmbeddingColumn
	}
	return ""
}

func (x *FeatureView_IndexConfig) GetFilterColumns() []string {
	if x != nil {
		return x.FilterColumns
	}
	return nil
}

func (x *FeatureView_IndexConfig) GetCrowdingColumn() string {
	if x != nil {
		return x.CrowdingColumn
	}
	return ""
}

func (x *FeatureView_IndexConfig) GetEmbeddingDimension() int32 {
	if x != nil && x.EmbeddingDimension != nil {
		return *x.EmbeddingDimension
	}
	return 0
}

func (x *FeatureView_IndexConfig) GetDistanceMeasureType() FeatureView_IndexConfig_DistanceMeasureType {
	if x != nil {
		return x.DistanceMeasureType
	}
	return FeatureView_IndexConfig_DISTANCE_MEASURE_TYPE_UNSPECIFIED
}

type isFeatureView_IndexConfig_AlgorithmConfig interface {
	isFeatureView_IndexConfig_AlgorithmConfig()
}

type FeatureView_IndexConfig_TreeAhConfig struct {
	// Optional. Configuration options for the tree-AH algorithm (Shallow tree
	// + Asymmetric Hashing). Please refer to this paper for more details:
	// https://arxiv.org/abs/1908.10396
	TreeAhConfig *FeatureView_IndexConfig_TreeAHConfig `protobuf:"bytes,6,opt,name=tree_ah_config,json=treeAhConfig,proto3,oneof"`
}

type FeatureView_IndexConfig_BruteForceConfig_ struct {
	// Optional. Configuration options for using brute force search, which
	// simply implements the standard linear search in the database for each
	// query. It is primarily meant for benchmarking and to generate the
	// ground truth for approximate search.
	BruteForceConfig *FeatureView_IndexConfig_BruteForceConfig `protobuf:"bytes,7,opt,name=brute_force_config,json=bruteForceConfig,proto3,oneof"`
}

func (*FeatureView_IndexConfig_TreeAhConfig) isFeatureView_IndexConfig_AlgorithmConfig() {}

func (*FeatureView_IndexConfig_BruteForceConfig_) isFeatureView_IndexConfig_AlgorithmConfig() {}

// A Feature Registry source for features that need to be synced to Online
// Store.
type FeatureView_FeatureRegistrySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of features that need to be synced to Online Store.
	FeatureGroups []*FeatureView_FeatureRegistrySource_FeatureGroup `protobuf:"bytes,1,rep,name=feature_groups,json=featureGroups,proto3" json:"feature_groups,omitempty"`
	// Optional. The project number of the parent project of the Feature Groups.
	ProjectNumber *int64 `protobuf:"varint,2,opt,name=project_number,json=projectNumber,proto3,oneof" json:"project_number,omitempty"`
}

func (x *FeatureView_FeatureRegistrySource) Reset() {
	*x = FeatureView_FeatureRegistrySource{}
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureView_FeatureRegistrySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureView_FeatureRegistrySource) ProtoMessage() {}

func (x *FeatureView_FeatureRegistrySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureView_FeatureRegistrySource.ProtoReflect.Descriptor instead.
func (*FeatureView_FeatureRegistrySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0, 3}
}

func (x *FeatureView_FeatureRegistrySource) GetFeatureGroups() []*FeatureView_FeatureRegistrySource_FeatureGroup {
	if x != nil {
		return x.FeatureGroups
	}
	return nil
}

func (x *FeatureView_FeatureRegistrySource) GetProjectNumber() int64 {
	if x != nil && x.ProjectNumber != nil {
		return *x.ProjectNumber
	}
	return 0
}

// A Vertex Rag source for features that need to be synced to Online
// Store.
type FeatureView_VertexRagSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery view/table URI that will be materialized on each
	// manual sync trigger. The table/view is expected to have the following
	// columns and types at least:
	//   - `corpus_id` (STRING, NULLABLE/REQUIRED)
	//   - `file_id` (STRING, NULLABLE/REQUIRED)
	//   - `chunk_id` (STRING, NULLABLE/REQUIRED)
	//   - `chunk_data_type` (STRING, NULLABLE/REQUIRED)
	//   - `chunk_data` (STRING, NULLABLE/REQUIRED)
	//   - `embeddings` (FLOAT, REPEATED)
	//   - `file_original_uri` (STRING, NULLABLE/REQUIRED)
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Optional. The RAG corpus id corresponding to this FeatureView.
	RagCorpusId int64 `protobuf:"varint,2,opt,name=rag_corpus_id,json=ragCorpusId,proto3" json:"rag_corpus_id,omitempty"`
}

func (x *FeatureView_VertexRagSource) Reset() {
	*x = FeatureView_VertexRagSource{}
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureView_VertexRagSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureView_VertexRagSource) ProtoMessage() {}

func (x *FeatureView_VertexRagSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureView_VertexRagSource.ProtoReflect.Descriptor instead.
func (*FeatureView_VertexRagSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0, 4}
}

func (x *FeatureView_VertexRagSource) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *FeatureView_VertexRagSource) GetRagCorpusId() int64 {
	if x != nil {
		return x.RagCorpusId
	}
	return 0
}

// Configuration for FeatureViews created in Optimized FeatureOnlineStore.
type FeatureView_OptimizedConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A description of resources that the FeatureView uses, which to
	// large degree are decided by Vertex AI, and optionally allows only a
	// modest additional configuration. If min_replica_count is not set, the
	// default value is 2. If max_replica_count is not set, the default value
	// is 6. The max allowed replica count is 1000.
	AutomaticResources *AutomaticResources `protobuf:"bytes,7,opt,name=automatic_resources,json=automaticResources,proto3" json:"automatic_resources,omitempty"`
}

func (x *FeatureView_OptimizedConfig) Reset() {
	*x = FeatureView_OptimizedConfig{}
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureView_OptimizedConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureView_OptimizedConfig) ProtoMessage() {}

func (x *FeatureView_OptimizedConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureView_OptimizedConfig.ProtoReflect.Descriptor instead.
func (*FeatureView_OptimizedConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0, 5}
}

func (x *FeatureView_OptimizedConfig) GetAutomaticResources() *AutomaticResources {
	if x != nil {
		return x.AutomaticResources
	}
	return nil
}

// Metadata for the Cloud Bigtable that supports directly interacting Bigtable
// instances.
type FeatureView_BigtableMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Bigtable App Profile to use for reading from Bigtable.
	ReadAppProfile string `protobuf:"bytes,1,opt,name=read_app_profile,json=readAppProfile,proto3" json:"read_app_profile,omitempty"`
}

func (x *FeatureView_BigtableMetadata) Reset() {
	*x = FeatureView_BigtableMetadata{}
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureView_BigtableMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureView_BigtableMetadata) ProtoMessage() {}

func (x *FeatureView_BigtableMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureView_BigtableMetadata.ProtoReflect.Descriptor instead.
func (*FeatureView_BigtableMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0, 7}
}

func (x *FeatureView_BigtableMetadata) GetReadAppProfile() string {
	if x != nil {
		return x.ReadAppProfile
	}
	return ""
}

// Configuration options for using brute force search.
type FeatureView_IndexConfig_BruteForceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *FeatureView_IndexConfig_BruteForceConfig) Reset() {
	*x = FeatureView_IndexConfig_BruteForceConfig{}
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureView_IndexConfig_BruteForceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureView_IndexConfig_BruteForceConfig) ProtoMessage() {}

func (x *FeatureView_IndexConfig_BruteForceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureView_IndexConfig_BruteForceConfig.ProtoReflect.Descriptor instead.
func (*FeatureView_IndexConfig_BruteForceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0, 2, 0}
}

// Configuration options for the tree-AH algorithm.
type FeatureView_IndexConfig_TreeAHConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Number of embeddings on each leaf node. The default value is
	// 1000 if not set.
	LeafNodeEmbeddingCount *int64 `protobuf:"varint,1,opt,name=leaf_node_embedding_count,json=leafNodeEmbeddingCount,proto3,oneof" json:"leaf_node_embedding_count,omitempty"`
}

func (x *FeatureView_IndexConfig_TreeAHConfig) Reset() {
	*x = FeatureView_IndexConfig_TreeAHConfig{}
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureView_IndexConfig_TreeAHConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureView_IndexConfig_TreeAHConfig) ProtoMessage() {}

func (x *FeatureView_IndexConfig_TreeAHConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureView_IndexConfig_TreeAHConfig.ProtoReflect.Descriptor instead.
func (*FeatureView_IndexConfig_TreeAHConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0, 2, 1}
}

func (x *FeatureView_IndexConfig_TreeAHConfig) GetLeafNodeEmbeddingCount() int64 {
	if x != nil && x.LeafNodeEmbeddingCount != nil {
		return *x.LeafNodeEmbeddingCount
	}
	return 0
}

// Features belonging to a single feature group that will be
// synced to Online Store.
type FeatureView_FeatureRegistrySource_FeatureGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Identifier of the feature group.
	FeatureGroupId string `protobuf:"bytes,1,opt,name=feature_group_id,json=featureGroupId,proto3" json:"feature_group_id,omitempty"`
	// Required. Identifiers of features under the feature group.
	FeatureIds []string `protobuf:"bytes,2,rep,name=feature_ids,json=featureIds,proto3" json:"feature_ids,omitempty"`
}

func (x *FeatureView_FeatureRegistrySource_FeatureGroup) Reset() {
	*x = FeatureView_FeatureRegistrySource_FeatureGroup{}
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureView_FeatureRegistrySource_FeatureGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureView_FeatureRegistrySource_FeatureGroup) ProtoMessage() {}

func (x *FeatureView_FeatureRegistrySource_FeatureGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureView_FeatureRegistrySource_FeatureGroup.ProtoReflect.Descriptor instead.
func (*FeatureView_FeatureRegistrySource_FeatureGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (x *FeatureView_FeatureRegistrySource_FeatureGroup) GetFeatureGroupId() string {
	if x != nil {
		return x.FeatureGroupId
	}
	return ""
}

func (x *FeatureView_FeatureRegistrySource_FeatureGroup) GetFeatureIds() []string {
	if x != nil {
		return x.FeatureIds
	}
	return nil
}

var File_google_cloud_aiplatform_v1_feature_view_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_feature_view_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb0, 0x19, 0x0a,
	0x0b, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x67, 0x0a, 0x10,
	0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x7c, 0x0a, 0x17, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x5f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x2e,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x15, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x6a, 0x0a, 0x11, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x72, 0x61,
	0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61,
	0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0f,
	0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x50, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x53, 0x0a, 0x0b, 0x73, 0x79, 0x6e, 0x63, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0a, 0x73, 0x79, 0x6e, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b, 0x0a, 0x0c,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x67, 0x0a, 0x10, 0x6f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x4f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x6b, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x37, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69,
	0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50,
	0x7a, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f,
	0x70, 0x7a, 0x69, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x12, 0x6a, 0x0a, 0x11,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x2e, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x58, 0x0a, 0x0e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75, 0x72,
	0x69, 0x12, 0x2f, 0x0a, 0x11, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x5f, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x73, 0x1a, 0x45, 0x0a, 0x0a, 0x53, 0x79, 0x6e, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x12, 0x0a, 0x04, 0x63, 0x72, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x63, 0x72, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f,
	0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63,
	0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x1a, 0xf9, 0x06, 0x0a, 0x0b, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6d, 0x0a, 0x0e, 0x74, 0x72, 0x65,
	0x65, 0x5f, 0x61, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x72, 0x65, 0x65, 0x41, 0x48, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x72, 0x65, 0x65,
	0x41, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x79, 0x0a, 0x12, 0x62, 0x72, 0x75, 0x74,
	0x65, 0x5f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x2e, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x42, 0x72, 0x75, 0x74, 0x65, 0x46,
	0x6f, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x10, 0x62, 0x72, 0x75, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x10, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x12, 0x2a, 0x0a, 0x0e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12,
	0x2c, 0x0a, 0x0f, 0x63, 0x72, 0x6f, 0x77, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63,
	0x72, 0x6f, 0x77, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x39, 0x0a,
	0x13, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x01, 0x52, 0x12, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x80, 0x01, 0x0a, 0x15, 0x64, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65,
	0x77, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x12, 0x0a, 0x10, 0x42,
	0x72, 0x75, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a,
	0x71, 0x0a, 0x0c, 0x54, 0x72, 0x65, 0x65, 0x41, 0x48, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x43, 0x0a, 0x19, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x65, 0x6d, 0x62,
	0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x16, 0x6c, 0x65, 0x61, 0x66, 0x4e,
	0x6f, 0x64, 0x65, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x88, 0x01, 0x01, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x22, 0x84, 0x01, 0x0a, 0x13, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x44, 0x49,
	0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4d, 0x45, 0x41, 0x53, 0x55, 0x52, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x51, 0x55, 0x41, 0x52, 0x45, 0x44, 0x5f, 0x4c, 0x32, 0x5f,
	0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x4f,
	0x53, 0x49, 0x4e, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x02, 0x12,
	0x18, 0x0a, 0x14, 0x44, 0x4f, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x5f, 0x44,
	0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x03, 0x42, 0x12, 0x0a, 0x10, 0x61, 0x6c, 0x67,
	0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x16, 0x0a,
	0x14, 0x5f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0xb8, 0x02, 0x0a, 0x15, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x76, 0x0a, 0x0e, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x2f, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x88, 0x01, 0x01, 0x1a, 0x63, 0x0a, 0x0c, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x2d, 0x0a, 0x10, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x49, 0x64, 0x73, 0x42, 0x11, 0x0a,
	0x0f, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x1a, 0x51, 0x0a, 0x0f, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x27, 0x0a, 0x0d, 0x72, 0x61,
	0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75,
	0x73, 0x49, 0x64, 0x1a, 0x77, 0x0a, 0x0f, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x63, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x41, 0x0a, 0x10, 0x42, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2d, 0x0a, 0x10, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64,
	0x41, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0x7b, 0x0a, 0x10, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22,
	0x0a, 0x1e, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x47,
	0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54,
	0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x47,
	0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45,
	0x5f, 0x56, 0x49, 0x45, 0x57, 0x10, 0x02, 0x3a, 0x9b, 0x01, 0xea, 0x41, 0x97, 0x01, 0x0a, 0x25,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x6e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x7d, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0xce, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x42, 0x10, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_feature_view_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_feature_view_proto_rawDescData = file_google_cloud_aiplatform_v1_feature_view_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_feature_view_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_feature_view_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_feature_view_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_feature_view_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_feature_view_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_feature_view_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_aiplatform_v1_feature_view_proto_goTypes = []any{
	(FeatureView_ServiceAgentType)(0),                      // 0: google.cloud.aiplatform.v1.FeatureView.ServiceAgentType
	(FeatureView_IndexConfig_DistanceMeasureType)(0),       // 1: google.cloud.aiplatform.v1.FeatureView.IndexConfig.DistanceMeasureType
	(*FeatureView)(nil),                                    // 2: google.cloud.aiplatform.v1.FeatureView
	(*FeatureView_BigQuerySource)(nil),                     // 3: google.cloud.aiplatform.v1.FeatureView.BigQuerySource
	(*FeatureView_SyncConfig)(nil),                         // 4: google.cloud.aiplatform.v1.FeatureView.SyncConfig
	(*FeatureView_IndexConfig)(nil),                        // 5: google.cloud.aiplatform.v1.FeatureView.IndexConfig
	(*FeatureView_FeatureRegistrySource)(nil),              // 6: google.cloud.aiplatform.v1.FeatureView.FeatureRegistrySource
	(*FeatureView_VertexRagSource)(nil),                    // 7: google.cloud.aiplatform.v1.FeatureView.VertexRagSource
	(*FeatureView_OptimizedConfig)(nil),                    // 8: google.cloud.aiplatform.v1.FeatureView.OptimizedConfig
	nil,                                                    // 9: google.cloud.aiplatform.v1.FeatureView.LabelsEntry
	(*FeatureView_BigtableMetadata)(nil),                   // 10: google.cloud.aiplatform.v1.FeatureView.BigtableMetadata
	(*FeatureView_IndexConfig_BruteForceConfig)(nil),       // 11: google.cloud.aiplatform.v1.FeatureView.IndexConfig.BruteForceConfig
	(*FeatureView_IndexConfig_TreeAHConfig)(nil),           // 12: google.cloud.aiplatform.v1.FeatureView.IndexConfig.TreeAHConfig
	(*FeatureView_FeatureRegistrySource_FeatureGroup)(nil), // 13: google.cloud.aiplatform.v1.FeatureView.FeatureRegistrySource.FeatureGroup
	(*timestamppb.Timestamp)(nil),                          // 14: google.protobuf.Timestamp
	(*AutomaticResources)(nil),                             // 15: google.cloud.aiplatform.v1.AutomaticResources
}
var file_google_cloud_aiplatform_v1_feature_view_proto_depIdxs = []int32{
	3,  // 0: google.cloud.aiplatform.v1.FeatureView.big_query_source:type_name -> google.cloud.aiplatform.v1.FeatureView.BigQuerySource
	6,  // 1: google.cloud.aiplatform.v1.FeatureView.feature_registry_source:type_name -> google.cloud.aiplatform.v1.FeatureView.FeatureRegistrySource
	7,  // 2: google.cloud.aiplatform.v1.FeatureView.vertex_rag_source:type_name -> google.cloud.aiplatform.v1.FeatureView.VertexRagSource
	14, // 3: google.cloud.aiplatform.v1.FeatureView.create_time:type_name -> google.protobuf.Timestamp
	14, // 4: google.cloud.aiplatform.v1.FeatureView.update_time:type_name -> google.protobuf.Timestamp
	9,  // 5: google.cloud.aiplatform.v1.FeatureView.labels:type_name -> google.cloud.aiplatform.v1.FeatureView.LabelsEntry
	4,  // 6: google.cloud.aiplatform.v1.FeatureView.sync_config:type_name -> google.cloud.aiplatform.v1.FeatureView.SyncConfig
	5,  // 7: google.cloud.aiplatform.v1.FeatureView.index_config:type_name -> google.cloud.aiplatform.v1.FeatureView.IndexConfig
	8,  // 8: google.cloud.aiplatform.v1.FeatureView.optimized_config:type_name -> google.cloud.aiplatform.v1.FeatureView.OptimizedConfig
	0,  // 9: google.cloud.aiplatform.v1.FeatureView.service_agent_type:type_name -> google.cloud.aiplatform.v1.FeatureView.ServiceAgentType
	10, // 10: google.cloud.aiplatform.v1.FeatureView.bigtable_metadata:type_name -> google.cloud.aiplatform.v1.FeatureView.BigtableMetadata
	12, // 11: google.cloud.aiplatform.v1.FeatureView.IndexConfig.tree_ah_config:type_name -> google.cloud.aiplatform.v1.FeatureView.IndexConfig.TreeAHConfig
	11, // 12: google.cloud.aiplatform.v1.FeatureView.IndexConfig.brute_force_config:type_name -> google.cloud.aiplatform.v1.FeatureView.IndexConfig.BruteForceConfig
	1,  // 13: google.cloud.aiplatform.v1.FeatureView.IndexConfig.distance_measure_type:type_name -> google.cloud.aiplatform.v1.FeatureView.IndexConfig.DistanceMeasureType
	13, // 14: google.cloud.aiplatform.v1.FeatureView.FeatureRegistrySource.feature_groups:type_name -> google.cloud.aiplatform.v1.FeatureView.FeatureRegistrySource.FeatureGroup
	15, // 15: google.cloud.aiplatform.v1.FeatureView.OptimizedConfig.automatic_resources:type_name -> google.cloud.aiplatform.v1.AutomaticResources
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_feature_view_proto_init() }
func file_google_cloud_aiplatform_v1_feature_view_proto_init() {
	if File_google_cloud_aiplatform_v1_feature_view_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_machine_resources_proto_init()
	file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[0].OneofWrappers = []any{
		(*FeatureView_BigQuerySource_)(nil),
		(*FeatureView_FeatureRegistrySource_)(nil),
		(*FeatureView_VertexRagSource_)(nil),
	}
	file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[3].OneofWrappers = []any{
		(*FeatureView_IndexConfig_TreeAhConfig)(nil),
		(*FeatureView_IndexConfig_BruteForceConfig_)(nil),
	}
	file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[4].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes[10].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_feature_view_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_feature_view_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_feature_view_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1_feature_view_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1_feature_view_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_feature_view_proto = out.File
	file_google_cloud_aiplatform_v1_feature_view_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_feature_view_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_feature_view_proto_depIdxs = nil
}
