// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataplex/v1/catalog.proto

package dataplexpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CatalogService_CreateEntryType_FullMethodName   = "/google.cloud.dataplex.v1.CatalogService/CreateEntryType"
	CatalogService_UpdateEntryType_FullMethodName   = "/google.cloud.dataplex.v1.CatalogService/UpdateEntryType"
	CatalogService_DeleteEntryType_FullMethodName   = "/google.cloud.dataplex.v1.CatalogService/DeleteEntryType"
	CatalogService_ListEntryTypes_FullMethodName    = "/google.cloud.dataplex.v1.CatalogService/ListEntryTypes"
	CatalogService_GetEntryType_FullMethodName      = "/google.cloud.dataplex.v1.CatalogService/GetEntryType"
	CatalogService_CreateAspectType_FullMethodName  = "/google.cloud.dataplex.v1.CatalogService/CreateAspectType"
	CatalogService_UpdateAspectType_FullMethodName  = "/google.cloud.dataplex.v1.CatalogService/UpdateAspectType"
	CatalogService_DeleteAspectType_FullMethodName  = "/google.cloud.dataplex.v1.CatalogService/DeleteAspectType"
	CatalogService_ListAspectTypes_FullMethodName   = "/google.cloud.dataplex.v1.CatalogService/ListAspectTypes"
	CatalogService_GetAspectType_FullMethodName     = "/google.cloud.dataplex.v1.CatalogService/GetAspectType"
	CatalogService_CreateEntryGroup_FullMethodName  = "/google.cloud.dataplex.v1.CatalogService/CreateEntryGroup"
	CatalogService_UpdateEntryGroup_FullMethodName  = "/google.cloud.dataplex.v1.CatalogService/UpdateEntryGroup"
	CatalogService_DeleteEntryGroup_FullMethodName  = "/google.cloud.dataplex.v1.CatalogService/DeleteEntryGroup"
	CatalogService_ListEntryGroups_FullMethodName   = "/google.cloud.dataplex.v1.CatalogService/ListEntryGroups"
	CatalogService_GetEntryGroup_FullMethodName     = "/google.cloud.dataplex.v1.CatalogService/GetEntryGroup"
	CatalogService_CreateEntry_FullMethodName       = "/google.cloud.dataplex.v1.CatalogService/CreateEntry"
	CatalogService_UpdateEntry_FullMethodName       = "/google.cloud.dataplex.v1.CatalogService/UpdateEntry"
	CatalogService_DeleteEntry_FullMethodName       = "/google.cloud.dataplex.v1.CatalogService/DeleteEntry"
	CatalogService_ListEntries_FullMethodName       = "/google.cloud.dataplex.v1.CatalogService/ListEntries"
	CatalogService_GetEntry_FullMethodName          = "/google.cloud.dataplex.v1.CatalogService/GetEntry"
	CatalogService_LookupEntry_FullMethodName       = "/google.cloud.dataplex.v1.CatalogService/LookupEntry"
	CatalogService_SearchEntries_FullMethodName     = "/google.cloud.dataplex.v1.CatalogService/SearchEntries"
	CatalogService_CreateMetadataJob_FullMethodName = "/google.cloud.dataplex.v1.CatalogService/CreateMetadataJob"
	CatalogService_GetMetadataJob_FullMethodName    = "/google.cloud.dataplex.v1.CatalogService/GetMetadataJob"
	CatalogService_ListMetadataJobs_FullMethodName  = "/google.cloud.dataplex.v1.CatalogService/ListMetadataJobs"
	CatalogService_CancelMetadataJob_FullMethodName = "/google.cloud.dataplex.v1.CatalogService/CancelMetadataJob"
	CatalogService_CreateEntryLink_FullMethodName   = "/google.cloud.dataplex.v1.CatalogService/CreateEntryLink"
	CatalogService_DeleteEntryLink_FullMethodName   = "/google.cloud.dataplex.v1.CatalogService/DeleteEntryLink"
	CatalogService_GetEntryLink_FullMethodName      = "/google.cloud.dataplex.v1.CatalogService/GetEntryLink"
)

// CatalogServiceClient is the client API for CatalogService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CatalogServiceClient interface {
	// Creates an EntryType.
	CreateEntryType(ctx context.Context, in *CreateEntryTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an EntryType.
	UpdateEntryType(ctx context.Context, in *UpdateEntryTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an EntryType.
	DeleteEntryType(ctx context.Context, in *DeleteEntryTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists EntryType resources in a project and location.
	ListEntryTypes(ctx context.Context, in *ListEntryTypesRequest, opts ...grpc.CallOption) (*ListEntryTypesResponse, error)
	// Gets an EntryType.
	GetEntryType(ctx context.Context, in *GetEntryTypeRequest, opts ...grpc.CallOption) (*EntryType, error)
	// Creates an AspectType.
	CreateAspectType(ctx context.Context, in *CreateAspectTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an AspectType.
	UpdateAspectType(ctx context.Context, in *UpdateAspectTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an AspectType.
	DeleteAspectType(ctx context.Context, in *DeleteAspectTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists AspectType resources in a project and location.
	ListAspectTypes(ctx context.Context, in *ListAspectTypesRequest, opts ...grpc.CallOption) (*ListAspectTypesResponse, error)
	// Gets an AspectType.
	GetAspectType(ctx context.Context, in *GetAspectTypeRequest, opts ...grpc.CallOption) (*AspectType, error)
	// Creates an EntryGroup.
	CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an EntryGroup.
	UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an EntryGroup.
	DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists EntryGroup resources in a project and location.
	ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error)
	// Gets an EntryGroup.
	GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Creates an Entry.
	CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Updates an Entry.
	UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deletes an Entry.
	DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Lists Entries within an EntryGroup.
	// Caution: The Vertex AI, Bigtable, Spanner, Pub/Sub, Dataform, and Dataproc
	// Metastore metadata that is stored in Dataplex Universal Catalog is
	// changing. For more information, see [Changes to metadata stored in
	// Dataplex Universal
	// Catalog](https://cloud.google.com/dataplex/docs/metadata-changes).
	ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error)
	// Gets an Entry.
	// Caution: The Vertex AI, Bigtable, Spanner, Pub/Sub, Dataform, and Dataproc
	// Metastore metadata that is stored in Dataplex Universal Catalog is
	// changing. For more information, see [Changes to metadata stored in
	// Dataplex Universal
	// Catalog](https://cloud.google.com/dataplex/docs/metadata-changes).
	GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Looks up an entry by name using the permission on the source system.
	// Caution: The Vertex AI, Bigtable, Spanner, Pub/Sub, Dataform, and Dataproc
	// Metastore metadata that is stored in Dataplex Universal Catalog is
	// changing. For more information, see [Changes to metadata stored in
	// Dataplex Universal
	// Catalog](https://cloud.google.com/dataplex/docs/metadata-changes).
	LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Searches for Entries matching the given query and scope.
	SearchEntries(ctx context.Context, in *SearchEntriesRequest, opts ...grpc.CallOption) (*SearchEntriesResponse, error)
	// Creates a metadata job. For example, use a metadata job to import metadata
	// from a third-party system into Dataplex Universal Catalog.
	CreateMetadataJob(ctx context.Context, in *CreateMetadataJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a metadata job.
	GetMetadataJob(ctx context.Context, in *GetMetadataJobRequest, opts ...grpc.CallOption) (*MetadataJob, error)
	// Lists metadata jobs.
	ListMetadataJobs(ctx context.Context, in *ListMetadataJobsRequest, opts ...grpc.CallOption) (*ListMetadataJobsResponse, error)
	// Cancels a metadata job.
	//
	// If you cancel a metadata import job that is in progress, the changes in the
	// job might be partially applied. We recommend that you reset the state of
	// the entry groups in your project by running another metadata job that
	// reverts the changes from the canceled job.
	CancelMetadataJob(ctx context.Context, in *CancelMetadataJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates an Entry Link.
	CreateEntryLink(ctx context.Context, in *CreateEntryLinkRequest, opts ...grpc.CallOption) (*EntryLink, error)
	// Deletes an Entry Link.
	DeleteEntryLink(ctx context.Context, in *DeleteEntryLinkRequest, opts ...grpc.CallOption) (*EntryLink, error)
	// Gets an Entry Link.
	GetEntryLink(ctx context.Context, in *GetEntryLinkRequest, opts ...grpc.CallOption) (*EntryLink, error)
}

type catalogServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCatalogServiceClient(cc grpc.ClientConnInterface) CatalogServiceClient {
	return &catalogServiceClient{cc}
}

func (c *catalogServiceClient) CreateEntryType(ctx context.Context, in *CreateEntryTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CatalogService_CreateEntryType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateEntryType(ctx context.Context, in *UpdateEntryTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CatalogService_UpdateEntryType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) DeleteEntryType(ctx context.Context, in *DeleteEntryTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CatalogService_DeleteEntryType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) ListEntryTypes(ctx context.Context, in *ListEntryTypesRequest, opts ...grpc.CallOption) (*ListEntryTypesResponse, error) {
	out := new(ListEntryTypesResponse)
	err := c.cc.Invoke(ctx, CatalogService_ListEntryTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetEntryType(ctx context.Context, in *GetEntryTypeRequest, opts ...grpc.CallOption) (*EntryType, error) {
	out := new(EntryType)
	err := c.cc.Invoke(ctx, CatalogService_GetEntryType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) CreateAspectType(ctx context.Context, in *CreateAspectTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CatalogService_CreateAspectType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateAspectType(ctx context.Context, in *UpdateAspectTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CatalogService_UpdateAspectType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) DeleteAspectType(ctx context.Context, in *DeleteAspectTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CatalogService_DeleteAspectType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) ListAspectTypes(ctx context.Context, in *ListAspectTypesRequest, opts ...grpc.CallOption) (*ListAspectTypesResponse, error) {
	out := new(ListAspectTypesResponse)
	err := c.cc.Invoke(ctx, CatalogService_ListAspectTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetAspectType(ctx context.Context, in *GetAspectTypeRequest, opts ...grpc.CallOption) (*AspectType, error) {
	out := new(AspectType)
	err := c.cc.Invoke(ctx, CatalogService_GetAspectType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CatalogService_CreateEntryGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CatalogService_UpdateEntryGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CatalogService_DeleteEntryGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error) {
	out := new(ListEntryGroupsResponse)
	err := c.cc.Invoke(ctx, CatalogService_ListEntryGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, CatalogService_GetEntryGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, CatalogService_CreateEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, CatalogService_UpdateEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, CatalogService_DeleteEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error) {
	out := new(ListEntriesResponse)
	err := c.cc.Invoke(ctx, CatalogService_ListEntries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, CatalogService_GetEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, CatalogService_LookupEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) SearchEntries(ctx context.Context, in *SearchEntriesRequest, opts ...grpc.CallOption) (*SearchEntriesResponse, error) {
	out := new(SearchEntriesResponse)
	err := c.cc.Invoke(ctx, CatalogService_SearchEntries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) CreateMetadataJob(ctx context.Context, in *CreateMetadataJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CatalogService_CreateMetadataJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetMetadataJob(ctx context.Context, in *GetMetadataJobRequest, opts ...grpc.CallOption) (*MetadataJob, error) {
	out := new(MetadataJob)
	err := c.cc.Invoke(ctx, CatalogService_GetMetadataJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) ListMetadataJobs(ctx context.Context, in *ListMetadataJobsRequest, opts ...grpc.CallOption) (*ListMetadataJobsResponse, error) {
	out := new(ListMetadataJobsResponse)
	err := c.cc.Invoke(ctx, CatalogService_ListMetadataJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) CancelMetadataJob(ctx context.Context, in *CancelMetadataJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CatalogService_CancelMetadataJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) CreateEntryLink(ctx context.Context, in *CreateEntryLinkRequest, opts ...grpc.CallOption) (*EntryLink, error) {
	out := new(EntryLink)
	err := c.cc.Invoke(ctx, CatalogService_CreateEntryLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) DeleteEntryLink(ctx context.Context, in *DeleteEntryLinkRequest, opts ...grpc.CallOption) (*EntryLink, error) {
	out := new(EntryLink)
	err := c.cc.Invoke(ctx, CatalogService_DeleteEntryLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetEntryLink(ctx context.Context, in *GetEntryLinkRequest, opts ...grpc.CallOption) (*EntryLink, error) {
	out := new(EntryLink)
	err := c.cc.Invoke(ctx, CatalogService_GetEntryLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CatalogServiceServer is the server API for CatalogService service.
// All implementations should embed UnimplementedCatalogServiceServer
// for forward compatibility
type CatalogServiceServer interface {
	// Creates an EntryType.
	CreateEntryType(context.Context, *CreateEntryTypeRequest) (*longrunningpb.Operation, error)
	// Updates an EntryType.
	UpdateEntryType(context.Context, *UpdateEntryTypeRequest) (*longrunningpb.Operation, error)
	// Deletes an EntryType.
	DeleteEntryType(context.Context, *DeleteEntryTypeRequest) (*longrunningpb.Operation, error)
	// Lists EntryType resources in a project and location.
	ListEntryTypes(context.Context, *ListEntryTypesRequest) (*ListEntryTypesResponse, error)
	// Gets an EntryType.
	GetEntryType(context.Context, *GetEntryTypeRequest) (*EntryType, error)
	// Creates an AspectType.
	CreateAspectType(context.Context, *CreateAspectTypeRequest) (*longrunningpb.Operation, error)
	// Updates an AspectType.
	UpdateAspectType(context.Context, *UpdateAspectTypeRequest) (*longrunningpb.Operation, error)
	// Deletes an AspectType.
	DeleteAspectType(context.Context, *DeleteAspectTypeRequest) (*longrunningpb.Operation, error)
	// Lists AspectType resources in a project and location.
	ListAspectTypes(context.Context, *ListAspectTypesRequest) (*ListAspectTypesResponse, error)
	// Gets an AspectType.
	GetAspectType(context.Context, *GetAspectTypeRequest) (*AspectType, error)
	// Creates an EntryGroup.
	CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*longrunningpb.Operation, error)
	// Updates an EntryGroup.
	UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*longrunningpb.Operation, error)
	// Deletes an EntryGroup.
	DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*longrunningpb.Operation, error)
	// Lists EntryGroup resources in a project and location.
	ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error)
	// Gets an EntryGroup.
	GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error)
	// Creates an Entry.
	CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error)
	// Updates an Entry.
	UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error)
	// Deletes an Entry.
	DeleteEntry(context.Context, *DeleteEntryRequest) (*Entry, error)
	// Lists Entries within an EntryGroup.
	// Caution: The Vertex AI, Bigtable, Spanner, Pub/Sub, Dataform, and Dataproc
	// Metastore metadata that is stored in Dataplex Universal Catalog is
	// changing. For more information, see [Changes to metadata stored in
	// Dataplex Universal
	// Catalog](https://cloud.google.com/dataplex/docs/metadata-changes).
	ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error)
	// Gets an Entry.
	// Caution: The Vertex AI, Bigtable, Spanner, Pub/Sub, Dataform, and Dataproc
	// Metastore metadata that is stored in Dataplex Universal Catalog is
	// changing. For more information, see [Changes to metadata stored in
	// Dataplex Universal
	// Catalog](https://cloud.google.com/dataplex/docs/metadata-changes).
	GetEntry(context.Context, *GetEntryRequest) (*Entry, error)
	// Looks up an entry by name using the permission on the source system.
	// Caution: The Vertex AI, Bigtable, Spanner, Pub/Sub, Dataform, and Dataproc
	// Metastore metadata that is stored in Dataplex Universal Catalog is
	// changing. For more information, see [Changes to metadata stored in
	// Dataplex Universal
	// Catalog](https://cloud.google.com/dataplex/docs/metadata-changes).
	LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error)
	// Searches for Entries matching the given query and scope.
	SearchEntries(context.Context, *SearchEntriesRequest) (*SearchEntriesResponse, error)
	// Creates a metadata job. For example, use a metadata job to import metadata
	// from a third-party system into Dataplex Universal Catalog.
	CreateMetadataJob(context.Context, *CreateMetadataJobRequest) (*longrunningpb.Operation, error)
	// Gets a metadata job.
	GetMetadataJob(context.Context, *GetMetadataJobRequest) (*MetadataJob, error)
	// Lists metadata jobs.
	ListMetadataJobs(context.Context, *ListMetadataJobsRequest) (*ListMetadataJobsResponse, error)
	// Cancels a metadata job.
	//
	// If you cancel a metadata import job that is in progress, the changes in the
	// job might be partially applied. We recommend that you reset the state of
	// the entry groups in your project by running another metadata job that
	// reverts the changes from the canceled job.
	CancelMetadataJob(context.Context, *CancelMetadataJobRequest) (*emptypb.Empty, error)
	// Creates an Entry Link.
	CreateEntryLink(context.Context, *CreateEntryLinkRequest) (*EntryLink, error)
	// Deletes an Entry Link.
	DeleteEntryLink(context.Context, *DeleteEntryLinkRequest) (*EntryLink, error)
	// Gets an Entry Link.
	GetEntryLink(context.Context, *GetEntryLinkRequest) (*EntryLink, error)
}

// UnimplementedCatalogServiceServer should be embedded to have forward compatible implementations.
type UnimplementedCatalogServiceServer struct {
}

func (UnimplementedCatalogServiceServer) CreateEntryType(context.Context, *CreateEntryTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntryType not implemented")
}
func (UnimplementedCatalogServiceServer) UpdateEntryType(context.Context, *UpdateEntryTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntryType not implemented")
}
func (UnimplementedCatalogServiceServer) DeleteEntryType(context.Context, *DeleteEntryTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntryType not implemented")
}
func (UnimplementedCatalogServiceServer) ListEntryTypes(context.Context, *ListEntryTypesRequest) (*ListEntryTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntryTypes not implemented")
}
func (UnimplementedCatalogServiceServer) GetEntryType(context.Context, *GetEntryTypeRequest) (*EntryType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntryType not implemented")
}
func (UnimplementedCatalogServiceServer) CreateAspectType(context.Context, *CreateAspectTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAspectType not implemented")
}
func (UnimplementedCatalogServiceServer) UpdateAspectType(context.Context, *UpdateAspectTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAspectType not implemented")
}
func (UnimplementedCatalogServiceServer) DeleteAspectType(context.Context, *DeleteAspectTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAspectType not implemented")
}
func (UnimplementedCatalogServiceServer) ListAspectTypes(context.Context, *ListAspectTypesRequest) (*ListAspectTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAspectTypes not implemented")
}
func (UnimplementedCatalogServiceServer) GetAspectType(context.Context, *GetAspectTypeRequest) (*AspectType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAspectType not implemented")
}
func (UnimplementedCatalogServiceServer) CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntryGroup not implemented")
}
func (UnimplementedCatalogServiceServer) UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntryGroup not implemented")
}
func (UnimplementedCatalogServiceServer) DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntryGroup not implemented")
}
func (UnimplementedCatalogServiceServer) ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntryGroups not implemented")
}
func (UnimplementedCatalogServiceServer) GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntryGroup not implemented")
}
func (UnimplementedCatalogServiceServer) CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntry not implemented")
}
func (UnimplementedCatalogServiceServer) UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntry not implemented")
}
func (UnimplementedCatalogServiceServer) DeleteEntry(context.Context, *DeleteEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntry not implemented")
}
func (UnimplementedCatalogServiceServer) ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntries not implemented")
}
func (UnimplementedCatalogServiceServer) GetEntry(context.Context, *GetEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntry not implemented")
}
func (UnimplementedCatalogServiceServer) LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEntry not implemented")
}
func (UnimplementedCatalogServiceServer) SearchEntries(context.Context, *SearchEntriesRequest) (*SearchEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchEntries not implemented")
}
func (UnimplementedCatalogServiceServer) CreateMetadataJob(context.Context, *CreateMetadataJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMetadataJob not implemented")
}
func (UnimplementedCatalogServiceServer) GetMetadataJob(context.Context, *GetMetadataJobRequest) (*MetadataJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetadataJob not implemented")
}
func (UnimplementedCatalogServiceServer) ListMetadataJobs(context.Context, *ListMetadataJobsRequest) (*ListMetadataJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMetadataJobs not implemented")
}
func (UnimplementedCatalogServiceServer) CancelMetadataJob(context.Context, *CancelMetadataJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelMetadataJob not implemented")
}
func (UnimplementedCatalogServiceServer) CreateEntryLink(context.Context, *CreateEntryLinkRequest) (*EntryLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntryLink not implemented")
}
func (UnimplementedCatalogServiceServer) DeleteEntryLink(context.Context, *DeleteEntryLinkRequest) (*EntryLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntryLink not implemented")
}
func (UnimplementedCatalogServiceServer) GetEntryLink(context.Context, *GetEntryLinkRequest) (*EntryLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntryLink not implemented")
}

// UnsafeCatalogServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CatalogServiceServer will
// result in compilation errors.
type UnsafeCatalogServiceServer interface {
	mustEmbedUnimplementedCatalogServiceServer()
}

func RegisterCatalogServiceServer(s grpc.ServiceRegistrar, srv CatalogServiceServer) {
	s.RegisterService(&CatalogService_ServiceDesc, srv)
}

func _CatalogService_CreateEntryType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).CreateEntryType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_CreateEntryType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).CreateEntryType(ctx, req.(*CreateEntryTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateEntryType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateEntryType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_UpdateEntryType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateEntryType(ctx, req.(*UpdateEntryTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_DeleteEntryType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).DeleteEntryType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_DeleteEntryType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).DeleteEntryType(ctx, req.(*DeleteEntryTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_ListEntryTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntryTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ListEntryTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_ListEntryTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ListEntryTypes(ctx, req.(*ListEntryTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetEntryType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetEntryType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_GetEntryType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetEntryType(ctx, req.(*GetEntryTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_CreateAspectType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAspectTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).CreateAspectType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_CreateAspectType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).CreateAspectType(ctx, req.(*CreateAspectTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateAspectType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAspectTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateAspectType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_UpdateAspectType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateAspectType(ctx, req.(*UpdateAspectTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_DeleteAspectType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAspectTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).DeleteAspectType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_DeleteAspectType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).DeleteAspectType(ctx, req.(*DeleteAspectTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_ListAspectTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAspectTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ListAspectTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_ListAspectTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ListAspectTypes(ctx, req.(*ListAspectTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetAspectType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAspectTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetAspectType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_GetAspectType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetAspectType(ctx, req.(*GetAspectTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_CreateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).CreateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_CreateEntryGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).CreateEntryGroup(ctx, req.(*CreateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_UpdateEntryGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateEntryGroup(ctx, req.(*UpdateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_DeleteEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).DeleteEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_DeleteEntryGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).DeleteEntryGroup(ctx, req.(*DeleteEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_ListEntryGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntryGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ListEntryGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_ListEntryGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ListEntryGroups(ctx, req.(*ListEntryGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_GetEntryGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetEntryGroup(ctx, req.(*GetEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_CreateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).CreateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_CreateEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).CreateEntry(ctx, req.(*CreateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_UpdateEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateEntry(ctx, req.(*UpdateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_DeleteEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).DeleteEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_DeleteEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).DeleteEntry(ctx, req.(*DeleteEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_ListEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ListEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_ListEntries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ListEntries(ctx, req.(*ListEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_GetEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetEntry(ctx, req.(*GetEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_LookupEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).LookupEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_LookupEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).LookupEntry(ctx, req.(*LookupEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_SearchEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).SearchEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_SearchEntries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).SearchEntries(ctx, req.(*SearchEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_CreateMetadataJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMetadataJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).CreateMetadataJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_CreateMetadataJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).CreateMetadataJob(ctx, req.(*CreateMetadataJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetMetadataJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetadataJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetMetadataJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_GetMetadataJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetMetadataJob(ctx, req.(*GetMetadataJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_ListMetadataJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetadataJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ListMetadataJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_ListMetadataJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ListMetadataJobs(ctx, req.(*ListMetadataJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_CancelMetadataJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelMetadataJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).CancelMetadataJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_CancelMetadataJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).CancelMetadataJob(ctx, req.(*CancelMetadataJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_CreateEntryLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).CreateEntryLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_CreateEntryLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).CreateEntryLink(ctx, req.(*CreateEntryLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_DeleteEntryLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).DeleteEntryLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_DeleteEntryLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).DeleteEntryLink(ctx, req.(*DeleteEntryLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetEntryLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetEntryLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_GetEntryLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetEntryLink(ctx, req.(*GetEntryLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CatalogService_ServiceDesc is the grpc.ServiceDesc for CatalogService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CatalogService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataplex.v1.CatalogService",
	HandlerType: (*CatalogServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateEntryType",
			Handler:    _CatalogService_CreateEntryType_Handler,
		},
		{
			MethodName: "UpdateEntryType",
			Handler:    _CatalogService_UpdateEntryType_Handler,
		},
		{
			MethodName: "DeleteEntryType",
			Handler:    _CatalogService_DeleteEntryType_Handler,
		},
		{
			MethodName: "ListEntryTypes",
			Handler:    _CatalogService_ListEntryTypes_Handler,
		},
		{
			MethodName: "GetEntryType",
			Handler:    _CatalogService_GetEntryType_Handler,
		},
		{
			MethodName: "CreateAspectType",
			Handler:    _CatalogService_CreateAspectType_Handler,
		},
		{
			MethodName: "UpdateAspectType",
			Handler:    _CatalogService_UpdateAspectType_Handler,
		},
		{
			MethodName: "DeleteAspectType",
			Handler:    _CatalogService_DeleteAspectType_Handler,
		},
		{
			MethodName: "ListAspectTypes",
			Handler:    _CatalogService_ListAspectTypes_Handler,
		},
		{
			MethodName: "GetAspectType",
			Handler:    _CatalogService_GetAspectType_Handler,
		},
		{
			MethodName: "CreateEntryGroup",
			Handler:    _CatalogService_CreateEntryGroup_Handler,
		},
		{
			MethodName: "UpdateEntryGroup",
			Handler:    _CatalogService_UpdateEntryGroup_Handler,
		},
		{
			MethodName: "DeleteEntryGroup",
			Handler:    _CatalogService_DeleteEntryGroup_Handler,
		},
		{
			MethodName: "ListEntryGroups",
			Handler:    _CatalogService_ListEntryGroups_Handler,
		},
		{
			MethodName: "GetEntryGroup",
			Handler:    _CatalogService_GetEntryGroup_Handler,
		},
		{
			MethodName: "CreateEntry",
			Handler:    _CatalogService_CreateEntry_Handler,
		},
		{
			MethodName: "UpdateEntry",
			Handler:    _CatalogService_UpdateEntry_Handler,
		},
		{
			MethodName: "DeleteEntry",
			Handler:    _CatalogService_DeleteEntry_Handler,
		},
		{
			MethodName: "ListEntries",
			Handler:    _CatalogService_ListEntries_Handler,
		},
		{
			MethodName: "GetEntry",
			Handler:    _CatalogService_GetEntry_Handler,
		},
		{
			MethodName: "LookupEntry",
			Handler:    _CatalogService_LookupEntry_Handler,
		},
		{
			MethodName: "SearchEntries",
			Handler:    _CatalogService_SearchEntries_Handler,
		},
		{
			MethodName: "CreateMetadataJob",
			Handler:    _CatalogService_CreateMetadataJob_Handler,
		},
		{
			MethodName: "GetMetadataJob",
			Handler:    _CatalogService_GetMetadataJob_Handler,
		},
		{
			MethodName: "ListMetadataJobs",
			Handler:    _CatalogService_ListMetadataJobs_Handler,
		},
		{
			MethodName: "CancelMetadataJob",
			Handler:    _CatalogService_CancelMetadataJob_Handler,
		},
		{
			MethodName: "CreateEntryLink",
			Handler:    _CatalogService_CreateEntryLink_Handler,
		},
		{
			MethodName: "DeleteEntryLink",
			Handler:    _CatalogService_DeleteEntryLink_Handler,
		},
		{
			MethodName: "GetEntryLink",
			Handler:    _CatalogService_GetEntryLink_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataplex/v1/catalog.proto",
}
