// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of log groups in the Region in your account. If you are
// performing this action in a monitoring account, you can choose to also return
// log groups from source accounts that are linked to the monitoring account. For
// more information about using cross-account observability to set up monitoring
// accounts and source accounts, see [CloudWatch cross-account observability].
//
// You can optionally filter the list by log group class and by using regular
// expressions in your request to match strings in the log group names.
//
// This operation is paginated. By default, your first use of this operation
// returns 50 results, and includes a token to use in a subsequent operation to
// return more results.
//
// [CloudWatch cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
func (c *Client) ListLogGroups(ctx context.Context, params *ListLogGroupsInput, optFns ...func(*Options)) (*ListLogGroupsOutput, error) {
	if params == nil {
		params = &ListLogGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListLogGroups", params, optFns, c.addOperationListLogGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListLogGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListLogGroupsInput struct {

	// When includeLinkedAccounts is set to true , use this parameter to specify the
	// list of accounts to search. You can specify as many as 20 account IDs in the
	// array.
	AccountIdentifiers []string

	// If you are using a monitoring account, set this to true to have the operation
	// return log groups in the accounts listed in accountIdentifiers .
	//
	// If this parameter is set to true and accountIdentifiers contains a null value,
	// the operation returns all log groups in the monitoring account and all log
	// groups in all source accounts that are linked to the monitoring account.
	//
	// The default for this parameter is false .
	IncludeLinkedAccounts *bool

	// The maximum number of log groups to return. If you omit this parameter, the
	// default is up to 50 log groups.
	Limit *int32

	// Use this parameter to limit the results to only those log groups in the
	// specified log group class. If you omit this parameter, log groups of all classes
	// can be returned.
	LogGroupClass types.LogGroupClass

	// Use this parameter to limit the returned log groups to only those with names
	// that match the pattern that you specify. This parameter is a regular expression
	// that can match prefixes and substrings, and supports wildcard matching and
	// matching multiple patterns, as in the following examples.
	//
	//   - Use ^ to match log group names by prefix.
	//
	//   - For a substring match, specify the string to match. All matches are case
	//   sensitive
	//
	//   - To match multiple patterns, separate them with a | as in the example
	//   ^/aws/lambda|discovery
	//
	// You can specify as many as five different regular expression patterns in this
	// field, each of which must be between 3 and 24 characters. You can include the ^
	// symbol as many as five times, and include the | symbol as many as four times.
	LogGroupNamePattern *string

	// The token for the next set of items to return. The token expires after 24 hours.
	NextToken *string

	noSmithyDocumentSerde
}

type ListLogGroupsOutput struct {

	// An array of structures, where each structure contains the information about one
	// log group.
	LogGroups []types.LogGroupSummary

	// The token for the next set of items to return. The token expires after 24 hours.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListLogGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListLogGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListLogGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListLogGroups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListLogGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListLogGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListLogGroups",
	}
}
