// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/apigeeregistry/v1/registry_service.proto

package apigeeregistrypb

import (
	context "context"

	httpbody "google.golang.org/genproto/googleapis/api/httpbody"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Registry_ListApis_FullMethodName                    = "/google.cloud.apigeeregistry.v1.Registry/ListApis"
	Registry_GetApi_FullMethodName                      = "/google.cloud.apigeeregistry.v1.Registry/GetApi"
	Registry_CreateApi_FullMethodName                   = "/google.cloud.apigeeregistry.v1.Registry/CreateApi"
	Registry_UpdateApi_FullMethodName                   = "/google.cloud.apigeeregistry.v1.Registry/UpdateApi"
	Registry_DeleteApi_FullMethodName                   = "/google.cloud.apigeeregistry.v1.Registry/DeleteApi"
	Registry_ListApiVersions_FullMethodName             = "/google.cloud.apigeeregistry.v1.Registry/ListApiVersions"
	Registry_GetApiVersion_FullMethodName               = "/google.cloud.apigeeregistry.v1.Registry/GetApiVersion"
	Registry_CreateApiVersion_FullMethodName            = "/google.cloud.apigeeregistry.v1.Registry/CreateApiVersion"
	Registry_UpdateApiVersion_FullMethodName            = "/google.cloud.apigeeregistry.v1.Registry/UpdateApiVersion"
	Registry_DeleteApiVersion_FullMethodName            = "/google.cloud.apigeeregistry.v1.Registry/DeleteApiVersion"
	Registry_ListApiSpecs_FullMethodName                = "/google.cloud.apigeeregistry.v1.Registry/ListApiSpecs"
	Registry_GetApiSpec_FullMethodName                  = "/google.cloud.apigeeregistry.v1.Registry/GetApiSpec"
	Registry_GetApiSpecContents_FullMethodName          = "/google.cloud.apigeeregistry.v1.Registry/GetApiSpecContents"
	Registry_CreateApiSpec_FullMethodName               = "/google.cloud.apigeeregistry.v1.Registry/CreateApiSpec"
	Registry_UpdateApiSpec_FullMethodName               = "/google.cloud.apigeeregistry.v1.Registry/UpdateApiSpec"
	Registry_DeleteApiSpec_FullMethodName               = "/google.cloud.apigeeregistry.v1.Registry/DeleteApiSpec"
	Registry_TagApiSpecRevision_FullMethodName          = "/google.cloud.apigeeregistry.v1.Registry/TagApiSpecRevision"
	Registry_ListApiSpecRevisions_FullMethodName        = "/google.cloud.apigeeregistry.v1.Registry/ListApiSpecRevisions"
	Registry_RollbackApiSpec_FullMethodName             = "/google.cloud.apigeeregistry.v1.Registry/RollbackApiSpec"
	Registry_DeleteApiSpecRevision_FullMethodName       = "/google.cloud.apigeeregistry.v1.Registry/DeleteApiSpecRevision"
	Registry_ListApiDeployments_FullMethodName          = "/google.cloud.apigeeregistry.v1.Registry/ListApiDeployments"
	Registry_GetApiDeployment_FullMethodName            = "/google.cloud.apigeeregistry.v1.Registry/GetApiDeployment"
	Registry_CreateApiDeployment_FullMethodName         = "/google.cloud.apigeeregistry.v1.Registry/CreateApiDeployment"
	Registry_UpdateApiDeployment_FullMethodName         = "/google.cloud.apigeeregistry.v1.Registry/UpdateApiDeployment"
	Registry_DeleteApiDeployment_FullMethodName         = "/google.cloud.apigeeregistry.v1.Registry/DeleteApiDeployment"
	Registry_TagApiDeploymentRevision_FullMethodName    = "/google.cloud.apigeeregistry.v1.Registry/TagApiDeploymentRevision"
	Registry_ListApiDeploymentRevisions_FullMethodName  = "/google.cloud.apigeeregistry.v1.Registry/ListApiDeploymentRevisions"
	Registry_RollbackApiDeployment_FullMethodName       = "/google.cloud.apigeeregistry.v1.Registry/RollbackApiDeployment"
	Registry_DeleteApiDeploymentRevision_FullMethodName = "/google.cloud.apigeeregistry.v1.Registry/DeleteApiDeploymentRevision"
	Registry_ListArtifacts_FullMethodName               = "/google.cloud.apigeeregistry.v1.Registry/ListArtifacts"
	Registry_GetArtifact_FullMethodName                 = "/google.cloud.apigeeregistry.v1.Registry/GetArtifact"
	Registry_GetArtifactContents_FullMethodName         = "/google.cloud.apigeeregistry.v1.Registry/GetArtifactContents"
	Registry_CreateArtifact_FullMethodName              = "/google.cloud.apigeeregistry.v1.Registry/CreateArtifact"
	Registry_ReplaceArtifact_FullMethodName             = "/google.cloud.apigeeregistry.v1.Registry/ReplaceArtifact"
	Registry_DeleteArtifact_FullMethodName              = "/google.cloud.apigeeregistry.v1.Registry/DeleteArtifact"
)

// RegistryClient is the client API for Registry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RegistryClient interface {
	// Returns matching APIs.
	ListApis(ctx context.Context, in *ListApisRequest, opts ...grpc.CallOption) (*ListApisResponse, error)
	// Returns a specified API.
	GetApi(ctx context.Context, in *GetApiRequest, opts ...grpc.CallOption) (*Api, error)
	// Creates a specified API.
	CreateApi(ctx context.Context, in *CreateApiRequest, opts ...grpc.CallOption) (*Api, error)
	// Used to modify a specified API.
	UpdateApi(ctx context.Context, in *UpdateApiRequest, opts ...grpc.CallOption) (*Api, error)
	// Removes a specified API and all of the resources that it
	// owns.
	DeleteApi(ctx context.Context, in *DeleteApiRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns matching versions.
	ListApiVersions(ctx context.Context, in *ListApiVersionsRequest, opts ...grpc.CallOption) (*ListApiVersionsResponse, error)
	// Returns a specified version.
	GetApiVersion(ctx context.Context, in *GetApiVersionRequest, opts ...grpc.CallOption) (*ApiVersion, error)
	// Creates a specified version.
	CreateApiVersion(ctx context.Context, in *CreateApiVersionRequest, opts ...grpc.CallOption) (*ApiVersion, error)
	// Used to modify a specified version.
	UpdateApiVersion(ctx context.Context, in *UpdateApiVersionRequest, opts ...grpc.CallOption) (*ApiVersion, error)
	// Removes a specified version and all of the resources that
	// it owns.
	DeleteApiVersion(ctx context.Context, in *DeleteApiVersionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns matching specs.
	ListApiSpecs(ctx context.Context, in *ListApiSpecsRequest, opts ...grpc.CallOption) (*ListApiSpecsResponse, error)
	// Returns a specified spec.
	GetApiSpec(ctx context.Context, in *GetApiSpecRequest, opts ...grpc.CallOption) (*ApiSpec, error)
	// Returns the contents of a specified spec.
	// If specs are stored with GZip compression, the default behavior
	// is to return the spec uncompressed (the mime_type response field
	// indicates the exact format returned).
	GetApiSpecContents(ctx context.Context, in *GetApiSpecContentsRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error)
	// Creates a specified spec.
	CreateApiSpec(ctx context.Context, in *CreateApiSpecRequest, opts ...grpc.CallOption) (*ApiSpec, error)
	// Used to modify a specified spec.
	UpdateApiSpec(ctx context.Context, in *UpdateApiSpecRequest, opts ...grpc.CallOption) (*ApiSpec, error)
	// Removes a specified spec, all revisions, and all child
	// resources (e.g., artifacts).
	DeleteApiSpec(ctx context.Context, in *DeleteApiSpecRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Adds a tag to a specified revision of a spec.
	TagApiSpecRevision(ctx context.Context, in *TagApiSpecRevisionRequest, opts ...grpc.CallOption) (*ApiSpec, error)
	// Lists all revisions of a spec.
	// Revisions are returned in descending order of revision creation time.
	ListApiSpecRevisions(ctx context.Context, in *ListApiSpecRevisionsRequest, opts ...grpc.CallOption) (*ListApiSpecRevisionsResponse, error)
	// Sets the current revision to a specified prior revision.
	// Note that this creates a new revision with a new revision ID.
	RollbackApiSpec(ctx context.Context, in *RollbackApiSpecRequest, opts ...grpc.CallOption) (*ApiSpec, error)
	// Deletes a revision of a spec.
	DeleteApiSpecRevision(ctx context.Context, in *DeleteApiSpecRevisionRequest, opts ...grpc.CallOption) (*ApiSpec, error)
	// Returns matching deployments.
	ListApiDeployments(ctx context.Context, in *ListApiDeploymentsRequest, opts ...grpc.CallOption) (*ListApiDeploymentsResponse, error)
	// Returns a specified deployment.
	GetApiDeployment(ctx context.Context, in *GetApiDeploymentRequest, opts ...grpc.CallOption) (*ApiDeployment, error)
	// Creates a specified deployment.
	CreateApiDeployment(ctx context.Context, in *CreateApiDeploymentRequest, opts ...grpc.CallOption) (*ApiDeployment, error)
	// Used to modify a specified deployment.
	UpdateApiDeployment(ctx context.Context, in *UpdateApiDeploymentRequest, opts ...grpc.CallOption) (*ApiDeployment, error)
	// Removes a specified deployment, all revisions, and all
	// child resources (e.g., artifacts).
	DeleteApiDeployment(ctx context.Context, in *DeleteApiDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Adds a tag to a specified revision of a
	// deployment.
	TagApiDeploymentRevision(ctx context.Context, in *TagApiDeploymentRevisionRequest, opts ...grpc.CallOption) (*ApiDeployment, error)
	// Lists all revisions of a deployment.
	// Revisions are returned in descending order of revision creation time.
	ListApiDeploymentRevisions(ctx context.Context, in *ListApiDeploymentRevisionsRequest, opts ...grpc.CallOption) (*ListApiDeploymentRevisionsResponse, error)
	// Sets the current revision to a specified prior
	// revision. Note that this creates a new revision with a new revision ID.
	RollbackApiDeployment(ctx context.Context, in *RollbackApiDeploymentRequest, opts ...grpc.CallOption) (*ApiDeployment, error)
	// Deletes a revision of a deployment.
	DeleteApiDeploymentRevision(ctx context.Context, in *DeleteApiDeploymentRevisionRequest, opts ...grpc.CallOption) (*ApiDeployment, error)
	// Returns matching artifacts.
	ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error)
	// Returns a specified artifact.
	GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Returns the contents of a specified artifact.
	// If artifacts are stored with GZip compression, the default behavior
	// is to return the artifact uncompressed (the mime_type response field
	// indicates the exact format returned).
	GetArtifactContents(ctx context.Context, in *GetArtifactContentsRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error)
	// Creates a specified artifact.
	CreateArtifact(ctx context.Context, in *CreateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Used to replace a specified artifact.
	ReplaceArtifact(ctx context.Context, in *ReplaceArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Removes a specified artifact.
	DeleteArtifact(ctx context.Context, in *DeleteArtifactRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type registryClient struct {
	cc grpc.ClientConnInterface
}

func NewRegistryClient(cc grpc.ClientConnInterface) RegistryClient {
	return &registryClient{cc}
}

func (c *registryClient) ListApis(ctx context.Context, in *ListApisRequest, opts ...grpc.CallOption) (*ListApisResponse, error) {
	out := new(ListApisResponse)
	err := c.cc.Invoke(ctx, Registry_ListApis_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetApi(ctx context.Context, in *GetApiRequest, opts ...grpc.CallOption) (*Api, error) {
	out := new(Api)
	err := c.cc.Invoke(ctx, Registry_GetApi_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) CreateApi(ctx context.Context, in *CreateApiRequest, opts ...grpc.CallOption) (*Api, error) {
	out := new(Api)
	err := c.cc.Invoke(ctx, Registry_CreateApi_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) UpdateApi(ctx context.Context, in *UpdateApiRequest, opts ...grpc.CallOption) (*Api, error) {
	out := new(Api)
	err := c.cc.Invoke(ctx, Registry_UpdateApi_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) DeleteApi(ctx context.Context, in *DeleteApiRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Registry_DeleteApi_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) ListApiVersions(ctx context.Context, in *ListApiVersionsRequest, opts ...grpc.CallOption) (*ListApiVersionsResponse, error) {
	out := new(ListApiVersionsResponse)
	err := c.cc.Invoke(ctx, Registry_ListApiVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetApiVersion(ctx context.Context, in *GetApiVersionRequest, opts ...grpc.CallOption) (*ApiVersion, error) {
	out := new(ApiVersion)
	err := c.cc.Invoke(ctx, Registry_GetApiVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) CreateApiVersion(ctx context.Context, in *CreateApiVersionRequest, opts ...grpc.CallOption) (*ApiVersion, error) {
	out := new(ApiVersion)
	err := c.cc.Invoke(ctx, Registry_CreateApiVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) UpdateApiVersion(ctx context.Context, in *UpdateApiVersionRequest, opts ...grpc.CallOption) (*ApiVersion, error) {
	out := new(ApiVersion)
	err := c.cc.Invoke(ctx, Registry_UpdateApiVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) DeleteApiVersion(ctx context.Context, in *DeleteApiVersionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Registry_DeleteApiVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) ListApiSpecs(ctx context.Context, in *ListApiSpecsRequest, opts ...grpc.CallOption) (*ListApiSpecsResponse, error) {
	out := new(ListApiSpecsResponse)
	err := c.cc.Invoke(ctx, Registry_ListApiSpecs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetApiSpec(ctx context.Context, in *GetApiSpecRequest, opts ...grpc.CallOption) (*ApiSpec, error) {
	out := new(ApiSpec)
	err := c.cc.Invoke(ctx, Registry_GetApiSpec_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetApiSpecContents(ctx context.Context, in *GetApiSpecContentsRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error) {
	out := new(httpbody.HttpBody)
	err := c.cc.Invoke(ctx, Registry_GetApiSpecContents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) CreateApiSpec(ctx context.Context, in *CreateApiSpecRequest, opts ...grpc.CallOption) (*ApiSpec, error) {
	out := new(ApiSpec)
	err := c.cc.Invoke(ctx, Registry_CreateApiSpec_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) UpdateApiSpec(ctx context.Context, in *UpdateApiSpecRequest, opts ...grpc.CallOption) (*ApiSpec, error) {
	out := new(ApiSpec)
	err := c.cc.Invoke(ctx, Registry_UpdateApiSpec_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) DeleteApiSpec(ctx context.Context, in *DeleteApiSpecRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Registry_DeleteApiSpec_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) TagApiSpecRevision(ctx context.Context, in *TagApiSpecRevisionRequest, opts ...grpc.CallOption) (*ApiSpec, error) {
	out := new(ApiSpec)
	err := c.cc.Invoke(ctx, Registry_TagApiSpecRevision_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) ListApiSpecRevisions(ctx context.Context, in *ListApiSpecRevisionsRequest, opts ...grpc.CallOption) (*ListApiSpecRevisionsResponse, error) {
	out := new(ListApiSpecRevisionsResponse)
	err := c.cc.Invoke(ctx, Registry_ListApiSpecRevisions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) RollbackApiSpec(ctx context.Context, in *RollbackApiSpecRequest, opts ...grpc.CallOption) (*ApiSpec, error) {
	out := new(ApiSpec)
	err := c.cc.Invoke(ctx, Registry_RollbackApiSpec_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) DeleteApiSpecRevision(ctx context.Context, in *DeleteApiSpecRevisionRequest, opts ...grpc.CallOption) (*ApiSpec, error) {
	out := new(ApiSpec)
	err := c.cc.Invoke(ctx, Registry_DeleteApiSpecRevision_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) ListApiDeployments(ctx context.Context, in *ListApiDeploymentsRequest, opts ...grpc.CallOption) (*ListApiDeploymentsResponse, error) {
	out := new(ListApiDeploymentsResponse)
	err := c.cc.Invoke(ctx, Registry_ListApiDeployments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetApiDeployment(ctx context.Context, in *GetApiDeploymentRequest, opts ...grpc.CallOption) (*ApiDeployment, error) {
	out := new(ApiDeployment)
	err := c.cc.Invoke(ctx, Registry_GetApiDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) CreateApiDeployment(ctx context.Context, in *CreateApiDeploymentRequest, opts ...grpc.CallOption) (*ApiDeployment, error) {
	out := new(ApiDeployment)
	err := c.cc.Invoke(ctx, Registry_CreateApiDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) UpdateApiDeployment(ctx context.Context, in *UpdateApiDeploymentRequest, opts ...grpc.CallOption) (*ApiDeployment, error) {
	out := new(ApiDeployment)
	err := c.cc.Invoke(ctx, Registry_UpdateApiDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) DeleteApiDeployment(ctx context.Context, in *DeleteApiDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Registry_DeleteApiDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) TagApiDeploymentRevision(ctx context.Context, in *TagApiDeploymentRevisionRequest, opts ...grpc.CallOption) (*ApiDeployment, error) {
	out := new(ApiDeployment)
	err := c.cc.Invoke(ctx, Registry_TagApiDeploymentRevision_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) ListApiDeploymentRevisions(ctx context.Context, in *ListApiDeploymentRevisionsRequest, opts ...grpc.CallOption) (*ListApiDeploymentRevisionsResponse, error) {
	out := new(ListApiDeploymentRevisionsResponse)
	err := c.cc.Invoke(ctx, Registry_ListApiDeploymentRevisions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) RollbackApiDeployment(ctx context.Context, in *RollbackApiDeploymentRequest, opts ...grpc.CallOption) (*ApiDeployment, error) {
	out := new(ApiDeployment)
	err := c.cc.Invoke(ctx, Registry_RollbackApiDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) DeleteApiDeploymentRevision(ctx context.Context, in *DeleteApiDeploymentRevisionRequest, opts ...grpc.CallOption) (*ApiDeployment, error) {
	out := new(ApiDeployment)
	err := c.cc.Invoke(ctx, Registry_DeleteApiDeploymentRevision_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error) {
	out := new(ListArtifactsResponse)
	err := c.cc.Invoke(ctx, Registry_ListArtifacts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, Registry_GetArtifact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetArtifactContents(ctx context.Context, in *GetArtifactContentsRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error) {
	out := new(httpbody.HttpBody)
	err := c.cc.Invoke(ctx, Registry_GetArtifactContents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) CreateArtifact(ctx context.Context, in *CreateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, Registry_CreateArtifact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) ReplaceArtifact(ctx context.Context, in *ReplaceArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, Registry_ReplaceArtifact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) DeleteArtifact(ctx context.Context, in *DeleteArtifactRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Registry_DeleteArtifact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RegistryServer is the server API for Registry service.
// All implementations should embed UnimplementedRegistryServer
// for forward compatibility
type RegistryServer interface {
	// Returns matching APIs.
	ListApis(context.Context, *ListApisRequest) (*ListApisResponse, error)
	// Returns a specified API.
	GetApi(context.Context, *GetApiRequest) (*Api, error)
	// Creates a specified API.
	CreateApi(context.Context, *CreateApiRequest) (*Api, error)
	// Used to modify a specified API.
	UpdateApi(context.Context, *UpdateApiRequest) (*Api, error)
	// Removes a specified API and all of the resources that it
	// owns.
	DeleteApi(context.Context, *DeleteApiRequest) (*emptypb.Empty, error)
	// Returns matching versions.
	ListApiVersions(context.Context, *ListApiVersionsRequest) (*ListApiVersionsResponse, error)
	// Returns a specified version.
	GetApiVersion(context.Context, *GetApiVersionRequest) (*ApiVersion, error)
	// Creates a specified version.
	CreateApiVersion(context.Context, *CreateApiVersionRequest) (*ApiVersion, error)
	// Used to modify a specified version.
	UpdateApiVersion(context.Context, *UpdateApiVersionRequest) (*ApiVersion, error)
	// Removes a specified version and all of the resources that
	// it owns.
	DeleteApiVersion(context.Context, *DeleteApiVersionRequest) (*emptypb.Empty, error)
	// Returns matching specs.
	ListApiSpecs(context.Context, *ListApiSpecsRequest) (*ListApiSpecsResponse, error)
	// Returns a specified spec.
	GetApiSpec(context.Context, *GetApiSpecRequest) (*ApiSpec, error)
	// Returns the contents of a specified spec.
	// If specs are stored with GZip compression, the default behavior
	// is to return the spec uncompressed (the mime_type response field
	// indicates the exact format returned).
	GetApiSpecContents(context.Context, *GetApiSpecContentsRequest) (*httpbody.HttpBody, error)
	// Creates a specified spec.
	CreateApiSpec(context.Context, *CreateApiSpecRequest) (*ApiSpec, error)
	// Used to modify a specified spec.
	UpdateApiSpec(context.Context, *UpdateApiSpecRequest) (*ApiSpec, error)
	// Removes a specified spec, all revisions, and all child
	// resources (e.g., artifacts).
	DeleteApiSpec(context.Context, *DeleteApiSpecRequest) (*emptypb.Empty, error)
	// Adds a tag to a specified revision of a spec.
	TagApiSpecRevision(context.Context, *TagApiSpecRevisionRequest) (*ApiSpec, error)
	// Lists all revisions of a spec.
	// Revisions are returned in descending order of revision creation time.
	ListApiSpecRevisions(context.Context, *ListApiSpecRevisionsRequest) (*ListApiSpecRevisionsResponse, error)
	// Sets the current revision to a specified prior revision.
	// Note that this creates a new revision with a new revision ID.
	RollbackApiSpec(context.Context, *RollbackApiSpecRequest) (*ApiSpec, error)
	// Deletes a revision of a spec.
	DeleteApiSpecRevision(context.Context, *DeleteApiSpecRevisionRequest) (*ApiSpec, error)
	// Returns matching deployments.
	ListApiDeployments(context.Context, *ListApiDeploymentsRequest) (*ListApiDeploymentsResponse, error)
	// Returns a specified deployment.
	GetApiDeployment(context.Context, *GetApiDeploymentRequest) (*ApiDeployment, error)
	// Creates a specified deployment.
	CreateApiDeployment(context.Context, *CreateApiDeploymentRequest) (*ApiDeployment, error)
	// Used to modify a specified deployment.
	UpdateApiDeployment(context.Context, *UpdateApiDeploymentRequest) (*ApiDeployment, error)
	// Removes a specified deployment, all revisions, and all
	// child resources (e.g., artifacts).
	DeleteApiDeployment(context.Context, *DeleteApiDeploymentRequest) (*emptypb.Empty, error)
	// Adds a tag to a specified revision of a
	// deployment.
	TagApiDeploymentRevision(context.Context, *TagApiDeploymentRevisionRequest) (*ApiDeployment, error)
	// Lists all revisions of a deployment.
	// Revisions are returned in descending order of revision creation time.
	ListApiDeploymentRevisions(context.Context, *ListApiDeploymentRevisionsRequest) (*ListApiDeploymentRevisionsResponse, error)
	// Sets the current revision to a specified prior
	// revision. Note that this creates a new revision with a new revision ID.
	RollbackApiDeployment(context.Context, *RollbackApiDeploymentRequest) (*ApiDeployment, error)
	// Deletes a revision of a deployment.
	DeleteApiDeploymentRevision(context.Context, *DeleteApiDeploymentRevisionRequest) (*ApiDeployment, error)
	// Returns matching artifacts.
	ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error)
	// Returns a specified artifact.
	GetArtifact(context.Context, *GetArtifactRequest) (*Artifact, error)
	// Returns the contents of a specified artifact.
	// If artifacts are stored with GZip compression, the default behavior
	// is to return the artifact uncompressed (the mime_type response field
	// indicates the exact format returned).
	GetArtifactContents(context.Context, *GetArtifactContentsRequest) (*httpbody.HttpBody, error)
	// Creates a specified artifact.
	CreateArtifact(context.Context, *CreateArtifactRequest) (*Artifact, error)
	// Used to replace a specified artifact.
	ReplaceArtifact(context.Context, *ReplaceArtifactRequest) (*Artifact, error)
	// Removes a specified artifact.
	DeleteArtifact(context.Context, *DeleteArtifactRequest) (*emptypb.Empty, error)
}

// UnimplementedRegistryServer should be embedded to have forward compatible implementations.
type UnimplementedRegistryServer struct {
}

func (UnimplementedRegistryServer) ListApis(context.Context, *ListApisRequest) (*ListApisResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApis not implemented")
}
func (UnimplementedRegistryServer) GetApi(context.Context, *GetApiRequest) (*Api, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApi not implemented")
}
func (UnimplementedRegistryServer) CreateApi(context.Context, *CreateApiRequest) (*Api, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateApi not implemented")
}
func (UnimplementedRegistryServer) UpdateApi(context.Context, *UpdateApiRequest) (*Api, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateApi not implemented")
}
func (UnimplementedRegistryServer) DeleteApi(context.Context, *DeleteApiRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteApi not implemented")
}
func (UnimplementedRegistryServer) ListApiVersions(context.Context, *ListApiVersionsRequest) (*ListApiVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApiVersions not implemented")
}
func (UnimplementedRegistryServer) GetApiVersion(context.Context, *GetApiVersionRequest) (*ApiVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApiVersion not implemented")
}
func (UnimplementedRegistryServer) CreateApiVersion(context.Context, *CreateApiVersionRequest) (*ApiVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateApiVersion not implemented")
}
func (UnimplementedRegistryServer) UpdateApiVersion(context.Context, *UpdateApiVersionRequest) (*ApiVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateApiVersion not implemented")
}
func (UnimplementedRegistryServer) DeleteApiVersion(context.Context, *DeleteApiVersionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteApiVersion not implemented")
}
func (UnimplementedRegistryServer) ListApiSpecs(context.Context, *ListApiSpecsRequest) (*ListApiSpecsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApiSpecs not implemented")
}
func (UnimplementedRegistryServer) GetApiSpec(context.Context, *GetApiSpecRequest) (*ApiSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApiSpec not implemented")
}
func (UnimplementedRegistryServer) GetApiSpecContents(context.Context, *GetApiSpecContentsRequest) (*httpbody.HttpBody, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApiSpecContents not implemented")
}
func (UnimplementedRegistryServer) CreateApiSpec(context.Context, *CreateApiSpecRequest) (*ApiSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateApiSpec not implemented")
}
func (UnimplementedRegistryServer) UpdateApiSpec(context.Context, *UpdateApiSpecRequest) (*ApiSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateApiSpec not implemented")
}
func (UnimplementedRegistryServer) DeleteApiSpec(context.Context, *DeleteApiSpecRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteApiSpec not implemented")
}
func (UnimplementedRegistryServer) TagApiSpecRevision(context.Context, *TagApiSpecRevisionRequest) (*ApiSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TagApiSpecRevision not implemented")
}
func (UnimplementedRegistryServer) ListApiSpecRevisions(context.Context, *ListApiSpecRevisionsRequest) (*ListApiSpecRevisionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApiSpecRevisions not implemented")
}
func (UnimplementedRegistryServer) RollbackApiSpec(context.Context, *RollbackApiSpecRequest) (*ApiSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RollbackApiSpec not implemented")
}
func (UnimplementedRegistryServer) DeleteApiSpecRevision(context.Context, *DeleteApiSpecRevisionRequest) (*ApiSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteApiSpecRevision not implemented")
}
func (UnimplementedRegistryServer) ListApiDeployments(context.Context, *ListApiDeploymentsRequest) (*ListApiDeploymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApiDeployments not implemented")
}
func (UnimplementedRegistryServer) GetApiDeployment(context.Context, *GetApiDeploymentRequest) (*ApiDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApiDeployment not implemented")
}
func (UnimplementedRegistryServer) CreateApiDeployment(context.Context, *CreateApiDeploymentRequest) (*ApiDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateApiDeployment not implemented")
}
func (UnimplementedRegistryServer) UpdateApiDeployment(context.Context, *UpdateApiDeploymentRequest) (*ApiDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateApiDeployment not implemented")
}
func (UnimplementedRegistryServer) DeleteApiDeployment(context.Context, *DeleteApiDeploymentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteApiDeployment not implemented")
}
func (UnimplementedRegistryServer) TagApiDeploymentRevision(context.Context, *TagApiDeploymentRevisionRequest) (*ApiDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TagApiDeploymentRevision not implemented")
}
func (UnimplementedRegistryServer) ListApiDeploymentRevisions(context.Context, *ListApiDeploymentRevisionsRequest) (*ListApiDeploymentRevisionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApiDeploymentRevisions not implemented")
}
func (UnimplementedRegistryServer) RollbackApiDeployment(context.Context, *RollbackApiDeploymentRequest) (*ApiDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RollbackApiDeployment not implemented")
}
func (UnimplementedRegistryServer) DeleteApiDeploymentRevision(context.Context, *DeleteApiDeploymentRevisionRequest) (*ApiDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteApiDeploymentRevision not implemented")
}
func (UnimplementedRegistryServer) ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListArtifacts not implemented")
}
func (UnimplementedRegistryServer) GetArtifact(context.Context, *GetArtifactRequest) (*Artifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetArtifact not implemented")
}
func (UnimplementedRegistryServer) GetArtifactContents(context.Context, *GetArtifactContentsRequest) (*httpbody.HttpBody, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetArtifactContents not implemented")
}
func (UnimplementedRegistryServer) CreateArtifact(context.Context, *CreateArtifactRequest) (*Artifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateArtifact not implemented")
}
func (UnimplementedRegistryServer) ReplaceArtifact(context.Context, *ReplaceArtifactRequest) (*Artifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplaceArtifact not implemented")
}
func (UnimplementedRegistryServer) DeleteArtifact(context.Context, *DeleteArtifactRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteArtifact not implemented")
}

// UnsafeRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RegistryServer will
// result in compilation errors.
type UnsafeRegistryServer interface {
	mustEmbedUnimplementedRegistryServer()
}

func RegisterRegistryServer(s grpc.ServiceRegistrar, srv RegistryServer) {
	s.RegisterService(&Registry_ServiceDesc, srv)
}

func _Registry_ListApis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).ListApis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_ListApis_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).ListApis(ctx, req.(*ListApisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetApi_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApiRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetApi(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_GetApi_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetApi(ctx, req.(*GetApiRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_CreateApi_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApiRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).CreateApi(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_CreateApi_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).CreateApi(ctx, req.(*CreateApiRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_UpdateApi_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApiRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).UpdateApi(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_UpdateApi_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).UpdateApi(ctx, req.(*UpdateApiRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_DeleteApi_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApiRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).DeleteApi(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_DeleteApi_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).DeleteApi(ctx, req.(*DeleteApiRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_ListApiVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApiVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).ListApiVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_ListApiVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).ListApiVersions(ctx, req.(*ListApiVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetApiVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApiVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetApiVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_GetApiVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetApiVersion(ctx, req.(*GetApiVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_CreateApiVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApiVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).CreateApiVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_CreateApiVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).CreateApiVersion(ctx, req.(*CreateApiVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_UpdateApiVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApiVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).UpdateApiVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_UpdateApiVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).UpdateApiVersion(ctx, req.(*UpdateApiVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_DeleteApiVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApiVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).DeleteApiVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_DeleteApiVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).DeleteApiVersion(ctx, req.(*DeleteApiVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_ListApiSpecs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApiSpecsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).ListApiSpecs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_ListApiSpecs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).ListApiSpecs(ctx, req.(*ListApiSpecsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetApiSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApiSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetApiSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_GetApiSpec_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetApiSpec(ctx, req.(*GetApiSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetApiSpecContents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApiSpecContentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetApiSpecContents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_GetApiSpecContents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetApiSpecContents(ctx, req.(*GetApiSpecContentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_CreateApiSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApiSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).CreateApiSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_CreateApiSpec_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).CreateApiSpec(ctx, req.(*CreateApiSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_UpdateApiSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApiSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).UpdateApiSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_UpdateApiSpec_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).UpdateApiSpec(ctx, req.(*UpdateApiSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_DeleteApiSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApiSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).DeleteApiSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_DeleteApiSpec_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).DeleteApiSpec(ctx, req.(*DeleteApiSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_TagApiSpecRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TagApiSpecRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).TagApiSpecRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_TagApiSpecRevision_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).TagApiSpecRevision(ctx, req.(*TagApiSpecRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_ListApiSpecRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApiSpecRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).ListApiSpecRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_ListApiSpecRevisions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).ListApiSpecRevisions(ctx, req.(*ListApiSpecRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_RollbackApiSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackApiSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).RollbackApiSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_RollbackApiSpec_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).RollbackApiSpec(ctx, req.(*RollbackApiSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_DeleteApiSpecRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApiSpecRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).DeleteApiSpecRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_DeleteApiSpecRevision_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).DeleteApiSpecRevision(ctx, req.(*DeleteApiSpecRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_ListApiDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApiDeploymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).ListApiDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_ListApiDeployments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).ListApiDeployments(ctx, req.(*ListApiDeploymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetApiDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApiDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetApiDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_GetApiDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetApiDeployment(ctx, req.(*GetApiDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_CreateApiDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApiDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).CreateApiDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_CreateApiDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).CreateApiDeployment(ctx, req.(*CreateApiDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_UpdateApiDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApiDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).UpdateApiDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_UpdateApiDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).UpdateApiDeployment(ctx, req.(*UpdateApiDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_DeleteApiDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApiDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).DeleteApiDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_DeleteApiDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).DeleteApiDeployment(ctx, req.(*DeleteApiDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_TagApiDeploymentRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TagApiDeploymentRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).TagApiDeploymentRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_TagApiDeploymentRevision_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).TagApiDeploymentRevision(ctx, req.(*TagApiDeploymentRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_ListApiDeploymentRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApiDeploymentRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).ListApiDeploymentRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_ListApiDeploymentRevisions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).ListApiDeploymentRevisions(ctx, req.(*ListApiDeploymentRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_RollbackApiDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackApiDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).RollbackApiDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_RollbackApiDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).RollbackApiDeployment(ctx, req.(*RollbackApiDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_DeleteApiDeploymentRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApiDeploymentRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).DeleteApiDeploymentRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_DeleteApiDeploymentRevision_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).DeleteApiDeploymentRevision(ctx, req.(*DeleteApiDeploymentRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_ListArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).ListArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_ListArtifacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).ListArtifacts(ctx, req.(*ListArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_GetArtifact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetArtifact(ctx, req.(*GetArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetArtifactContents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetArtifactContentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetArtifactContents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_GetArtifactContents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetArtifactContents(ctx, req.(*GetArtifactContentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_CreateArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).CreateArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_CreateArtifact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).CreateArtifact(ctx, req.(*CreateArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_ReplaceArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplaceArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).ReplaceArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_ReplaceArtifact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).ReplaceArtifact(ctx, req.(*ReplaceArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_DeleteArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).DeleteArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Registry_DeleteArtifact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).DeleteArtifact(ctx, req.(*DeleteArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Registry_ServiceDesc is the grpc.ServiceDesc for Registry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Registry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.apigeeregistry.v1.Registry",
	HandlerType: (*RegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListApis",
			Handler:    _Registry_ListApis_Handler,
		},
		{
			MethodName: "GetApi",
			Handler:    _Registry_GetApi_Handler,
		},
		{
			MethodName: "CreateApi",
			Handler:    _Registry_CreateApi_Handler,
		},
		{
			MethodName: "UpdateApi",
			Handler:    _Registry_UpdateApi_Handler,
		},
		{
			MethodName: "DeleteApi",
			Handler:    _Registry_DeleteApi_Handler,
		},
		{
			MethodName: "ListApiVersions",
			Handler:    _Registry_ListApiVersions_Handler,
		},
		{
			MethodName: "GetApiVersion",
			Handler:    _Registry_GetApiVersion_Handler,
		},
		{
			MethodName: "CreateApiVersion",
			Handler:    _Registry_CreateApiVersion_Handler,
		},
		{
			MethodName: "UpdateApiVersion",
			Handler:    _Registry_UpdateApiVersion_Handler,
		},
		{
			MethodName: "DeleteApiVersion",
			Handler:    _Registry_DeleteApiVersion_Handler,
		},
		{
			MethodName: "ListApiSpecs",
			Handler:    _Registry_ListApiSpecs_Handler,
		},
		{
			MethodName: "GetApiSpec",
			Handler:    _Registry_GetApiSpec_Handler,
		},
		{
			MethodName: "GetApiSpecContents",
			Handler:    _Registry_GetApiSpecContents_Handler,
		},
		{
			MethodName: "CreateApiSpec",
			Handler:    _Registry_CreateApiSpec_Handler,
		},
		{
			MethodName: "UpdateApiSpec",
			Handler:    _Registry_UpdateApiSpec_Handler,
		},
		{
			MethodName: "DeleteApiSpec",
			Handler:    _Registry_DeleteApiSpec_Handler,
		},
		{
			MethodName: "TagApiSpecRevision",
			Handler:    _Registry_TagApiSpecRevision_Handler,
		},
		{
			MethodName: "ListApiSpecRevisions",
			Handler:    _Registry_ListApiSpecRevisions_Handler,
		},
		{
			MethodName: "RollbackApiSpec",
			Handler:    _Registry_RollbackApiSpec_Handler,
		},
		{
			MethodName: "DeleteApiSpecRevision",
			Handler:    _Registry_DeleteApiSpecRevision_Handler,
		},
		{
			MethodName: "ListApiDeployments",
			Handler:    _Registry_ListApiDeployments_Handler,
		},
		{
			MethodName: "GetApiDeployment",
			Handler:    _Registry_GetApiDeployment_Handler,
		},
		{
			MethodName: "CreateApiDeployment",
			Handler:    _Registry_CreateApiDeployment_Handler,
		},
		{
			MethodName: "UpdateApiDeployment",
			Handler:    _Registry_UpdateApiDeployment_Handler,
		},
		{
			MethodName: "DeleteApiDeployment",
			Handler:    _Registry_DeleteApiDeployment_Handler,
		},
		{
			MethodName: "TagApiDeploymentRevision",
			Handler:    _Registry_TagApiDeploymentRevision_Handler,
		},
		{
			MethodName: "ListApiDeploymentRevisions",
			Handler:    _Registry_ListApiDeploymentRevisions_Handler,
		},
		{
			MethodName: "RollbackApiDeployment",
			Handler:    _Registry_RollbackApiDeployment_Handler,
		},
		{
			MethodName: "DeleteApiDeploymentRevision",
			Handler:    _Registry_DeleteApiDeploymentRevision_Handler,
		},
		{
			MethodName: "ListArtifacts",
			Handler:    _Registry_ListArtifacts_Handler,
		},
		{
			MethodName: "GetArtifact",
			Handler:    _Registry_GetArtifact_Handler,
		},
		{
			MethodName: "GetArtifactContents",
			Handler:    _Registry_GetArtifactContents_Handler,
		},
		{
			MethodName: "CreateArtifact",
			Handler:    _Registry_CreateArtifact_Handler,
		},
		{
			MethodName: "ReplaceArtifact",
			Handler:    _Registry_ReplaceArtifact_Handler,
		},
		{
			MethodName: "DeleteArtifact",
			Handler:    _Registry_DeleteArtifact_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/apigeeregistry/v1/registry_service.proto",
}
