// Copyright 2025 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: grafeas/v1/secret.proto

package grafeas

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Kind of secret.
type SecretKind int32

const (
	// Unspecified
	SecretKind_SECRET_KIND_UNSPECIFIED SecretKind = 0
	// The secret kind is unknown.
	SecretKind_SECRET_KIND_UNKNOWN SecretKind = 1
	// A Google Cloud service account key per:
	// https://cloud.google.com/iam/docs/creating-managing-service-account-keys
	SecretKind_SECRET_KIND_GCP_SERVICE_ACCOUNT_KEY SecretKind = 2
	// A Google Cloud API key per:
	// https://cloud.google.com/docs/authentication/api-keys
	SecretKind_SECRET_KIND_GCP_API_KEY SecretKind = 3
	// A Google Cloud OAuth2 client credentials per:
	// https://developers.google.com/identity/protocols/oauth2
	SecretKind_SECRET_KIND_GCP_OAUTH2_CLIENT_CREDENTIALS SecretKind = 4
	// A Google Cloud OAuth2 access token per:
	// https://cloud.google.com/docs/authentication/token-types#access
	SecretKind_SECRET_KIND_GCP_OAUTH2_ACCESS_TOKEN SecretKind = 5
	// An Anthropic Admin API key.
	SecretKind_SECRET_KIND_ANTHROPIC_ADMIN_API_KEY SecretKind = 6
	// An Anthropic API key.
	SecretKind_SECRET_KIND_ANTHROPIC_API_KEY SecretKind = 7
	// An Azure access token.
	SecretKind_SECRET_KIND_AZURE_ACCESS_TOKEN SecretKind = 8
	// An Azure Identity Platform ID token.
	SecretKind_SECRET_KIND_AZURE_IDENTITY_TOKEN SecretKind = 9
	// A Docker Hub personal access token.
	SecretKind_SECRET_KIND_DOCKER_HUB_PERSONAL_ACCESS_TOKEN SecretKind = 10
	// A GitHub App refresh token.
	SecretKind_SECRET_KIND_GITHUB_APP_REFRESH_TOKEN SecretKind = 11
	// A GitHub App server-to-server token.
	SecretKind_SECRET_KIND_GITHUB_APP_SERVER_TO_SERVER_TOKEN SecretKind = 12
	// A GitHub App user-to-server token.
	SecretKind_SECRET_KIND_GITHUB_APP_USER_TO_SERVER_TOKEN SecretKind = 13
	// A GitHub personal access token (classic).
	SecretKind_SECRET_KIND_GITHUB_CLASSIC_PERSONAL_ACCESS_TOKEN SecretKind = 14
	// A GitHub fine-grained personal access token.
	SecretKind_SECRET_KIND_GITHUB_FINE_GRAINED_PERSONAL_ACCESS_TOKEN SecretKind = 15
	// A GitHub OAuth token.
	SecretKind_SECRET_KIND_GITHUB_OAUTH_TOKEN SecretKind = 16
	// A Hugging Face API key.
	SecretKind_SECRET_KIND_HUGGINGFACE_API_KEY SecretKind = 17
	// An OpenAI API key.
	SecretKind_SECRET_KIND_OPENAI_API_KEY SecretKind = 18
	// A Perplexity API key.
	SecretKind_SECRET_KIND_PERPLEXITY_API_KEY SecretKind = 19
	// A Stripe secret key.
	SecretKind_SECRET_KIND_STRIPE_SECRET_KEY SecretKind = 20
	// A Stripe restricted key.
	SecretKind_SECRET_KIND_STRIPE_RESTRICTED_KEY SecretKind = 21
	// A Stripe webhook secret.
	SecretKind_SECRET_KIND_STRIPE_WEBHOOK_SECRET SecretKind = 22
)

// Enum value maps for SecretKind.
var (
	SecretKind_name = map[int32]string{
		0:  "SECRET_KIND_UNSPECIFIED",
		1:  "SECRET_KIND_UNKNOWN",
		2:  "SECRET_KIND_GCP_SERVICE_ACCOUNT_KEY",
		3:  "SECRET_KIND_GCP_API_KEY",
		4:  "SECRET_KIND_GCP_OAUTH2_CLIENT_CREDENTIALS",
		5:  "SECRET_KIND_GCP_OAUTH2_ACCESS_TOKEN",
		6:  "SECRET_KIND_ANTHROPIC_ADMIN_API_KEY",
		7:  "SECRET_KIND_ANTHROPIC_API_KEY",
		8:  "SECRET_KIND_AZURE_ACCESS_TOKEN",
		9:  "SECRET_KIND_AZURE_IDENTITY_TOKEN",
		10: "SECRET_KIND_DOCKER_HUB_PERSONAL_ACCESS_TOKEN",
		11: "SECRET_KIND_GITHUB_APP_REFRESH_TOKEN",
		12: "SECRET_KIND_GITHUB_APP_SERVER_TO_SERVER_TOKEN",
		13: "SECRET_KIND_GITHUB_APP_USER_TO_SERVER_TOKEN",
		14: "SECRET_KIND_GITHUB_CLASSIC_PERSONAL_ACCESS_TOKEN",
		15: "SECRET_KIND_GITHUB_FINE_GRAINED_PERSONAL_ACCESS_TOKEN",
		16: "SECRET_KIND_GITHUB_OAUTH_TOKEN",
		17: "SECRET_KIND_HUGGINGFACE_API_KEY",
		18: "SECRET_KIND_OPENAI_API_KEY",
		19: "SECRET_KIND_PERPLEXITY_API_KEY",
		20: "SECRET_KIND_STRIPE_SECRET_KEY",
		21: "SECRET_KIND_STRIPE_RESTRICTED_KEY",
		22: "SECRET_KIND_STRIPE_WEBHOOK_SECRET",
	}
	SecretKind_value = map[string]int32{
		"SECRET_KIND_UNSPECIFIED":                               0,
		"SECRET_KIND_UNKNOWN":                                   1,
		"SECRET_KIND_GCP_SERVICE_ACCOUNT_KEY":                   2,
		"SECRET_KIND_GCP_API_KEY":                               3,
		"SECRET_KIND_GCP_OAUTH2_CLIENT_CREDENTIALS":             4,
		"SECRET_KIND_GCP_OAUTH2_ACCESS_TOKEN":                   5,
		"SECRET_KIND_ANTHROPIC_ADMIN_API_KEY":                   6,
		"SECRET_KIND_ANTHROPIC_API_KEY":                         7,
		"SECRET_KIND_AZURE_ACCESS_TOKEN":                        8,
		"SECRET_KIND_AZURE_IDENTITY_TOKEN":                      9,
		"SECRET_KIND_DOCKER_HUB_PERSONAL_ACCESS_TOKEN":          10,
		"SECRET_KIND_GITHUB_APP_REFRESH_TOKEN":                  11,
		"SECRET_KIND_GITHUB_APP_SERVER_TO_SERVER_TOKEN":         12,
		"SECRET_KIND_GITHUB_APP_USER_TO_SERVER_TOKEN":           13,
		"SECRET_KIND_GITHUB_CLASSIC_PERSONAL_ACCESS_TOKEN":      14,
		"SECRET_KIND_GITHUB_FINE_GRAINED_PERSONAL_ACCESS_TOKEN": 15,
		"SECRET_KIND_GITHUB_OAUTH_TOKEN":                        16,
		"SECRET_KIND_HUGGINGFACE_API_KEY":                       17,
		"SECRET_KIND_OPENAI_API_KEY":                            18,
		"SECRET_KIND_PERPLEXITY_API_KEY":                        19,
		"SECRET_KIND_STRIPE_SECRET_KEY":                         20,
		"SECRET_KIND_STRIPE_RESTRICTED_KEY":                     21,
		"SECRET_KIND_STRIPE_WEBHOOK_SECRET":                     22,
	}
)

func (x SecretKind) Enum() *SecretKind {
	p := new(SecretKind)
	*p = x
	return p
}

func (x SecretKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecretKind) Descriptor() protoreflect.EnumDescriptor {
	return file_grafeas_v1_secret_proto_enumTypes[0].Descriptor()
}

func (SecretKind) Type() protoreflect.EnumType {
	return &file_grafeas_v1_secret_proto_enumTypes[0]
}

func (x SecretKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecretKind.Descriptor instead.
func (SecretKind) EnumDescriptor() ([]byte, []int) {
	return file_grafeas_v1_secret_proto_rawDescGZIP(), []int{0}
}

// The status of the secret.
type SecretStatus_Status int32

const (
	// Unspecified
	SecretStatus_STATUS_UNSPECIFIED SecretStatus_Status = 0
	// The status of the secret is unknown.
	SecretStatus_UNKNOWN SecretStatus_Status = 1
	// The secret is valid.
	SecretStatus_VALID SecretStatus_Status = 2
	// The secret is invalid.
	SecretStatus_INVALID SecretStatus_Status = 3
)

// Enum value maps for SecretStatus_Status.
var (
	SecretStatus_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "UNKNOWN",
		2: "VALID",
		3: "INVALID",
	}
	SecretStatus_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"UNKNOWN":            1,
		"VALID":              2,
		"INVALID":            3,
	}
)

func (x SecretStatus_Status) Enum() *SecretStatus_Status {
	p := new(SecretStatus_Status)
	*p = x
	return p
}

func (x SecretStatus_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecretStatus_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_grafeas_v1_secret_proto_enumTypes[1].Descriptor()
}

func (SecretStatus_Status) Type() protoreflect.EnumType {
	return &file_grafeas_v1_secret_proto_enumTypes[1]
}

func (x SecretStatus_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecretStatus_Status.Descriptor instead.
func (SecretStatus_Status) EnumDescriptor() ([]byte, []int) {
	return file_grafeas_v1_secret_proto_rawDescGZIP(), []int{3, 0}
}

// The note representing a secret.
type SecretNote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SecretNote) Reset() {
	*x = SecretNote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_secret_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretNote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretNote) ProtoMessage() {}

func (x *SecretNote) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_secret_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretNote.ProtoReflect.Descriptor instead.
func (*SecretNote) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_secret_proto_rawDescGZIP(), []int{0}
}

// The occurrence provides details of a secret.
type SecretOccurrence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of secret.
	Kind SecretKind `protobuf:"varint,1,opt,name=kind,proto3,enum=grafeas.v1.SecretKind" json:"kind,omitempty"`
	// Locations where the secret is detected.
	Locations []*SecretLocation `protobuf:"bytes,2,rep,name=locations,proto3" json:"locations,omitempty"`
	// Status of the secret.
	Statuses []*SecretStatus `protobuf:"bytes,3,rep,name=statuses,proto3" json:"statuses,omitempty"`
	// Scan result of the secret.
	Data *anypb.Any `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
	// Hash value, typically a digest for the secret data, that allows unique
	// identification of a specific secret.
	Digest *Digest `protobuf:"bytes,5,opt,name=digest,proto3" json:"digest,omitempty"`
}

func (x *SecretOccurrence) Reset() {
	*x = SecretOccurrence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_secret_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretOccurrence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretOccurrence) ProtoMessage() {}

func (x *SecretOccurrence) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_secret_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretOccurrence.ProtoReflect.Descriptor instead.
func (*SecretOccurrence) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_secret_proto_rawDescGZIP(), []int{1}
}

func (x *SecretOccurrence) GetKind() SecretKind {
	if x != nil {
		return x.Kind
	}
	return SecretKind_SECRET_KIND_UNSPECIFIED
}

func (x *SecretOccurrence) GetLocations() []*SecretLocation {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *SecretOccurrence) GetStatuses() []*SecretStatus {
	if x != nil {
		return x.Statuses
	}
	return nil
}

func (x *SecretOccurrence) GetData() *anypb.Any {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *SecretOccurrence) GetDigest() *Digest {
	if x != nil {
		return x.Digest
	}
	return nil
}

// The location of the secret.
type SecretLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The detailed location of the secret.
	//
	// Types that are assignable to Location:
	//
	//	*SecretLocation_FileLocation
	Location isSecretLocation_Location `protobuf_oneof:"location"`
}

func (x *SecretLocation) Reset() {
	*x = SecretLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_secret_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretLocation) ProtoMessage() {}

func (x *SecretLocation) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_secret_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretLocation.ProtoReflect.Descriptor instead.
func (*SecretLocation) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_secret_proto_rawDescGZIP(), []int{2}
}

func (m *SecretLocation) GetLocation() isSecretLocation_Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (x *SecretLocation) GetFileLocation() *FileLocation {
	if x, ok := x.GetLocation().(*SecretLocation_FileLocation); ok {
		return x.FileLocation
	}
	return nil
}

type isSecretLocation_Location interface {
	isSecretLocation_Location()
}

type SecretLocation_FileLocation struct {
	// The secret is found from a file.
	FileLocation *FileLocation `protobuf:"bytes,1,opt,name=file_location,json=fileLocation,proto3,oneof"`
}

func (*SecretLocation_FileLocation) isSecretLocation_Location() {}

// The status of the secret with a timestamp.
type SecretStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of the secret.
	Status SecretStatus_Status `protobuf:"varint,1,opt,name=status,proto3,enum=grafeas.v1.SecretStatus_Status" json:"status,omitempty"`
	// The time the secret status was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional message about the status code.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *SecretStatus) Reset() {
	*x = SecretStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_secret_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretStatus) ProtoMessage() {}

func (x *SecretStatus) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_secret_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretStatus.ProtoReflect.Descriptor instead.
func (*SecretStatus) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_secret_proto_rawDescGZIP(), []int{3}
}

func (x *SecretStatus) GetStatus() SecretStatus_Status {
	if x != nil {
		return x.Status
	}
	return SecretStatus_STATUS_UNSPECIFIED
}

func (x *SecretStatus) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *SecretStatus) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_grafeas_v1_secret_proto protoreflect.FileDescriptor

var file_grafeas_v1_secret_proto_rawDesc = []byte{
	0x0a, 0x17, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0a, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x0c, 0x0a, 0x0a, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x22, 0x93, 0x02, 0x0a, 0x10, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x2f,
	0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x4b, 0x69, 0x6e, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12,
	0x3d, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x39,
	0x0a, 0x08, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x04, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x2a, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x22,
	0x5d, 0x0a, 0x0e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3f, 0x0a, 0x0d, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf4,
	0x01, 0x0a, 0x0c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x3c, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x1d, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x45,
	0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x01, 0x12, 0x09, 0x0a,
	0x05, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41,
	0x4c, 0x49, 0x44, 0x10, 0x03, 0x2a, 0xa5, 0x07, 0x0a, 0x0a, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x4b, 0x69, 0x6e, 0x64, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b,
	0x49, 0x4e, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44,
	0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x01, 0x12, 0x27, 0x0a, 0x23, 0x53, 0x45,
	0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x47, 0x43, 0x50, 0x5f, 0x53, 0x45,
	0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x4b, 0x45,
	0x59, 0x10, 0x02, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49,
	0x4e, 0x44, 0x5f, 0x47, 0x43, 0x50, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x03,
	0x12, 0x2d, 0x0a, 0x29, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f,
	0x47, 0x43, 0x50, 0x5f, 0x4f, 0x41, 0x55, 0x54, 0x48, 0x32, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e,
	0x54, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x53, 0x10, 0x04, 0x12,
	0x27, 0x0a, 0x23, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x47,
	0x43, 0x50, 0x5f, 0x4f, 0x41, 0x55, 0x54, 0x48, 0x32, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53,
	0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x05, 0x12, 0x27, 0x0a, 0x23, 0x53, 0x45, 0x43, 0x52,
	0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x41, 0x4e, 0x54, 0x48, 0x52, 0x4f, 0x50, 0x49,
	0x43, 0x5f, 0x41, 0x44, 0x4d, 0x49, 0x4e, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x4b, 0x45, 0x59, 0x10,
	0x06, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44,
	0x5f, 0x41, 0x4e, 0x54, 0x48, 0x52, 0x4f, 0x50, 0x49, 0x43, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x4b,
	0x45, 0x59, 0x10, 0x07, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b,
	0x49, 0x4e, 0x44, 0x5f, 0x41, 0x5a, 0x55, 0x52, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53,
	0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x08, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x45, 0x43, 0x52,
	0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x41, 0x5a, 0x55, 0x52, 0x45, 0x5f, 0x49, 0x44,
	0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x09, 0x12, 0x30,
	0x0a, 0x2c, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x44, 0x4f,
	0x43, 0x4b, 0x45, 0x52, 0x5f, 0x48, 0x55, 0x42, 0x5f, 0x50, 0x45, 0x52, 0x53, 0x4f, 0x4e, 0x41,
	0x4c, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x0a,
	0x12, 0x28, 0x0a, 0x24, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f,
	0x47, 0x49, 0x54, 0x48, 0x55, 0x42, 0x5f, 0x41, 0x50, 0x50, 0x5f, 0x52, 0x45, 0x46, 0x52, 0x45,
	0x53, 0x48, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x0b, 0x12, 0x31, 0x0a, 0x2d, 0x53, 0x45,
	0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x47, 0x49, 0x54, 0x48, 0x55, 0x42,
	0x5f, 0x41, 0x50, 0x50, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x54, 0x4f, 0x5f, 0x53,
	0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x0c, 0x12, 0x2f, 0x0a,
	0x2b, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x47, 0x49, 0x54,
	0x48, 0x55, 0x42, 0x5f, 0x41, 0x50, 0x50, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x54, 0x4f, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x0d, 0x12, 0x34,
	0x0a, 0x30, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x47, 0x49,
	0x54, 0x48, 0x55, 0x42, 0x5f, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x49, 0x43, 0x5f, 0x50, 0x45, 0x52,
	0x53, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x4f, 0x4b,
	0x45, 0x4e, 0x10, 0x0e, 0x12, 0x39, 0x0a, 0x35, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b,
	0x49, 0x4e, 0x44, 0x5f, 0x47, 0x49, 0x54, 0x48, 0x55, 0x42, 0x5f, 0x46, 0x49, 0x4e, 0x45, 0x5f,
	0x47, 0x52, 0x41, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x50, 0x45, 0x52, 0x53, 0x4f, 0x4e, 0x41, 0x4c,
	0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x0f, 0x12,
	0x22, 0x0a, 0x1e, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x47,
	0x49, 0x54, 0x48, 0x55, 0x42, 0x5f, 0x4f, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x54, 0x4f, 0x4b, 0x45,
	0x4e, 0x10, 0x10, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49,
	0x4e, 0x44, 0x5f, 0x48, 0x55, 0x47, 0x47, 0x49, 0x4e, 0x47, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x41,
	0x50, 0x49, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x11, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x45, 0x43, 0x52,
	0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x4f, 0x50, 0x45, 0x4e, 0x41, 0x49, 0x5f, 0x41,
	0x50, 0x49, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x12, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x45, 0x43, 0x52,
	0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x50, 0x45, 0x52, 0x50, 0x4c, 0x45, 0x58, 0x49,
	0x54, 0x59, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x13, 0x12, 0x21, 0x0a, 0x1d,
	0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x53, 0x54, 0x52, 0x49,
	0x50, 0x45, 0x5f, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x14, 0x12,
	0x25, 0x0a, 0x21, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x53,
	0x54, 0x52, 0x49, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x45, 0x44,
	0x5f, 0x4b, 0x45, 0x59, 0x10, 0x15, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54,
	0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x50, 0x45, 0x5f, 0x57, 0x45, 0x42,
	0x48, 0x4f, 0x4f, 0x4b, 0x5f, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x10, 0x16, 0x42, 0x51, 0x0a,
	0x0d, 0x69, 0x6f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x50, 0x01,
	0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f,
	0x76, 0x31, 0x3b, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0xa2, 0x02, 0x03, 0x47, 0x52, 0x41,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_grafeas_v1_secret_proto_rawDescOnce sync.Once
	file_grafeas_v1_secret_proto_rawDescData = file_grafeas_v1_secret_proto_rawDesc
)

func file_grafeas_v1_secret_proto_rawDescGZIP() []byte {
	file_grafeas_v1_secret_proto_rawDescOnce.Do(func() {
		file_grafeas_v1_secret_proto_rawDescData = protoimpl.X.CompressGZIP(file_grafeas_v1_secret_proto_rawDescData)
	})
	return file_grafeas_v1_secret_proto_rawDescData
}

var file_grafeas_v1_secret_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_grafeas_v1_secret_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_grafeas_v1_secret_proto_goTypes = []interface{}{
	(SecretKind)(0),               // 0: grafeas.v1.SecretKind
	(SecretStatus_Status)(0),      // 1: grafeas.v1.SecretStatus.Status
	(*SecretNote)(nil),            // 2: grafeas.v1.SecretNote
	(*SecretOccurrence)(nil),      // 3: grafeas.v1.SecretOccurrence
	(*SecretLocation)(nil),        // 4: grafeas.v1.SecretLocation
	(*SecretStatus)(nil),          // 5: grafeas.v1.SecretStatus
	(*anypb.Any)(nil),             // 6: google.protobuf.Any
	(*Digest)(nil),                // 7: grafeas.v1.Digest
	(*FileLocation)(nil),          // 8: grafeas.v1.FileLocation
	(*timestamppb.Timestamp)(nil), // 9: google.protobuf.Timestamp
}
var file_grafeas_v1_secret_proto_depIdxs = []int32{
	0, // 0: grafeas.v1.SecretOccurrence.kind:type_name -> grafeas.v1.SecretKind
	4, // 1: grafeas.v1.SecretOccurrence.locations:type_name -> grafeas.v1.SecretLocation
	5, // 2: grafeas.v1.SecretOccurrence.statuses:type_name -> grafeas.v1.SecretStatus
	6, // 3: grafeas.v1.SecretOccurrence.data:type_name -> google.protobuf.Any
	7, // 4: grafeas.v1.SecretOccurrence.digest:type_name -> grafeas.v1.Digest
	8, // 5: grafeas.v1.SecretLocation.file_location:type_name -> grafeas.v1.FileLocation
	1, // 6: grafeas.v1.SecretStatus.status:type_name -> grafeas.v1.SecretStatus.Status
	9, // 7: grafeas.v1.SecretStatus.update_time:type_name -> google.protobuf.Timestamp
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_grafeas_v1_secret_proto_init() }
func file_grafeas_v1_secret_proto_init() {
	if File_grafeas_v1_secret_proto != nil {
		return
	}
	file_grafeas_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_grafeas_v1_secret_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretNote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_secret_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretOccurrence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_secret_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_secret_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_grafeas_v1_secret_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*SecretLocation_FileLocation)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_grafeas_v1_secret_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_grafeas_v1_secret_proto_goTypes,
		DependencyIndexes: file_grafeas_v1_secret_proto_depIdxs,
		EnumInfos:         file_grafeas_v1_secret_proto_enumTypes,
		MessageInfos:      file_grafeas_v1_secret_proto_msgTypes,
	}.Build()
	File_grafeas_v1_secret_proto = out.File
	file_grafeas_v1_secret_proto_rawDesc = nil
	file_grafeas_v1_secret_proto_goTypes = nil
	file_grafeas_v1_secret_proto_depIdxs = nil
}
