/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public class BuiltInPartitioner {
    private final Logger log;
    private final String topic;
    private final int stickyBatchSize;
    private volatile PartitionLoadStats partitionLoadStats = null;
    private final AtomicReference<StickyPartitionInfo> stickyPartitionInfo = new AtomicReference();

    public BuiltInPartitioner(LogContext logContext, String topic, int stickyBatchSize) {
        this.log = logContext.logger(BuiltInPartitioner.class);
        this.topic = topic;
        if (stickyBatchSize < 1) {
            throw new IllegalArgumentException("stickyBatchSize must be >= 1 but got " + stickyBatchSize);
        }
        this.stickyBatchSize = stickyBatchSize;
    }

    private int nextPartition(Cluster cluster) {
        int partition;
        int random = this.randomPartition();
        PartitionLoadStats partitionLoadStats = this.partitionLoadStats;
        if (partitionLoadStats == null) {
            List<PartitionInfo> availablePartitions = cluster.availablePartitionsForTopic(this.topic);
            if (!availablePartitions.isEmpty()) {
                partition = availablePartitions.get(random % availablePartitions.size()).partition();
            } else {
                List<PartitionInfo> partitions = cluster.partitionsForTopic(this.topic);
                partition = random % partitions.size();
            }
        } else {
            assert (partitionLoadStats.length > 0);
            int[] cumulativeFrequencyTable = partitionLoadStats.cumulativeFrequencyTable;
            int weightedRandom = random % cumulativeFrequencyTable[partitionLoadStats.length - 1];
            int searchResult = Arrays.binarySearch(cumulativeFrequencyTable, 0, partitionLoadStats.length, weightedRandom);
            int partitionIndex = Math.abs(searchResult + 1);
            assert (partitionIndex < partitionLoadStats.length);
            partition = partitionLoadStats.partitionIds[partitionIndex];
        }
        this.log.trace("Switching to partition {} in topic {}", (Object)partition, (Object)this.topic);
        return partition;
    }

    int randomPartition() {
        return Utils.toPositive(ThreadLocalRandom.current().nextInt());
    }

    public int loadStatsRangeEnd() {
        assert (this.partitionLoadStats != null);
        assert (this.partitionLoadStats.length > 0);
        return this.partitionLoadStats.cumulativeFrequencyTable[this.partitionLoadStats.length - 1];
    }

    StickyPartitionInfo peekCurrentPartitionInfo(Cluster cluster) {
        StickyPartitionInfo partitionInfo = this.stickyPartitionInfo.get();
        if (partitionInfo != null) {
            return partitionInfo;
        }
        partitionInfo = new StickyPartitionInfo(this.nextPartition(cluster));
        if (this.stickyPartitionInfo.compareAndSet(null, partitionInfo)) {
            return partitionInfo;
        }
        return this.stickyPartitionInfo.get();
    }

    boolean isPartitionChanged(StickyPartitionInfo partitionInfo) {
        return partitionInfo != null && this.stickyPartitionInfo.get() != partitionInfo;
    }

    void updatePartitionInfo(StickyPartitionInfo partitionInfo, int appendedBytes, Cluster cluster) {
        this.updatePartitionInfo(partitionInfo, appendedBytes, cluster, true);
    }

    void updatePartitionInfo(StickyPartitionInfo partitionInfo, int appendedBytes, Cluster cluster, boolean enableSwitch) {
        if (partitionInfo == null) {
            return;
        }
        assert (partitionInfo == this.stickyPartitionInfo.get());
        int producedBytes = partitionInfo.producedBytes.addAndGet(appendedBytes);
        if (producedBytes >= this.stickyBatchSize * 2) {
            this.log.trace("Produced {} bytes, exceeding twice the batch size of {} bytes, with switching set to {}", new Object[]{producedBytes, this.stickyBatchSize, enableSwitch});
        }
        if (producedBytes >= this.stickyBatchSize && enableSwitch || producedBytes >= this.stickyBatchSize * 2) {
            StickyPartitionInfo newPartitionInfo = new StickyPartitionInfo(this.nextPartition(cluster));
            this.stickyPartitionInfo.set(newPartitionInfo);
        }
    }

    public void updatePartitionLoadStats(int[] queueSizes, int[] partitionIds, int length) {
        int i;
        if (queueSizes == null) {
            this.log.trace("No load stats for topic {}, not using adaptive", (Object)this.topic);
            this.partitionLoadStats = null;
            return;
        }
        assert (queueSizes.length == partitionIds.length);
        assert (length <= queueSizes.length);
        if (length < 1 || queueSizes.length < 2) {
            this.log.trace("The number of partitions is too small: available={}, all={}, not using adaptive for topic {}", new Object[]{length, queueSizes.length, this.topic});
            this.partitionLoadStats = null;
            return;
        }
        int maxSizePlus1 = queueSizes[0];
        boolean allEqual = true;
        for (i = 1; i < length; ++i) {
            if (queueSizes[i] != maxSizePlus1) {
                allEqual = false;
            }
            if (queueSizes[i] <= maxSizePlus1) continue;
            maxSizePlus1 = queueSizes[i];
        }
        ++maxSizePlus1;
        if (allEqual && length == queueSizes.length) {
            this.log.trace("All queue lengths are the same, not using adaptive for topic {}", (Object)this.topic);
            this.partitionLoadStats = null;
            return;
        }
        queueSizes[0] = maxSizePlus1 - queueSizes[0];
        for (i = 1; i < length; ++i) {
            queueSizes[i] = maxSizePlus1 - queueSizes[i] + queueSizes[i - 1];
        }
        this.log.trace("Partition load stats for topic {}: CFT={}, IDs={}, length={}", new Object[]{this.topic, queueSizes, partitionIds, length});
        this.partitionLoadStats = new PartitionLoadStats(queueSizes, partitionIds, length);
    }

    public static int partitionForKey(byte[] serializedKey, int numPartitions) {
        return Utils.toPositive(Utils.murmur2(serializedKey)) % numPartitions;
    }

    private static final class PartitionLoadStats {
        public final int[] cumulativeFrequencyTable;
        public final int[] partitionIds;
        public final int length;

        public PartitionLoadStats(int[] cumulativeFrequencyTable, int[] partitionIds, int length) {
            assert (cumulativeFrequencyTable.length == partitionIds.length);
            assert (length <= cumulativeFrequencyTable.length);
            this.cumulativeFrequencyTable = cumulativeFrequencyTable;
            this.partitionIds = partitionIds;
            this.length = length;
        }
    }

    public static class StickyPartitionInfo {
        private final int index;
        private final AtomicInteger producedBytes = new AtomicInteger();

        StickyPartitionInfo(int index) {
            this.index = index;
        }

        public int partition() {
            return this.index;
        }
    }
}

