/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.stat;

import io.jenetics.stat.LongMomentStatistics;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;

public final class LongMoments
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long _count;
    private final long _min;
    private final long _max;
    private final long _sum;
    private final double _mean;
    private final double _variance;
    private final double _skewness;
    private final double _kurtosis;

    private LongMoments(long count, long min, long max, long sum, double mean, double variance, double skewness, double kurtosis) {
        this._count = count;
        this._min = min;
        this._max = max;
        this._sum = sum;
        this._mean = mean;
        this._variance = variance;
        this._skewness = skewness;
        this._kurtosis = kurtosis;
    }

    public long getCount() {
        return this._count;
    }

    public long getMin() {
        return this._min;
    }

    public long getMax() {
        return this._max;
    }

    public long getSum() {
        return this._sum;
    }

    public double getMean() {
        return this._mean;
    }

    public double getVariance() {
        return this._variance;
    }

    public double getSkewness() {
        return this._skewness;
    }

    public double getKurtosis() {
        return this._kurtosis;
    }

    public int hashCode() {
        int hash = 17;
        hash = (int)((long)hash + (33L * this._count + 37L));
        hash = (int)((long)hash + (33L * this._sum + 37L));
        hash = (int)((long)hash + (33L * this._min + 37L));
        hash = (int)((long)hash + (33L * this._max + 37L));
        hash += 33 * Double.hashCode(this._mean) + 37;
        hash += 33 * Double.hashCode(this._variance) + 37;
        hash += 33 * Double.hashCode(this._skewness) + 37;
        return hash += 33 * Double.hashCode(this._kurtosis) + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof LongMoments && this._count == ((LongMoments)obj)._count && this._sum == ((LongMoments)obj)._sum && this._min == ((LongMoments)obj)._min && this._max == ((LongMoments)obj)._max && Double.compare(this._mean, ((LongMoments)obj)._mean) == 0 && Double.compare(this._variance, ((LongMoments)obj)._variance) == 0 && Double.compare(this._skewness, ((LongMoments)obj)._skewness) == 0 && Double.compare(this._kurtosis, ((LongMoments)obj)._kurtosis) == 0;
    }

    public String toString() {
        return String.format("LongMoments[N=%d, \u2227=%s, \u2228=%s, \u03a3=%s, \u03bc=%s, s\u00b2=%s, S=%s, K=%s]", this.getCount(), this.getMin(), this.getMax(), this.getSum(), this.getMean(), this.getVariance(), this.getSkewness(), this.getKurtosis());
    }

    public static LongMoments of(long count, long min, long max, long sum, double mean, double variance, double skewness, double kurtosis) {
        return new LongMoments(count, min, max, sum, mean, variance, skewness, kurtosis);
    }

    public static LongMoments of(LongMomentStatistics statistics) {
        return new LongMoments(statistics.getCount(), statistics.getMin(), statistics.getMax(), statistics.getSum(), statistics.getMean(), statistics.getVariance(), statistics.getSkewness(), statistics.getKurtosis());
    }

    public static <N extends Number> Collector<N, ?, LongMoments> toLongMoments() {
        return LongMoments.toLongMoments(Number::longValue);
    }

    public static <T> Collector<T, ?, LongMoments> toLongMoments(ToLongFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return Collector.of(LongMomentStatistics::new, (a, b) -> a.accept(mapper.applyAsLong(b)), LongMomentStatistics::combine, LongMoments::of, new Collector.Characteristics[0]);
    }
}

