/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.firewall;

import com.ubnt.data.Site;
import com.ubnt.model.api.firewall.policy.FirewallPolicyDto;
import com.ubnt.model.api.firewall.policy.FirewallPolicyReorderDto;
import com.ubnt.model.api.firewall.policy.FirewallPolicyUpdateDto;
import com.ubnt.model.api.firewall.policy.PreDefinedFirewallRuleUpdateDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.config.ubios.firewall.predefined.rule.OoOO;
import com.ubnt.service.firewall.policy.FirewallPolicyDocument;
import com.ubnt.service.firewall.policy.Oooo;
import com.ubnt.service.firewall.policy.U;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Tag(name="Firewall Policies")
public class FirewallPolicyController {
    private final U \u00d200000;
    private final OoOO o00000;

    @GetMapping(value={"/api/site/{siteName}/firewall-policies"})
    @Operation(summary="List Firewall Policies")
    public List<FirewallPolicyDto> listFirewallPolicies(@PathVariable(value="siteName") Site site) {
        String string = site.getId();
        return this.\u00d200000.\u00f800000(string);
    }

    @GetMapping(value={"/api/site/{siteName}/firewall-policies/{id}"})
    @Operation(summary="Get Firewall Policy")
    public FirewallPolicyDto getFirewallPolicy(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        return FirewallPolicyDto.fromDocument(this.\u00d200000.\u00f8O0000(string, site.getId()));
    }

    @PostMapping(value={"/api/site/{siteName}/firewall-policies"}, consumes={"application/json"})
    @Operation(summary="Create a new Firewall Policy")
    @ResponseStatus(value=HttpStatus.CREATED)
    public FirewallPolicyDto createFirewallPolicy(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull FirewallPolicyDto firewallPolicyDto) {
        FirewallPolicyDocument firewallPolicyDocument = this.\u00d200000.private(firewallPolicyDto.toDocument(site.getId()));
        return FirewallPolicyDto.fromDocument(firewallPolicyDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/firewall-policies/{id}"}, consumes={"application/json"})
    @Operation(summary="Update Firewall Policy")
    public FirewallPolicyDto updateFirewallPolicy(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid @NotNull FirewallPolicyDto firewallPolicyDto) {
        FirewallPolicyDto firewallPolicyDto2 = FirewallPolicyDto.withId(firewallPolicyDto, string);
        FirewallPolicyDocument firewallPolicyDocument = this.\u00d200000.\u00d6O0000(firewallPolicyDto2.toDocument(site.getId()));
        return FirewallPolicyDto.fromDocument(firewallPolicyDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/firewall-policies/predefined/{id}"}, consumes={"application/json"})
    @Operation(summary="Update PreDefined Firewall Policy")
    public PreDefinedFirewallRuleUpdateDto updatePreDefinedFirewallPolicy(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid @NotNull PreDefinedFirewallRuleUpdateDto preDefinedFirewallRuleUpdateDto) {
        PreDefinedFirewallRuleUpdateDto preDefinedFirewallRuleUpdateDto2 = PreDefinedFirewallRuleUpdateDto.withId(preDefinedFirewallRuleUpdateDto, string);
        this.o00000.for(site.getId(), preDefinedFirewallRuleUpdateDto2);
        return preDefinedFirewallRuleUpdateDto;
    }

    @DeleteMapping(value={"/api/site/{siteName}/firewall-policies/{id}"})
    @Operation(summary="Delete Firewall Policy")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFirewallPolicy(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        this.\u00d200000.returnsuper(string, site.getId());
    }

    @GetMapping(value={"/api/site/{siteName}/firewall-policies/defaults"})
    @Operation(summary="Get default Firewall Policy settings")
    public FirewallPolicyDto getDefaults(@PathVariable(value="siteName") Site site) {
        return FirewallPolicyDto.fromDocument(this.\u00d200000.\u00f600000());
    }

    @PostMapping(value={"/api/site/{siteName}/firewall-policies/batch-delete"})
    @Operation(summary="Batch delete Firewall Policies")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void batchDeleteFirewallPolicies(@PathVariable(value="siteName") Site site, @RequestBody @NotEmpty List<String> list) {
        this.\u00d200000.ifsuper(list, site.getId());
    }

    @PutMapping(value={"/api/site/{siteName}/firewall-policies/batch"})
    @Operation(summary="Batch update Firewall Policies")
    public List<FirewallPolicyDto> batchUpdateFirewallPolicies(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<FirewallPolicyUpdateDto> list) {
        List<Oooo> list2 = list.stream().map(FirewallPolicyUpdateDto::toUpdate).toList();
        List<FirewallPolicyDocument> list3 = this.\u00d200000.oO0000(list2, site.getId());
        return list3.stream().map(FirewallPolicyDto::fromDocument).toList();
    }

    @PutMapping(value={"/api/site/{siteName}/firewall-policies/batch-reorder"})
    @Operation(summary="Reorder Firewall Policies")
    public List<FirewallPolicyDto> reorderFirewallPolicies(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty FirewallPolicyReorderDto firewallPolicyReorderDto) {
        List<FirewallPolicyDocument> list = this.\u00d200000.\u00d8o0000(firewallPolicyReorderDto.beforePredefinedIds(), firewallPolicyReorderDto.afterPredefinedIds(), site.getId(), firewallPolicyReorderDto.sourceZoneId(), firewallPolicyReorderDto.destinationZoneId());
        return list.stream().map(FirewallPolicyDto::fromDocument).toList();
    }

    @ConstructorProperties(value={"firewallPolicyService", "preDefinedFirewallRuleService"})
    @Generated
    public FirewallPolicyController(U u2, OoOO ooOO2) {
        this.\u00d200000 = u2;
        this.o00000 = ooOO2;
    }
}

