/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.alert;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.alert.AlertDevicesDtoParameters;
import com.ubnt.model.api.alert.AlertDtoParameters;
import com.ubnt.model.api.alert.DeviceDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Generated(from="AlertDevicesDtoParameters", generator="Immutables")
public final class ImmutableAlertDevicesDtoParameters
implements AlertDevicesDtoParameters {
    private final String id;
    private final String name;
    @Nullable
    private final Boolean notActionable;
    @Nullable
    private final Boolean enclosedWithBrackets;
    private final List<DeviceDto> devices;

    private ImmutableAlertDevicesDtoParameters(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.notActionable = builder.notActionable;
        this.enclosedWithBrackets = builder.enclosedWithBrackets;
        this.devices = ImmutableAlertDevicesDtoParameters.\u00d5O0000(true, builder.devices);
    }

    @Override
    @Schema(name="ID of the referenced entity")
    public String id() {
        return this.id;
    }

    @Override
    @Schema(name="Name of the referenced entity")
    public String name() {
        return this.name;
    }

    @Override
    @Schema(name="System log parameter not actionable", example="true")
    public Optional<Boolean> notActionable() {
        return Optional.ofNullable(this.notActionable);
    }

    @Override
    @Schema(name="enclose the parameter with brackets")
    public Optional<Boolean> enclosedWithBrackets() {
        return Optional.ofNullable(this.enclosedWithBrackets);
    }

    @Override
    @Schema(name="Devices")
    public List<DeviceDto> devices() {
        return this.devices;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableAlertDevicesDtoParameters && this.\u00d8O0000(0, (ImmutableAlertDevicesDtoParameters)object);
    }

    private boolean \u00d8O0000(int n2, ImmutableAlertDevicesDtoParameters immutableAlertDevicesDtoParameters) {
        return Objects.equals(this.id, immutableAlertDevicesDtoParameters.id) && Objects.equals(this.name, immutableAlertDevicesDtoParameters.name) && Objects.equals(this.notActionable, immutableAlertDevicesDtoParameters.notActionable) && Objects.equals(this.enclosedWithBrackets, immutableAlertDevicesDtoParameters.enclosedWithBrackets) && this.devices.equals(immutableAlertDevicesDtoParameters.devices);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + Objects.hashCode(this.id);
        n2 += (n2 << 5) + Objects.hashCode(this.name);
        n2 += (n2 << 5) + Objects.hashCode(this.notActionable);
        n2 += (n2 << 5) + Objects.hashCode(this.enclosedWithBrackets);
        n2 += (n2 << 5) + this.devices.hashCode();
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AlertDevicesDtoParameters{");
        if (this.id != null) {
            stringBuilder.append("id=").append(this.id);
        }
        if (this.name != null) {
            if (stringBuilder.length() > 26) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("name=").append(this.name);
        }
        if (this.notActionable != null) {
            if (stringBuilder.length() > 26) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("notActionable=").append(this.notActionable);
        }
        if (this.enclosedWithBrackets != null) {
            if (stringBuilder.length() > 26) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("enclosedWithBrackets=").append(this.enclosedWithBrackets);
        }
        if (stringBuilder.length() > 26) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("devices=").append(this.devices);
        return stringBuilder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> thissuper(Iterable<? extends T> iterable, boolean bl, boolean bl2) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n2);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t2 : iterable) {
            if (bl2 && t2 == null) continue;
            if (bl) {
                Objects.requireNonNull(t2, "element");
            }
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static <T> List<T> \u00d5O0000(boolean bl, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AlertDevicesDtoParameters", generator="Immutables")
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private Boolean notActionable;
        @Nullable
        private Boolean enclosedWithBrackets;
        private List<DeviceDto> devices = new ArrayList<DeviceDto>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AlertDtoParameters alertDtoParameters) {
            Objects.requireNonNull(alertDtoParameters, "instance");
            this.o00000((short)0, alertDtoParameters);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AlertDevicesDtoParameters alertDevicesDtoParameters) {
            Objects.requireNonNull(alertDevicesDtoParameters, "instance");
            this.o00000((short)0, alertDevicesDtoParameters);
            return this;
        }

        private void o00000(short s2, Object object) {
            Optional<Boolean> optional;
            AlertDtoParameters alertDtoParameters;
            long l2 = 0L;
            if (object instanceof AlertDtoParameters) {
                alertDtoParameters = (AlertDtoParameters)object;
                if ((l2 & 4L) == 0L) {
                    optional = alertDtoParameters.name();
                    if (optional != null) {
                        this.name((String)((Object)optional));
                    }
                    l2 |= 4L;
                }
                if ((l2 & 8L) == 0L) {
                    optional = alertDtoParameters.id();
                    if (optional != null) {
                        this.id((String)((Object)optional));
                    }
                    l2 |= 8L;
                }
                if ((l2 & 1L) == 0L) {
                    optional = alertDtoParameters.enclosedWithBrackets();
                    if (optional.isPresent()) {
                        this.enclosedWithBrackets(optional);
                    }
                    l2 |= 1L;
                }
                if ((l2 & 2L) == 0L) {
                    optional = alertDtoParameters.notActionable();
                    if (optional.isPresent()) {
                        this.notActionable(optional);
                    }
                    l2 |= 2L;
                }
            }
            if (object instanceof AlertDevicesDtoParameters) {
                alertDtoParameters = (AlertDevicesDtoParameters)object;
                if ((l2 & 4L) == 0L) {
                    optional = alertDtoParameters.name();
                    if (optional != null) {
                        this.name((String)((Object)optional));
                    }
                    l2 |= 4L;
                }
                if ((l2 & 8L) == 0L) {
                    optional = alertDtoParameters.id();
                    if (optional != null) {
                        this.id((String)((Object)optional));
                    }
                    l2 |= 8L;
                }
                if ((l2 & 1L) == 0L) {
                    optional = alertDtoParameters.enclosedWithBrackets();
                    if (optional.isPresent()) {
                        this.enclosedWithBrackets(optional);
                    }
                    l2 |= 1L;
                }
                this.addAllDevices(alertDtoParameters.devices());
                if ((l2 & 2L) == 0L) {
                    optional = alertDtoParameters.notActionable();
                    if (optional.isPresent()) {
                        this.notActionable(optional);
                    }
                    l2 |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(String string) {
            this.id = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String string) {
            this.name = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder notActionable(@Nullable Boolean bl) {
            this.notActionable = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder notActionable(Optional<Boolean> optional) {
            this.notActionable = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enclosedWithBrackets(@Nullable Boolean bl) {
            this.enclosedWithBrackets = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enclosedWithBrackets(Optional<Boolean> optional) {
            this.enclosedWithBrackets = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDevices(@Nullable DeviceDto deviceDto) {
            this.devices.add(deviceDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDevices(DeviceDto ... deviceDtoArray) {
            for (DeviceDto deviceDto : deviceDtoArray) {
                this.devices.add(deviceDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder devices(Iterable<? extends DeviceDto> iterable) {
            this.devices.clear();
            return this.addAllDevices(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDevices(Iterable<? extends DeviceDto> iterable) {
            for (DeviceDto deviceDto : iterable) {
                this.devices.add(deviceDto);
            }
            return this;
        }

        public ImmutableAlertDevicesDtoParameters build() {
            return new ImmutableAlertDevicesDtoParameters(this);
        }
    }
}

