/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.alg.KosarajuStrongConnectivityInspector;
import org.jgrapht.alg.cycle.HierholzerEulerianCycle;
import org.jgrapht.graph.AbstractBaseGraph;

public abstract class GraphTests {
    public static <V, E> boolean isEmpty(Graph<V, E> graph) {
        Objects.requireNonNull(graph, "Graph cannot be null");
        return graph.edgeSet().isEmpty();
    }

    public static <V, E> boolean isSimple(Graph<V, E> graph) {
        AbstractBaseGraph abg;
        Objects.requireNonNull(graph, "Graph cannot be null");
        if (graph instanceof AbstractBaseGraph && !(abg = (AbstractBaseGraph)graph).isAllowingLoops() && !abg.isAllowingMultipleEdges()) {
            return true;
        }
        boolean isDirected = graph instanceof DirectedGraph;
        for (V v : graph.vertexSet()) {
            Set<E> edgesOf = isDirected ? ((DirectedGraph)graph).outgoingEdgesOf(v) : graph.edgesOf(v);
            HashSet<V> neighbors = new HashSet<V>();
            for (Object e : edgesOf) {
                V u = Graphs.getOppositeVertex(graph, e, v);
                if (!u.equals(v) && neighbors.add(u)) continue;
                return false;
            }
        }
        return true;
    }

    public static <V, E> boolean isComplete(Graph<V, E> graph) {
        int allEdges;
        Objects.requireNonNull(graph, "Graph cannot be null");
        int n = graph.vertexSet().size();
        if (graph instanceof DirectedGraph) {
            allEdges = Math.multiplyExact(n, n - 1);
        } else if (graph instanceof UndirectedGraph) {
            allEdges = n % 2 == 0 ? Math.multiplyExact(n / 2, n - 1) : Math.multiplyExact(n, (n - 1) / 2);
        } else {
            throw new IllegalArgumentException("Graph must be directed or undirected");
        }
        return graph.edgeSet().size() == allEdges && GraphTests.isSimple(graph);
    }

    public static <V, E> boolean isConnected(UndirectedGraph<V, E> graph) {
        Objects.requireNonNull(graph, "Graph cannot be null");
        return new ConnectivityInspector<V, E>(graph).isGraphConnected();
    }

    public static <V, E> boolean isWeaklyConnected(DirectedGraph<V, E> graph) {
        Objects.requireNonNull(graph, "Graph cannot be null");
        return new ConnectivityInspector<V, E>(graph).isGraphConnected();
    }

    public static <V, E> boolean isStronglyConnected(DirectedGraph<V, E> graph) {
        Objects.requireNonNull(graph, "Graph cannot be null");
        return new KosarajuStrongConnectivityInspector<V, E>(graph).isStronglyConnected();
    }

    public static <V, E> boolean isTree(UndirectedGraph<V, E> graph) {
        return graph.edgeSet().size() == graph.vertexSet().size() - 1 && GraphTests.isConnected(graph);
    }

    public static <V, E> boolean isBipartite(Graph<V, E> graph) {
        if (GraphTests.isEmpty(graph)) {
            return true;
        }
        try {
            if (Math.multiplyExact(4, graph.edgeSet().size()) > Math.multiplyExact(graph.vertexSet().size(), graph.vertexSet().size())) {
                return false;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        HashSet<V> unknown = new HashSet<V>(graph.vertexSet());
        HashSet<V> odd = new HashSet<V>();
        LinkedList<Object> queue = new LinkedList<Object>();
        while (!unknown.isEmpty()) {
            if (queue.isEmpty()) {
                queue.add(unknown.iterator().next());
            }
            Object v = queue.removeFirst();
            unknown.remove(v);
            for (E e : graph.edgesOf(v)) {
                V n = Graphs.getOppositeVertex(graph, e, v);
                if (unknown.contains(n)) {
                    queue.add(n);
                    if (odd.contains(v)) continue;
                    odd.add(n);
                    continue;
                }
                if (odd.contains(v) ^ odd.contains(n)) continue;
                return false;
            }
        }
        return true;
    }

    public static <V, E> boolean isBipartitePartition(Graph<V, E> graph, Set<? extends V> firstPartition, Set<? extends V> secondPartition) {
        Objects.requireNonNull(graph, "Graph cannot be null");
        Objects.requireNonNull(firstPartition, "First partition cannot be null");
        Objects.requireNonNull(secondPartition, "Second partition cannot be null");
        if (graph.vertexSet().size() != firstPartition.size() + secondPartition.size()) {
            return false;
        }
        for (V v : graph.vertexSet()) {
            Set<V> otherPartition;
            if (firstPartition.contains(v)) {
                otherPartition = secondPartition;
            } else if (secondPartition.contains(v)) {
                otherPartition = firstPartition;
            } else {
                return false;
            }
            for (E e : graph.edgesOf(v)) {
                V other = Graphs.getOppositeVertex(graph, e, v);
                if (otherPartition.contains(other)) continue;
                return false;
            }
        }
        return true;
    }

    public static <V, E> boolean isEulerian(Graph<V, E> graph) {
        Objects.requireNonNull(graph, "Graph cannot be null");
        return new HierholzerEulerianCycle<V, E>().isEulerian(graph);
    }
}

