/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.Near;
import org.springframework.data.mongodb.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

public class MongoParameters
extends Parameters<MongoParameters, MongoParameter> {
    private final int rangeIndex;
    private final int maxDistanceIndex;
    @Nullable
    private final Integer fullTextIndex;
    @Nullable
    private final Integer nearIndex;
    @Nullable
    private final Integer collationIndex;
    private final int updateIndex;
    private final TypeInformation<?> domainType;

    public MongoParameters(ParametersSource parametersSource, boolean isGeoNearMethod) {
        this(parametersSource, new NearIndex(parametersSource, isGeoNearMethod));
    }

    private MongoParameters(ParametersSource parametersSource, NearIndex nearIndex) {
        super(parametersSource, methodParameter -> new MongoParameter((MethodParameter)methodParameter, (TypeInformation<?>)parametersSource.getDomainTypeInformation(), nearIndex.nearIndex));
        Method method = parametersSource.getMethod();
        List<Class<?>> parameterTypes = Arrays.asList(method.getParameterTypes());
        this.domainType = parametersSource.getDomainTypeInformation();
        this.fullTextIndex = parameterTypes.indexOf(TextCriteria.class);
        TypeInformation declaringClassInfo = TypeInformation.of((Class)parametersSource.getContainingClass());
        List parameterTypeInfo = declaringClassInfo.getParameterTypes(method);
        this.rangeIndex = this.getTypeIndex(parameterTypeInfo, Range.class, Distance.class);
        this.maxDistanceIndex = this.rangeIndex == -1 ? this.getTypeIndex(parameterTypeInfo, Distance.class, null) : -1;
        this.collationIndex = this.getTypeIndex(parameterTypeInfo, Collation.class, null);
        this.updateIndex = QueryUtils.indexOfAssignableParameter(UpdateDefinition.class, parameterTypes);
        this.nearIndex = nearIndex.nearIndex;
    }

    private MongoParameters(List<MongoParameter> parameters, int maxDistanceIndex, @Nullable Integer nearIndex, @Nullable Integer fullTextIndex, int rangeIndex, @Nullable Integer collationIndex, int updateIndex, TypeInformation<?> domainType) {
        super(parameters);
        this.nearIndex = nearIndex;
        this.fullTextIndex = fullTextIndex;
        this.maxDistanceIndex = maxDistanceIndex;
        this.rangeIndex = rangeIndex;
        this.collationIndex = collationIndex;
        this.updateIndex = updateIndex;
        this.domainType = domainType;
    }

    private static int getNearIndex(List<Class<?>> parameterTypes) {
        for (Class reference : Arrays.asList(Point.class, double[].class)) {
            int nearIndex = parameterTypes.indexOf(reference);
            if (nearIndex == -1) continue;
            if (nearIndex == parameterTypes.lastIndexOf(reference)) {
                return nearIndex;
            }
            throw new IllegalStateException("Multiple Point parameters found but none annotated with @Near");
        }
        return -1;
    }

    static int findNearIndexInParameters(Method method) {
        int index = -1;
        for (java.lang.reflect.Parameter p : method.getParameters()) {
            MethodParameter methodParameter = MethodParameter.forParameter((java.lang.reflect.Parameter)p);
            if (!Point.class.isAssignableFrom(methodParameter.getParameterType()) && !methodParameter.getParameterType().equals(double[].class) || !methodParameter.hasParameterAnnotation(Near.class)) continue;
            if (index == -1) {
                index = methodParameter.getParameterIndex();
                continue;
            }
            throw new IllegalStateException(String.format("Found multiple @Near annotations ond method %s; Only one allowed", method));
        }
        return index;
    }

    public int getDistanceRangeIndex() {
        return -1;
    }

    public int getMaxDistanceIndex() {
        return this.maxDistanceIndex;
    }

    public int getNearIndex() {
        return this.nearIndex;
    }

    public int getFullTextParameterIndex() {
        return this.fullTextIndex != null ? this.fullTextIndex : -1;
    }

    public boolean hasFullTextParameter() {
        return this.fullTextIndex != null && this.fullTextIndex >= 0;
    }

    public int getRangeIndex() {
        return this.rangeIndex;
    }

    public int getCollationParameterIndex() {
        return this.collationIndex != null ? this.collationIndex : -1;
    }

    public int getUpdateIndex() {
        return this.updateIndex;
    }

    protected MongoParameters createFrom(List<MongoParameter> parameters) {
        return new MongoParameters(parameters, this.maxDistanceIndex, this.nearIndex, this.fullTextIndex, this.rangeIndex, this.collationIndex, this.updateIndex, this.domainType);
    }

    private int getTypeIndex(List<TypeInformation<?>> parameterTypes, Class<?> type, @Nullable Class<?> componentType) {
        for (int i = 0; i < parameterTypes.size(); ++i) {
            TypeInformation<?> candidate = parameterTypes.get(i);
            if (!candidate.getType().equals(type)) continue;
            if (componentType == null) {
                return i;
            }
            if (!componentType.equals(candidate.getRequiredComponentType().getType())) continue;
            return i;
        }
        return -1;
    }

    static class NearIndex {
        @Nullable
        private final Integer nearIndex;

        public NearIndex(ParametersSource parametersSource, boolean isGeoNearMethod) {
            int index = MongoParameters.findNearIndexInParameters(parametersSource.getMethod());
            if (index == -1 && isGeoNearMethod) {
                index = MongoParameters.getNearIndex(Arrays.asList(parametersSource.getMethod().getParameterTypes()));
            }
            this.nearIndex = index;
        }
    }

    static class MongoParameter
    extends Parameter {
        private final MethodParameter parameter;
        @Nullable
        private final Integer nearIndex;

        MongoParameter(MethodParameter parameter, TypeInformation<?> domainType, @Nullable Integer nearIndex) {
            super(parameter, domainType);
            this.parameter = parameter;
            this.nearIndex = nearIndex;
            if (!this.isPoint() && this.hasNearAnnotation()) {
                throw new IllegalArgumentException("Near annotation is only allowed at Point parameter");
            }
        }

        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || Distance.class.isAssignableFrom(this.getType()) || this.isNearParameter() || TextCriteria.class.isAssignableFrom(this.getType()) || Collation.class.isAssignableFrom(this.getType());
        }

        private boolean isNearParameter() {
            return this.nearIndex != null && this.nearIndex.equals(this.getIndex());
        }

        private boolean isManuallyAnnotatedNearParameter() {
            return this.isPoint() && this.hasNearAnnotation();
        }

        private boolean isPoint() {
            return Point.class.isAssignableFrom(this.getType()) || this.getType().equals(double[].class);
        }

        private boolean hasNearAnnotation() {
            return this.parameter.getParameterAnnotation(Near.class) != null;
        }
    }
}

