// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package cloudcontrolspartner provides access to the Cloud Controls Partner API.
//
// For product documentation, see: https://cloud.google.com/sovereign-controls-by-partners/docs/sovereign-partners/reference/rest
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/cloudcontrolspartner/v1"
//	...
//	ctx := context.Background()
//	cloudcontrolspartnerService, err := cloudcontrolspartner.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	cloudcontrolspartnerService, err := cloudcontrolspartner.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	cloudcontrolspartnerService, err := cloudcontrolspartner.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package cloudcontrolspartner // import "google.golang.org/api/cloudcontrolspartner/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "cloudcontrolspartner:v1"
const apiName = "cloudcontrolspartner"
const apiVersion = "v1"
const basePath = "https://cloudcontrolspartner.googleapis.com/"
const basePathTemplate = "https://cloudcontrolspartner.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://cloudcontrolspartner.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Organizations = NewOrganizationsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Organizations *OrganizationsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Locations = NewOrganizationsLocationsService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Locations *OrganizationsLocationsService
}

func NewOrganizationsLocationsService(s *Service) *OrganizationsLocationsService {
	rs := &OrganizationsLocationsService{s: s}
	rs.Customers = NewOrganizationsLocationsCustomersService(s)
	return rs
}

type OrganizationsLocationsService struct {
	s *Service

	Customers *OrganizationsLocationsCustomersService
}

func NewOrganizationsLocationsCustomersService(s *Service) *OrganizationsLocationsCustomersService {
	rs := &OrganizationsLocationsCustomersService{s: s}
	rs.Workloads = NewOrganizationsLocationsCustomersWorkloadsService(s)
	return rs
}

type OrganizationsLocationsCustomersService struct {
	s *Service

	Workloads *OrganizationsLocationsCustomersWorkloadsService
}

func NewOrganizationsLocationsCustomersWorkloadsService(s *Service) *OrganizationsLocationsCustomersWorkloadsService {
	rs := &OrganizationsLocationsCustomersWorkloadsService{s: s}
	rs.AccessApprovalRequests = NewOrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsService(s)
	rs.Violations = NewOrganizationsLocationsCustomersWorkloadsViolationsService(s)
	return rs
}

type OrganizationsLocationsCustomersWorkloadsService struct {
	s *Service

	AccessApprovalRequests *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsService

	Violations *OrganizationsLocationsCustomersWorkloadsViolationsService
}

func NewOrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsService(s *Service) *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsService {
	rs := &OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsService{s: s}
	return rs
}

type OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsService struct {
	s *Service
}

func NewOrganizationsLocationsCustomersWorkloadsViolationsService(s *Service) *OrganizationsLocationsCustomersWorkloadsViolationsService {
	rs := &OrganizationsLocationsCustomersWorkloadsViolationsService{s: s}
	return rs
}

type OrganizationsLocationsCustomersWorkloadsViolationsService struct {
	s *Service
}

// AccessApprovalRequest: Details about the Access request.
type AccessApprovalRequest struct {
	// Name: Identifier. Format:
	// `organizations/{organization}/locations/{location}/customers/{customer}/workl
	// oads/{workload}/accessApprovalRequests/{access_approval_request}`
	Name string `json:"name,omitempty"`
	// RequestTime: The time at which approval was requested.
	RequestTime string `json:"requestTime,omitempty"`
	// RequestedExpirationTime: The requested expiration for the approval. If the
	// request is approved, access will be granted from the time of approval until
	// the expiration time.
	RequestedExpirationTime string `json:"requestedExpirationTime,omitempty"`
	// RequestedReason: The justification for which approval is being requested.
	RequestedReason *AccessReason `json:"requestedReason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessApprovalRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccessApprovalRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessReason: Reason for the access.
type AccessReason struct {
	// Detail: More detail about certain reason types. See comments for each type
	// above.
	Detail string `json:"detail,omitempty"`
	// Type: Type of access justification.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value for proto, shouldn't be used.
	//   "CUSTOMER_INITIATED_SUPPORT" - Customer made a request or raised an issue
	// that required the principal to access customer data. `detail` is of the form
	// ("#####" is the issue ID): - "Feedback Report: #####" - "Case Number: #####"
	// - "Case ID: #####" - "E-PIN Reference: #####" - "Google-#####" - "T-#####"
	//   "GOOGLE_INITIATED_SERVICE" - The principal accessed customer data in order
	// to diagnose or resolve a suspected issue in services. Often this access is
	// used to confirm that customers are not affected by a suspected service issue
	// or to remediate a reversible system issue.
	//   "GOOGLE_INITIATED_REVIEW" - Google initiated service for security, fraud,
	// abuse, or compliance purposes.
	//   "THIRD_PARTY_DATA_REQUEST" - The principal was compelled to access
	// customer data in order to respond to a legal third party data request or
	// process, including legal processes from customers themselves.
	//   "GOOGLE_RESPONSE_TO_PRODUCTION_ALERT" - The principal accessed customer
	// data in order to diagnose or resolve a suspected issue in services or a
	// known outage.
	//   "CLOUD_INITIATED_ACCESS" - Similar to 'GOOGLE_INITIATED_SERVICE' or
	// 'GOOGLE_INITIATED_REVIEW', but with universe agnostic naming. The principal
	// accessed customer data in order to diagnose or resolve a suspected issue in
	// services or a known outage, or for security, fraud, abuse, or compliance
	// review purposes.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Detail") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Detail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessReason) MarshalJSON() ([]byte, error) {
	type NoMethod AccessReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConnectionError: Information around the error that occurred if the
// connection state is anything other than available or unspecified
type ConnectionError struct {
	// ErrorDomain: The error domain for the error
	ErrorDomain string `json:"errorDomain,omitempty"`
	// ErrorMessage: The error message for the error
	ErrorMessage string `json:"errorMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorDomain") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorDomain") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConnectionError) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectionError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Console: Remediation instructions to resolve violation via cloud console
type Console struct {
	// AdditionalLinks: Additional urls for more information about steps
	AdditionalLinks []string `json:"additionalLinks,omitempty"`
	// ConsoleUris: Link to console page where violations can be resolved
	ConsoleUris []string `json:"consoleUris,omitempty"`
	// Steps: Steps to resolve violation via cloud console
	Steps []string `json:"steps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalLinks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalLinks") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Console) MarshalJSON() ([]byte, error) {
	type NoMethod Console
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Customer: Contains metadata around a Cloud Controls Partner Customer
type Customer struct {
	// CustomerOnboardingState: Output only. Container for customer onboarding
	// steps
	CustomerOnboardingState *CustomerOnboardingState `json:"customerOnboardingState,omitempty"`
	// DisplayName: Required. Display name for the customer
	DisplayName string `json:"displayName,omitempty"`
	// IsOnboarded: Output only. Indicates whether a customer is fully onboarded
	IsOnboarded bool `json:"isOnboarded,omitempty"`
	// Name: Identifier. Format:
	// `organizations/{organization}/locations/{location}/customers/{customer}`
	Name string `json:"name,omitempty"`
	// OrganizationDomain: Output only. The customer organization domain, extracted
	// from CRM Organization’s display_name field. e.g. "google.com"
	OrganizationDomain string `json:"organizationDomain,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CustomerOnboardingState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomerOnboardingState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Customer) MarshalJSON() ([]byte, error) {
	type NoMethod Customer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerOnboardingState: Container for customer onboarding steps
type CustomerOnboardingState struct {
	// OnboardingSteps: List of customer onboarding steps
	OnboardingSteps []*CustomerOnboardingStep `json:"onboardingSteps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OnboardingSteps") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OnboardingSteps") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerOnboardingState) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerOnboardingState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerOnboardingStep: Container for customer onboarding information
type CustomerOnboardingStep struct {
	// CompletionState: Output only. Current state of the step
	//
	// Possible values:
	//   "COMPLETION_STATE_UNSPECIFIED" - Unspecified completion state.
	//   "PENDING" - Task started (has start date) but not yet completed.
	//   "SUCCEEDED" - Succeeded state.
	//   "FAILED" - Failed state.
	//   "NOT_APPLICABLE" - Not applicable state.
	CompletionState string `json:"completionState,omitempty"`
	// CompletionTime: The completion time of the onboarding step
	CompletionTime string `json:"completionTime,omitempty"`
	// StartTime: The starting time of the onboarding step
	StartTime string `json:"startTime,omitempty"`
	// Step: The onboarding step
	//
	// Possible values:
	//   "STEP_UNSPECIFIED" - Unspecified step
	//   "KAJ_ENROLLMENT" - KAJ Enrollment
	//   "CUSTOMER_ENVIRONMENT" - Customer Environment
	Step string `json:"step,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletionState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletionState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerOnboardingStep) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerOnboardingStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EkmConnection: Details about the EKM connection
type EkmConnection struct {
	// ConnectionError: The connection error that occurred if any
	ConnectionError *ConnectionError `json:"connectionError,omitempty"`
	// ConnectionName: Resource name of the EKM connection in the format:
	// projects/{project}/locations/{location}/ekmConnections/{ekm_connection}
	ConnectionName string `json:"connectionName,omitempty"`
	// ConnectionState: Output only. The connection state
	//
	// Possible values:
	//   "CONNECTION_STATE_UNSPECIFIED" - Unspecified EKM connection state
	//   "AVAILABLE" - Available EKM connection state
	//   "NOT_AVAILABLE" - Not available EKM connection state
	//   "ERROR" - Error EKM connection state
	//   "PERMISSION_DENIED" - Permission denied EKM connection state
	ConnectionState string `json:"connectionState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionError") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionError") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EkmConnection) MarshalJSON() ([]byte, error) {
	type NoMethod EkmConnection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EkmConnections: The EKM connections associated with a workload
type EkmConnections struct {
	// EkmConnections: The EKM connections associated with the workload
	EkmConnections []*EkmConnection `json:"ekmConnections,omitempty"`
	// Name: Identifier. Format:
	// `organizations/{organization}/locations/{location}/customers/{customer}/workl
	// oads/{workload}/ekmConnections`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EkmConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EkmConnections") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EkmConnections) MarshalJSON() ([]byte, error) {
	type NoMethod EkmConnections
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EkmMetadata: Holds information needed by Mudbray to use partner EKMs for
// workloads.
type EkmMetadata struct {
	// EkmEndpointUri: Endpoint for sending requests to the EKM for key
	// provisioning during Assured Workload creation.
	EkmEndpointUri string `json:"ekmEndpointUri,omitempty"`
	// EkmSolution: The Cloud EKM partner.
	//
	// Possible values:
	//   "EKM_SOLUTION_UNSPECIFIED" - Unspecified EKM solution
	//   "FORTANIX" - EKM Partner Fortanix
	//   "FUTUREX" - EKM Partner FutureX
	//   "THALES" - EKM Partner Thales
	//   "VIRTRU" - This enum value is never used.
	EkmSolution string `json:"ekmSolution,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EkmEndpointUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EkmEndpointUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EkmMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod EkmMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Gcloud: Remediation instructions to resolve violation via gcloud cli
type Gcloud struct {
	// AdditionalLinks: Additional urls for more information about steps
	AdditionalLinks []string `json:"additionalLinks,omitempty"`
	// GcloudCommands: Gcloud command to resolve violation
	GcloudCommands []string `json:"gcloudCommands,omitempty"`
	// Steps: Steps to resolve violation via gcloud cli
	Steps []string `json:"steps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalLinks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalLinks") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Gcloud) MarshalJSON() ([]byte, error) {
	type NoMethod Gcloud
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Instructions: Instructions to remediate violation
type Instructions struct {
	// ConsoleInstructions: Remediation instructions to resolve violation via cloud
	// console
	ConsoleInstructions *Console `json:"consoleInstructions,omitempty"`
	// GcloudInstructions: Remediation instructions to resolve violation via gcloud
	// cli
	GcloudInstructions *Gcloud `json:"gcloudInstructions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsoleInstructions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsoleInstructions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Instructions) MarshalJSON() ([]byte, error) {
	type NoMethod Instructions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAccessApprovalRequestsResponse: Response message for list access
// requests.
type ListAccessApprovalRequestsResponse struct {
	// AccessApprovalRequests: List of access approval requests
	AccessApprovalRequests []*AccessApprovalRequest `json:"accessApprovalRequests,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessApprovalRequests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessApprovalRequests") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAccessApprovalRequestsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAccessApprovalRequestsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCustomersResponse: Response message for list customer Customers requests
type ListCustomersResponse struct {
	// Customers: List of customers
	Customers []*Customer `json:"customers,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Customers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCustomersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCustomersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListViolationsResponse: Response message for list customer violation
// requests
type ListViolationsResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Workloads that could not be reached due to permission errors or
	// any other error. Ref: https://google.aip.dev/217
	Unreachable []string `json:"unreachable,omitempty"`
	// Violations: List of violation
	Violations []*Violation `json:"violations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListViolationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListViolationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListWorkloadsResponse: Response message for list customer workloads
// requests.
type ListWorkloadsResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`
	// Workloads: List of customer workloads
	Workloads []*Workload `json:"workloads,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListWorkloadsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListWorkloadsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have been cancelled
	// successfully have Operation.error value with a google.rpc.Status.code of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Partner: Message describing Partner resource
type Partner struct {
	// CreateTime: Output only. Time the resource was created
	CreateTime string `json:"createTime,omitempty"`
	// EkmSolutions: List of Google Cloud supported EKM partners supported by the
	// partner
	EkmSolutions []*EkmMetadata `json:"ekmSolutions,omitempty"`
	// Name: Identifier. The resource name of the partner. Format:
	// `organizations/{organization}/locations/{location}/partner` Example:
	// "organizations/123456/locations/us-central1/partner"
	Name string `json:"name,omitempty"`
	// OperatedCloudRegions: List of Google Cloud regions that the partner sells
	// services to customers. Valid Google Cloud regions found here:
	// https://cloud.google.com/compute/docs/regions-zones
	OperatedCloudRegions []string `json:"operatedCloudRegions,omitempty"`
	// PartnerProjectId: Google Cloud project ID in the partner's Google Cloud
	// organization for receiving enhanced Logs for Partners.
	PartnerProjectId string `json:"partnerProjectId,omitempty"`
	// Skus: List of SKUs the partner is offering
	Skus []*Sku `json:"skus,omitempty"`
	// UpdateTime: Output only. The last time the resource was updated
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Partner) MarshalJSON() ([]byte, error) {
	type NoMethod Partner
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PartnerPermissions: The permissions granted to the partner for a workload
type PartnerPermissions struct {
	// Name: Identifier. Format:
	// `organizations/{organization}/locations/{location}/customers/{customer}/workl
	// oads/{workload}/partnerPermissions`
	Name string `json:"name,omitempty"`
	// PartnerPermissions: The partner permissions granted for the workload
	//
	// Possible values:
	//   "PERMISSION_UNSPECIFIED" - Unspecified partner permission
	//   "ACCESS_TRANSPARENCY_AND_EMERGENCY_ACCESS_LOGS" - Permission for Access
	// Transparency and emergency logs
	//   "ASSURED_WORKLOADS_MONITORING" - Permission for Assured Workloads
	// monitoring violations
	//   "ACCESS_APPROVAL_REQUESTS" - Permission for Access Approval requests
	//   "ASSURED_WORKLOADS_EKM_CONNECTION_STATUS" - Permission for External Key
	// Manager connection status
	//   "ACCESS_TRANSPARENCY_LOGS_SUPPORT_CASE_VIEWER" - Permission for support
	// case details for Access Transparency log entries
	PartnerPermissions []string `json:"partnerPermissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PartnerPermissions) MarshalJSON() ([]byte, error) {
	type NoMethod PartnerPermissions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Remediation: Represents remediation guidance to resolve compliance violation
// for AssuredWorkload
type Remediation struct {
	// CompliantValues: Values that can resolve the violation For example: for list
	// org policy violations, this will either be the list of allowed or denied
	// values
	CompliantValues []string `json:"compliantValues,omitempty"`
	// Instructions: Required. Remediation instructions to resolve violations
	Instructions *Instructions `json:"instructions,omitempty"`
	// RemediationType: Output only. Remediation type based on the type of org
	// policy values violated
	//
	// Possible values:
	//   "REMEDIATION_TYPE_UNSPECIFIED" - Unspecified remediation type
	//   "REMEDIATION_BOOLEAN_ORG_POLICY_VIOLATION" - Remediation type for boolean
	// org policy
	//   "REMEDIATION_LIST_ALLOWED_VALUES_ORG_POLICY_VIOLATION" - Remediation type
	// for list org policy which have allowed values in the monitoring rule
	//   "REMEDIATION_LIST_DENIED_VALUES_ORG_POLICY_VIOLATION" - Remediation type
	// for list org policy which have denied values in the monitoring rule
	//   "REMEDIATION_RESTRICT_CMEK_CRYPTO_KEY_PROJECTS_ORG_POLICY_VIOLATION" -
	// Remediation type for gcp.restrictCmekCryptoKeyProjects
	//   "REMEDIATION_RESOURCE_VIOLATION" - Remediation type for resource
	// violation.
	RemediationType string `json:"remediationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompliantValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompliantValues") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Remediation) MarshalJSON() ([]byte, error) {
	type NoMethod Remediation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Sku: Represents the SKU a partner owns inside Google Cloud to sell to
// customers.
type Sku struct {
	// DisplayName: Display name of the product identified by the SKU. A partner
	// may want to show partner branded names for their offerings such as local
	// sovereign cloud solutions.
	DisplayName string `json:"displayName,omitempty"`
	// Id: Argentum product SKU, that is associated with the partner offerings to
	// customers used by Syntro for billing purposes. SKUs can represent resold
	// Google products or support services.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Sku) MarshalJSON() ([]byte, error) {
	type NoMethod Sku
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Violation: Details of resource Violation
type Violation struct {
	// BeginTime: Output only. Time of the event which triggered the Violation.
	BeginTime string `json:"beginTime,omitempty"`
	// Category: Output only. Category under which this violation is mapped. e.g.
	// Location, Service Usage, Access, Encryption, etc.
	Category string `json:"category,omitempty"`
	// Description: Output only. Description for the Violation. e.g. OrgPolicy
	// gcp.resourceLocations has non compliant value.
	Description string `json:"description,omitempty"`
	// FolderId: The folder_id of the violation
	FolderId int64 `json:"folderId,omitempty,string"`
	// Name: Identifier. Format:
	// `organizations/{organization}/locations/{location}/customers/{customer}/workl
	// oads/{workload}/violations/{violation}`
	Name string `json:"name,omitempty"`
	// NonCompliantOrgPolicy: Output only. Immutable. Name of the OrgPolicy which
	// was modified with non-compliant change and resulted this violation. Format:
	// `projects/{project_number}/policies/{constraint_name}`
	// `folders/{folder_id}/policies/{constraint_name}`
	// `organizations/{organization_id}/policies/{constraint_name}`
	NonCompliantOrgPolicy string `json:"nonCompliantOrgPolicy,omitempty"`
	// Remediation: Output only. Compliance violation remediation
	Remediation *Remediation `json:"remediation,omitempty"`
	// ResolveTime: Output only. Time of the event which fixed the Violation. If
	// the violation is ACTIVE this will be empty.
	ResolveTime string `json:"resolveTime,omitempty"`
	// State: Output only. State of the violation
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RESOLVED" - Violation is resolved.
	//   "UNRESOLVED" - Violation is Unresolved
	//   "EXCEPTION" - Violation is Exception
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The last time when the Violation record was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BeginTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BeginTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Violation) MarshalJSON() ([]byte, error) {
	type NoMethod Violation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Workload: Contains metadata around the Workload resource
// (https://cloud.google.com/assured-workloads/docs/reference/rest/Shared.Types/Workload)
// in the Assured Workloads API.
type Workload struct {
	// CreateTime: Output only. Time the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Folder: Output only. The name of container folder of the assured workload
	Folder string `json:"folder,omitempty"`
	// FolderId: Output only. Folder id this workload is associated with
	FolderId int64 `json:"folderId,omitempty,string"`
	// IsOnboarded: Indicates whether a workload is fully onboarded.
	IsOnboarded bool `json:"isOnboarded,omitempty"`
	// KeyManagementProjectId: The project id of the key management project for the
	// workload
	KeyManagementProjectId string `json:"keyManagementProjectId,omitempty"`
	// Location: The Google Cloud location of the workload
	Location string `json:"location,omitempty"`
	// Name: Identifier. Format:
	// `organizations/{organization}/locations/{location}/customers/{customer}/workl
	// oads/{workload}`
	Name string `json:"name,omitempty"`
	// Partner: Partner associated with this workload.
	//
	// Possible values:
	//   "PARTNER_UNSPECIFIED" - Unknown Partner.
	//   "PARTNER_LOCAL_CONTROLS_BY_S3NS" - Enum representing S3NS (Thales)
	// partner.
	//   "PARTNER_SOVEREIGN_CONTROLS_BY_T_SYSTEMS" - Enum representing T_SYSTEM
	// (TSI) partner.
	//   "PARTNER_SOVEREIGN_CONTROLS_BY_SIA_MINSAIT" - Enum representing
	// SIA_MINSAIT (Indra) partner.
	//   "PARTNER_SOVEREIGN_CONTROLS_BY_PSN" - Enum representing PSN (TIM) partner.
	//   "PARTNER_SOVEREIGN_CONTROLS_BY_CNTXT" - Enum representing CNTXT (Kingdom
	// of Saudi Arabia) partner.
	//   "PARTNER_SOVEREIGN_CONTROLS_BY_CNTXT_NO_EKM" - Enum representing CNXT
	// (Kingdom of Saudi Arabia) partner offering without EKM provisioning.
	Partner string `json:"partner,omitempty"`
	// WorkloadOnboardingState: Container for workload onboarding steps.
	WorkloadOnboardingState *WorkloadOnboardingState `json:"workloadOnboardingState,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Workload) MarshalJSON() ([]byte, error) {
	type NoMethod Workload
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadOnboardingState: Container for workload onboarding steps.
type WorkloadOnboardingState struct {
	// OnboardingSteps: List of workload onboarding steps.
	OnboardingSteps []*WorkloadOnboardingStep `json:"onboardingSteps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OnboardingSteps") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OnboardingSteps") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadOnboardingState) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadOnboardingState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkloadOnboardingStep: Container for workload onboarding information.
type WorkloadOnboardingStep struct {
	// CompletionState: Output only. The completion state of the onboarding step.
	//
	// Possible values:
	//   "COMPLETION_STATE_UNSPECIFIED" - Unspecified completion state.
	//   "PENDING" - Task started (has start date) but not yet completed.
	//   "SUCCEEDED" - Succeeded state.
	//   "FAILED" - Failed state.
	//   "NOT_APPLICABLE" - Not applicable state.
	CompletionState string `json:"completionState,omitempty"`
	// CompletionTime: The completion time of the onboarding step.
	CompletionTime string `json:"completionTime,omitempty"`
	// StartTime: The starting time of the onboarding step.
	StartTime string `json:"startTime,omitempty"`
	// Step: The onboarding step.
	//
	// Possible values:
	//   "STEP_UNSPECIFIED" - Unspecified step.
	//   "EKM_PROVISIONED" - EKM Provisioned step.
	//   "SIGNED_ACCESS_APPROVAL_CONFIGURED" - Signed Access Approval step.
	Step string `json:"step,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletionState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletionState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkloadOnboardingStep) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadOnboardingStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OrganizationsLocationsGetPartnerCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetPartner: Get details of a Partner.
//
// - name: Format: `organizations/{organization}/locations/{location}/partner`.
func (r *OrganizationsLocationsService) GetPartner(name string) *OrganizationsLocationsGetPartnerCall {
	c := &OrganizationsLocationsGetPartnerCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsGetPartnerCall) Fields(s ...googleapi.Field) *OrganizationsLocationsGetPartnerCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsGetPartnerCall) IfNoneMatch(entityTag string) *OrganizationsLocationsGetPartnerCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsGetPartnerCall) Context(ctx context.Context) *OrganizationsLocationsGetPartnerCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsGetPartnerCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsGetPartnerCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.getPartner", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.getPartner" call.
// Any non-2xx status code is an error. Response headers are in either
// *Partner.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsGetPartnerCall) Do(opts ...googleapi.CallOption) (*Partner, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Partner{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.getPartner", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsCustomersCreateCall struct {
	s          *Service
	parent     string
	customer   *Customer
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new customer.
//
//   - parent: Parent resource Format:
//     `organizations/{organization}/locations/{location}`.
func (r *OrganizationsLocationsCustomersService) Create(parent string, customer *Customer) *OrganizationsLocationsCustomersCreateCall {
	c := &OrganizationsLocationsCustomersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.customer = customer
	return c
}

// CustomerId sets the optional parameter "customerId": Required. The customer
// id to use for the customer, which will become the final component of the
// customer's resource name. The specified value must be a valid Google cloud
// organization id.
func (c *OrganizationsLocationsCustomersCreateCall) CustomerId(customerId string) *OrganizationsLocationsCustomersCreateCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsCustomersCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsCustomersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsCustomersCreateCall) Context(ctx context.Context) *OrganizationsLocationsCustomersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsCustomersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsCustomersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.customer)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/customers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.customers.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Customer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsCustomersCreateCall) Do(opts ...googleapi.CallOption) (*Customer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Customer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsCustomersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete details of a single customer
//
//   - name: name of the resource to be deleted format:
//     name=organizations/*/locations/*/customers/*.
func (r *OrganizationsLocationsCustomersService) Delete(name string) *OrganizationsLocationsCustomersDeleteCall {
	c := &OrganizationsLocationsCustomersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsCustomersDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsCustomersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsCustomersDeleteCall) Context(ctx context.Context) *OrganizationsLocationsCustomersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsCustomersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsCustomersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.customers.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsCustomersDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsCustomersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single customer
//
//   - name: Format:
//     `organizations/{organization}/locations/{location}/customers/{customer}`.
func (r *OrganizationsLocationsCustomersService) Get(name string) *OrganizationsLocationsCustomersGetCall {
	c := &OrganizationsLocationsCustomersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsCustomersGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsCustomersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsCustomersGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsCustomersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsCustomersGetCall) Context(ctx context.Context) *OrganizationsLocationsCustomersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsCustomersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsCustomersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.customers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Customer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsCustomersGetCall) Do(opts ...googleapi.CallOption) (*Customer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Customer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsCustomersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists customers of a partner identified by its Google Cloud
// organization ID
//
//   - parent: Parent resource Format:
//     `organizations/{organization}/locations/{location}`.
func (r *OrganizationsLocationsCustomersService) List(parent string) *OrganizationsLocationsCustomersListCall {
	c := &OrganizationsLocationsCustomersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results
func (c *OrganizationsLocationsCustomersListCall) Filter(filter string) *OrganizationsLocationsCustomersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results
func (c *OrganizationsLocationsCustomersListCall) OrderBy(orderBy string) *OrganizationsLocationsCustomersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// Customers to return. The service may return fewer than this value. If
// unspecified, at most 500 Customers will be returned.
func (c *OrganizationsLocationsCustomersListCall) PageSize(pageSize int64) *OrganizationsLocationsCustomersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListCustomers` call. Provide this to retrieve the
// subsequent page.
func (c *OrganizationsLocationsCustomersListCall) PageToken(pageToken string) *OrganizationsLocationsCustomersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsCustomersListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsCustomersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsCustomersListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsCustomersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsCustomersListCall) Context(ctx context.Context) *OrganizationsLocationsCustomersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsCustomersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsCustomersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/customers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.customers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCustomersResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsCustomersListCall) Do(opts ...googleapi.CallOption) (*ListCustomersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCustomersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsCustomersListCall) Pages(ctx context.Context, f func(*ListCustomersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsCustomersPatchCall struct {
	s          *Service
	name       string
	customer   *Customer
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update details of a single customer
//
//   - name: Identifier. Format:
//     `organizations/{organization}/locations/{location}/customers/{customer}`.
func (r *OrganizationsLocationsCustomersService) Patch(name string, customer *Customer) *OrganizationsLocationsCustomersPatchCall {
	c := &OrganizationsLocationsCustomersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.customer = customer
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update
func (c *OrganizationsLocationsCustomersPatchCall) UpdateMask(updateMask string) *OrganizationsLocationsCustomersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsCustomersPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsCustomersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsCustomersPatchCall) Context(ctx context.Context) *OrganizationsLocationsCustomersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsCustomersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsCustomersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.customer)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.customers.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Customer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsCustomersPatchCall) Do(opts ...googleapi.CallOption) (*Customer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Customer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsCustomersWorkloadsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single workload
//
//   - name: Format:
//     `organizations/{organization}/locations/{location}/customers/{customer}/wor
//     kloads/{workload}`.
func (r *OrganizationsLocationsCustomersWorkloadsService) Get(name string) *OrganizationsLocationsCustomersWorkloadsGetCall {
	c := &OrganizationsLocationsCustomersWorkloadsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsCustomersWorkloadsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsCustomersWorkloadsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsCustomersWorkloadsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsCustomersWorkloadsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsCustomersWorkloadsGetCall) Context(ctx context.Context) *OrganizationsLocationsCustomersWorkloadsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsCustomersWorkloadsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsCustomersWorkloadsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.customers.workloads.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Workload.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsCustomersWorkloadsGetCall) Do(opts ...googleapi.CallOption) (*Workload, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Workload{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsCustomersWorkloadsGetEkmConnectionsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEkmConnections: Gets the EKM connections associated with a workload
//
//   - name: Format:
//     `organizations/{organization}/locations/{location}/customers/{customer}/wor
//     kloads/{workload}/ekmConnections`.
func (r *OrganizationsLocationsCustomersWorkloadsService) GetEkmConnections(name string) *OrganizationsLocationsCustomersWorkloadsGetEkmConnectionsCall {
	c := &OrganizationsLocationsCustomersWorkloadsGetEkmConnectionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsCustomersWorkloadsGetEkmConnectionsCall) Fields(s ...googleapi.Field) *OrganizationsLocationsCustomersWorkloadsGetEkmConnectionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsCustomersWorkloadsGetEkmConnectionsCall) IfNoneMatch(entityTag string) *OrganizationsLocationsCustomersWorkloadsGetEkmConnectionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsCustomersWorkloadsGetEkmConnectionsCall) Context(ctx context.Context) *OrganizationsLocationsCustomersWorkloadsGetEkmConnectionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsCustomersWorkloadsGetEkmConnectionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsCustomersWorkloadsGetEkmConnectionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.getEkmConnections", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.customers.workloads.getEkmConnections" call.
// Any non-2xx status code is an error. Response headers are in either
// *EkmConnections.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsCustomersWorkloadsGetEkmConnectionsCall) Do(opts ...googleapi.CallOption) (*EkmConnections, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EkmConnections{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.getEkmConnections", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsCustomersWorkloadsGetPartnerPermissionsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetPartnerPermissions: Gets the partner permissions granted for a workload
//
//   - name: Name of the resource to get in the format:
//     `organizations/{organization}/locations/{location}/customers/{customer}/wor
//     kloads/{workload}/partnerPermissions`.
func (r *OrganizationsLocationsCustomersWorkloadsService) GetPartnerPermissions(name string) *OrganizationsLocationsCustomersWorkloadsGetPartnerPermissionsCall {
	c := &OrganizationsLocationsCustomersWorkloadsGetPartnerPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsCustomersWorkloadsGetPartnerPermissionsCall) Fields(s ...googleapi.Field) *OrganizationsLocationsCustomersWorkloadsGetPartnerPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsCustomersWorkloadsGetPartnerPermissionsCall) IfNoneMatch(entityTag string) *OrganizationsLocationsCustomersWorkloadsGetPartnerPermissionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsCustomersWorkloadsGetPartnerPermissionsCall) Context(ctx context.Context) *OrganizationsLocationsCustomersWorkloadsGetPartnerPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsCustomersWorkloadsGetPartnerPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsCustomersWorkloadsGetPartnerPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.getPartnerPermissions", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.customers.workloads.getPartnerPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *PartnerPermissions.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsCustomersWorkloadsGetPartnerPermissionsCall) Do(opts ...googleapi.CallOption) (*PartnerPermissions, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PartnerPermissions{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.getPartnerPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsCustomersWorkloadsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists customer workloads for a given customer org id
//
//   - parent: Parent resource Format:
//     `organizations/{organization}/locations/{location}/customers/{customer}`.
func (r *OrganizationsLocationsCustomersWorkloadsService) List(parent string) *OrganizationsLocationsCustomersWorkloadsListCall {
	c := &OrganizationsLocationsCustomersWorkloadsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *OrganizationsLocationsCustomersWorkloadsListCall) Filter(filter string) *OrganizationsLocationsCustomersWorkloadsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results.
func (c *OrganizationsLocationsCustomersWorkloadsListCall) OrderBy(orderBy string) *OrganizationsLocationsCustomersWorkloadsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// workloads to return. The service may return fewer than this value. If
// unspecified, at most 500 workloads will be returned.
func (c *OrganizationsLocationsCustomersWorkloadsListCall) PageSize(pageSize int64) *OrganizationsLocationsCustomersWorkloadsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListWorkloads` call. Provide this to retrieve the
// subsequent page.
func (c *OrganizationsLocationsCustomersWorkloadsListCall) PageToken(pageToken string) *OrganizationsLocationsCustomersWorkloadsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsCustomersWorkloadsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsCustomersWorkloadsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsCustomersWorkloadsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsCustomersWorkloadsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsCustomersWorkloadsListCall) Context(ctx context.Context) *OrganizationsLocationsCustomersWorkloadsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsCustomersWorkloadsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsCustomersWorkloadsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/workloads")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.customers.workloads.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListWorkloadsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsCustomersWorkloadsListCall) Do(opts ...googleapi.CallOption) (*ListWorkloadsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListWorkloadsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsCustomersWorkloadsListCall) Pages(ctx context.Context, f func(*ListWorkloadsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Deprecated: Only returns access approval requests directly associated
// with an assured workload folder.
//
//   - parent: Parent resource Format:
//     `organizations/{organization}/locations/{location}/customers/{customer}/wor
//     kloads/{workload}`.
func (r *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsService) List(parent string) *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall {
	c := &OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall) Filter(filter string) *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results.
func (c *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall) OrderBy(orderBy string) *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// access requests to return. The service may return fewer than this value. If
// unspecified, at most 500 access requests will be returned.
func (c *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall) PageSize(pageSize int64) *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListAccessApprovalRequests` call. Provide this to retrieve
// the subsequent page.
func (c *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall) PageToken(pageToken string) *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall) Context(ctx context.Context) *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/accessApprovalRequests")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.accessApprovalRequests.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.customers.workloads.accessApprovalRequests.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAccessApprovalRequestsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall) Do(opts ...googleapi.CallOption) (*ListAccessApprovalRequestsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAccessApprovalRequestsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.accessApprovalRequests.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsCustomersWorkloadsAccessApprovalRequestsListCall) Pages(ctx context.Context, f func(*ListAccessApprovalRequestsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsCustomersWorkloadsViolationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Violation.
//
//   - name: Format:
//     `organizations/{organization}/locations/{location}/customers/{customer}/wor
//     kloads/{workload}/violations/{violation}`.
func (r *OrganizationsLocationsCustomersWorkloadsViolationsService) Get(name string) *OrganizationsLocationsCustomersWorkloadsViolationsGetCall {
	c := &OrganizationsLocationsCustomersWorkloadsViolationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsCustomersWorkloadsViolationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsCustomersWorkloadsViolationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsGetCall) Context(ctx context.Context) *OrganizationsLocationsCustomersWorkloadsViolationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsCustomersWorkloadsViolationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.violations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.customers.workloads.violations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Violation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsGetCall) Do(opts ...googleapi.CallOption) (*Violation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Violation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.violations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsCustomersWorkloadsViolationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Violations for a workload Callers may also choose to read across
// multiple Customers or for a single customer as per AIP-159
// (https://google.aip.dev/159) by using '-' (the hyphen or dash character) as
// a wildcard character instead of {customer} & {workload}. Format:
// `organizations/{organization}/locations/{location}/customers/{customer}/workl
// oads/{workload}`
//
//   - parent: Parent resource Format
//     `organizations/{organization}/locations/{location}/customers/{customer}/wor
//     kloads/{workload}`.
func (r *OrganizationsLocationsCustomersWorkloadsViolationsService) List(parent string) *OrganizationsLocationsCustomersWorkloadsViolationsListCall {
	c := &OrganizationsLocationsCustomersWorkloadsViolationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results
func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) Filter(filter string) *OrganizationsLocationsCustomersWorkloadsViolationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// IntervalEndTime sets the optional parameter "interval.endTime": Exclusive
// end of the interval. If specified, a Timestamp matching this interval will
// have to be before the end.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) IntervalEndTime(intervalEndTime string) *OrganizationsLocationsCustomersWorkloadsViolationsListCall {
	c.urlParams_.Set("interval.endTime", intervalEndTime)
	return c
}

// IntervalStartTime sets the optional parameter "interval.startTime":
// Inclusive start of the interval. If specified, a Timestamp matching this
// interval will have to be the same or after the start.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) IntervalStartTime(intervalStartTime string) *OrganizationsLocationsCustomersWorkloadsViolationsListCall {
	c.urlParams_.Set("interval.startTime", intervalStartTime)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results
func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) OrderBy(orderBy string) *OrganizationsLocationsCustomersWorkloadsViolationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// customers row to return. The service may return fewer than this value. If
// unspecified, at most 10 customers will be returned.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) PageSize(pageSize int64) *OrganizationsLocationsCustomersWorkloadsViolationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListViolations` call. Provide this to retrieve the
// subsequent page.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) PageToken(pageToken string) *OrganizationsLocationsCustomersWorkloadsViolationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsCustomersWorkloadsViolationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsCustomersWorkloadsViolationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) Context(ctx context.Context) *OrganizationsLocationsCustomersWorkloadsViolationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/violations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.violations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudcontrolspartner.organizations.locations.customers.workloads.violations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListViolationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) Do(opts ...googleapi.CallOption) (*ListViolationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListViolationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudcontrolspartner.organizations.locations.customers.workloads.violations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsCustomersWorkloadsViolationsListCall) Pages(ctx context.Context, f func(*ListViolationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
