// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/bigtable/admin/v2/types.proto

package adminpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// `Type` represents the type of data that is written to, read from, or stored
// in Bigtable. It is heavily based on the GoogleSQL standard to help maintain
// familiarity and consistency across products and features.
//
// For compatibility with Bigtable's existing untyped APIs, each `Type` includes
// an `Encoding` which describes how to convert to or from the underlying data.
//
// Each encoding can operate in one of two modes:
//
//   - Sorted: In this mode, Bigtable guarantees that `Encode(X) <= Encode(Y)`
//     if and only if `X <= Y`. This is useful anywhere sort order is important,
//     for example when encoding keys.
//   - Distinct: In this mode, Bigtable guarantees that if `X != Y` then
//     `Encode(X) != Encode(Y)`. However, the converse is not guaranteed. For
//     example, both "{'foo': '1', 'bar': '2'}" and "{'bar': '2', 'foo': '1'}"
//     are valid encodings of the same JSON value.
//
// The API clearly documents which mode is used wherever an encoding can be
// configured. Each encoding also documents which values are supported in which
// modes. For example, when encoding INT64 as a numeric STRING, negative numbers
// cannot be encoded in sorted mode. This is because `INT64(1) > INT64(-1)`, but
// `STRING("-00001") > STRING("00001")`.
type Type struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The kind of type that this represents.
	//
	// Types that are assignable to Kind:
	//
	//	*Type_BytesType
	//	*Type_StringType
	//	*Type_Int64Type
	//	*Type_Float32Type
	//	*Type_Float64Type
	//	*Type_BoolType
	//	*Type_TimestampType
	//	*Type_DateType
	//	*Type_AggregateType
	//	*Type_StructType
	//	*Type_ArrayType
	//	*Type_MapType
	//	*Type_ProtoType
	//	*Type_EnumType
	Kind isType_Kind `protobuf_oneof:"kind"`
}

func (x *Type) Reset() {
	*x = Type{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type) ProtoMessage() {}

func (x *Type) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type.ProtoReflect.Descriptor instead.
func (*Type) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0}
}

func (m *Type) GetKind() isType_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *Type) GetBytesType() *Type_Bytes {
	if x, ok := x.GetKind().(*Type_BytesType); ok {
		return x.BytesType
	}
	return nil
}

func (x *Type) GetStringType() *Type_String {
	if x, ok := x.GetKind().(*Type_StringType); ok {
		return x.StringType
	}
	return nil
}

func (x *Type) GetInt64Type() *Type_Int64 {
	if x, ok := x.GetKind().(*Type_Int64Type); ok {
		return x.Int64Type
	}
	return nil
}

func (x *Type) GetFloat32Type() *Type_Float32 {
	if x, ok := x.GetKind().(*Type_Float32Type); ok {
		return x.Float32Type
	}
	return nil
}

func (x *Type) GetFloat64Type() *Type_Float64 {
	if x, ok := x.GetKind().(*Type_Float64Type); ok {
		return x.Float64Type
	}
	return nil
}

func (x *Type) GetBoolType() *Type_Bool {
	if x, ok := x.GetKind().(*Type_BoolType); ok {
		return x.BoolType
	}
	return nil
}

func (x *Type) GetTimestampType() *Type_Timestamp {
	if x, ok := x.GetKind().(*Type_TimestampType); ok {
		return x.TimestampType
	}
	return nil
}

func (x *Type) GetDateType() *Type_Date {
	if x, ok := x.GetKind().(*Type_DateType); ok {
		return x.DateType
	}
	return nil
}

func (x *Type) GetAggregateType() *Type_Aggregate {
	if x, ok := x.GetKind().(*Type_AggregateType); ok {
		return x.AggregateType
	}
	return nil
}

func (x *Type) GetStructType() *Type_Struct {
	if x, ok := x.GetKind().(*Type_StructType); ok {
		return x.StructType
	}
	return nil
}

func (x *Type) GetArrayType() *Type_Array {
	if x, ok := x.GetKind().(*Type_ArrayType); ok {
		return x.ArrayType
	}
	return nil
}

func (x *Type) GetMapType() *Type_Map {
	if x, ok := x.GetKind().(*Type_MapType); ok {
		return x.MapType
	}
	return nil
}

func (x *Type) GetProtoType() *Type_Proto {
	if x, ok := x.GetKind().(*Type_ProtoType); ok {
		return x.ProtoType
	}
	return nil
}

func (x *Type) GetEnumType() *Type_Enum {
	if x, ok := x.GetKind().(*Type_EnumType); ok {
		return x.EnumType
	}
	return nil
}

type isType_Kind interface {
	isType_Kind()
}

type Type_BytesType struct {
	// Bytes
	BytesType *Type_Bytes `protobuf:"bytes,1,opt,name=bytes_type,json=bytesType,proto3,oneof"`
}

type Type_StringType struct {
	// String
	StringType *Type_String `protobuf:"bytes,2,opt,name=string_type,json=stringType,proto3,oneof"`
}

type Type_Int64Type struct {
	// Int64
	Int64Type *Type_Int64 `protobuf:"bytes,5,opt,name=int64_type,json=int64Type,proto3,oneof"`
}

type Type_Float32Type struct {
	// Float32
	Float32Type *Type_Float32 `protobuf:"bytes,12,opt,name=float32_type,json=float32Type,proto3,oneof"`
}

type Type_Float64Type struct {
	// Float64
	Float64Type *Type_Float64 `protobuf:"bytes,9,opt,name=float64_type,json=float64Type,proto3,oneof"`
}

type Type_BoolType struct {
	// Bool
	BoolType *Type_Bool `protobuf:"bytes,8,opt,name=bool_type,json=boolType,proto3,oneof"`
}

type Type_TimestampType struct {
	// Timestamp
	TimestampType *Type_Timestamp `protobuf:"bytes,10,opt,name=timestamp_type,json=timestampType,proto3,oneof"`
}

type Type_DateType struct {
	// Date
	DateType *Type_Date `protobuf:"bytes,11,opt,name=date_type,json=dateType,proto3,oneof"`
}

type Type_AggregateType struct {
	// Aggregate
	AggregateType *Type_Aggregate `protobuf:"bytes,6,opt,name=aggregate_type,json=aggregateType,proto3,oneof"`
}

type Type_StructType struct {
	// Struct
	StructType *Type_Struct `protobuf:"bytes,7,opt,name=struct_type,json=structType,proto3,oneof"`
}

type Type_ArrayType struct {
	// Array
	ArrayType *Type_Array `protobuf:"bytes,3,opt,name=array_type,json=arrayType,proto3,oneof"`
}

type Type_MapType struct {
	// Map
	MapType *Type_Map `protobuf:"bytes,4,opt,name=map_type,json=mapType,proto3,oneof"`
}

type Type_ProtoType struct {
	// Proto
	ProtoType *Type_Proto `protobuf:"bytes,13,opt,name=proto_type,json=protoType,proto3,oneof"`
}

type Type_EnumType struct {
	// Enum
	EnumType *Type_Enum `protobuf:"bytes,14,opt,name=enum_type,json=enumType,proto3,oneof"`
}

func (*Type_BytesType) isType_Kind() {}

func (*Type_StringType) isType_Kind() {}

func (*Type_Int64Type) isType_Kind() {}

func (*Type_Float32Type) isType_Kind() {}

func (*Type_Float64Type) isType_Kind() {}

func (*Type_BoolType) isType_Kind() {}

func (*Type_TimestampType) isType_Kind() {}

func (*Type_DateType) isType_Kind() {}

func (*Type_AggregateType) isType_Kind() {}

func (*Type_StructType) isType_Kind() {}

func (*Type_ArrayType) isType_Kind() {}

func (*Type_MapType) isType_Kind() {}

func (*Type_ProtoType) isType_Kind() {}

func (*Type_EnumType) isType_Kind() {}

// Bytes
// Values of type `Bytes` are stored in `Value.bytes_value`.
type Type_Bytes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encoding to use when converting to or from lower level types.
	Encoding *Type_Bytes_Encoding `protobuf:"bytes,1,opt,name=encoding,proto3" json:"encoding,omitempty"`
}

func (x *Type_Bytes) Reset() {
	*x = Type_Bytes{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Bytes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Bytes) ProtoMessage() {}

func (x *Type_Bytes) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Bytes.ProtoReflect.Descriptor instead.
func (*Type_Bytes) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Type_Bytes) GetEncoding() *Type_Bytes_Encoding {
	if x != nil {
		return x.Encoding
	}
	return nil
}

// String
// Values of type `String` are stored in `Value.string_value`.
type Type_String struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encoding to use when converting to or from lower level types.
	Encoding *Type_String_Encoding `protobuf:"bytes,1,opt,name=encoding,proto3" json:"encoding,omitempty"`
}

func (x *Type_String) Reset() {
	*x = Type_String{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_String) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_String) ProtoMessage() {}

func (x *Type_String) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_String.ProtoReflect.Descriptor instead.
func (*Type_String) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Type_String) GetEncoding() *Type_String_Encoding {
	if x != nil {
		return x.Encoding
	}
	return nil
}

// Int64
// Values of type `Int64` are stored in `Value.int_value`.
type Type_Int64 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encoding to use when converting to or from lower level types.
	Encoding *Type_Int64_Encoding `protobuf:"bytes,1,opt,name=encoding,proto3" json:"encoding,omitempty"`
}

func (x *Type_Int64) Reset() {
	*x = Type_Int64{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Int64) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Int64) ProtoMessage() {}

func (x *Type_Int64) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Int64.ProtoReflect.Descriptor instead.
func (*Type_Int64) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Type_Int64) GetEncoding() *Type_Int64_Encoding {
	if x != nil {
		return x.Encoding
	}
	return nil
}

// bool
// Values of type `Bool` are stored in `Value.bool_value`.
type Type_Bool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Bool) Reset() {
	*x = Type_Bool{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Bool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Bool) ProtoMessage() {}

func (x *Type_Bool) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Bool.ProtoReflect.Descriptor instead.
func (*Type_Bool) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 3}
}

// Float32
// Values of type `Float32` are stored in `Value.float_value`.
type Type_Float32 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Float32) Reset() {
	*x = Type_Float32{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Float32) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Float32) ProtoMessage() {}

func (x *Type_Float32) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Float32.ProtoReflect.Descriptor instead.
func (*Type_Float32) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 4}
}

// Float64
// Values of type `Float64` are stored in `Value.float_value`.
type Type_Float64 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Float64) Reset() {
	*x = Type_Float64{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Float64) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Float64) ProtoMessage() {}

func (x *Type_Float64) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Float64.ProtoReflect.Descriptor instead.
func (*Type_Float64) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 5}
}

// Timestamp
// Values of type `Timestamp` are stored in `Value.timestamp_value`.
type Type_Timestamp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encoding to use when converting to or from lower level types.
	Encoding *Type_Timestamp_Encoding `protobuf:"bytes,1,opt,name=encoding,proto3" json:"encoding,omitempty"`
}

func (x *Type_Timestamp) Reset() {
	*x = Type_Timestamp{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Timestamp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Timestamp) ProtoMessage() {}

func (x *Type_Timestamp) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Timestamp.ProtoReflect.Descriptor instead.
func (*Type_Timestamp) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Type_Timestamp) GetEncoding() *Type_Timestamp_Encoding {
	if x != nil {
		return x.Encoding
	}
	return nil
}

// Date
// Values of type `Date` are stored in `Value.date_value`.
type Type_Date struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Date) Reset() {
	*x = Type_Date{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Date) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Date) ProtoMessage() {}

func (x *Type_Date) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Date.ProtoReflect.Descriptor instead.
func (*Type_Date) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 7}
}

// A structured data value, consisting of fields which map to dynamically
// typed values.
// Values of type `Struct` are stored in `Value.array_value` where entries are
// in the same order and number as `field_types`.
type Type_Struct struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The names and types of the fields in this struct.
	Fields []*Type_Struct_Field `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	// The encoding to use when converting to or from lower level types.
	Encoding *Type_Struct_Encoding `protobuf:"bytes,2,opt,name=encoding,proto3" json:"encoding,omitempty"`
}

func (x *Type_Struct) Reset() {
	*x = Type_Struct{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Struct) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Struct) ProtoMessage() {}

func (x *Type_Struct) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Struct.ProtoReflect.Descriptor instead.
func (*Type_Struct) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 8}
}

func (x *Type_Struct) GetFields() []*Type_Struct_Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *Type_Struct) GetEncoding() *Type_Struct_Encoding {
	if x != nil {
		return x.Encoding
	}
	return nil
}

// A protobuf message type.
// Values of type `Proto` are stored in `Value.bytes_value`.
type Type_Proto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the schema bundle that this proto is defined in.
	SchemaBundleId string `protobuf:"bytes,1,opt,name=schema_bundle_id,json=schemaBundleId,proto3" json:"schema_bundle_id,omitempty"`
	// The fully qualified name of the protobuf message, including package. In
	// the format of "foo.bar.Message".
	MessageName string `protobuf:"bytes,2,opt,name=message_name,json=messageName,proto3" json:"message_name,omitempty"`
}

func (x *Type_Proto) Reset() {
	*x = Type_Proto{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Proto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Proto) ProtoMessage() {}

func (x *Type_Proto) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Proto.ProtoReflect.Descriptor instead.
func (*Type_Proto) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 9}
}

func (x *Type_Proto) GetSchemaBundleId() string {
	if x != nil {
		return x.SchemaBundleId
	}
	return ""
}

func (x *Type_Proto) GetMessageName() string {
	if x != nil {
		return x.MessageName
	}
	return ""
}

// A protobuf enum type.
// Values of type `Enum` are stored in `Value.int_value`.
type Type_Enum struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the schema bundle that this enum is defined in.
	SchemaBundleId string `protobuf:"bytes,1,opt,name=schema_bundle_id,json=schemaBundleId,proto3" json:"schema_bundle_id,omitempty"`
	// The fully qualified name of the protobuf enum message, including package.
	// In the format of "foo.bar.EnumMessage".
	EnumName string `protobuf:"bytes,2,opt,name=enum_name,json=enumName,proto3" json:"enum_name,omitempty"`
}

func (x *Type_Enum) Reset() {
	*x = Type_Enum{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Enum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Enum) ProtoMessage() {}

func (x *Type_Enum) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Enum.ProtoReflect.Descriptor instead.
func (*Type_Enum) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 10}
}

func (x *Type_Enum) GetSchemaBundleId() string {
	if x != nil {
		return x.SchemaBundleId
	}
	return ""
}

func (x *Type_Enum) GetEnumName() string {
	if x != nil {
		return x.EnumName
	}
	return ""
}

// An ordered list of elements of a given type.
// Values of type `Array` are stored in `Value.array_value`.
type Type_Array struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the elements in the array. This must not be `Array`.
	ElementType *Type `protobuf:"bytes,1,opt,name=element_type,json=elementType,proto3" json:"element_type,omitempty"`
}

func (x *Type_Array) Reset() {
	*x = Type_Array{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Array) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Array) ProtoMessage() {}

func (x *Type_Array) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Array.ProtoReflect.Descriptor instead.
func (*Type_Array) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 11}
}

func (x *Type_Array) GetElementType() *Type {
	if x != nil {
		return x.ElementType
	}
	return nil
}

// A mapping of keys to values of a given type.
// Values of type `Map` are stored in a `Value.array_value` where each entry
// is another `Value.array_value` with two elements (the key and the value,
// in that order).
// Normally encoded Map values won't have repeated keys, however, clients are
// expected to handle the case in which they do. If the same key appears
// multiple times, the _last_ value takes precedence.
type Type_Map struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of a map key.
	// Only `Bytes`, `String`, and `Int64` are allowed as key types.
	KeyType *Type `protobuf:"bytes,1,opt,name=key_type,json=keyType,proto3" json:"key_type,omitempty"`
	// The type of the values in a map.
	ValueType *Type `protobuf:"bytes,2,opt,name=value_type,json=valueType,proto3" json:"value_type,omitempty"`
}

func (x *Type_Map) Reset() {
	*x = Type_Map{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Map) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Map) ProtoMessage() {}

func (x *Type_Map) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Map.ProtoReflect.Descriptor instead.
func (*Type_Map) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 12}
}

func (x *Type_Map) GetKeyType() *Type {
	if x != nil {
		return x.KeyType
	}
	return nil
}

func (x *Type_Map) GetValueType() *Type {
	if x != nil {
		return x.ValueType
	}
	return nil
}

// A value that combines incremental updates into a summarized value.
//
// Data is never directly written or read using type `Aggregate`. Writes will
// provide either the `input_type` or `state_type`, and reads will always
// return the `state_type` .
type Type_Aggregate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the inputs that are accumulated by this `Aggregate`, which must
	// specify a full encoding.
	// Use `AddInput` mutations to accumulate new inputs.
	InputType *Type `protobuf:"bytes,1,opt,name=input_type,json=inputType,proto3" json:"input_type,omitempty"`
	// Output only. Type that holds the internal accumulator state for the
	// `Aggregate`. This is a function of the `input_type` and `aggregator`
	// chosen, and will always specify a full encoding.
	StateType *Type `protobuf:"bytes,2,opt,name=state_type,json=stateType,proto3" json:"state_type,omitempty"`
	// Which aggregator function to use. The configured types must match.
	//
	// Types that are assignable to Aggregator:
	//
	//	*Type_Aggregate_Sum_
	//	*Type_Aggregate_HllppUniqueCount
	//	*Type_Aggregate_Max_
	//	*Type_Aggregate_Min_
	Aggregator isType_Aggregate_Aggregator `protobuf_oneof:"aggregator"`
}

func (x *Type_Aggregate) Reset() {
	*x = Type_Aggregate{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Aggregate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Aggregate) ProtoMessage() {}

func (x *Type_Aggregate) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Aggregate.ProtoReflect.Descriptor instead.
func (*Type_Aggregate) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 13}
}

func (x *Type_Aggregate) GetInputType() *Type {
	if x != nil {
		return x.InputType
	}
	return nil
}

func (x *Type_Aggregate) GetStateType() *Type {
	if x != nil {
		return x.StateType
	}
	return nil
}

func (m *Type_Aggregate) GetAggregator() isType_Aggregate_Aggregator {
	if m != nil {
		return m.Aggregator
	}
	return nil
}

func (x *Type_Aggregate) GetSum() *Type_Aggregate_Sum {
	if x, ok := x.GetAggregator().(*Type_Aggregate_Sum_); ok {
		return x.Sum
	}
	return nil
}

func (x *Type_Aggregate) GetHllppUniqueCount() *Type_Aggregate_HyperLogLogPlusPlusUniqueCount {
	if x, ok := x.GetAggregator().(*Type_Aggregate_HllppUniqueCount); ok {
		return x.HllppUniqueCount
	}
	return nil
}

func (x *Type_Aggregate) GetMax() *Type_Aggregate_Max {
	if x, ok := x.GetAggregator().(*Type_Aggregate_Max_); ok {
		return x.Max
	}
	return nil
}

func (x *Type_Aggregate) GetMin() *Type_Aggregate_Min {
	if x, ok := x.GetAggregator().(*Type_Aggregate_Min_); ok {
		return x.Min
	}
	return nil
}

type isType_Aggregate_Aggregator interface {
	isType_Aggregate_Aggregator()
}

type Type_Aggregate_Sum_ struct {
	// Sum aggregator.
	Sum *Type_Aggregate_Sum `protobuf:"bytes,4,opt,name=sum,proto3,oneof"`
}

type Type_Aggregate_HllppUniqueCount struct {
	// HyperLogLogPlusPlusUniqueCount aggregator.
	HllppUniqueCount *Type_Aggregate_HyperLogLogPlusPlusUniqueCount `protobuf:"bytes,5,opt,name=hllpp_unique_count,json=hllppUniqueCount,proto3,oneof"`
}

type Type_Aggregate_Max_ struct {
	// Max aggregator.
	Max *Type_Aggregate_Max `protobuf:"bytes,6,opt,name=max,proto3,oneof"`
}

type Type_Aggregate_Min_ struct {
	// Min aggregator.
	Min *Type_Aggregate_Min `protobuf:"bytes,7,opt,name=min,proto3,oneof"`
}

func (*Type_Aggregate_Sum_) isType_Aggregate_Aggregator() {}

func (*Type_Aggregate_HllppUniqueCount) isType_Aggregate_Aggregator() {}

func (*Type_Aggregate_Max_) isType_Aggregate_Aggregator() {}

func (*Type_Aggregate_Min_) isType_Aggregate_Aggregator() {}

// Rules used to convert to or from lower level types.
type Type_Bytes_Encoding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which encoding to use.
	//
	// Types that are assignable to Encoding:
	//
	//	*Type_Bytes_Encoding_Raw_
	Encoding isType_Bytes_Encoding_Encoding `protobuf_oneof:"encoding"`
}

func (x *Type_Bytes_Encoding) Reset() {
	*x = Type_Bytes_Encoding{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Bytes_Encoding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Bytes_Encoding) ProtoMessage() {}

func (x *Type_Bytes_Encoding) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Bytes_Encoding.ProtoReflect.Descriptor instead.
func (*Type_Bytes_Encoding) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (m *Type_Bytes_Encoding) GetEncoding() isType_Bytes_Encoding_Encoding {
	if m != nil {
		return m.Encoding
	}
	return nil
}

func (x *Type_Bytes_Encoding) GetRaw() *Type_Bytes_Encoding_Raw {
	if x, ok := x.GetEncoding().(*Type_Bytes_Encoding_Raw_); ok {
		return x.Raw
	}
	return nil
}

type isType_Bytes_Encoding_Encoding interface {
	isType_Bytes_Encoding_Encoding()
}

type Type_Bytes_Encoding_Raw_ struct {
	// Use `Raw` encoding.
	Raw *Type_Bytes_Encoding_Raw `protobuf:"bytes,1,opt,name=raw,proto3,oneof"`
}

func (*Type_Bytes_Encoding_Raw_) isType_Bytes_Encoding_Encoding() {}

// Leaves the value as-is.
//
// Sorted mode: all values are supported.
//
// Distinct mode: all values are supported.
type Type_Bytes_Encoding_Raw struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Bytes_Encoding_Raw) Reset() {
	*x = Type_Bytes_Encoding_Raw{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Bytes_Encoding_Raw) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Bytes_Encoding_Raw) ProtoMessage() {}

func (x *Type_Bytes_Encoding_Raw) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Bytes_Encoding_Raw.ProtoReflect.Descriptor instead.
func (*Type_Bytes_Encoding_Raw) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 0, 0, 0}
}

// Rules used to convert to or from lower level types.
type Type_String_Encoding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which encoding to use.
	//
	// Types that are assignable to Encoding:
	//
	//	*Type_String_Encoding_Utf8Raw_
	//	*Type_String_Encoding_Utf8Bytes_
	Encoding isType_String_Encoding_Encoding `protobuf_oneof:"encoding"`
}

func (x *Type_String_Encoding) Reset() {
	*x = Type_String_Encoding{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_String_Encoding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_String_Encoding) ProtoMessage() {}

func (x *Type_String_Encoding) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_String_Encoding.ProtoReflect.Descriptor instead.
func (*Type_String_Encoding) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (m *Type_String_Encoding) GetEncoding() isType_String_Encoding_Encoding {
	if m != nil {
		return m.Encoding
	}
	return nil
}

// Deprecated: Marked as deprecated in google/bigtable/admin/v2/types.proto.
func (x *Type_String_Encoding) GetUtf8Raw() *Type_String_Encoding_Utf8Raw {
	if x, ok := x.GetEncoding().(*Type_String_Encoding_Utf8Raw_); ok {
		return x.Utf8Raw
	}
	return nil
}

func (x *Type_String_Encoding) GetUtf8Bytes() *Type_String_Encoding_Utf8Bytes {
	if x, ok := x.GetEncoding().(*Type_String_Encoding_Utf8Bytes_); ok {
		return x.Utf8Bytes
	}
	return nil
}

type isType_String_Encoding_Encoding interface {
	isType_String_Encoding_Encoding()
}

type Type_String_Encoding_Utf8Raw_ struct {
	// Deprecated: if set, converts to an empty `utf8_bytes`.
	//
	// Deprecated: Marked as deprecated in google/bigtable/admin/v2/types.proto.
	Utf8Raw *Type_String_Encoding_Utf8Raw `protobuf:"bytes,1,opt,name=utf8_raw,json=utf8Raw,proto3,oneof"`
}

type Type_String_Encoding_Utf8Bytes_ struct {
	// Use `Utf8Bytes` encoding.
	Utf8Bytes *Type_String_Encoding_Utf8Bytes `protobuf:"bytes,2,opt,name=utf8_bytes,json=utf8Bytes,proto3,oneof"`
}

func (*Type_String_Encoding_Utf8Raw_) isType_String_Encoding_Encoding() {}

func (*Type_String_Encoding_Utf8Bytes_) isType_String_Encoding_Encoding() {}

// Deprecated: prefer the equivalent `Utf8Bytes`.
//
// Deprecated: Marked as deprecated in google/bigtable/admin/v2/types.proto.
type Type_String_Encoding_Utf8Raw struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_String_Encoding_Utf8Raw) Reset() {
	*x = Type_String_Encoding_Utf8Raw{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_String_Encoding_Utf8Raw) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_String_Encoding_Utf8Raw) ProtoMessage() {}

func (x *Type_String_Encoding_Utf8Raw) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_String_Encoding_Utf8Raw.ProtoReflect.Descriptor instead.
func (*Type_String_Encoding_Utf8Raw) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 1, 0, 0}
}

// UTF-8 encoding.
//
// Sorted mode:
//   - All values are supported.
//   - Code point order is preserved.
//
// Distinct mode: all values are supported.
//
// Compatible with:
//
//   - BigQuery `TEXT` encoding
//   - HBase `Bytes.toBytes`
//   - Java `String#getBytes(StandardCharsets.UTF_8)`
type Type_String_Encoding_Utf8Bytes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_String_Encoding_Utf8Bytes) Reset() {
	*x = Type_String_Encoding_Utf8Bytes{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_String_Encoding_Utf8Bytes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_String_Encoding_Utf8Bytes) ProtoMessage() {}

func (x *Type_String_Encoding_Utf8Bytes) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_String_Encoding_Utf8Bytes.ProtoReflect.Descriptor instead.
func (*Type_String_Encoding_Utf8Bytes) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 1, 0, 1}
}

// Rules used to convert to or from lower level types.
type Type_Int64_Encoding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which encoding to use.
	//
	// Types that are assignable to Encoding:
	//
	//	*Type_Int64_Encoding_BigEndianBytes_
	//	*Type_Int64_Encoding_OrderedCodeBytes_
	Encoding isType_Int64_Encoding_Encoding `protobuf_oneof:"encoding"`
}

func (x *Type_Int64_Encoding) Reset() {
	*x = Type_Int64_Encoding{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Int64_Encoding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Int64_Encoding) ProtoMessage() {}

func (x *Type_Int64_Encoding) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Int64_Encoding.ProtoReflect.Descriptor instead.
func (*Type_Int64_Encoding) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (m *Type_Int64_Encoding) GetEncoding() isType_Int64_Encoding_Encoding {
	if m != nil {
		return m.Encoding
	}
	return nil
}

func (x *Type_Int64_Encoding) GetBigEndianBytes() *Type_Int64_Encoding_BigEndianBytes {
	if x, ok := x.GetEncoding().(*Type_Int64_Encoding_BigEndianBytes_); ok {
		return x.BigEndianBytes
	}
	return nil
}

func (x *Type_Int64_Encoding) GetOrderedCodeBytes() *Type_Int64_Encoding_OrderedCodeBytes {
	if x, ok := x.GetEncoding().(*Type_Int64_Encoding_OrderedCodeBytes_); ok {
		return x.OrderedCodeBytes
	}
	return nil
}

type isType_Int64_Encoding_Encoding interface {
	isType_Int64_Encoding_Encoding()
}

type Type_Int64_Encoding_BigEndianBytes_ struct {
	// Use `BigEndianBytes` encoding.
	BigEndianBytes *Type_Int64_Encoding_BigEndianBytes `protobuf:"bytes,1,opt,name=big_endian_bytes,json=bigEndianBytes,proto3,oneof"`
}

type Type_Int64_Encoding_OrderedCodeBytes_ struct {
	// Use `OrderedCodeBytes` encoding.
	OrderedCodeBytes *Type_Int64_Encoding_OrderedCodeBytes `protobuf:"bytes,2,opt,name=ordered_code_bytes,json=orderedCodeBytes,proto3,oneof"`
}

func (*Type_Int64_Encoding_BigEndianBytes_) isType_Int64_Encoding_Encoding() {}

func (*Type_Int64_Encoding_OrderedCodeBytes_) isType_Int64_Encoding_Encoding() {}

// Encodes the value as an 8-byte big-endian two's complement value.
//
// Sorted mode: non-negative values are supported.
//
// Distinct mode: all values are supported.
//
// Compatible with:
//
//   - BigQuery `BINARY` encoding
//   - HBase `Bytes.toBytes`
//   - Java `ByteBuffer.putLong()` with `ByteOrder.BIG_ENDIAN`
type Type_Int64_Encoding_BigEndianBytes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated: ignored if set.
	//
	// Deprecated: Marked as deprecated in google/bigtable/admin/v2/types.proto.
	BytesType *Type_Bytes `protobuf:"bytes,1,opt,name=bytes_type,json=bytesType,proto3" json:"bytes_type,omitempty"`
}

func (x *Type_Int64_Encoding_BigEndianBytes) Reset() {
	*x = Type_Int64_Encoding_BigEndianBytes{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Int64_Encoding_BigEndianBytes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Int64_Encoding_BigEndianBytes) ProtoMessage() {}

func (x *Type_Int64_Encoding_BigEndianBytes) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Int64_Encoding_BigEndianBytes.ProtoReflect.Descriptor instead.
func (*Type_Int64_Encoding_BigEndianBytes) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 2, 0, 0}
}

// Deprecated: Marked as deprecated in google/bigtable/admin/v2/types.proto.
func (x *Type_Int64_Encoding_BigEndianBytes) GetBytesType() *Type_Bytes {
	if x != nil {
		return x.BytesType
	}
	return nil
}

// Encodes the value in a variable length binary format of up to 10 bytes.
// Values that are closer to zero use fewer bytes.
//
// Sorted mode: all values are supported.
//
// Distinct mode: all values are supported.
type Type_Int64_Encoding_OrderedCodeBytes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Int64_Encoding_OrderedCodeBytes) Reset() {
	*x = Type_Int64_Encoding_OrderedCodeBytes{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Int64_Encoding_OrderedCodeBytes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Int64_Encoding_OrderedCodeBytes) ProtoMessage() {}

func (x *Type_Int64_Encoding_OrderedCodeBytes) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Int64_Encoding_OrderedCodeBytes.ProtoReflect.Descriptor instead.
func (*Type_Int64_Encoding_OrderedCodeBytes) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 2, 0, 1}
}

// Rules used to convert to or from lower level types.
type Type_Timestamp_Encoding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which encoding to use.
	//
	// Types that are assignable to Encoding:
	//
	//	*Type_Timestamp_Encoding_UnixMicrosInt64
	Encoding isType_Timestamp_Encoding_Encoding `protobuf_oneof:"encoding"`
}

func (x *Type_Timestamp_Encoding) Reset() {
	*x = Type_Timestamp_Encoding{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Timestamp_Encoding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Timestamp_Encoding) ProtoMessage() {}

func (x *Type_Timestamp_Encoding) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Timestamp_Encoding.ProtoReflect.Descriptor instead.
func (*Type_Timestamp_Encoding) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 6, 0}
}

func (m *Type_Timestamp_Encoding) GetEncoding() isType_Timestamp_Encoding_Encoding {
	if m != nil {
		return m.Encoding
	}
	return nil
}

func (x *Type_Timestamp_Encoding) GetUnixMicrosInt64() *Type_Int64_Encoding {
	if x, ok := x.GetEncoding().(*Type_Timestamp_Encoding_UnixMicrosInt64); ok {
		return x.UnixMicrosInt64
	}
	return nil
}

type isType_Timestamp_Encoding_Encoding interface {
	isType_Timestamp_Encoding_Encoding()
}

type Type_Timestamp_Encoding_UnixMicrosInt64 struct {
	// Encodes the number of microseconds since the Unix epoch using the
	// given `Int64` encoding. Values must be microsecond-aligned.
	//
	// Compatible with:
	//
	//   - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
	UnixMicrosInt64 *Type_Int64_Encoding `protobuf:"bytes,1,opt,name=unix_micros_int64,json=unixMicrosInt64,proto3,oneof"`
}

func (*Type_Timestamp_Encoding_UnixMicrosInt64) isType_Timestamp_Encoding_Encoding() {}

// A struct field and its type.
type Type_Struct_Field struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field name (optional). Fields without a `field_name` are considered
	// anonymous and cannot be referenced by name.
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// The type of values in this field.
	Type *Type `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *Type_Struct_Field) Reset() {
	*x = Type_Struct_Field{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Struct_Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Struct_Field) ProtoMessage() {}

func (x *Type_Struct_Field) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Struct_Field.ProtoReflect.Descriptor instead.
func (*Type_Struct_Field) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 8, 0}
}

func (x *Type_Struct_Field) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (x *Type_Struct_Field) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

// Rules used to convert to or from lower level types.
type Type_Struct_Encoding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which encoding to use.
	//
	// Types that are assignable to Encoding:
	//
	//	*Type_Struct_Encoding_Singleton_
	//	*Type_Struct_Encoding_DelimitedBytes_
	//	*Type_Struct_Encoding_OrderedCodeBytes_
	Encoding isType_Struct_Encoding_Encoding `protobuf_oneof:"encoding"`
}

func (x *Type_Struct_Encoding) Reset() {
	*x = Type_Struct_Encoding{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Struct_Encoding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Struct_Encoding) ProtoMessage() {}

func (x *Type_Struct_Encoding) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Struct_Encoding.ProtoReflect.Descriptor instead.
func (*Type_Struct_Encoding) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 8, 1}
}

func (m *Type_Struct_Encoding) GetEncoding() isType_Struct_Encoding_Encoding {
	if m != nil {
		return m.Encoding
	}
	return nil
}

func (x *Type_Struct_Encoding) GetSingleton() *Type_Struct_Encoding_Singleton {
	if x, ok := x.GetEncoding().(*Type_Struct_Encoding_Singleton_); ok {
		return x.Singleton
	}
	return nil
}

func (x *Type_Struct_Encoding) GetDelimitedBytes() *Type_Struct_Encoding_DelimitedBytes {
	if x, ok := x.GetEncoding().(*Type_Struct_Encoding_DelimitedBytes_); ok {
		return x.DelimitedBytes
	}
	return nil
}

func (x *Type_Struct_Encoding) GetOrderedCodeBytes() *Type_Struct_Encoding_OrderedCodeBytes {
	if x, ok := x.GetEncoding().(*Type_Struct_Encoding_OrderedCodeBytes_); ok {
		return x.OrderedCodeBytes
	}
	return nil
}

type isType_Struct_Encoding_Encoding interface {
	isType_Struct_Encoding_Encoding()
}

type Type_Struct_Encoding_Singleton_ struct {
	// Use `Singleton` encoding.
	Singleton *Type_Struct_Encoding_Singleton `protobuf:"bytes,1,opt,name=singleton,proto3,oneof"`
}

type Type_Struct_Encoding_DelimitedBytes_ struct {
	// Use `DelimitedBytes` encoding.
	DelimitedBytes *Type_Struct_Encoding_DelimitedBytes `protobuf:"bytes,2,opt,name=delimited_bytes,json=delimitedBytes,proto3,oneof"`
}

type Type_Struct_Encoding_OrderedCodeBytes_ struct {
	// User `OrderedCodeBytes` encoding.
	OrderedCodeBytes *Type_Struct_Encoding_OrderedCodeBytes `protobuf:"bytes,3,opt,name=ordered_code_bytes,json=orderedCodeBytes,proto3,oneof"`
}

func (*Type_Struct_Encoding_Singleton_) isType_Struct_Encoding_Encoding() {}

func (*Type_Struct_Encoding_DelimitedBytes_) isType_Struct_Encoding_Encoding() {}

func (*Type_Struct_Encoding_OrderedCodeBytes_) isType_Struct_Encoding_Encoding() {}

// Uses the encoding of `fields[0].type` as-is.
// Only valid if `fields.size == 1`.
type Type_Struct_Encoding_Singleton struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Struct_Encoding_Singleton) Reset() {
	*x = Type_Struct_Encoding_Singleton{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Struct_Encoding_Singleton) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Struct_Encoding_Singleton) ProtoMessage() {}

func (x *Type_Struct_Encoding_Singleton) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Struct_Encoding_Singleton.ProtoReflect.Descriptor instead.
func (*Type_Struct_Encoding_Singleton) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 8, 1, 0}
}

// Fields are encoded independently and concatenated with a configurable
// `delimiter` in between.
//
// A struct with no fields defined is encoded as a single `delimiter`.
//
// Sorted mode:
//
//   - Fields are encoded in sorted mode.
//   - Encoded field values must not contain any bytes <= `delimiter[0]`
//   - Element-wise order is preserved: `A < B` if `A[0] < B[0]`, or if
//     `A[0] == B[0] && A[1] < B[1]`, etc. Strict prefixes sort first.
//
// Distinct mode:
//
//   - Fields are encoded in distinct mode.
//   - Encoded field values must not contain `delimiter[0]`.
type Type_Struct_Encoding_DelimitedBytes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Byte sequence used to delimit concatenated fields. The delimiter must
	// contain at least 1 character and at most 50 characters.
	Delimiter []byte `protobuf:"bytes,1,opt,name=delimiter,proto3" json:"delimiter,omitempty"`
}

func (x *Type_Struct_Encoding_DelimitedBytes) Reset() {
	*x = Type_Struct_Encoding_DelimitedBytes{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Struct_Encoding_DelimitedBytes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Struct_Encoding_DelimitedBytes) ProtoMessage() {}

func (x *Type_Struct_Encoding_DelimitedBytes) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Struct_Encoding_DelimitedBytes.ProtoReflect.Descriptor instead.
func (*Type_Struct_Encoding_DelimitedBytes) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 8, 1, 1}
}

func (x *Type_Struct_Encoding_DelimitedBytes) GetDelimiter() []byte {
	if x != nil {
		return x.Delimiter
	}
	return nil
}

// Fields are encoded independently and concatenated with the fixed byte
// pair {0x00, 0x01} in between.
//
// Any null (0x00) byte in an encoded field is replaced by the fixed byte
// pair {0x00, 0xFF}.
//
// Fields that encode to the empty string "" have special handling:
//
//   - If *every* field encodes to "", or if the STRUCT has no fields
//     defined, then the STRUCT is encoded as the fixed byte pair
//     {0x00, 0x00}.
//   - Otherwise, the STRUCT only encodes until the last non-empty field,
//     omitting any trailing empty fields. Any empty fields that aren't
//     omitted are replaced with the fixed byte pair {0x00, 0x00}.
//
// Examples:
//
//   - STRUCT()             -> "\00\00"
//   - STRUCT("")           -> "\00\00"
//   - STRUCT("", "")       -> "\00\00"
//   - STRUCT("", "B")      -> "\00\00" + "\00\01" + "B"
//   - STRUCT("A", "")      -> "A"
//   - STRUCT("", "B", "")  -> "\00\00" + "\00\01" + "B"
//   - STRUCT("A", "", "C") -> "A" + "\00\01" + "\00\00" + "\00\01" + "C"
//
// Since null bytes are always escaped, this encoding can cause size
// blowup for encodings like `Int64.BigEndianBytes` that are likely to
// produce many such bytes.
//
// Sorted mode:
//
//   - Fields are encoded in sorted mode.
//   - All values supported by the field encodings are allowed
//   - Element-wise order is preserved: `A < B` if `A[0] < B[0]`, or if
//     `A[0] == B[0] && A[1] < B[1]`, etc. Strict prefixes sort first.
//
// Distinct mode:
//
//   - Fields are encoded in distinct mode.
//   - All values supported by the field encodings are allowed.
type Type_Struct_Encoding_OrderedCodeBytes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Struct_Encoding_OrderedCodeBytes) Reset() {
	*x = Type_Struct_Encoding_OrderedCodeBytes{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Struct_Encoding_OrderedCodeBytes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Struct_Encoding_OrderedCodeBytes) ProtoMessage() {}

func (x *Type_Struct_Encoding_OrderedCodeBytes) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Struct_Encoding_OrderedCodeBytes.ProtoReflect.Descriptor instead.
func (*Type_Struct_Encoding_OrderedCodeBytes) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 8, 1, 2}
}

// Computes the sum of the input values.
// Allowed input: `Int64`
// State: same as input
type Type_Aggregate_Sum struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Aggregate_Sum) Reset() {
	*x = Type_Aggregate_Sum{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Aggregate_Sum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Aggregate_Sum) ProtoMessage() {}

func (x *Type_Aggregate_Sum) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Aggregate_Sum.ProtoReflect.Descriptor instead.
func (*Type_Aggregate_Sum) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 13, 0}
}

// Computes the max of the input values.
// Allowed input: `Int64`
// State: same as input
type Type_Aggregate_Max struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Aggregate_Max) Reset() {
	*x = Type_Aggregate_Max{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Aggregate_Max) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Aggregate_Max) ProtoMessage() {}

func (x *Type_Aggregate_Max) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Aggregate_Max.ProtoReflect.Descriptor instead.
func (*Type_Aggregate_Max) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 13, 1}
}

// Computes the min of the input values.
// Allowed input: `Int64`
// State: same as input
type Type_Aggregate_Min struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Aggregate_Min) Reset() {
	*x = Type_Aggregate_Min{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Aggregate_Min) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Aggregate_Min) ProtoMessage() {}

func (x *Type_Aggregate_Min) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Aggregate_Min.ProtoReflect.Descriptor instead.
func (*Type_Aggregate_Min) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 13, 2}
}

// Computes an approximate unique count over the input values. When using
// raw data as input, be careful to use a consistent encoding. Otherwise
// the same value encoded differently could count more than once, or two
// distinct values could count as identical.
// Input: Any, or omit for Raw
// State: TBD
// Special state conversions: `Int64` (the unique count estimate)
type Type_Aggregate_HyperLogLogPlusPlusUniqueCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Aggregate_HyperLogLogPlusPlusUniqueCount) Reset() {
	*x = Type_Aggregate_HyperLogLogPlusPlusUniqueCount{}
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Aggregate_HyperLogLogPlusPlusUniqueCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Aggregate_HyperLogLogPlusPlusUniqueCount) ProtoMessage() {}

func (x *Type_Aggregate_HyperLogLogPlusPlusUniqueCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Aggregate_HyperLogLogPlusPlusUniqueCount.ProtoReflect.Descriptor instead.
func (*Type_Aggregate_HyperLogLogPlusPlusUniqueCount) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 13, 3}
}

var File_google_bigtable_admin_v2_types_proto protoreflect.FileDescriptor

var file_google_bigtable_admin_v2_types_proto_rawDesc = []byte{
	0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xd3, 0x1d, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x48, 0x00, 0x52, 0x09, 0x62, 0x79, 0x74, 0x65, 0x73, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x48, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52,
	0x0a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x69,
	0x6e, 0x74, 0x36, 0x34, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x48, 0x00, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x4b, 0x0a, 0x0c, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x33, 0x32, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x33, 0x32,
	0x48, 0x00, 0x52, 0x0b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x33, 0x32, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x4b, 0x0a, 0x0c, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x36, 0x34, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x36, 0x34, 0x48, 0x00, 0x52,
	0x0b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x36, 0x34, 0x54, 0x79, 0x70, 0x65, 0x12, 0x42, 0x0a, 0x09,
	0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x48, 0x00, 0x52, 0x08, 0x62, 0x6f, 0x6f, 0x6c, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x51, 0x0a, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x48, 0x00, 0x52, 0x0d, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x42, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x08, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x51, 0x0a, 0x0e, 0x61, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x48, 0x0a, 0x0b, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00,
	0x52, 0x09, 0x61, 0x72, 0x72, 0x61, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x6d,
	0x61, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x61,
	0x70, 0x48, 0x00, 0x52, 0x07, 0x6d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x45, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x48, 0x00, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x42, 0x0a, 0x09, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x48, 0x00, 0x52, 0x08, 0x65,
	0x6e, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xb8, 0x01, 0x0a, 0x05, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x49, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x1a, 0x64, 0x0a, 0x08,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x45, 0x0a, 0x03, 0x72, 0x61, 0x77, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x2e, 0x52, 0x61, 0x77, 0x48, 0x00, 0x52, 0x03, 0x72, 0x61, 0x77, 0x1a,
	0x05, 0x0a, 0x03, 0x52, 0x61, 0x77, 0x42, 0x0a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x1a, 0xbd, 0x02, 0x0a, 0x06, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x4a, 0x0a,
	0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52,
	0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x1a, 0xe6, 0x01, 0x0a, 0x08, 0x45, 0x6e,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x57, 0x0a, 0x08, 0x75, 0x74, 0x66, 0x38, 0x5f, 0x72,
	0x61, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x55, 0x74, 0x66, 0x38, 0x52, 0x61, 0x77,
	0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x07, 0x75, 0x74, 0x66, 0x38, 0x52, 0x61, 0x77, 0x12,
	0x59, 0x0a, 0x0a, 0x75, 0x74, 0x66, 0x38, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x2e, 0x55, 0x74, 0x66, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x48, 0x00, 0x52,
	0x09, 0x75, 0x74, 0x66, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x1a, 0x0d, 0x0a, 0x07, 0x55, 0x74,
	0x66, 0x38, 0x52, 0x61, 0x77, 0x3a, 0x02, 0x18, 0x01, 0x1a, 0x0b, 0x0a, 0x09, 0x55, 0x74, 0x66,
	0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x1a, 0xb4, 0x03, 0x0a, 0x05, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x12, 0x49, 0x0a, 0x08,
	0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x1a, 0xdf, 0x02, 0x0a, 0x08, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x68, 0x0a, 0x10, 0x62, 0x69, 0x67, 0x5f, 0x65, 0x6e, 0x64, 0x69,
	0x61, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x42, 0x69,
	0x67, 0x45, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0e,
	0x62, 0x69, 0x67, 0x45, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x6e,
	0x0a, 0x12, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x65,
	0x64, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x48, 0x00, 0x52, 0x10, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x65, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x1a, 0x59,
	0x0a, 0x0e, 0x42, 0x69, 0x67, 0x45, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x47, 0x0a, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69,
	0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x12, 0x0a, 0x10, 0x4f, 0x72, 0x64,
	0x65, 0x72, 0x65, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x42, 0x0a, 0x0a,
	0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x1a, 0x06, 0x0a, 0x04, 0x42, 0x6f, 0x6f,
	0x6c, 0x1a, 0x09, 0x0a, 0x07, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x33, 0x32, 0x1a, 0x09, 0x0a, 0x07,
	0x46, 0x6c, 0x6f, 0x61, 0x74, 0x36, 0x34, 0x1a, 0xcf, 0x01, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x4d, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x1a, 0x73, 0x0a, 0x08, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x12, 0x5b, 0x0a, 0x11, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x5f,
	0x69, 0x6e, 0x74, 0x36, 0x34, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x75, 0x6e,
	0x69, 0x78, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x42, 0x0a, 0x0a,
	0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x1a, 0x06, 0x0a, 0x04, 0x44, 0x61, 0x74,
	0x65, 0x1a, 0x94, 0x05, 0x0a, 0x06, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x12, 0x43, 0x0a, 0x06,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x12, 0x4a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x1a, 0x5a, 0x0a,
	0x05, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x9c, 0x03, 0x0a, 0x08, 0x45, 0x6e,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x58, 0x0a, 0x09, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x74, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x74, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x74, 0x6f, 0x6e,
	0x12, 0x68, 0x0a, 0x0f, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x64, 0x65, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x6f, 0x0a, 0x12, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x45, 0x6e,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x43, 0x6f,
	0x64, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x48, 0x00, 0x52, 0x10, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x65, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x1a, 0x0b, 0x0a, 0x09, 0x53,
	0x69, 0x6e, 0x67, 0x6c, 0x65, 0x74, 0x6f, 0x6e, 0x1a, 0x2e, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x65,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x64,
	0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x1a, 0x12, 0x0a, 0x10, 0x4f, 0x72, 0x64, 0x65,
	0x72, 0x65, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x42, 0x0a, 0x0a, 0x08,
	0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x1a, 0x54, 0x0a, 0x05, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x62, 0x75, 0x6e, 0x64,
	0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x4d,
	0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x49, 0x64,
	0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x75, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x4a, 0x0a,
	0x05, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x41, 0x0a, 0x0c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x7f, 0x0a, 0x03, 0x4d, 0x61, 0x70,
	0x12, 0x39, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3d, 0x0a, 0x0a, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x09, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x92, 0x04, 0x0a, 0x09, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x12, 0x3d, 0x0a, 0x0a, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x42, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x03, 0x73,
	0x75, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x48, 0x00, 0x52, 0x03, 0x73, 0x75, 0x6d, 0x12, 0x77, 0x0a,
	0x12, 0x68, 0x6c, 0x6c, 0x70, 0x70, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67,
	0x61, 0x74, 0x65, 0x2e, 0x48, 0x79, 0x70, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x4c, 0x6f, 0x67, 0x50,
	0x6c, 0x75, 0x73, 0x50, 0x6c, 0x75, 0x73, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x48, 0x00, 0x52, 0x10, 0x68, 0x6c, 0x6c, 0x70, 0x70, 0x55, 0x6e, 0x69, 0x71, 0x75,
	0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x61,
	0x78, 0x48, 0x00, 0x52, 0x03, 0x6d, 0x61, 0x78, 0x12, 0x40, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x2e,
	0x4d, 0x69, 0x6e, 0x48, 0x00, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x1a, 0x05, 0x0a, 0x03, 0x53, 0x75,
	0x6d, 0x1a, 0x05, 0x0a, 0x03, 0x4d, 0x61, 0x78, 0x1a, 0x05, 0x0a, 0x03, 0x4d, 0x69, 0x6e, 0x1a,
	0x20, 0x0a, 0x1e, 0x48, 0x79, 0x70, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x4c, 0x6f, 0x67, 0x50, 0x6c,
	0x75, 0x73, 0x50, 0x6c, 0x75, 0x73, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x42, 0x0c, 0x0a, 0x0a, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x42,
	0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x42, 0xcd, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x42, 0x0a, 0x54, 0x79, 0x70, 0x65, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32,
	0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x70, 0x62, 0x3b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x70, 0x62,
	0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x56,
	0x32, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x5c,
	0x56, 0x32, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_bigtable_admin_v2_types_proto_rawDescOnce sync.Once
	file_google_bigtable_admin_v2_types_proto_rawDescData = file_google_bigtable_admin_v2_types_proto_rawDesc
)

func file_google_bigtable_admin_v2_types_proto_rawDescGZIP() []byte {
	file_google_bigtable_admin_v2_types_proto_rawDescOnce.Do(func() {
		file_google_bigtable_admin_v2_types_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_bigtable_admin_v2_types_proto_rawDescData)
	})
	return file_google_bigtable_admin_v2_types_proto_rawDescData
}

var file_google_bigtable_admin_v2_types_proto_msgTypes = make([]protoimpl.MessageInfo, 33)
var file_google_bigtable_admin_v2_types_proto_goTypes = []any{
	(*Type)(nil),                                          // 0: google.bigtable.admin.v2.Type
	(*Type_Bytes)(nil),                                    // 1: google.bigtable.admin.v2.Type.Bytes
	(*Type_String)(nil),                                   // 2: google.bigtable.admin.v2.Type.String
	(*Type_Int64)(nil),                                    // 3: google.bigtable.admin.v2.Type.Int64
	(*Type_Bool)(nil),                                     // 4: google.bigtable.admin.v2.Type.Bool
	(*Type_Float32)(nil),                                  // 5: google.bigtable.admin.v2.Type.Float32
	(*Type_Float64)(nil),                                  // 6: google.bigtable.admin.v2.Type.Float64
	(*Type_Timestamp)(nil),                                // 7: google.bigtable.admin.v2.Type.Timestamp
	(*Type_Date)(nil),                                     // 8: google.bigtable.admin.v2.Type.Date
	(*Type_Struct)(nil),                                   // 9: google.bigtable.admin.v2.Type.Struct
	(*Type_Proto)(nil),                                    // 10: google.bigtable.admin.v2.Type.Proto
	(*Type_Enum)(nil),                                     // 11: google.bigtable.admin.v2.Type.Enum
	(*Type_Array)(nil),                                    // 12: google.bigtable.admin.v2.Type.Array
	(*Type_Map)(nil),                                      // 13: google.bigtable.admin.v2.Type.Map
	(*Type_Aggregate)(nil),                                // 14: google.bigtable.admin.v2.Type.Aggregate
	(*Type_Bytes_Encoding)(nil),                           // 15: google.bigtable.admin.v2.Type.Bytes.Encoding
	(*Type_Bytes_Encoding_Raw)(nil),                       // 16: google.bigtable.admin.v2.Type.Bytes.Encoding.Raw
	(*Type_String_Encoding)(nil),                          // 17: google.bigtable.admin.v2.Type.String.Encoding
	(*Type_String_Encoding_Utf8Raw)(nil),                  // 18: google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw
	(*Type_String_Encoding_Utf8Bytes)(nil),                // 19: google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes
	(*Type_Int64_Encoding)(nil),                           // 20: google.bigtable.admin.v2.Type.Int64.Encoding
	(*Type_Int64_Encoding_BigEndianBytes)(nil),            // 21: google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
	(*Type_Int64_Encoding_OrderedCodeBytes)(nil),          // 22: google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
	(*Type_Timestamp_Encoding)(nil),                       // 23: google.bigtable.admin.v2.Type.Timestamp.Encoding
	(*Type_Struct_Field)(nil),                             // 24: google.bigtable.admin.v2.Type.Struct.Field
	(*Type_Struct_Encoding)(nil),                          // 25: google.bigtable.admin.v2.Type.Struct.Encoding
	(*Type_Struct_Encoding_Singleton)(nil),                // 26: google.bigtable.admin.v2.Type.Struct.Encoding.Singleton
	(*Type_Struct_Encoding_DelimitedBytes)(nil),           // 27: google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
	(*Type_Struct_Encoding_OrderedCodeBytes)(nil),         // 28: google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
	(*Type_Aggregate_Sum)(nil),                            // 29: google.bigtable.admin.v2.Type.Aggregate.Sum
	(*Type_Aggregate_Max)(nil),                            // 30: google.bigtable.admin.v2.Type.Aggregate.Max
	(*Type_Aggregate_Min)(nil),                            // 31: google.bigtable.admin.v2.Type.Aggregate.Min
	(*Type_Aggregate_HyperLogLogPlusPlusUniqueCount)(nil), // 32: google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
}
var file_google_bigtable_admin_v2_types_proto_depIdxs = []int32{
	1,  // 0: google.bigtable.admin.v2.Type.bytes_type:type_name -> google.bigtable.admin.v2.Type.Bytes
	2,  // 1: google.bigtable.admin.v2.Type.string_type:type_name -> google.bigtable.admin.v2.Type.String
	3,  // 2: google.bigtable.admin.v2.Type.int64_type:type_name -> google.bigtable.admin.v2.Type.Int64
	5,  // 3: google.bigtable.admin.v2.Type.float32_type:type_name -> google.bigtable.admin.v2.Type.Float32
	6,  // 4: google.bigtable.admin.v2.Type.float64_type:type_name -> google.bigtable.admin.v2.Type.Float64
	4,  // 5: google.bigtable.admin.v2.Type.bool_type:type_name -> google.bigtable.admin.v2.Type.Bool
	7,  // 6: google.bigtable.admin.v2.Type.timestamp_type:type_name -> google.bigtable.admin.v2.Type.Timestamp
	8,  // 7: google.bigtable.admin.v2.Type.date_type:type_name -> google.bigtable.admin.v2.Type.Date
	14, // 8: google.bigtable.admin.v2.Type.aggregate_type:type_name -> google.bigtable.admin.v2.Type.Aggregate
	9,  // 9: google.bigtable.admin.v2.Type.struct_type:type_name -> google.bigtable.admin.v2.Type.Struct
	12, // 10: google.bigtable.admin.v2.Type.array_type:type_name -> google.bigtable.admin.v2.Type.Array
	13, // 11: google.bigtable.admin.v2.Type.map_type:type_name -> google.bigtable.admin.v2.Type.Map
	10, // 12: google.bigtable.admin.v2.Type.proto_type:type_name -> google.bigtable.admin.v2.Type.Proto
	11, // 13: google.bigtable.admin.v2.Type.enum_type:type_name -> google.bigtable.admin.v2.Type.Enum
	15, // 14: google.bigtable.admin.v2.Type.Bytes.encoding:type_name -> google.bigtable.admin.v2.Type.Bytes.Encoding
	17, // 15: google.bigtable.admin.v2.Type.String.encoding:type_name -> google.bigtable.admin.v2.Type.String.Encoding
	20, // 16: google.bigtable.admin.v2.Type.Int64.encoding:type_name -> google.bigtable.admin.v2.Type.Int64.Encoding
	23, // 17: google.bigtable.admin.v2.Type.Timestamp.encoding:type_name -> google.bigtable.admin.v2.Type.Timestamp.Encoding
	24, // 18: google.bigtable.admin.v2.Type.Struct.fields:type_name -> google.bigtable.admin.v2.Type.Struct.Field
	25, // 19: google.bigtable.admin.v2.Type.Struct.encoding:type_name -> google.bigtable.admin.v2.Type.Struct.Encoding
	0,  // 20: google.bigtable.admin.v2.Type.Array.element_type:type_name -> google.bigtable.admin.v2.Type
	0,  // 21: google.bigtable.admin.v2.Type.Map.key_type:type_name -> google.bigtable.admin.v2.Type
	0,  // 22: google.bigtable.admin.v2.Type.Map.value_type:type_name -> google.bigtable.admin.v2.Type
	0,  // 23: google.bigtable.admin.v2.Type.Aggregate.input_type:type_name -> google.bigtable.admin.v2.Type
	0,  // 24: google.bigtable.admin.v2.Type.Aggregate.state_type:type_name -> google.bigtable.admin.v2.Type
	29, // 25: google.bigtable.admin.v2.Type.Aggregate.sum:type_name -> google.bigtable.admin.v2.Type.Aggregate.Sum
	32, // 26: google.bigtable.admin.v2.Type.Aggregate.hllpp_unique_count:type_name -> google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
	30, // 27: google.bigtable.admin.v2.Type.Aggregate.max:type_name -> google.bigtable.admin.v2.Type.Aggregate.Max
	31, // 28: google.bigtable.admin.v2.Type.Aggregate.min:type_name -> google.bigtable.admin.v2.Type.Aggregate.Min
	16, // 29: google.bigtable.admin.v2.Type.Bytes.Encoding.raw:type_name -> google.bigtable.admin.v2.Type.Bytes.Encoding.Raw
	18, // 30: google.bigtable.admin.v2.Type.String.Encoding.utf8_raw:type_name -> google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw
	19, // 31: google.bigtable.admin.v2.Type.String.Encoding.utf8_bytes:type_name -> google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes
	21, // 32: google.bigtable.admin.v2.Type.Int64.Encoding.big_endian_bytes:type_name -> google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
	22, // 33: google.bigtable.admin.v2.Type.Int64.Encoding.ordered_code_bytes:type_name -> google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
	1,  // 34: google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.bytes_type:type_name -> google.bigtable.admin.v2.Type.Bytes
	20, // 35: google.bigtable.admin.v2.Type.Timestamp.Encoding.unix_micros_int64:type_name -> google.bigtable.admin.v2.Type.Int64.Encoding
	0,  // 36: google.bigtable.admin.v2.Type.Struct.Field.type:type_name -> google.bigtable.admin.v2.Type
	26, // 37: google.bigtable.admin.v2.Type.Struct.Encoding.singleton:type_name -> google.bigtable.admin.v2.Type.Struct.Encoding.Singleton
	27, // 38: google.bigtable.admin.v2.Type.Struct.Encoding.delimited_bytes:type_name -> google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
	28, // 39: google.bigtable.admin.v2.Type.Struct.Encoding.ordered_code_bytes:type_name -> google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
	40, // [40:40] is the sub-list for method output_type
	40, // [40:40] is the sub-list for method input_type
	40, // [40:40] is the sub-list for extension type_name
	40, // [40:40] is the sub-list for extension extendee
	0,  // [0:40] is the sub-list for field type_name
}

func init() { file_google_bigtable_admin_v2_types_proto_init() }
func file_google_bigtable_admin_v2_types_proto_init() {
	if File_google_bigtable_admin_v2_types_proto != nil {
		return
	}
	file_google_bigtable_admin_v2_types_proto_msgTypes[0].OneofWrappers = []any{
		(*Type_BytesType)(nil),
		(*Type_StringType)(nil),
		(*Type_Int64Type)(nil),
		(*Type_Float32Type)(nil),
		(*Type_Float64Type)(nil),
		(*Type_BoolType)(nil),
		(*Type_TimestampType)(nil),
		(*Type_DateType)(nil),
		(*Type_AggregateType)(nil),
		(*Type_StructType)(nil),
		(*Type_ArrayType)(nil),
		(*Type_MapType)(nil),
		(*Type_ProtoType)(nil),
		(*Type_EnumType)(nil),
	}
	file_google_bigtable_admin_v2_types_proto_msgTypes[14].OneofWrappers = []any{
		(*Type_Aggregate_Sum_)(nil),
		(*Type_Aggregate_HllppUniqueCount)(nil),
		(*Type_Aggregate_Max_)(nil),
		(*Type_Aggregate_Min_)(nil),
	}
	file_google_bigtable_admin_v2_types_proto_msgTypes[15].OneofWrappers = []any{
		(*Type_Bytes_Encoding_Raw_)(nil),
	}
	file_google_bigtable_admin_v2_types_proto_msgTypes[17].OneofWrappers = []any{
		(*Type_String_Encoding_Utf8Raw_)(nil),
		(*Type_String_Encoding_Utf8Bytes_)(nil),
	}
	file_google_bigtable_admin_v2_types_proto_msgTypes[20].OneofWrappers = []any{
		(*Type_Int64_Encoding_BigEndianBytes_)(nil),
		(*Type_Int64_Encoding_OrderedCodeBytes_)(nil),
	}
	file_google_bigtable_admin_v2_types_proto_msgTypes[23].OneofWrappers = []any{
		(*Type_Timestamp_Encoding_UnixMicrosInt64)(nil),
	}
	file_google_bigtable_admin_v2_types_proto_msgTypes[25].OneofWrappers = []any{
		(*Type_Struct_Encoding_Singleton_)(nil),
		(*Type_Struct_Encoding_DelimitedBytes_)(nil),
		(*Type_Struct_Encoding_OrderedCodeBytes_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_bigtable_admin_v2_types_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   33,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_bigtable_admin_v2_types_proto_goTypes,
		DependencyIndexes: file_google_bigtable_admin_v2_types_proto_depIdxs,
		MessageInfos:      file_google_bigtable_admin_v2_types_proto_msgTypes,
	}.Build()
	File_google_bigtable_admin_v2_types_proto = out.File
	file_google_bigtable_admin_v2_types_proto_rawDesc = nil
	file_google_bigtable_admin_v2_types_proto_goTypes = nil
	file_google_bigtable_admin_v2_types_proto_depIdxs = nil
}
